/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctcash;

import com.kingdee.eas.fi.rpt.CashTypeEnum;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.AssistantGroupComparator;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCash;
import com.kingdee.eas.fi.rpt.batch.acctcash.AcctCashSortState;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AcctCashSortRegister
implements IBatchSQLSorterRegister {
    private static Comparator groupComparator = new AssistantGroupComparator();
    private List sortStateList = new LinkedList();
    private Map sortMap = new HashMap();
    private AcctCashSortState acctCashSortState = new AcctCashSortState();
    private boolean isCompanyChanges;
    private boolean isCurrencyChanges;
    private boolean isForIncashFlow = false;
    private boolean isUseTempTableScheme = false;

    @Override
    public List getSortStates() {
        return this.sortStateList;
    }

    @Override
    public void register(IFormulaCalculator formula) {
        AcctCash acctCash = (AcctCash)formula;
        this.setSortState(acctCash);
        String key = this.acctCashSortState.generateKey();
        AcctCashSortState state = (AcctCashSortState)this.sortMap.get(key);
        if (state == null) {
            state = (AcctCashSortState)this.acctCashSortState.clone();
            state.setForIncashFlow(this.isForIncashFlow());
            state.setUseTempTableScheme(this.isUseTempTableScheme(acctCash));
            state.setMaxCashItemLevel(acctCash.cashFlowItemList.size());
            state.setMaxCompanyLevel(acctCash.companyList.size());
            this.sortStateList.add(state);
            this.sortMap.put(key, state);
        } else {
            if (state.getMaxCashItemLevel() < acctCash.cashFlowItemList.size()) {
                state.setMaxCashItemLevel(acctCash.cashFlowItemList.size());
            }
            if (state.getMaxCompanyLevel() < acctCash.companyList.size()) {
                state.setMaxCompanyLevel(acctCash.companyList.size());
            }
        }
        state.addFormula(formula);
    }

    private void setSortState(AcctCash acctCash) {
        AssistantGroup[] groups;
        this.acctCashSortState.reset();
        if (this.isUseTempTableScheme(acctCash)) {
            String companynumber = acctCash.company.isIsOnlyUnion() ? acctCash.company.getLongNumber() : acctCash.company.getId().toString();
            this.acctCashSortState.setCompanyNumber(companynumber);
            this.acctCashSortState.setBizCompany(!acctCash.company.isIsOnlyUnion());
            if (acctCash.cashTypeEnum == null || !CashTypeEnum.AS.equals((Object)acctCash.cashTypeEnum) && !CashTypeEnum.AZ.equals((Object)acctCash.cashTypeEnum)) {
                this.acctCashSortState.setCurrencyNumber(acctCash.currencyNumber);
            }
        } else {
            if (!this.isCompanyChanges) {
                this.acctCashSortState.setCompanyIDList(acctCash.companyList);
                this.acctCashSortState.setCompanyNumber(acctCash.fiOrgUnit);
            }
            if (acctCash.cashTypeEnum == null || !CashTypeEnum.AS.equals((Object)acctCash.cashTypeEnum) && !CashTypeEnum.AZ.equals((Object)acctCash.cashTypeEnum)) {
                this.acctCashSortState.setMultiCurrency(this.isCurrencyChanges);
                if (!this.isCurrencyChanges) {
                    this.acctCashSortState.setCurrencyNumber(acctCash.currencyNumber);
                }
            }
        }
        this.acctCashSortState.setIncludingUnPosted(acctCash.isIncludingUnPosted);
        this.acctCashSortState.setTimeCondition(acctCash.getTimeCondition());
        this.acctCashSortState.setCashFlowItemType(acctCash.cashFlowItemInfo.getType());
        this.acctCashSortState.setLeafCashFlowItem(acctCash.cashFlowItemInfo.isIsLeaf());
        this.acctCashSortState.setCashFlowDirection(acctCash.cashFlowItemInfo.getDirection());
        if (acctCash.cashFlowItem.hasItem() && acctCash.sorttedCashFlowAsstActTypeList != null) {
            List assistantItemExtList;
            ArrayList<String[]> numberList = null;
            ArrayList<String[]> singleNumberList = null;
            HashMap<String, AssistantGroup[]> groupMap = null;
            AcctountAsstItemParser.AccountAsstItem asstItem = acctCash.cashFlowItem.getAccountAsstItem();
            this.acctCashSortState.setCashFlowAsstActTypeList(acctCash.sorttedCashFlowAsstActTypeList);
            if (asstItem != null && asstItem.asstItems.length > 0 && asstItem.asstItems[0].startNumber != null && (assistantItemExtList = acctCash.assistantItemExtList) != null) {
                int size = assistantItemExtList.size();
                for (int i = 0; i < size; ++i) {
                    AssistantItemExt assistantItem = (AssistantItemExt)assistantItemExtList.get(i);
                    AsstActType itemType = assistantItem.itemType;
                    if (assistantItem != null && assistantItem.startItem != null && !StringUtils.isEmpty((String)assistantItem.startItem.number) && assistantItem.endItem != null && !StringUtils.isEmpty((String)assistantItem.endItem.number)) {
                        String endNumber;
                        String tableName = itemType.realtionDataObject;
                        boolean isGeneralasstacttype = RptUtil.isUseLongNumber(itemType.useLongNumber, tableName);
                        String startNumber = isGeneralasstacttype ? assistantItem.startItem.longNumber : assistantItem.startItem.number;
                        String string = endNumber = isGeneralasstacttype ? assistantItem.endItem.longNumber : assistantItem.endItem.number;
                        if (startNumber.equals(endNumber)) {
                            if (singleNumberList == null) {
                                singleNumberList = new ArrayList<String[]>();
                            }
                            singleNumberList.add(new String[]{itemType.number, isGeneralasstacttype ? "FLongNumber" : "FNumber"});
                        } else {
                            if (numberList == null) {
                                numberList = new ArrayList<String[]>();
                            }
                            numberList.add(new String[]{itemType.number, startNumber, endNumber, isGeneralasstacttype ? "FLongNumber" : "FNumber"});
                        }
                    }
                    if (assistantItem.getGroups() != null && assistantItem.getGroups().length > 0) {
                        if (groupMap == null) {
                            groupMap = new HashMap<String, AssistantGroup[]>();
                        }
                        groups = assistantItem.getGroups();
                        Arrays.sort(groups, groupComparator);
                        groupMap.put(itemType.number, groups);
                    }
                    this.acctCashSortState.setSingleCashFlowAsstActItem(singleNumberList);
                    this.acctCashSortState.setCashFlowAsstActItems(numberList);
                    this.acctCashSortState.setCashFlowGroupMap(groupMap);
                }
            }
        }
        if (!this.isForIncashFlow && acctCash.oppAccountItem != null) {
            String startAccount = acctCash.oppAccountItem.getAccountAsstItem().startNumber;
            String endAccount = acctCash.oppAccountItem.getAccountAsstItem().endNumber;
            if (!StringUtils.isEmpty((String)startAccount) && !StringUtils.isEmpty((String)endAccount)) {
                this.acctCashSortState.setNeedAccount(true);
                if (!startAccount.equals(endAccount)) {
                    this.acctCashSortState.setOppAccount(new String[]{startAccount, endAccount});
                }
            }
            if (acctCash.oppAccountItem.hasItem() && acctCash.sorttedOppAsstActTypeList != null) {
                ArrayList<String[]> numberList = null;
                ArrayList<String[]> singleNumberList = null;
                HashMap<String, AssistantGroup[]> groupMap = null;
                this.acctCashSortState.setOppAsstActTypeList(acctCash.sorttedOppAsstActTypeList);
                AcctountAsstItemParser.AccountAsstItem asstItem = acctCash.oppAccountItem.getAccountAsstItem();
                if (asstItem != null && asstItem.asstItems.length > 0 && asstItem.asstItems[0].startNumber != null) {
                    for (AsstActType itemType : acctCash.sorttedOppAsstActTypeList) {
                        AssistantItem assistantItem = acctCash.oppAccountItem.getItem(itemType.number);
                        if (assistantItem != null && !StringUtils.isEmpty((String)assistantItem.startItem.number) && !StringUtils.isEmpty((String)assistantItem.endItem.number)) {
                            if (itemType.realtionDataObject.equalsIgnoreCase("t_bd_generalasstacttype")) {
                                if (numberList == null) {
                                    numberList = new ArrayList<String[]>();
                                }
                                numberList.add(new String[]{itemType.number, assistantItem.startItem.longNumber, assistantItem.endItem.longNumber});
                            } else if (!assistantItem.startItem.number.equals(assistantItem.endItem.number)) {
                                if (numberList == null) {
                                    numberList = new ArrayList();
                                }
                                numberList.add(new String[]{itemType.number, assistantItem.startItem.number, assistantItem.endItem.number});
                            } else {
                                if (singleNumberList == null) {
                                    singleNumberList = new ArrayList<String[]>();
                                }
                                singleNumberList.add(new String[]{itemType.number, "FNumber"});
                            }
                        }
                        if (assistantItem == null || assistantItem.getGroups() == null || assistantItem.getGroups().length <= 0) continue;
                        if (groupMap == null) {
                            groupMap = new HashMap<String, AssistantGroup[]>();
                        }
                        groups = assistantItem.getGroups();
                        Arrays.sort(groups, groupComparator);
                        groupMap.put(itemType.number, groups);
                    }
                    this.acctCashSortState.setSingleOppAsstActItem(singleNumberList);
                    this.acctCashSortState.setOppAsstActItems(numberList);
                    this.acctCashSortState.setGroupMap(groupMap);
                }
            }
        }
    }

    public boolean isCompanyChanges() {
        return this.isCompanyChanges;
    }

    public void setCompanyChanges(boolean isCompanyChanges) {
        this.isCompanyChanges = isCompanyChanges;
    }

    public boolean isCurrencyChanges() {
        return this.isCurrencyChanges;
    }

    public void setCurrencyChanges(boolean isCurrencyChanges) {
        this.isCurrencyChanges = isCurrencyChanges;
    }

    public boolean isForIncashFlow() {
        return this.isForIncashFlow;
    }

    public void setForIncashFlow(boolean isForIncashFlow) {
        this.isForIncashFlow = isForIncashFlow;
    }

    public boolean isUseTempTableScheme(AcctCash acctCash) {
        return this.isUseTempTableScheme && acctCash.sorttedCashFlowAsstActTypeList != null && acctCash.sorttedCashFlowAsstActTypeList.size() > 0;
    }

    public void setUseTempTableScheme(boolean isUseTempTableScheme) {
        this.isUseTempTableScheme = isUseTempTableScheme;
    }
}

