/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctext;

import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.SQLStringWrapper;
import com.kingdee.eas.fi.rpt.batch.acctext.Acctext;
import com.kingdee.eas.fi.rpt.batch.acctext.AcctextAccrualCombinaState;
import com.kingdee.eas.fi.rpt.batch.acctext.AcctextAccrualSortState;
import com.kingdee.eas.fi.rpt.batch.acctext.VoucherResposit;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class AcctextAccrualProcessor
implements IBatchSQLSorterProcessor {
    private AcctextAccrualSortState sortState;
    private AcctextAccrualCombinaState combinaState;
    private int batchSize;
    private String selectPart;
    private String fromPart;
    private SQLStringWrapper constantWherePart;
    private String groupByPart;
    private String[] indexFiled;
    private boolean isQueryDirect;
    private List longAsstItemNumberList;
    private VoucherResposit voucherResposit = new VoucherResposit();

    protected AcctextAccrualProcessor() {
    }

    public AcctextAccrualProcessor(int batchSize) {
        this();
        this.batchSize = batchSize;
        this.combinaState = new AcctextAccrualCombinaState();
        this.longAsstItemNumberList = new ArrayList();
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        sql.append(this.selectPart);
    }

    private String innerBuildSelectPart() {
        StringBuffer sql = new StringBuffer();
        if (this.sortState.getAsstActTypeList() != null) {
            if (this.sortState.isAccrual()) {
                sql.append(" select sum(A_Record.FOriginalAmount) OriginalValue         \n");
                sql.append(" ,sum(A_Record.FLocalAmount) LocalValue \t                \n");
                sql.append(" ,sum(A_Record.FReportingAmount) ReportingValue             \n");
            } else {
                sql.append(" select sum(A_Record.FOriginalAmount * (voucherEntry.FEntryDC * 2 -1)) OriginalValue,      \n");
                sql.append(" sum(A_Record.FLocalAmount*(voucherEntry.FEntryDC * 2 -1)) LocalValue, \t                   \n");
                sql.append(" sum(A_Record.FReportingAmount * (voucherEntry.FEntryDC * 2 -1)) ReportingValue,A_Account.Fnumber AccountNumber  \n");
            }
        } else if (this.sortState.isAccrual()) {
            sql.append(" select sum(voucherEntry.FOriginalAmount) OriginalValue     \n");
            sql.append(" ,sum(voucherEntry.FLocalAmount) LocalValue \t\t\t\t\n");
            sql.append(" ,sum(voucherEntry.FReportingAmount) ReportingValue  \t\t\n");
        } else {
            sql.append(" select sum(voucherEntry.FOriginalAmount * (voucherEntry.FEntryDC * 2 -1)) OriginalValue,  \n");
            sql.append(" sum(voucherEntry.FLocalAmount * (voucherEntry.FEntryDC * 2 -1)) LocalValue, \t           \n");
            sql.append(" sum(voucherEntry.FReportingAmount * (voucherEntry.FEntryDC * 2 -1)) ReportingValue,A_Account.Fnumber AccountNumber \n");
        }
        if (this.sortState.getUnionCompanyLongNumber() == null && this.sortState.getSingleCompanyID() == null) {
            sql.append(" ,Voucher." + this.voucherResposit.getFieldName(this.sortState.getRptOrgType(), "Voucher") + " CompanyID\t\t\t\t\t\t            \n");
        }
        if (this.sortState.isNeedCurrency() && this.sortState.getSingleCurrencyID() == null) {
            sql.append(" ,voucherEntry.FCurrencyID currency  \t\t\t\t            \n");
        }
        if (this.sortState.getAccounts() == null) {
            sql.append(" ,A_Account.Fnumber AccountNumber                               \n");
        }
        if (this.sortState.getSingleAsstActItem() != null) {
            for (String[] asstitem : this.sortState.getSingleAsstActItem()) {
                sql.append(" , A_AsstType").append(asstitem[0]).append(".").append(asstitem[1]).append(" AsstActItem").append(asstitem[0]).append(" ");
            }
        }
        return sql.toString();
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append(this.fromPart);
    }

    private String innerBuildFromPart() {
        StringBuffer sql = new StringBuffer();
        sql.append(" From " + this.voucherResposit.getTableName(this.sortState.getRptOrgType(), "VoucherEntry") + " voucherEntry \t\t\t                                           \n");
        sql.append(" inner join " + this.voucherResposit.getTableName(this.sortState.getRptOrgType(), "Voucher") + " voucher on voucher.FID = voucherEntry.FBillID \t\t\t           \n");
        sql.append(" inner join T_BD_AccountView A_Account on voucherEntry.FAccountID = A_Account.Fid \t\t   \n");
        sql.append(" inner join T_ORG_Company VoucherCompany on voucher.FCompanyID = VoucherCompany.FID        \n");
        if (this.sortState.getUserDefineFilter() != null && this.sortState.getUserDefineFilter().indexOf("VoucherType") > -1) {
            sql.append(" inner join T_BD_VoucherTypes VoucherType on VoucherType.FID = voucher.FVoucherTypeID");
        }
        if (this.sortState.getAsstActTypeList() != null) {
            sql.append(" inner join " + this.voucherResposit.getTableName(this.sortState.getRptOrgType(), "VoucherAssistRecord") + " A_Record on voucherEntry.fid = A_Record.FEntryID  \n");
            sql.append(" inner join T_BD_AssistantHG A_Hg on A_Record.FAssGrpID = A_Hg.fid   \n");
            for (AsstActType itemType : this.sortState.getAsstActTypeList()) {
                sql.append(" inner join ").append(itemType.realtionDataObject).append(" A_AsstType").append(itemType.number).append(" on A_Hg.").append(itemType.mappingFieldName).append("=").append("A_AsstType").append(itemType.number).append(".FID   \n");
            }
        }
        return sql.toString();
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append(this.constantWherePart.getSQLString());
        params.addAll(this.constantWherePart.getParams());
    }

    private SQLStringWrapper innerBuildConstantWherePart() {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sql.append(" Where voucher.FBizStatus <> 0 \t\t\t        \n");
        sql.append(" and voucher.FBizStatus <> 2 \t\t\t        \n");
        if (!this.sortState.isIncludingUnPosted()) {
            sql.append(" and voucher.FBizStatus = 5 \t\t\t    \n");
        }
        sql.append(" and A_Account.FIsLeaf = 1\t\t\t            \n");
        if (this.sortState.isAccrual()) {
            sql.append(" and voucherEntry.FEntryDC = ?\t\t\t    \n");
            params.add(this.sortState.getDC());
        }
        sql.append(" and voucher.FBookedDate >= ?\t\t\t\t\t\n");
        if (this.sortState.isAccrual()) {
            params.add(new Timestamp(this.sortState.getStartDate().getTimeInMillis()));
        } else {
            params.add(new Timestamp(this.sortState.getEndPeriod().getBeginDate().getTime()));
        }
        sql.append(" and voucher.FBookedDate <= ?  \t\t\t\t\t\n");
        params.add(new Timestamp(this.sortState.getEndDate().getTimeInMillis()));
        if (this.sortState.getUnionCompanyLongNumber() != null) {
            sql.append(" and VoucherCompany.FLongNumber like ? ");
            sql.append(" and VoucherCompany.FIsbizunit = 1  \t    \n");
            params.add(this.sortState.getUnionCompanyLongNumber() + "!%");
        } else if (this.sortState.getSingleCompanyID() != null) {
            sql.append(" and voucher." + this.voucherResposit.getFieldName(this.sortState.getRptOrgType(), "Voucher") + " = ?\t\t            \n");
            params.add(this.sortState.getSingleCompanyID());
            sql.append(" and A_Account.FAccountTableID = ?          \n");
            params.add(this.sortState.getSingleAccountTableID());
        }
        if (this.sortState.isNeedCurrency() && this.sortState.getSingleCurrencyID() != null) {
            sql.append(" and voucherEntry.FCurrencyID=? \t\t\t\n");
            params.add(this.sortState.getSingleCurrencyID());
        }
        if (this.sortState.getAccounts() != null) {
            String[] accounts = this.sortState.getAccounts();
            sql.append(" and (A_Account.Fnumber >= ? and A_Account.Fnumber <= ? or A_Account.Fnumber like ?) ");
            params.add(accounts[0]);
            params.add(accounts[1]);
            params.add(accounts[1] + "%");
        }
        if (this.sortState.getAsstActTypeList() != null) {
            for (int i = 0; i < this.sortState.getAsstActTypeList().size(); ++i) {
                AsstActType item = (AsstActType)this.sortState.getAsstActTypeList().get(i);
                if (!item.realtionDataObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) continue;
                sql.append(" and A_AsstType").append(item.number).append(".FGroupID=? ");
                params.add(item.glAsstActTypeGrpID);
            }
        }
        if (this.sortState.getAsstActItems() != null) {
            for (String[] asstActItem : this.sortState.getAsstActItems()) {
                sql.append(" and A_AsstType").append(asstActItem[0]).append(".").append(asstActItem[3]).append(" >= ? and A_AsstType").append(asstActItem[0]).append(".").append(asstActItem[3]).append(" <= ?  ");
                params.add(asstActItem[1]);
                params.add(asstActItem[2]);
            }
        }
        if (this.sortState.getUserDefineFilter() != null) {
            sql.append(" and (").append(this.sortState.getUserDefineFilter()).append(") \t\t\n");
        }
        sql.append(" and ( ");
        return new SQLStringWrapper(sql.toString(), params);
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        if (this.isQueryDirect) {
            sql.append(" ( 1=? ) ");
            params.add(Integer.valueOf("1"));
            return;
        }
        boolean isFirst = true;
        Acctext acctext = (Acctext)formula;
        sql.append(" ( ");
        if (this.sortState.getUnionCompanyLongNumber() == null && this.sortState.getSingleCompanyID() == null) {
            sql.append(" voucher." + this.voucherResposit.getFieldName(this.sortState.getRptOrgType(), "Voucher") + " = ?\t\t\n");
            params.add(acctext.company.getId().toString());
            sql.append(" and A_Account.FAccountTableID = ?  \n");
            params.add(acctext.company.getAccountTable().getId().toString());
            isFirst = false;
        }
        if (this.sortState.isNeedCurrency() && this.sortState.getSingleCurrencyID() == null) {
            if (!isFirst) {
                sql.append(" and ");
            }
            sql.append(" voucherEntry.FCurrencyID = ? \t\t\t\n");
            params.add(acctext.currency.getId().toString());
            isFirst = false;
        }
        if (this.sortState.getAccounts() == null) {
            if (!isFirst) {
                sql.append(" and ");
            }
            sql.append(" A_Account.Fnumber like ?\t");
            params.add(acctext.accountItem.getAccountAsstItem().startNumber + "%");
            isFirst = false;
        }
        if (this.sortState.getSingleAsstActItem() != null) {
            for (String[] assistantItem : this.sortState.getSingleAsstActItem()) {
                AssistantItem asstItem = acctext.accountItem.getItem(assistantItem[0]);
                if (!isFirst) {
                    sql.append(" and ");
                }
                if (assistantItem[1] == "FLongNumber") {
                    sql.append("  ( A_AsstType").append(assistantItem[0]).append(".FLongNumber = ? or A_AsstType").append(assistantItem[0]).append(".FLongNumber like ? ) ");
                    params.add(asstItem.startItem.longNumber);
                    params.add(asstItem.startItem.longNumber + "!%");
                } else {
                    sql.append("  A_AsstType").append(assistantItem[0]).append(".FNumber = ? ");
                    params.add(asstItem.startItem.number);
                }
                isFirst = false;
            }
        }
        sql.append(" ) ");
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(this.groupByPart);
    }

    private String innerBuildGroupByPart() {
        StringBuffer sql = new StringBuffer();
        sql.append(" ) Group by ");
        if (this.isQueryDirect) {
            if (!this.sortState.isAccrual()) {
                sql.append(" A_Account.Fnumber ");
                return sql.toString();
            }
            return " ) ";
        }
        boolean isFirst = true;
        if (this.sortState.getUnionCompanyLongNumber() == null && this.sortState.getSingleCompanyID() == null) {
            sql.append("  Voucher." + this.voucherResposit.getFieldName(this.sortState.getRptOrgType(), "Voucher") + " ");
            isFirst = false;
        }
        if (this.sortState.isNeedCurrency() && this.sortState.getSingleCurrencyID() == null) {
            if (!isFirst) {
                sql.append(" , ");
            }
            sql.append(" voucherEntry.FCurrencyID ");
            isFirst = false;
        }
        if (this.sortState.getAccounts() == null) {
            if (!isFirst) {
                sql.append(" , ");
            }
            sql.append(" A_Account.Fnumber ");
            isFirst = false;
        }
        if (this.sortState.getSingleAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleAsstActItem()) {
                if (!isFirst) {
                    sql.append(" , ");
                }
                sql.append(" A_AsstType").append(itemType[0]).append(".").append(itemType[1]).append(" ");
                isFirst = false;
            }
        }
        if (!this.sortState.isAccrual()) {
            if (!isFirst) {
                sql.append(" , ");
            }
            sql.append(" A_Account.Fnumber ");
            isFirst = false;
        }
        return sql.toString();
    }

    @Override
    public void setSortState(IBatchSQLSortState sortState) {
        this.sortState = (AcctextAccrualSortState)sortState;
        this.refreshSQL();
    }

    private void refreshSQL() {
        this.isQueryDirect = this.isQueryDirect();
        this.selectPart = this.innerBuildSelectPart();
        this.fromPart = this.innerBuildFromPart();
        this.constantWherePart = this.innerBuildConstantWherePart();
        this.groupByPart = this.innerBuildGroupByPart();
        this.indexFiled = this.innerBuildIndexFiled();
        this.longAsstItemNumberList.clear();
        if (this.sortState.getSingleAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleAsstActItem()) {
                if (itemType[1] != "FLongNumber") continue;
                this.longAsstItemNumberList.add(itemType[0]);
            }
        }
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combinaState;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        Acctext acctExt = (Acctext)formula;
        ArrayList<String> fileds = new ArrayList<String>();
        if (this.sortState.getUnionCompanyLongNumber() == null && this.sortState.getSingleCompanyID() == null) {
            fileds.add(acctExt.company.getId().toString());
        }
        if (this.sortState.isNeedCurrency() && this.sortState.getSingleCurrencyID() == null) {
            fileds.add(acctExt.currency.getId().toString());
        }
        if (this.sortState.getSingleAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleAsstActItem()) {
                if (itemType[1] == "FLongNumber") continue;
                AssistantItem item = acctExt.accountItem.getItem(itemType[0]);
                fileds.add(item.startItem.number);
            }
        }
        Object[][] result = new Object[1][fileds.size()];
        result[0] = fileds.toArray();
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        return this.indexFiled;
    }

    private String[] innerBuildIndexFiled() {
        ArrayList<String> indexedFields = new ArrayList<String>();
        if (this.sortState.getUnionCompanyLongNumber() == null && this.sortState.getSingleCompanyID() == null) {
            indexedFields.add("CompanyID");
        }
        if (this.sortState.isNeedCurrency() && this.sortState.getSingleCurrencyID() == null) {
            indexedFields.add("currency");
        }
        if (this.sortState.getSingleAsstActItem() != null) {
            for (String[] itemType : this.sortState.getSingleAsstActItem()) {
                if (itemType[1] == "FLongNumber") continue;
                indexedFields.add("AsstActItem" + itemType[0]);
            }
        }
        String[] result = new String[indexedFields.size()];
        indexedFields.toArray(result);
        return result;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return this.batchSize;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        AcctextAccrualCombinaState state = (AcctextAccrualCombinaState)combineState;
        if (this.sortState.getAccounts() == null) {
            state.setAccountNumber(rs.getString("AccountNumber"));
        } else {
            state.setAccountNumber(null);
        }
        if (!this.sortState.isAccrual()) {
            state.setAccountNumberByDC(rs.getString("AccountNumber"));
        }
        state.getLongNumberMap().clear();
        for (String field : this.longAsstItemNumberList) {
            state.getLongNumberMap().put(field, rs.getString("AsstActItem" + field));
        }
        state.setOriginal(rs.getBigDecimal("OriginalValue"));
        state.setLocal(rs.getBigDecimal("LocalValue"));
        state.setReporting(rs.getBigDecimal("ReportingValue"));
    }

    @Override
    public Set getAllowedNullFields() {
        return null;
    }

    @Override
    public List getFormulaCalculators() {
        return this.sortState.getFormulaList();
    }

    public boolean isQueryDirect() {
        if (this.sortState.getUnionCompanyLongNumber() == null && this.sortState.getSingleCompanyID() == null) {
            return false;
        }
        if (this.sortState.isNeedCurrency() && this.sortState.getSingleCurrencyID() == null) {
            return false;
        }
        if (this.sortState.getAccounts() == null) {
            return false;
        }
        return this.sortState.getSingleAsstActItem() == null;
    }
}

