/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctext;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountUserLevelCollection;
import com.kingdee.eas.basedata.master.account.AccountUserLevelInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ReportBatchCalculatorImpl;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.VoucherGetTypeEnum;
import com.kingdee.eas.fi.rpt.app.Account;
import com.kingdee.eas.fi.rpt.app.AccountItem;
import com.kingdee.eas.fi.rpt.app.AcctExtCalculater;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.ProfitCenterQuerySolution;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterProcessor;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSorterRegister;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.batch.PropertyFilter;
import com.kingdee.eas.fi.rpt.batch.acctext.Acctext;
import com.kingdee.eas.fi.rpt.batch.acctext.AcctextAccrualProcessor;
import com.kingdee.eas.fi.rpt.batch.acctext.AcctextRootBuilder;
import com.kingdee.eas.fi.rpt.batch.acctext.IAcctextCalculateProcessor;
import com.kingdee.eas.fi.rpt.batch.acctext.IAcctextSorter;
import com.kingdee.eas.fi.rpt.batch.acctext.INeedAcctCalculate;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AcctextBatchCalculator
extends AbstractCalculator {
    private static final int MAX_TEMPTABLE_SIZE = 10000;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final String ACCOUNT_TEMP_TABLE = "account_temp_table";
    private Map accountTableCache = new HashMap();
    private Map periodCache = new HashMap();
    public static final Set originalSet;
    public static final Set localSet;
    public static final Set reportingSet;
    private static Map accountTableID2InfoMap;

    public AcctextBatchCalculator(ICalculateContextProvider context, Context serverCtx) {
        super(context, serverCtx);
    }

    @Override
    protected void calculate() throws BOSException, EASBizException {
        AcctextRootBuilder builder = new AcctextRootBuilder();
        for (Acctext acctext : this.getFormulaCalculatorParameterList()) {
            builder.submitFormula(acctext);
        }
        this.calculateAcct(builder);
        this.calculateWithBuilder(builder);
        this.calculateWithOldMethod(builder.getOldMethodList());
        this.setScale();
    }

    private void setScale() throws EASBizException, BOSException {
        Map paramsMap = RptUtil.getCslParams(this.serverContext, new String[]{"AcctExt_Value_RoundingByPrecision"});
        boolean isRoundingByPrecision = RptUtil.isTrue(paramsMap.get("AcctExt_Value_RoundingByPrecision"));
        if (isRoundingByPrecision) {
            for (Acctext acctext : this.getFormulaCalculatorParameterList()) {
                if (acctext.isException() || !(acctext.getParameter().getValue() instanceof BigDecimal)) continue;
                BigDecimal value = (BigDecimal)acctext.getParameter().getValue();
                value = value.setScale(acctext.currency.getPrecision(), 4);
            }
        }
    }

    private void calculateWithOldMethod(List oldMethodList) throws EASBizException, BOSException {
        for (Acctext acctext : oldMethodList) {
            try {
                AcctExtCalculater calculater = new AcctExtCalculater(this.getServerContext(), acctext.company, acctext.accountItem, acctext.oppAccountItem, acctext.userDefineFiter, acctext.vchGetType, acctext.currency, acctext.startDate, acctext.endDate, acctext.isincludingUnPosted, false, acctext.startPeriod, acctext.endPeriod);
                BigDecimal result = calculater.calculateOne();
                acctext.combineNumberValue(result);
            }
            catch (EASBizException ex) {
                acctext.setException((Exception)((Object)ex));
            }
            catch (BOSException bosex) {
                acctext.setException((Exception)((Object)bosex));
            }
        }
    }

    private void calculateAcct(AcctextRootBuilder builder) {
        ArrayList arrayParam = new ArrayList();
        SortedParameterArray paramList = new SortedParameterArray();
        this.collectParam(builder, paramList, arrayParam);
        this.doCalcAcct(paramList);
        this.fillAcctResult(paramList, arrayParam);
    }

    private void fillAcctResult(SortedParameterArray paramList, List arrayParam) {
        int count = paramList.size();
        ArrayList<Object> acctCalculatedList = new ArrayList<Object>();
        for (int i = 0; i < count; ++i) {
            acctCalculatedList.add(paramList.getAt(i));
        }
        for (Parameter[] param : arrayParam) {
            BigDecimal newValue;
            BigDecimal oldValue;
            Object old;
            Object value = param[1].getValue();
            if (value == null) {
                int pos = Collections.binarySearch(acctCalculatedList, param[1]);
                if (pos != -1) {
                    Parameter parameter = (Parameter)acctCalculatedList.get(pos);
                    value = parameter.getValue();
                } else {
                    value = new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"37_AcctextBatchCalculator", (Locale)this.getServerContext().getLocale()));
                }
            }
            if ((old = param[0].getValue()) == null) {
                old = CslConstant.BGZERO;
            }
            if (value instanceof Exception) {
                param[0].setValue(value);
                continue;
            }
            if (value instanceof String) {
                oldValue = null;
                try {
                    oldValue = new BigDecimal(old.toString());
                }
                catch (RuntimeException e1) {
                    old = CslConstant.BGZERO;
                    oldValue = CslConstant.BGZERO;
                }
                try {
                    newValue = new BigDecimal(value.toString());
                    param[0].setValue((Object)oldValue.add(newValue));
                }
                catch (RuntimeException e) {
                    param[0].setValue(value);
                }
                continue;
            }
            if (!(value instanceof BigDecimal)) continue;
            oldValue = null;
            try {
                oldValue = new BigDecimal(old.toString());
            }
            catch (RuntimeException e1) {
                old = CslConstant.BGZERO;
                oldValue = CslConstant.BGZERO;
            }
            try {
                newValue = (BigDecimal)value;
                param[0].setValue((Object)oldValue.add(newValue));
            }
            catch (RuntimeException e) {
                param[0].setValue(value);
            }
        }
    }

    private void doCalcAcct(SortedParameterArray paramList) {
        ReportBatchCalculatorImpl calculater = new ReportBatchCalculatorImpl();
        calculater.batchMethodQuery(this.getCalCulateContext(), "acct", paramList);
    }

    private void collectParam(AcctextRootBuilder builder, SortedParameterArray paramList, List arrayParam) {
        INeedAcctCalculate needAcct;
        if (builder.getCalculateProcessors() != null && builder instanceof INeedAcctCalculate) {
            for (IAcctextCalculateProcessor processor : builder.getCalculateProcessors()) {
                if (!(processor instanceof INeedAcctCalculate)) continue;
                needAcct = (INeedAcctCalculate)((Object)processor);
                arrayParam.addAll(needAcct.getAcctextParams());
                for (Parameter[] param : needAcct.getAcctextParams()) {
                    paramList.insert((Object)param[1]);
                }
            }
        }
        if (builder.getSubSorters() != null) {
            for (IAcctextSorter subBuilder : builder.getSubSorters()) {
                if (!(subBuilder instanceof INeedAcctCalculate)) continue;
                needAcct = (INeedAcctCalculate)((Object)subBuilder);
                arrayParam.addAll(needAcct.getAcctextParams());
                for (Parameter[] param : needAcct.getAcctextParams()) {
                    paramList.insert((Object)param[1]);
                }
            }
        }
    }

    private void calculateWithBuilder(IAcctextSorter builder) throws BOSException {
        if (builder.getCalculateProcessors() != null) {
            for (Object processor : builder.getCalculateProcessors()) {
                processor.calculate(this.getBatchHelper());
            }
        }
        if (builder.getSubSorters() != null) {
            for (IAcctextSorter subBuilder : builder.getSubSorters()) {
                this.calculateWithBuilder(subBuilder);
            }
        }
        if (builder instanceof IBatchSQLSorterRegister) {
            try {
                Object processor;
                IBatchSQLSorterRegister register = (IBatchSQLSorterRegister)((Object)builder);
                processor = new AcctextAccrualProcessor(this.batchHelper.getBatchSize());
                this.getBatchHelper().batchCalculateBigDecimalBySorter((IBatchSQLSorterProcessor)processor, register);
            }
            catch (BOSException e) {
                try {
                    BatchHelper.printExceptionMessage((Exception)((Object)e));
                }
                catch (EASBizException e1) {
                    throw new BOSException((Throwable)e1);
                }
            }
        }
    }

    @Override
    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        this.getBatchHelper().initBatchSize("AcctextParamsSize");
        int count = params.size();
        HashMap<String, Object> currencyMap = new HashMap<String, Object>();
        HashMap companyMap = new HashMap();
        HashMap<String, Object> profitCenterMap = new HashMap<String, Object>();
        HashMap<String, Object> orgMap = null;
        OneToManyMap asstActTypeNumber2ItemMap = new OneToManyMap(2);
        for (int i = 0; i < count; ++i) {
            Acctext acctext = new Acctext(params.getParameter(i), this.batchHelper);
            if (acctext.isException()) {
                this.addToErrorList(acctext);
                continue;
            }
            orgMap = OrgType.ProfitCenter.equals((Object)acctext.orgType) ? profitCenterMap : companyMap;
            currencyMap.put(acctext.currencyString, null);
            if (acctext.companys == null) {
                orgMap.put(acctext.fiOrgUnit, null);
            } else {
                for (String companyNumber : acctext.companys) {
                    orgMap.put(companyNumber, null);
                }
            }
            String[] accounts = acctext.account.split("\\s*,\\s*");
            if (accounts.length == 1) {
                try {
                    AcctountAsstItemParser.AccountAsstItem parsedStartAcctItem = AcctountAsstItemParser.parse(acctext.account);
                    acctext.accountItem = new AccountItem(this.getServerContext(), parsedStartAcctItem, null);
                    this.addAsstActType(asstActTypeNumber2ItemMap, parsedStartAcctItem);
                    if (!StringUtils.isEmpty((String)acctext.opposingAccount)) {
                        if (acctext.opposingAccount.split("\\s*,\\s*").length > 1) {
                            this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.OPPACCOUT_NOT_SURPORT_DESCRETEACCOUNT)));
                            continue;
                        }
                        AcctountAsstItemParser.AccountAsstItem parsedOppAcctItem = AcctountAsstItemParser.parse(acctext.opposingAccount);
                        acctext.oppAccountItem = new AccountItem(this.getServerContext(), parsedOppAcctItem, null);
                        this.addAsstActType(asstActTypeNumber2ItemMap, parsedOppAcctItem);
                    }
                    acctext.accountItem.discreteAccount = new Account[acctext.accountItem.getAccountAsstItem().accounts.length][2];
                }
                catch (ParseException e) {
                    this.addToErrorList(acctext, e);
                    continue;
                }
                this.getFormulaCalculatorParameterList().add(acctext);
                continue;
            }
            try {
                if (!StringUtils.isEmpty((String)acctext.opposingAccount)) {
                    if (acctext.opposingAccount.split("\\s*,\\s*").length > 1) {
                        this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.OPPACCOUT_NOT_SURPORT_DESCRETEACCOUNT)));
                        continue;
                    }
                    AcctountAsstItemParser.AccountAsstItem parsedOppAcctItem = AcctountAsstItemParser.parse(acctext.opposingAccount);
                    acctext.oppAccountItem = new AccountItem(this.getServerContext(), parsedOppAcctItem, null);
                    this.addAsstActType(asstActTypeNumber2ItemMap, parsedOppAcctItem);
                }
                for (int j = 0; j < accounts.length; ++j) {
                    Acctext newAcctext = acctext.cloneForSplit();
                    newAcctext.account = accounts[j];
                    AcctountAsstItemParser.AccountAsstItem parsedStartAcctItem = AcctountAsstItemParser.parse(accounts[j]);
                    newAcctext.accountItem = new AccountItem(this.getServerContext(), parsedStartAcctItem, null);
                    this.addAsstActType(asstActTypeNumber2ItemMap, parsedStartAcctItem);
                    newAcctext.accountItem.discreteAccount = new Account[newAcctext.accountItem.getAccountAsstItem().accounts.length][2];
                    this.getFormulaCalculatorParameterList().add(newAcctext);
                }
                continue;
            }
            catch (ParseException e) {
                this.addToErrorList(acctext, e);
            }
        }
        this.initCurrency(currencyMap);
        this.initCompanys(companyMap);
        this.initProfitCenters(profitCenterMap);
        this.initCompanyDependencies(asstActTypeNumber2ItemMap);
    }

    private void addAsstActType(Map asstActTypeNumber2ItemMap, AcctountAsstItemParser.AccountAsstItem parsedAcctItem) {
        if (parsedAcctItem.asstItems == null) {
            return;
        }
        for (int i = 0; i < parsedAcctItem.asstItems.length; ++i) {
            if (!StringUtils.isEmpty((String)parsedAcctItem.asstItems[i].startNumber)) {
                asstActTypeNumber2ItemMap.put(parsedAcctItem.asstItems[i].asstTypeNumber, parsedAcctItem.asstItems[i].startNumber);
            }
            if (!StringUtils.isEmpty((String)parsedAcctItem.asstItems[i].endNumber)) {
                asstActTypeNumber2ItemMap.put(parsedAcctItem.asstItems[i].asstTypeNumber, parsedAcctItem.asstItems[i].endNumber);
            }
            if (asstActTypeNumber2ItemMap.get(parsedAcctItem.asstItems[i].asstTypeNumber) != null) continue;
            asstActTypeNumber2ItemMap.put(parsedAcctItem.asstItems[i].asstTypeNumber, null);
        }
    }

    /*
     * Exception decompiling
     */
    private void initCompanyDependencies(Map asstActTypeNumber2ItemMap) throws EASBizException, BOSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isAccrualAmoutNoOppAccount(Acctext acctext) {
        return !acctext.company.isIsBizUnit() && acctext.oppAccountItem == null && AcctextBatchCalculator.isGetAccrualAmount(acctext.vchGetType);
    }

    private static boolean isVirtualUnitBalance(Acctext acctext) {
        return !acctext.company.isIsBizUnit() && (AcctextBatchCalculator.isGetEndBalance(acctext.vchGetType) || AcctextBatchCalculator.isGetInitialAmount(acctext.vchGetType));
    }

    private void initAccount(Map acctext2AccountMap, Map asstActTypeNumber2ItemMap, Map asstActTypeMap, Map needLongNumberasstActTypeMap) throws BOSException, EASBizException {
        Iterator iterator = this.getFormulaCalculatorParameterList().iterator();
        while (iterator.hasNext()) {
            String none;
            Acctext acctext = (Acctext)iterator.next();
            if (acctext.isException()) {
                this.addToErrorList(acctext);
                iterator.remove();
                continue;
            }
            this.fillAccount(acctext, acctext.accountItem, acctext2AccountMap, asstActTypeMap, needLongNumberasstActTypeMap);
            if (!AcctextBatchCalculator.isAccrualAmoutNoOppAccount(acctext) && !AcctextBatchCalculator.isVirtualUnitBalance(acctext)) {
                if (acctext.accountItem.startAccount == null || acctext.accountItem.endAccount == null) {
                    String string = none = acctext.accountItem.startAccount == null ? acctext.accountItem.getAccountAsstItem().startNumber : acctext.accountItem.getAccountAsstItem().endNumber;
                    if (acctext.companys != null && acctext.companys.size() > 1) {
                        acctext.getParameter().setValue((Object)CslConstant.BGZERO);
                    } else {
                        this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"38_AcctextBatchCalculator", (Locale)this.batchHelper.getServerContext().getLocale()) + acctext.company.getNumber() + " " + RptUtil.getReportResource("report_calc_noaccount", this.getServerContext().getLocale()) + " \"" + none + "\""})));
                    }
                    iterator.remove();
                    continue;
                }
                if (!acctext.accountItem.isSameLevel()) {
                    this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.ACCTEXT_FORMULA_ERROR)));
                    iterator.remove();
                    continue;
                }
                acctext.accountLevel = new Integer(acctext.accountItem.startAccount.level);
            }
            Iterator it = acctext.accountItem.getItemTypes().entrySet().iterator();
            while (it.hasNext()) {
                AssistantItem item = (AssistantItem)it.next().getValue();
                if (!StringUtils.isEmpty((String)item.startItem.number) || !StringUtils.isEmpty((String)item.endItem.number)) {
                    acctext.hasDetailAsstact = true;
                }
                if (item.itemType == null) continue;
                if (item.itemType.realtionDataObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                    acctext.isAsstActNeedLongNumber = true;
                    acctext.hasGeneralAsstActType = true;
                    continue;
                }
                if (!item.itemType.useLongNumber && !RptUtil.isUseLongNumber(item.itemType.useLongNumber, item.itemType.realtionDataObject)) continue;
                acctext.isAsstActNeedLongNumber = true;
            }
            if (acctext.oppAccountItem == null) continue;
            this.fillAccount(acctext, acctext.oppAccountItem, acctext2AccountMap, asstActTypeMap, needLongNumberasstActTypeMap);
            if (acctext.oppAccountItem.startAccount == null || acctext.oppAccountItem.endAccount == null) {
                String string = none = acctext.oppAccountItem.startAccount == null ? acctext.oppAccountItem.getAccountAsstItem().startNumber : acctext.oppAccountItem.getAccountAsstItem().endNumber;
                if (acctext.companys != null && acctext.companys.size() > 1) {
                    acctext.getParameter().setValue((Object)CslConstant.BGZERO);
                } else {
                    this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"38_AcctextBatchCalculator", (Locale)this.getServerContext().getLocale()) + acctext.company.getNumber() + " " + RptUtil.getReportResource("report_calc_noaccount", this.getServerContext().getLocale()) + " \"" + none + "\""})));
                }
                iterator.remove();
                continue;
            }
            if (!AcctextBatchCalculator.isGetAccrualAmount(acctext.vchGetType)) {
                if ((AcctextBatchCalculator.isGetInitialAmount(acctext.vchGetType) || AcctextBatchCalculator.isGetEndBalance(acctext.vchGetType)) && acctext.oppAccountItem != null) {
                    this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.NOT_SUPPORT_FORMULA_PARAMETER)));
                    iterator.remove();
                    continue;
                }
                if (acctext.accountItem.hasItem() && acctext.oppAccountItem != null && acctext.oppAccountItem.endAccount != null) {
                    this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.NOT_SUPPORT_FORMULA_PARAMETER)));
                    iterator.remove();
                    continue;
                }
                if (acctext.oppAccountItem != null && acctext.oppAccountItem.hasItem()) {
                    this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.NOT_SUPPORT_FORMULA_PARAMETER)));
                    iterator.remove();
                    continue;
                }
            }
            if (acctext.oppAccountItem.isSameLevel()) continue;
            this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.ACCTEXT_FORMULA_ERROR)));
            iterator.remove();
        }
    }

    private void fillAccount(Acctext acctext, AccountItem accountItem, Map acctext2AccountMap, Map asstActTypeMap, Map needLongNumberasstActTypeMap) throws EASBizException, BOSException {
        int i;
        AcctountAsstItemParser.AccountAsstItem acctitem = accountItem.getAccountAsstItem();
        accountItem.discreteAccount = new Account[acctitem.accounts.length][2];
        StringBuffer sb = new StringBuffer();
        for (i = 0; acctitem.accounts != null && i < acctitem.accounts.length; ++i) {
            block8: {
                try {
                    if (acctext2AccountMap == null) break block8;
                    sb.append(acctext.company.getLongNumber()).append(acctext.company.getAccountTable().getId()).append(acctitem.accounts[i].startNumber);
                    accountItem.discreteAccount[i][0] = (Account)acctext2AccountMap.get(sb.toString());
                    sb.setLength(0);
                    sb.append(acctext.company.getLongNumber()).append(acctext.company.getAccountTable().getId()).append(acctitem.accounts[i].endNumber);
                    accountItem.discreteAccount[i][1] = (Account)acctext2AccountMap.get(sb.toString());
                    sb.setLength(0);
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (i != 0) continue;
            accountItem.startAccount = accountItem.discreteAccount[0][0];
            accountItem.endAccount = accountItem.discreteAccount[0][1];
            if (AcctextBatchCalculator.isAccrualAmoutNoOppAccount(acctext) || AcctextBatchCalculator.isVirtualUnitBalance(acctext) || accountItem.startAccount != null && accountItem.endAccount != null || StringUtils.isEmpty((String)acctitem.startNumber) || StringUtils.isEmpty((String)acctitem.endNumber) || acctitem.startNumber.length() != acctitem.endNumber.length() || acctitem.startNumber.equals(acctitem.endNumber)) continue;
            this.fillAccountAgainForInterval(acctext, accountItem);
            if (accountItem.startAccount == null || accountItem.endAccount == null) continue;
            accountItem.getAccountAsstItem().startNumber = accountItem.startAccount.number;
            accountItem.getAccountAsstItem().endNumber = accountItem.endAccount.number;
            accountItem.getAccountAsstItem().accounts[0].startNumber = accountItem.startAccount.number;
            accountItem.getAccountAsstItem().accounts[0].endNumber = accountItem.endAccount.number;
        }
        for (i = 0; acctitem.asstItems != null && i < acctitem.asstItems.length; ++i) {
            AssistantItem item = new AssistantItem();
            item.itemType = (AsstActType)asstActTypeMap.get(acctitem.asstItems[i].asstTypeNumber);
            if (item.itemType == null) {
                acctext.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("report_calc_noitemtype", this.getServerContext().getLocale()) + " \"" + acctitem.asstItems[i].asstTypeNumber + "\""})));
                return;
            }
            item.startItem = new GroupTreeNode();
            item.endItem = new GroupTreeNode();
            accountItem.getItemTypes().put(item.itemType.number, item);
            item.startItem.number = acctitem.asstItems[i].startNumber;
            item.endItem.number = acctitem.asstItems[i].endNumber;
            if (item.itemType.realtionDataObject != null && (item.itemType.useLongNumber || item.itemType.realtionDataObject.equalsIgnoreCase("t_bd_generalasstacttype"))) {
                item.startItem.number = item.startItem.number == null ? null : item.startItem.number.replaceAll("\\.", "\\!");
                item.startItem.longNumber = item.startItem.number;
                item.endItem.number = item.endItem.number == null ? null : item.endItem.number.replaceAll("\\.", "\\!");
                item.endItem.longNumber = item.endItem.number;
                if (item.startItem.number == null || item.endItem.number == null || item.startItem.number == item.endItem.number || item.startItem.number.split("\\!").length == item.endItem.number.split("\\!").length) continue;
                acctext.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("AssistantItemMustbeTheSameLevel")})));
                return;
            }
            if (item.itemType.realtionDataObject == null || !RptUtil.isUseLongNumber(item.itemType.useLongNumber, item.itemType.realtionDataObject) || StringUtils.isEmpty((String)item.startItem.number) && StringUtils.isEmpty((String)item.endItem.number)) continue;
            GroupTreeNode node = (GroupTreeNode)needLongNumberasstActTypeMap.get(item.startItem.number);
            GroupTreeNode node2 = (GroupTreeNode)needLongNumberasstActTypeMap.get(item.endItem.number);
            if (node == null) {
                acctext.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"1_AccountItem", (Locale)this.getServerContext().getLocale()) + item.startItem.number + "\""})));
                return;
            }
            if (node2 == null) {
                acctext.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"1_AccountItem", (Locale)this.getServerContext().getLocale()) + item.endItem.number + "\""})));
                return;
            }
            item.startItem.longNumber = node.longNumber;
            item.endItem.longNumber = node2.longNumber;
        }
    }

    private void fillAccountAgainForInterval(Acctext acctext, AccountItem accountItem) throws EASBizException, BOSException {
        int i;
        AccountTableInfo accountTable = (AccountTableInfo)accountTableID2InfoMap.get(acctext.company.getAccountTable().getId().toString());
        if (accountTable == null) {
            accountTable = AccountTableFactory.getLocalInstance((Context)this.getServerContext()).getAccountTableInfo((IObjectPK)new ObjectUuidPK(acctext.company.getAccountTable().getId()));
            accountTableID2InfoMap.put(accountTable.getId().toString(), accountTable);
        }
        String startAccount = accountItem.getAccountAsstItem().startNumber;
        int level = 0;
        if (!accountTable.isIsUseSeparator() || StringUtils.isEmpty((String)accountTable.getSeparator())) {
            AccountUserLevelCollection userLevel = accountTable.getUserLevel();
            int lenth = startAccount.length();
            int addLenth = 0;
            for (i = 0; i < userLevel.size(); ++i) {
                AccountUserLevelInfo userLevelInfo = userLevel.get(i);
                if ((addLenth += userLevelInfo.getLength()) <= lenth) continue;
                level = i;
                break;
            }
        } else {
            StringBuffer newSeparator = new StringBuffer();
            String separator = accountTable.getSeparator();
            int length = separator.length();
            for (i = 0; i < length; ++i) {
                char ch = separator.charAt(i);
                if ('.' == ch || '+' == ch || '*' == ch || '[' == ch || ']' == ch || '{' == ch || '}' == ch) {
                    newSeparator.append("\\").append(ch);
                    continue;
                }
                newSeparator.append(ch);
            }
            level = startAccount.split(newSeparator.toString()).length;
        }
        if (level > 0) {
            StringBuffer sql = new StringBuffer();
            ArrayList<Object> params = new ArrayList<Object>();
            sql.append(" Select V.FID ID, V.FNumber AccountNumber,V.FDc AccountDC,V.FIsLeaf IsLeaf, V.FLevel lv, max(company.FLevel) O_FLevel  \n");
            sql.append(" from T_Bd_AccountView V   \n");
            sql.append(" inner join T_ORG_Company company on V.FCompanyID = company.FID   \n");
            sql.append(" inner join T_ORG_Company leafCompany on charindex(concat(company.FLongNumber,'!'),leafCompany.FLongNumber) = 1 or leafCompany.FLongNumber = company.FLongNumber   \n");
            sql.append(" where V.FNumber >= ?   \n");
            params.add(accountItem.getAccountAsstItem().startNumber);
            sql.append(" and V.FNumber <= ?   \n");
            params.add(accountItem.getAccountAsstItem().endNumber);
            sql.append(" and  V.FAccountTableID = ?  \n");
            params.add(acctext.company.getAccountTable().getId().toString());
            sql.append(" and V.FLevel = ?   \n");
            params.add(new Integer(level));
            sql.append(" and leafCompany.FID = ?  \n");
            params.add(acctext.company.getId().toString());
            sql.append(" GROUP BY V.FID, V.FDc ,V.FIsLeaf, V.FLevel,V.FNumber   \n");
            sql.append(" order by O_FLevel desc, V.FNumber asc   \n");
            IRowSet rowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)sql.toString(), (Object[])params.toArray());
            try {
                boolean isFirst = true;
                int maxCompanyLevel = -1;
                while (rowSet.next()) {
                    Account account;
                    if (isFirst) {
                        maxCompanyLevel = rowSet.getInt("O_FLevel");
                        account = new Account();
                        account.id = rowSet.getString("ID");
                        account.dc = rowSet.getInt("AccountDC");
                        account.isLeaf = rowSet.getInt("IsLeaf") == 1;
                        account.level = rowSet.getInt("lv");
                        account.number = rowSet.getString("AccountNumber");
                        account.companyLevel = maxCompanyLevel;
                        accountItem.startAccount = account;
                        isFirst = false;
                        continue;
                    }
                    if (rowSet.getInt("O_FLevel") == maxCompanyLevel) continue;
                    rowSet.last();
                    account = new Account();
                    account.id = rowSet.getString("ID");
                    account.dc = rowSet.getInt("AccountDC");
                    account.isLeaf = rowSet.getInt("IsLeaf") == 1;
                    account.level = rowSet.getInt("lv");
                    account.number = rowSet.getString("AccountNumber");
                    account.companyLevel = maxCompanyLevel;
                    accountItem.endAccount = account;
                    break;
                }
                if (accountItem.endAccount == null) {
                    accountItem.endAccount = accountItem.startAccount;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private void queryAsstActType(Map asstActTypeNumber2ItemMap, Map asstActTypeMap, Map needLongNumberasstActTypeMap) throws BOSException {
        if (asstActTypeNumber2ItemMap == null || asstActTypeNumber2ItemMap.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FNumber, FrealtionDataObject FtableName, FmappingFieldName FfieldName ,    \n").append(" FGlAsstActTypeGrpID groupID, FGroupTableName , FGroupMappingFieldName,FUseLongNumber                \n").append(" FROM T_BD_AsstActType where  FNumber IN                                              \n");
        sql.append(this.getBatchHelper().createInSql(asstActTypeNumber2ItemMap.keySet().iterator()));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)sql.toString());
        HashMap needLongNumberTypeMap = new HashMap();
        try {
            while (rowSet.next()) {
                AsstActType type = new AsstActType();
                type.realtionDataObject = rowSet.getString("FtableName").toUpperCase();
                type.mappingFieldName = rowSet.getString("FfieldName").toUpperCase();
                type.number = rowSet.getString("FNumber");
                type.glAsstActTypeGrpID = rowSet.getString("groupID");
                type.groupTableName = rowSet.getString("FGroupTableName");
                type.groupMappingFieldName = rowSet.getString("FGroupMappingFieldName");
                type.useLongNumber = rowSet.getBoolean("FUseLongNumber");
                asstActTypeMap.put(type.number, type);
                if (type.realtionDataObject == null || !RptUtil.isUseLongNumber(type.useLongNumber, type.realtionDataObject)) continue;
                HashSet detailNumberSet = (HashSet)needLongNumberTypeMap.get(type.realtionDataObject);
                if (detailNumberSet == null) {
                    detailNumberSet = new HashSet();
                    needLongNumberTypeMap.put(type.realtionDataObject, detailNumberSet);
                }
                detailNumberSet.addAll((Set)asstActTypeNumber2ItemMap.get(type.number));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        this.queryAsstActItemLongNumber(needLongNumberTypeMap, needLongNumberasstActTypeMap);
    }

    private void queryAsstActItemLongNumber(Map needLongNumberTypeMap, Map needLongNumberasstActTypeMap) throws BOSException {
        if (needLongNumberTypeMap.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("select distinct FNumber, FLongNumber, FLevel from ");
        String sqlwhere = " where fnumber in ";
        for (Map.Entry entry : needLongNumberTypeMap.entrySet()) {
            Set detailNumberSet = (Set)entry.getValue();
            if (!(detailNumberSet.size() <= 0 || detailNumberSet.size() == 1 && detailNumberSet.contains(null))) {
                sql.append(entry.getKey());
                sql.append(sqlwhere);
                sql.append(this.getBatchHelper().createInSql(detailNumberSet.iterator()));
                IRowSet rowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)sql.toString());
                try {
                    while (rowSet.next()) {
                        GroupTreeNode item = new GroupTreeNode();
                        item.longNumber = rowSet.getString("FLongNumber");
                        item.number = rowSet.getString("FNumber");
                        item.level = rowSet.getInt("FLevel");
                        needLongNumberasstActTypeMap.put(item.number, item);
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            sql.setLength(0);
            sql.append("select distinct FNumber, FLongNumber, FLevel from  ");
        }
    }

    private Map queryAccount(String tempAccountTableName) throws BOSException {
        if (this.getFormulaCalculatorParameterList().size() == 0) {
            TableManagerFacadeFactory.getLocalInstance((Context)this.getServerContext()).releaseTemporaryTableName(tempAccountTableName);
            return new HashMap();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Select V.FID ID, V.FDc DC ,V.FIsLeaf IsLeaf, V.FLevel lv , max(company.FLevel) O_FLevel ,                \n");
        sql.append(" t.FCompanyLongNumber CompanyLongNumber,t.FAccountTableID AccountTableID,t.FAccountNumber AccountNumber   \n");
        sql.append(" from T_Bd_AccountView V    \n");
        sql.append(" inner join T_ORG_Company company on company.fid = V.FCompanyID                                           \n");
        sql.append(" inner join ").append(tempAccountTableName).append(" t on V.FAccountTableID = t.FAccountTableID           \n");
        sql.append(" where V.FNumber = t.FAccountNumber   \n");
        sql.append(" and (charindex(concat(company.FLongNumber,'!'),t.FCompanyLongNumber)=1 or t.FCompanyLongNumber = company.FLongNumber)     \n");
        sql.append(" GROUP BY V.FID, V.FDc ,V.FIsLeaf, V.FLevel,company.FLongNumber,t.FCompanyLongNumber,t.FAccountTableID,t.FAccountNumber    \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)sql.toString());
        StringBuffer keyBuffer = new StringBuffer();
        HashMap<String, Account> acctext2AccountMap = new HashMap<String, Account>();
        try {
            while (rowSet.next()) {
                keyBuffer.append(rowSet.getString("CompanyLongNumber")).append(rowSet.getString("AccountTableID")).append(rowSet.getString("AccountNumber"));
                Account account = (Account)acctext2AccountMap.get(keyBuffer.toString());
                if (account == null) {
                    account = new Account();
                }
                if (account.companyLevel == -1 || account.companyLevel < rowSet.getInt("O_FLevel")) {
                    account.id = rowSet.getString("ID");
                    account.dc = rowSet.getInt("DC");
                    account.isLeaf = rowSet.getInt("IsLeaf") == 1;
                    account.level = rowSet.getInt("lv");
                    account.number = rowSet.getString("AccountNumber");
                    account.companyLevel = rowSet.getInt("O_FLevel");
                    acctext2AccountMap.put(keyBuffer.toString(), account);
                }
                keyBuffer.setLength(0);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            TableManagerFacadeFactory.getLocalInstance((Context)this.getServerContext()).releaseTemporaryTableName(tempAccountTableName);
        }
        return acctext2AccountMap;
    }

    private void batchInsertAccountTempTable(Connection connection, PreparedStatement prepareStatement) throws SQLDataException {
        try {
            prepareStatement.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            try {
                prepareStatement.clearBatch();
            }
            catch (SQLException e) {
                SQLUtils.cleanup(null, (Statement)prepareStatement, (Connection)connection);
                throw new SQLDataException(e);
            }
            SQLUtils.cleanup(null, (Statement)prepareStatement, (Connection)connection);
        }
    }

    private boolean insertTempTableForAccount(Set cache, PreparedStatement prepareStatement, Acctext acctext) throws SQLDataException {
        StringBuffer key = new StringBuffer();
        try {
            int i;
            for (i = 0; i < acctext.accountItem.getAccountAsstItem().accounts.length; ++i) {
                key.setLength(0);
                key.append(acctext.company.getLongNumber()).append("||").append(acctext.company.getAccountTable().getId().toString()).append("||").append(acctext.accountItem.getAccountAsstItem().accounts[i].startNumber);
                if (!cache.contains(key.toString())) {
                    prepareStatement.setString(1, acctext.company.getLongNumber());
                    prepareStatement.setString(2, acctext.company.getAccountTable().getId().toString());
                    prepareStatement.setString(3, acctext.accountItem.getAccountAsstItem().accounts[i].startNumber);
                    prepareStatement.addBatch();
                    cache.add(key.toString());
                }
                if (StringUtils.isEmpty((String)acctext.accountItem.getAccountAsstItem().accounts[i].endNumber) || acctext.accountItem.getAccountAsstItem().accounts[i].endNumber.equals(acctext.accountItem.getAccountAsstItem().accounts[i].startNumber)) continue;
                key.setLength(0);
                key.append(acctext.company.getLongNumber()).append("||").append(acctext.company.getAccountTable().getId().toString()).append("||").append(acctext.accountItem.getAccountAsstItem().accounts[i].endNumber);
                if (cache.contains(key.toString())) continue;
                prepareStatement.setString(1, acctext.company.getLongNumber());
                prepareStatement.setString(2, acctext.company.getAccountTable().getId().toString());
                prepareStatement.setString(3, acctext.accountItem.getAccountAsstItem().accounts[i].endNumber);
                prepareStatement.addBatch();
                cache.add(key.toString());
            }
            if (acctext.oppAccountItem != null) {
                for (i = 0; i < acctext.oppAccountItem.getAccountAsstItem().accounts.length; ++i) {
                    key.setLength(0);
                    key.append(acctext.company.getLongNumber()).append("||").append(acctext.company.getAccountTable().getId().toString()).append("||").append(acctext.oppAccountItem.getAccountAsstItem().accounts[i].startNumber);
                    if (!cache.contains(key.toString())) {
                        prepareStatement.setString(1, acctext.company.getLongNumber());
                        prepareStatement.setString(2, acctext.company.getAccountTable().getId().toString());
                        prepareStatement.setString(3, acctext.oppAccountItem.getAccountAsstItem().accounts[i].startNumber);
                        prepareStatement.addBatch();
                        cache.add(key.toString());
                    }
                    if (StringUtils.isEmpty((String)acctext.oppAccountItem.getAccountAsstItem().accounts[i].endNumber) || acctext.oppAccountItem.getAccountAsstItem().accounts[i].endNumber.equals(acctext.oppAccountItem.getAccountAsstItem().accounts[i].startNumber)) continue;
                    key.setLength(0);
                    key.append(acctext.company.getLongNumber()).append("||").append(acctext.company.getAccountTable().getId().toString()).append("||").append(acctext.oppAccountItem.getAccountAsstItem().accounts[i].endNumber);
                    if (cache.contains(key.toString())) continue;
                    prepareStatement.setString(1, acctext.company.getLongNumber());
                    prepareStatement.setString(2, acctext.company.getAccountTable().getId().toString());
                    prepareStatement.setString(3, acctext.oppAccountItem.getAccountAsstItem().accounts[i].endNumber);
                    prepareStatement.addBatch();
                    cache.add(key.toString());
                }
            }
            return true;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private String createTempTableForAccount() throws BOSException {
        ITableManagerFacade tableManager = TableManagerFacadeFactory.getLocalInstance((Context)this.getServerContext());
        String tableName = tableManager.getTableName(ACCOUNT_TEMP_TABLE);
        String sql = "CREATE TABLE " + tableName + " (FCompanyLongNumber nvarchar(80),FAccountTableID varchar(44),FAccountNumber nvarchar(80))";
        tableManager.createTempTable(sql);
        return tableName;
    }

    private void initPeriod(Set periodTypeSet) throws BOSException {
        if (periodTypeSet.size() == 0) {
            return;
        }
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)this.getServerContext());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodTypeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.FALSE));
        evi.setFilter(filter);
        PeriodCollection periods = iPeriod.getPeriodCollection(evi);
        HashMap periodType2PeriodMap = new HashMap();
        HashMap<String, PeriodInfo> periodNumber2PeriodMap = new HashMap<String, PeriodInfo>();
        int count = periods.size();
        for (int i = 0; i < count; ++i) {
            PeriodInfo periodInfo = periods.get(i);
            periodNumber2PeriodMap.put(periodInfo.getPeriodType().getId().toString() + periodInfo.getPeriodYear() + periodInfo.getPeriodNumber(), periodInfo);
            HashMap<String, Object> property = new HashMap<String, Object>();
            property.put("PeriodInfo", periodInfo);
            property.put("BeginDate", periodInfo.getBeginDate());
            property.put("EndDate", new Date(periodInfo.getEndDate().getTime()));
            String periodTypeID = periodInfo.getPeriodType().getId().toString();
            ArrayList periodList = (ArrayList)periodType2PeriodMap.get(periodTypeID);
            if (periodList == null) {
                periodList = new ArrayList();
                periodType2PeriodMap.put(periodInfo.getPeriodType().getId().toString(), periodList);
            }
            periodList.add(property);
        }
        int reportPeriodType = this.getBatchHelper().getReport_PeriodType();
        PropertyFilter propertyFilter = new PropertyFilter();
        FilterInfo propertyFilterInfo = new FilterInfo();
        FilterItemInfo beginItem = new FilterItemInfo("BeginDate", null, CompareType.LESS_EQUALS);
        FilterItemInfo endItem = new FilterItemInfo("EndDate", null, CompareType.GREATER_EQUALS);
        propertyFilterInfo.getFilterItems().add(beginItem);
        propertyFilterInfo.getFilterItems().add(endItem);
        Iterator iterator = this.getFormulaCalculatorParameterList().iterator();
        while (iterator.hasNext()) {
            Acctext acctext = (Acctext)iterator.next();
            if (acctext.isException()) {
                this.addToErrorList(acctext);
                iterator.remove();
                continue;
            }
            if (RptPeriodTypeEnum.MONTHLY.getValue() == reportPeriodType) {
                int reportYear = this.getBatchHelper().getReport_Year();
                int reportPeriod = this.getBatchHelper().getReport_Period();
                int startYear = this.getBatchHelper().getSheet_StartYear(acctext.getSheetName());
                int startPeriod = this.getBatchHelper().getSheet_StartPeriod(acctext.getSheetName());
                int endYear = this.getBatchHelper().getSheet_EndYear(acctext.getSheetName());
                int endPeriod = this.getBatchHelper().getSheet_EndPeriod(acctext.getSheetName());
                if (startYear == 0) {
                    startYear = reportYear;
                }
                if (startPeriod == 0) {
                    startPeriod = reportPeriod;
                }
                if (endYear == 0) {
                    endYear = reportYear;
                }
                if (endPeriod == 0) {
                    endPeriod = reportPeriod;
                }
                if (endYear < startYear || endYear == startYear && endPeriod < startPeriod) {
                    this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.PERIOD_ERROR)));
                    iterator.remove();
                    continue;
                }
                String periodTypeId = acctext.company.getAccountPeriodType().getId().toString();
                PeriodInfo startPeriodInfo = (PeriodInfo)periodNumber2PeriodMap.get(periodTypeId + startYear + startPeriod);
                PeriodInfo endPeriodInfo = (PeriodInfo)periodNumber2PeriodMap.get(periodTypeId + endYear + endPeriod);
                if (startPeriodInfo != null && acctext.isStartDateFromRpt && !acctext.isGetBalance()) {
                    acctext.startDate.setTime(startPeriodInfo.getBeginDate());
                }
                if (endPeriodInfo != null && acctext.isEndDateFromRpt && !acctext.isGetInitialAmount()) {
                    acctext.endDate.setTime(endPeriodInfo.getEndDate());
                }
            }
            if (AcctextBatchCalculator.isAccrualAmoutNoOppAccount(acctext) || this.getPeriodFromCached(acctext)) continue;
            List periodMapList = (List)periodType2PeriodMap.get(acctext.company.getAccountPeriodType().getId().toString());
            if (periodMapList != propertyFilter.getPropertyList()) {
                propertyFilter.setPropertyMapList(periodMapList);
            }
            if (acctext.startPeriod == null) {
                beginItem.setCompareValue((Object)acctext.startDate.getTime());
                endItem.setCompareValue((Object)acctext.startDate.getTime());
                Map[] startPeriod = propertyFilter.getPropertyMapByConditions(propertyFilterInfo);
                if (startPeriod.length != 1) {
                    if (acctext.companys != null && acctext.companys.size() > 1) {
                        acctext.getParameter().setValue((Object)CslConstant.BGZERO);
                    } else {
                        this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.PERIOD_ERROR)));
                    }
                    iterator.remove();
                    continue;
                }
                acctext.startPeriod = (PeriodInfo)startPeriod[0].get("PeriodInfo");
                this.cachePeriod(acctext.startDate, acctext.company, acctext.startPeriod);
            }
            if (acctext.endPeriod != null) continue;
            beginItem.setCompareValue((Object)acctext.endDate.getTime());
            endItem.setCompareValue((Object)acctext.endDate.getTime());
            Map[] endPeriod = propertyFilter.getPropertyMapByConditions(propertyFilterInfo);
            if (endPeriod.length != 1) {
                if (acctext.companys != null && acctext.companys.size() > 1) {
                    acctext.getParameter().setValue((Object)CslConstant.BGZERO);
                } else {
                    this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.PERIOD_ERROR)));
                }
                iterator.remove();
                continue;
            }
            acctext.endPeriod = (PeriodInfo)endPeriod[0].get("PeriodInfo");
            this.cachePeriod(acctext.endDate, acctext.company, acctext.endPeriod);
        }
    }

    private void cachePeriod(GregorianCalendar date, CompanyOrgUnitInfo company, PeriodInfo period) {
        String key = dateFormat.format(date.getTime()) + company.getAccountPeriodType().getId();
        this.periodCache.put(key, period);
    }

    private boolean getPeriodFromCached(Acctext acctext) {
        String startDate = dateFormat.format(acctext.startDate.getTime()) + acctext.company.getAccountPeriodType().getId();
        String endDate = dateFormat.format(acctext.endDate.getTime()) + acctext.company.getAccountPeriodType().getId();
        PeriodInfo startPeriod = (PeriodInfo)this.periodCache.get(startDate);
        PeriodInfo endPeriod = (PeriodInfo)this.periodCache.get(endDate);
        acctext.startPeriod = startPeriod;
        acctext.endPeriod = endPeriod;
        return startPeriod != null && endPeriod != null;
    }

    private void getCorrectAccountTable(Set companyIDSet) throws BOSException {
        if (companyIDSet == null || companyIDSet.size() == 0) {
            return;
        }
        StringBuffer oql = new StringBuffer();
        oql.append("select *,enabledAcctTable.*,disabledAcctTable.*,enabledPeriod.* where refType=1 and company.id in  ");
        oql.append(this.batchHelper.createInSql(companyIDSet.iterator()));
        oql.append("and isEnabled = 1 and enabledPeriod is not null ");
        oql.append("order by enabledPeriod.periodYear desc,enabledPeriod.periodNumber desc");
        AccountRefContrastCollection lastRefCollection = AccountRefContrastFactory.getLocalInstance((Context)this.getServerContext()).getAccountRefContrastCollection(oql.toString());
        HashMap cu2LastRefMap = new HashMap();
        for (AccountRefContrastInfo lastRef : lastRefCollection) {
            if (cu2LastRefMap.get(lastRef.getCompany().getId().toString()) == null) {
                ArrayList<AccountRefContrastInfo> list = new ArrayList<AccountRefContrastInfo>();
                list.add(lastRef);
                cu2LastRefMap.put(lastRef.getCompany().getId().toString(), list);
                continue;
            }
            ((List)cu2LastRefMap.get(lastRef.getCompany().getId().toString())).add(lastRef);
        }
        Iterator iterator = this.getFormulaCalculatorParameterList().iterator();
        while (iterator.hasNext()) {
            int periodNumber;
            Acctext acctext = (Acctext)iterator.next();
            if (acctext.isException()) {
                this.addToErrorList(acctext);
                iterator.remove();
                continue;
            }
            CompanyOrgUnitInfo company = acctext.company;
            int periodYear = acctext.endDate.get(1);
            if (!this.getAccountTableFromCache(company, periodYear, periodNumber = acctext.endDate.get(2) + 1)) {
                List lastRefCol = (List)cu2LastRefMap.get(company.getId().toString());
                AccountTableInfo accountTableInfo = company.getAccountTable();
                if (accountTableInfo == null) {
                    accountTableInfo = new AccountTableInfo();
                    company.setAccountTable(accountTableInfo);
                }
                BOSUuid enabledAcctTableID = accountTableInfo.getId();
                for (int i = 0; lastRefCol != null && i < lastRefCol.size(); ++i) {
                    AccountRefContrastInfo info = (AccountRefContrastInfo)lastRefCol.get(i);
                    if (info.getEnabledAcctTable().getId().equals((Object)enabledAcctTableID) && (periodYear > info.getEnabledPeriod().getPeriodYear() || periodYear == info.getEnabledPeriod().getPeriodYear() && periodNumber > info.getEnabledPeriod().getPeriodNumber())) {
                        company.getAccountTable().setId(info.getEnabledAcctTable().getId());
                        break;
                    }
                    if (info.getEnabledAcctTable().getId().equals((Object)enabledAcctTableID) || enabledAcctTableID == null) {
                        enabledAcctTableID = info.getDisabledAcctTable().getId();
                    }
                    if (i != lastRefCol.size() - 1) continue;
                    company.getAccountTable().setId(enabledAcctTableID);
                    break;
                }
                if (company.getAccountTable().getId() != null) {
                    this.cacheAccountTable(company, periodYear, periodNumber);
                }
            }
            if (acctext.company.getAccountTable().getId() != null) continue;
            if (acctext.companys != null && acctext.companys.size() > 1) {
                acctext.getParameter().setValue((Object)CslConstant.BGZERO);
                iterator.remove();
                continue;
            }
            acctext.setException((Exception)((Object)new ReportException(new NumericExceptionSubItem("154", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"38_AcctextBatchCalculator", (Locale)this.getServerContext().getLocale()) + company.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"39_AcctextBatchCalculator", (Locale)this.getServerContext().getLocale())))));
        }
    }

    private void cacheAccountTable(CompanyOrgUnitInfo company, int periodYear, int periodNumber) {
        String key = company.getNumber() + "|" + periodYear + "|" + periodNumber;
        this.accountTableCache.put(key, company.getAccountTable().getId().toString());
    }

    private boolean getAccountTableFromCache(CompanyOrgUnitInfo company, int periodYear, int periodNumber) {
        String key = company.getNumber() + "|" + periodYear + "|" + periodNumber;
        String accountTableID = (String)this.accountTableCache.get(key);
        if (accountTableID != null) {
            company.getAccountTable().setId(BOSUuid.read((String)accountTableID));
            return true;
        }
        return false;
    }

    private void checkAccountTableExclusive(Map cu2CompanyMap, Map companyNumber2AcctextMap) throws BOSException, EASBizException {
        if (cu2CompanyMap.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT count(FID) ct,FDestCompanyID FROM T_BD_ACCT_CONTORL WHERE FDestCompanyID in ");
        sql.append(this.batchHelper.createInSql(cu2CompanyMap.keySet().iterator()));
        sql.append(" AND FISDEFAULTFORREFER = 1 group by FDestCompanyID having count(FID) > 1");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)sql.toString());
        try {
            while (rowSet.next()) {
                String cuid = rowSet.getString("FDestCompanyID");
                String companyNumber = (String)cu2CompanyMap.get(cuid);
                List acctextList = (List)companyNumber2AcctextMap.get(companyNumber);
                for (Acctext acctext : acctextList) {
                    if (acctext.isException()) continue;
                    acctext.setException((Exception)((Object)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_cacl_existmuiltaccount", (Locale)this.getServerContext().getLocale())})));
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void initCompanys(Map companyMap) throws BOSException, EASBizException {
        if (companyMap.isEmpty()) {
            return;
        }
        this.initCompanyByNumber(companyMap);
        Map subCompany = this.getSubCompanyMap(companyMap);
        this.expendAcctextByCompany(subCompany, companyMap);
    }

    private void initProfitCenters(Map companyMap) throws BOSException, EASBizException {
        if (companyMap.isEmpty()) {
            return;
        }
        this.initProfitCenterByNumber(companyMap);
        Map subCompany = this.getSubProfitCenterMap(companyMap);
        this.expendAcctextByProfitCenter(subCompany, companyMap);
    }

    private void expendAcctextByCompany(Map groupCompanyMap, Map unitCompanyMap) {
        ArrayList newAcctextList = new ArrayList();
        HashMap comapny2SubNumberMap = new HashMap();
        for (Map.Entry entry : groupCompanyMap.entrySet()) {
            List subComanyList = (List)entry.getValue();
            HashSet<String> set = new HashSet<String>();
            for (CompanyOrgUnitInfo subCompanyInfo : subComanyList) {
                set.add(subCompanyInfo.getNumber());
            }
            comapny2SubNumberMap.put(entry.getKey(), set);
        }
        HashSet tempSet = new HashSet();
        Iterator iterator = this.getFormulaCalculatorParameterList().iterator();
        while (iterator.hasNext()) {
            ArrayList<Acctext> subList;
            Acctext acctext = (Acctext)iterator.next();
            if (acctext.isException()) {
                this.addToErrorList(acctext);
                iterator.remove();
                continue;
            }
            if (acctext.companys != null && acctext.companys.size() > 1) {
                if (acctext.oppAccountItem == null && AcctextBatchCalculator.isGetAccrualAmount(acctext.vchGetType) || AcctextBatchCalculator.isGetEndBalance(acctext.vchGetType) || AcctextBatchCalculator.isGetInitialAmount(acctext.vchGetType)) {
                    this.removeSubCompany(acctext.companys, comapny2SubNumberMap, tempSet);
                }
                try {
                    for (String companyNumber : acctext.companys) {
                        this.getBatchHelper().checkCompanyPermision(acctext.orgType, companyNumber);
                        subList = new ArrayList();
                        boolean isRemove = this.addAcctextBySingleCompanyNumber(groupCompanyMap, unitCompanyMap, subList, acctext, companyNumber);
                        if (!acctext.isException()) {
                            if (!isRemove) {
                                Acctext acctextNew = acctext.cloneForSplit();
                                acctextNew.fiOrgUnit = acctext.company.getNumber();
                                acctextNew.company = this.cloneForCompany(acctext.company);
                                subList.add(acctextNew);
                            }
                            newAcctextList.addAll(subList);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    this.addToErrorList(acctext, e);
                }
                iterator.remove();
                continue;
            }
            String companyNumber = acctext.fiOrgUnit;
            boolean isRemove = false;
            try {
                subList = new ArrayList<Acctext>();
                isRemove = this.addAcctextBySingleCompanyNumber(groupCompanyMap, unitCompanyMap, subList, acctext, companyNumber);
                newAcctextList.addAll(subList);
            }
            catch (Exception e) {
                this.addToErrorList(acctext, e);
            }
            if (!isRemove && !acctext.isException()) continue;
            iterator.remove();
        }
        this.getFormulaCalculatorParameterList().addAll(newAcctextList);
    }

    private void expendAcctextByProfitCenter(Map groupCompanyMap, Map unitCompanyMap) {
        ArrayList newAcctextList = new ArrayList();
        HashMap comapny2SubNumberMap = new HashMap();
        for (Map.Entry entry : groupCompanyMap.entrySet()) {
            List subComanyList = (List)entry.getValue();
            HashSet<String> set = new HashSet<String>();
            for (CompanyOrgUnitInfo subCompanyInfo : subComanyList) {
                set.add(subCompanyInfo.getNumber());
            }
            comapny2SubNumberMap.put(entry.getKey(), set);
        }
        HashSet tempSet = new HashSet();
        Iterator iterator = this.getFormulaCalculatorParameterList().iterator();
        while (iterator.hasNext()) {
            ArrayList<Acctext> subList;
            Acctext acctext = (Acctext)iterator.next();
            if (acctext.isException()) {
                this.addToErrorList(acctext);
                iterator.remove();
                continue;
            }
            if (acctext.companys != null && acctext.companys.size() > 1) {
                if (acctext.oppAccountItem == null && AcctextBatchCalculator.isGetAccrualAmount(acctext.vchGetType) || AcctextBatchCalculator.isGetEndBalance(acctext.vchGetType) || AcctextBatchCalculator.isGetInitialAmount(acctext.vchGetType)) {
                    this.removeSubCompany(acctext.companys, comapny2SubNumberMap, tempSet);
                }
                try {
                    for (String companyNumber : acctext.companys) {
                        this.getBatchHelper().checkCompanyPermision(companyNumber);
                        subList = new ArrayList();
                        boolean isRemove = this.addAcctextBySingleCompanyNumber(groupCompanyMap, unitCompanyMap, subList, acctext, companyNumber);
                        if (!acctext.isException()) {
                            if (!isRemove) {
                                Acctext acctextNew = acctext.cloneForSplit();
                                acctextNew.fiOrgUnit = acctext.company.getNumber();
                                acctextNew.company = this.cloneForCompany(acctext.company);
                                subList.add(acctextNew);
                            }
                            newAcctextList.addAll(subList);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    this.addToErrorList(acctext, e);
                }
                iterator.remove();
                continue;
            }
            String companyNumber = acctext.fiOrgUnit;
            boolean isRemove = false;
            try {
                subList = new ArrayList<Acctext>();
                isRemove = this.addAcctextBySingleCompanyNumber(groupCompanyMap, unitCompanyMap, subList, acctext, companyNumber);
                newAcctextList.addAll(subList);
            }
            catch (Exception e) {
                this.addToErrorList(acctext, e);
            }
            if (!isRemove && !acctext.isException()) continue;
            iterator.remove();
        }
        this.getFormulaCalculatorParameterList().addAll(newAcctextList);
    }

    private void removeSubCompany(Set companys, Map comapny2SubNumberMap, Set tempSet) {
        tempSet.clear();
        for (String companyNumber : companys) {
            Set subCompanySet = (Set)comapny2SubNumberMap.get(companyNumber);
            if (subCompanySet == null) continue;
            tempSet.addAll(subCompanySet);
        }
        if (tempSet.size() > 0) {
            tempSet.retainAll(companys);
            companys.removeAll(tempSet);
        }
    }

    private boolean addAcctextBySingleCompanyNumber(Map groupCompanyMap, Map unitCompanyMap, List newAcctextList, Acctext acctext, String companyNumber) throws ParseException, BOSException, EASBizException {
        List subList = (List)groupCompanyMap.get(companyNumber);
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)unitCompanyMap.get(companyNumber);
        boolean isRemove = false;
        if (!(subList == null || AcctextBatchCalculator.isGetAccrualAmount(acctext.vchGetType) && acctext.oppAccountItem == null || AcctextBatchCalculator.isGetEndBalance(acctext.vchGetType) || AcctextBatchCalculator.isGetInitialAmount(acctext.vchGetType))) {
            for (CompanyOrgUnitInfo company : subList) {
                if (acctext.companys == null) {
                    acctext.companys = new HashSet();
                }
                if (acctext.companys.contains(company.getNumber())) continue;
                Acctext acctextNew = acctext.cloneForSplit();
                acctextNew.fiOrgUnit = company.getNumber();
                this.getBatchHelper().checkCompanyPermision(acctextNew.fiOrgUnit);
                acctextNew.company = this.cloneForCompany(company);
                newAcctextList.add(acctextNew);
                acctext.companys.add(company.getNumber());
            }
            isRemove = true;
        } else if (companyInfo != null) {
            acctext.company = this.cloneForCompany(companyInfo);
        } else {
            this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.FIND_COMPANY_ERROR)));
            isRemove = true;
        }
        return isRemove;
    }

    private Map getSubCompanyMap(Map companyMap) throws BOSException {
        HashMap subCompany = new HashMap();
        for (Map.Entry entry : companyMap.entrySet()) {
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)entry.getValue();
            if (companyOrgUnitInfo == null || companyOrgUnitInfo.isIsBizUnit()) continue;
            subCompany.put(entry.getKey(), entry.getValue());
        }
        if (subCompany.size() == 0) {
            return subCompany;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select super.fnumber superNumber,company.FLongnumber subLongNumber,");
        sql.append(" company.FID subFID,company.FisOnlyUnion subIsOnlyUnion,company.FNumber subNumber,");
        sql.append(" company.FIsLeaf subIsLeaf,company.FisBizUnit subisBizUnit,company.FAccountPeriodID subAccountPeriodID,  \t\t");
        sql.append(" company.FControlUnitID subCUID,company.FAccountTableID subAccountTableID,  \t");
        sql.append(" company.FBaseCurrencyID subBasCurrencyID,currency.FPrecision subCurrencyPrecision \t\n");
        sql.append(" from T_ORG_Company company  \t\n");
        sql.append(" inner join (\t\t\t\t\t\n");
        boolean first = true;
        for (CompanyOrgUnitInfo companyOrgUnitInfo : subCompany.values()) {
            if (!first) {
                sql.append(" union all   \n");
            } else {
                first = false;
            }
            sql.append(" select '").append(companyOrgUnitInfo.getLongNumber()).append("!' as flongnumber,'").append(companyOrgUnitInfo.getNumber()).append("' as fnumber    \n");
        }
        sql.append(" ) as super on charindex(super.flongnumber,company.FLongnumber)=1\t\t\n");
        sql.append(" inner join T_BD_Currency currency on currency.FID = company.FBaseCurrencyID  \n");
        sql.append(" where company.FIsbizunit = 1\t\t\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)sql.toString());
        HashMap result = new HashMap();
        try {
            while (rowSet.next()) {
                String superNumber = rowSet.getString("superNumber");
                ArrayList<CompanyOrgUnitInfo> list = (ArrayList<CompanyOrgUnitInfo>)result.get(superNumber);
                if (list == null) {
                    list = new ArrayList<CompanyOrgUnitInfo>();
                    result.put(superNumber, list);
                }
                CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
                companyOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("subFID")));
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)rowSet.getString("subCUID")));
                companyOrgUnitInfo.setCU(cu);
                companyOrgUnitInfo.setIsOnlyUnion(rowSet.getBoolean("subIsOnlyUnion"));
                String accountID = rowSet.getString("subAccountTableID");
                if (accountID != null) {
                    AccountTableInfo accountTable = new AccountTableInfo();
                    accountTable.setId(BOSUuid.read((String)accountID));
                    companyOrgUnitInfo.setAccountTable(accountTable);
                }
                CurrencyInfo baseCurrency = new CurrencyInfo();
                baseCurrency.setId(BOSUuid.read((String)rowSet.getString("subBasCurrencyID")));
                baseCurrency.setPrecision(rowSet.getInt("subCurrencyPrecision"));
                companyOrgUnitInfo.setBaseCurrency(baseCurrency);
                companyOrgUnitInfo.setNumber(rowSet.getString("subNumber"));
                companyOrgUnitInfo.setLongNumber(rowSet.getString("subLongNumber"));
                PeriodTypeInfo periodTypeInfo = new PeriodTypeInfo();
                periodTypeInfo.setId(BOSUuid.read((String)rowSet.getString("subAccountPeriodID")));
                companyOrgUnitInfo.setAccountPeriodType(periodTypeInfo);
                companyOrgUnitInfo.setIsLeaf(rowSet.getBoolean("subIsLeaf"));
                companyOrgUnitInfo.setIsBizUnit(rowSet.getBoolean("subisBizUnit"));
                list.add(companyOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private Map getSubProfitCenterMap(Map companyMap) throws BOSException {
        HashMap subCompany = new HashMap();
        for (Map.Entry entry : companyMap.entrySet()) {
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)entry.getValue();
            if (companyOrgUnitInfo == null || companyOrgUnitInfo.isIsBizUnit()) continue;
            subCompany.put(entry.getKey(), entry.getValue());
        }
        if (subCompany.size() == 0) {
            return subCompany;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select super.fnumber superNumber,company.FLongnumber subLongNumber,");
        sql.append(" company.FID subFID,company.FisOnlyUnion subIsOnlyUnion,company.FNumber subNumber,");
        sql.append(" company.FIsLeaf subIsLeaf,company.FisBizUnit subisBizUnit,company.FAccountPeriodID subAccountPeriodID,  \t\t");
        sql.append(" company.FControlUnitID subCUID,company.FAccountTableID subAccountTableID,  \t");
        sql.append(" company.FBaseCurrencyID subBasCurrencyID,currency.FPrecision subCurrencyPrecision \t\n");
        sql.append(" from T_ORG_Company company  \t\n");
        sql.append(" inner join (\t\t\t\t\t\n");
        boolean first = true;
        for (CompanyOrgUnitInfo companyOrgUnitInfo : subCompany.values()) {
            if (!first) {
                sql.append(" union all   \n");
            } else {
                first = false;
            }
            sql.append(" select '").append(companyOrgUnitInfo.getLongNumber()).append("!' as flongnumber,'").append(companyOrgUnitInfo.getNumber()).append("' as fnumber    \n");
        }
        sql.append(" ) as super on charindex(super.flongnumber,company.FLongnumber)=1\t\t\n");
        sql.append(" inner join T_BD_Currency currency on currency.FID = company.FBaseCurrencyID  \n");
        sql.append(" where company.FIsbizunit = 1\t\t\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getServerContext(), (String)sql.toString());
        HashMap result = new HashMap();
        try {
            while (rowSet.next()) {
                String superNumber = rowSet.getString("superNumber");
                ArrayList<CompanyOrgUnitInfo> list = (ArrayList<CompanyOrgUnitInfo>)result.get(superNumber);
                if (list == null) {
                    list = new ArrayList<CompanyOrgUnitInfo>();
                    result.put(superNumber, list);
                }
                CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
                companyOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("subFID")));
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)rowSet.getString("subCUID")));
                companyOrgUnitInfo.setCU(cu);
                companyOrgUnitInfo.setIsOnlyUnion(rowSet.getBoolean("subIsOnlyUnion"));
                String accountID = rowSet.getString("subAccountTableID");
                if (accountID != null) {
                    AccountTableInfo accountTable = new AccountTableInfo();
                    accountTable.setId(BOSUuid.read((String)accountID));
                    companyOrgUnitInfo.setAccountTable(accountTable);
                }
                CurrencyInfo baseCurrency = new CurrencyInfo();
                baseCurrency.setId(BOSUuid.read((String)rowSet.getString("subBasCurrencyID")));
                baseCurrency.setPrecision(rowSet.getInt("subCurrencyPrecision"));
                companyOrgUnitInfo.setBaseCurrency(baseCurrency);
                companyOrgUnitInfo.setNumber(rowSet.getString("subNumber"));
                companyOrgUnitInfo.setLongNumber(rowSet.getString("subLongNumber"));
                PeriodTypeInfo periodTypeInfo = new PeriodTypeInfo();
                periodTypeInfo.setId(BOSUuid.read((String)rowSet.getString("subAccountPeriodID")));
                companyOrgUnitInfo.setAccountPeriodType(periodTypeInfo);
                companyOrgUnitInfo.setIsLeaf(rowSet.getBoolean("subIsLeaf"));
                companyOrgUnitInfo.setIsBizUnit(rowSet.getBoolean("subisBizUnit"));
                list.add(companyOrgUnitInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private void initCompanyByNumber(Map companyMap) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        this.getCompanySelector(view);
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet();
        set.addAll(companyMap.keySet());
        if (set.size() == 0) {
            return;
        }
        CompanyOrgUnitCollection companyOrgUnitCollection = null;
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        view.setFilter(filter);
        companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)this.getServerContext()).getCompanyOrgUnitCollection(view);
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnitCollection.get(i);
            companyMap.put(companyOrgUnitInfo.getNumber(), companyOrgUnitInfo);
        }
    }

    private void initProfitCenterByNumber(Map companyMap) throws BOSException, EASBizException {
        Connection conn;
        EntityViewInfo view = new EntityViewInfo();
        this.getCompanySelector(view);
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet();
        set.addAll(companyMap.keySet());
        if (set.size() == 0) {
            return;
        }
        CompanyOrgUnitCollection companyOrgUnitCollection = null;
        try {
            conn = EJBFactory.getConnection((Context)this.serverContext);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        ProfitCenterQuerySolution query = new ProfitCenterQuerySolution(conn);
        ProfitCenterQuerySolution.QueryedCompany queryCompany = new ProfitCenterQuerySolution.QueryedCompany();
        for (Object compNum : companyMap.keySet()) {
            try {
                query.add((String)compNum, queryCompany);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        try {
            query.exec();
            query.handleVirutalProfitCenter(this.serverContext);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        companyOrgUnitCollection = queryCompany.all();
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnitCollection.get(i);
            companyMap.put(companyOrgUnitInfo.getNumber(), companyOrgUnitInfo);
        }
    }

    private void getCompanySelector(EntityViewInfo view) {
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("cu.id"));
        view.getSelector().add(new SelectorItemInfo("isOnlyUnion"));
        view.getSelector().add(new SelectorItemInfo("accountTable.id"));
        view.getSelector().add(new SelectorItemInfo("baseCurrency.precision"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("longnumber"));
        view.getSelector().add(new SelectorItemInfo("accountPeriodType.id"));
        view.getSelector().add(new SelectorItemInfo("isLeaf"));
        view.getSelector().add(new SelectorItemInfo("isBizUnit"));
    }

    private CompanyOrgUnitInfo cloneForCompany(CompanyOrgUnitInfo oldCompany) {
        Integer p1;
        CompanyOrgUnitInfo newInfo = new CompanyOrgUnitInfo();
        newInfo.setId(oldCompany.getId());
        newInfo.setCU(oldCompany.getCU());
        newInfo.setIsOnlyUnion(oldCompany.isIsOnlyUnion());
        newInfo.setIsCompanyOrgUnit(oldCompany.isIsCompanyOrgUnit());
        newInfo.setIsProfitOrgUnit(oldCompany.isIsProfitOrgUnit());
        if (oldCompany.getAccountTable() != null) {
            AccountTableInfo accountTable = new AccountTableInfo();
            accountTable.setId(oldCompany.getAccountTable().getId());
            newInfo.setAccountTable(accountTable);
        }
        if (oldCompany.getBaseCurrency() != null) {
            newInfo.setBaseCurrency(oldCompany.getBaseCurrency());
        } else {
            Integer pecision;
            CurrencyInfo baseCurrency = new CurrencyInfo();
            if (oldCompany.containsKey("GLC")) {
                pecision = (Integer)oldCompany.get("GLC");
                baseCurrency.setPrecision(pecision.intValue());
            } else if (oldCompany.containsKey("GRC")) {
                pecision = (Integer)oldCompany.get("GRC");
                baseCurrency.setPrecision(pecision.intValue());
            }
            newInfo.setBaseCurrency(baseCurrency);
        }
        newInfo.setNumber(oldCompany.getNumber());
        newInfo.setLongNumber(oldCompany.getLongNumber());
        newInfo.setAccountPeriodType(oldCompany.getAccountPeriodType());
        newInfo.setIsLeaf(oldCompany.isIsLeaf());
        newInfo.setIsBizUnit(oldCompany.isIsBizUnit());
        Object obj = oldCompany.get("GLC");
        if (obj != null && obj.toString().trim().length() > 0) {
            p1 = new Integer(obj.toString());
            newInfo.put("GLC", (Object)p1);
        }
        if ((obj = oldCompany.get("GRC")) != null && obj.toString().trim().length() > 0) {
            p1 = new Integer(obj.toString());
            newInfo.put("GRC", (Object)p1);
        }
        if ((obj = oldCompany.get("DELEGATED_COMPANY_ID")) != null && obj.toString().trim().length() > 0) {
            newInfo.put("DELEGATED_COMPANY_ID", obj);
        }
        if ((obj = oldCompany.get("DELEGATED_COMPANY_LONG_NUMBER")) != null && obj.toString().trim().length() > 0) {
            newInfo.put("DELEGATED_COMPANY_LONG_NUMBER", obj);
        }
        return newInfo;
    }

    private void initCurrency(Map currencyMap) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet();
        set.addAll(currencyMap.keySet());
        if (set.size() == 0) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        view.setFilter(filter);
        CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)this.getServerContext()).getCurrencyCollection(view);
        for (int i = 0; i < currencyCollection.size(); ++i) {
            CurrencyInfo currencyInfo = currencyCollection.get(i);
            currencyMap.put(currencyInfo.getNumber(), currencyInfo);
        }
        Iterator iterator = this.getFormulaCalculatorParameterList().iterator();
        while (iterator.hasNext()) {
            Acctext acctext = (Acctext)iterator.next();
            acctext.currency = (CurrencyInfo)currencyMap.get(acctext.currencyString);
            if (acctext.currency != null) continue;
            this.addToErrorList(acctext, (Exception)((Object)new ReportException(ReportException.CRYNULL)));
            iterator.remove();
        }
    }

    public static boolean isGetAccrualAmount(VoucherGetTypeEnum _vchGetType) {
        switch (_vchGetType.getValue()) {
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return true;
            }
            case 14: {
                return true;
            }
            case 15: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGetEndBalance(VoucherGetTypeEnum _vchGetType) {
        switch (_vchGetType.getValue()) {
            case 2: {
                return true;
            }
            case 6: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGetInitialAmount(VoucherGetTypeEnum _vchGetType) {
        switch (_vchGetType.getValue()) {
            case 1: {
                return true;
            }
            case 5: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void clear() {
    }

    static {
        accountTableID2InfoMap = new HashMap();
        originalSet = new HashSet();
        originalSet.add(VoucherGetTypeEnum.C);
        originalSet.add(VoucherGetTypeEnum.Y);
        originalSet.add(VoucherGetTypeEnum.JF);
        originalSet.add(VoucherGetTypeEnum.DF);
        localSet = new HashSet();
        localSet.add(VoucherGetTypeEnum.TC);
        localSet.add(VoucherGetTypeEnum.TY);
        localSet.add(VoucherGetTypeEnum.TJF);
        localSet.add(VoucherGetTypeEnum.TDF);
        reportingSet = new HashSet();
        reportingSet.add(VoucherGetTypeEnum.ZTC);
        reportingSet.add(VoucherGetTypeEnum.ZTY);
        reportingSet.add(VoucherGetTypeEnum.ZJF);
        reportingSet.add(VoucherGetTypeEnum.ZDF);
    }
}

