/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctext;

import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.acctext.Acctext;
import com.kingdee.eas.fi.rpt.batch.acctext.AcctextBatchCalculator;
import com.kingdee.eas.fi.rpt.batch.acctext.AcctextRootBuilder;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class AcctextCombinestate
implements IFormulaCombinationPreparedState {
    private BigDecimal reporting;
    private BigDecimal local;
    private BigDecimal original;
    private long time;
    private String accountNumber;
    private Map itemTypeNumberMap = new HashMap();

    @Override
    public Object getFormulaResultValue(IFormulaCalculator formula) {
        Acctext acctext = (Acctext)formula;
        BigDecimal returnVal = null;
        returnVal = "GLC".equals(acctext.currency.getNumber()) ? this.local : ("GRC".equals(acctext.currency.getNumber()) ? this.reporting : (AcctextBatchCalculator.originalSet.contains((Object)acctext.vchGetType) ? this.original : (AcctextBatchCalculator.localSet.contains((Object)acctext.vchGetType) ? this.local : (AcctextBatchCalculator.reportingSet.contains((Object)acctext.vchGetType) ? this.reporting : this.original))));
        return returnVal;
    }

    public void setReporting(BigDecimal bigDecimal) {
        this.reporting = bigDecimal == null ? CslConstant.BGZERO : bigDecimal;
    }

    public void setLocal(BigDecimal bigDecimal) {
        this.local = bigDecimal == null ? CslConstant.BGZERO : bigDecimal;
    }

    public void setOriginal(BigDecimal bigDecimal) {
        this.original = bigDecimal == null ? CslConstant.BGZERO : bigDecimal;
    }

    public void setAccountNumber(String string) {
        this.accountNumber = string;
    }

    public void setTime(Timestamp timestamp) {
        this.time = timestamp.getTime();
    }

    @Override
    public boolean isFormulaResultNumberValue(IFormulaCalculator formula) {
        return true;
    }

    @Override
    public boolean isPrepared(IFormulaCalculator formula) {
        Acctext acctext = (Acctext)formula;
        if (AcctextRootBuilder.isGetInitialAmount(acctext.vchGetType) || AcctextRootBuilder.isGetEndBalance(acctext.vchGetType) ? this.time < acctext.endPeriod.getBeginDate().getTime() : AcctextRootBuilder.isGetAccrualAmount(acctext.vchGetType) && this.time < acctext.startDate.getTimeInMillis()) {
            return false;
        }
        if (this.time > acctext.endDate.getTimeInMillis()) {
            return false;
        }
        if (this.accountNumber.compareTo(acctext.accountItem.startAccount.number) < 0) {
            return false;
        }
        if (this.accountNumber.compareTo(acctext.accountItem.endAccount.number) > 0) {
            return false;
        }
        if (acctext.hasDetailAsstact) {
            for (Map.Entry entry : acctext.accountItem.getItemTypes().entrySet()) {
                AssistantItem item = (AssistantItem)entry.getValue();
                String number = (String)this.itemTypeNumberMap.get(item.itemType.realtionDataObject.toLowerCase());
                if (number == null) {
                    return false;
                }
                if (number.compareTo(item.startItem.number) < 0) {
                    return false;
                }
                if (number.compareTo(item.endItem.number) <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public Map getItemTypeNumberMap() {
        return this.itemTypeNumberMap;
    }
}

