/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.acctext;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.rpt.VoucherGetTypeEnum;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.ISingleSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.acctext.Acctext;
import com.kingdee.eas.fi.rpt.batch.acctext.AcctextCombinestate;
import com.kingdee.eas.fi.rpt.batch.acctext.IAcctextCalculateProcessor;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BalanceNullAsstBatchProcessor
implements IBatchSQLProcessor,
ISingleSQLProcessor,
IAcctextCalculateProcessor {
    protected Set nullFields;
    protected List formulaList = new ArrayList();
    protected AcctextCombinestate combinestate;
    private int batchSize = 500;
    protected static String[] IndexResultSetFields = new String[]{"CompanyID", "currency", "AccountTableID", "AccountLevel"};

    public BalanceNullAsstBatchProcessor() {
        this.nullFields = new HashSet();
        this.nullFields.add("currency");
        this.nullFields.add("isincludingUnPosted");
        this.combinestate = new AcctextCombinestate();
    }

    protected void buildSumPart(StringBuffer sql) {
        sql.append(" Select Out_Account.FDc*(sum(voucherEntry.FOriginalAmount * (voucherEntry.FEntryDC * 2 -1))) OriginalValue ,  \n");
        sql.append(" Out_Account.FDc*(sum(voucherEntry.FLocalAmount * (voucherEntry.FEntryDC * 2 -1))) LocalValue, \t\n");
        sql.append(" Out_Account.FDc*(sum(voucherEntry.FReportingAmount * (voucherEntry.FEntryDC * 2 -1))) ReportingValue,  \n");
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        this.buildSumPart(sql);
        if (!nullSet.contains("currency")) {
            sql.append(" voucherEntry.FCurrencyID currency,  \t\t\t\t\n");
        }
        sql.append(" voucher.FBookedDate BookedDate,\t\t\t\t\t\t\n");
        sql.append(" Out_Account.FCompanyID CompanyID,\t\t\t\t\t\t\n");
        sql.append(" Out_Account.FAccountTableID AccountTableID,\t\t\t\n");
        sql.append(" Out_Account.flevel AccountLevel,\t\t\t\t\t\t\n");
        sql.append(" Out_Account.Fnumber AccountNumber\t\t\t\t\t\t\n");
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append(" From T_GL_VoucherEntry voucherEntry \t\t\t\n");
        sql.append(" inner join T_GL_Voucher voucher on voucher.FID = voucherEntry.FBillID \t\t\t\n");
        sql.append(" inner join T_BD_AccountView A_Account on voucherEntry.FAccountID = A_Account.Fid \t\t\t\n");
        sql.append(" inner join T_Bd_AccountView Out_Account on charIndex(Out_Account.Fnumber,A_Account.Fnumber)=1  \t\t\t\n");
        if (!nullSet.contains("currency")) {
            sql.append(" inner join T_BD_Currency Currency on voucherEntry.FCurrencyID = Currency.FID \t\t\t\n");
        }
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append(" where ");
        this.buildRealConstantPart(nullSet, sql, params);
    }

    protected void buildRealConstantPart(Set nullSet, StringBuffer sql, List params) {
        sql.append(" voucher.FBizStatus <>0 \t\t\t\n");
        sql.append(" and voucher.FBizStatus <>2 \t\t\t\n");
        sql.append(" and A_Account.FIsLeaf = 1\t\t\t\n");
        if (!nullSet.contains("isincludingUnPosted")) {
            sql.append(" and voucher.FBizStatus=5 \t\t\t\n");
        }
        sql.append(" and voucher.FCompanyID = Out_Account.FCompanyID\t\t\t\n");
        sql.append(" and A_Account.FAccountTableID=Out_Account.FAccountTableID  and (\t\t\t\n");
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        Acctext acctext = (Acctext)formula;
        sql.append(" (  ");
        this.buildRealVariableWherePart(sql, params, acctext);
        sql.append("  )   \n ");
    }

    protected void buildRealVariableWherePart(StringBuffer sql, List params, Acctext acctext) {
        sql.append(" Out_Account.FCompanyID = ?\t\t\n");
        params.add(acctext.company.getId().toString());
        if (!acctext.getNullFields().contains("currency")) {
            sql.append(" and voucherEntry.FCurrencyID=? \t\t\t\n");
            params.add(acctext.currency.getId().toString());
        }
        sql.append(" and voucher.FBookedDate >= ?\t\t\t\t\t\n");
        params.add(new Timestamp(acctext.endPeriod.getBeginDate().getTime()));
        sql.append(" and voucher.FBookedDate <= ?  \t\t\t\t\t\n");
        params.add(new Timestamp(acctext.endDate.getTimeInMillis()));
        sql.append(" and Out_Account.FAccountTableID = ?   \n");
        params.add(acctext.company.getAccountTable().getId().toString());
        sql.append(" and Out_Account.flevel = ?\t\t\t\n");
        params.add(acctext.accountLevel);
        sql.append(" and Out_Account.Fnumber >= ?     \n");
        params.add(acctext.accountItem.startAccount.number);
        sql.append(" and Out_Account.Fnumber <= ?\t");
        params.add(acctext.accountItem.endAccount.number);
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(" )group by Out_Account.FDc,voucher.FBookedDate\t\n");
        if (!nullSet.contains("currency")) {
            sql.append(" , voucherEntry.FCurrencyID");
        }
        sql.append(" ,Out_Account.FCompanyID,Out_Account.FAccountTableID,Out_Account.flevel,Out_Account.Fnumber\t");
    }

    @Override
    public Set getAllowedNullFields() {
        return this.nullFields;
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combinestate;
    }

    @Override
    public List getFormulaCalculators() {
        return this.formulaList;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        Acctext acctExt = (Acctext)formula;
        ArrayList<Object> fileds = new ArrayList<Object>();
        fileds.add(acctExt.company.getId().toString());
        if (!acctExt.getNullFields().contains("currency")) {
            fileds.add(acctExt.currency.getId().toString());
        }
        fileds.add(acctExt.company.getAccountTable().getId().toString());
        fileds.add(acctExt.accountLevel);
        Object[][] result = new Object[1][fileds.size()];
        result[0] = fileds.toArray();
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        return IndexResultSetFields;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return this.batchSize;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        AcctextCombinestate state = (AcctextCombinestate)combineState;
        state.setTime(rs.getTimestamp("BookedDate"));
        state.setAccountNumber(rs.getString("AccountNumber"));
        state.setOriginal(rs.getBigDecimal("OriginalValue"));
        state.setLocal(rs.getBigDecimal("LocalValue"));
        state.setReporting(rs.getBigDecimal("ReportingValue"));
    }

    @Override
    public String getValueColumn(IFormulaCalculator formula) {
        Acctext acctext = (Acctext)formula;
        if ("GLC".equals(acctext.currency.getNumber())) {
            return "LocalValue";
        }
        if ("GRC".equals(acctext.currency.getNumber())) {
            return "ReportingValue";
        }
        if (acctext.vchGetType == VoucherGetTypeEnum.C || acctext.vchGetType == VoucherGetTypeEnum.Y) {
            return "OriginalValue";
        }
        if (acctext.vchGetType == VoucherGetTypeEnum.TC || acctext.vchGetType == VoucherGetTypeEnum.TY) {
            return "LocalValue";
        }
        if (acctext.vchGetType == VoucherGetTypeEnum.ZTC || acctext.vchGetType == VoucherGetTypeEnum.ZTY) {
            return "ReportingValue";
        }
        return "OriginalValue";
    }

    @Override
    public void preparedBuildSQL(IFormulaCalculator formula) {
    }

    @Override
    public void calculate(BatchHelper batchHelper) throws BOSException {
        this.batchSize = batchHelper.getBatchSize();
        batchHelper.batchCalculateBigDecimal(this);
    }

    @Override
    public boolean submitFormula(Acctext acctext) {
        this.getFormulaCalculators().add(acctext);
        return true;
    }

    public void setFormulaList(List formulaList) {
        this.formulaList = formulaList;
    }
}

