/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.app.AccountItemExt;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.util.DateTimeUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Age
extends AbstractFormulaCalculatorParameter {
    public static final Logger logger = Logger.getLogger(Age.class);
    private BatchHelper batchHelper;
    String fiOrgUnit;
    String orgUnit;
    String acctItem;
    String currency;
    String endDateString;
    String from;
    String to;
    public String balType;
    String ageType;
    String accountDateStr;
    Date endDate;
    Date accountDate;
    boolean includingUnPosted;
    AccountItemExt accountItem;
    public String companyId;
    String accountTableId;
    String currencyid;
    String amountField;
    boolean isGeneralCurrency;
    boolean isCalcAll;
    Date fromDate;
    Date toDate;
    boolean isInTimeVerify;
    private boolean isMergeByFiscalPeriod;
    PeriodCollection periods;
    String noGeneralCurrencyId;
    String calcType = "CUSSENT";
    Boolean isBizunit;
    String companyIdsForOnlyUnion;
    List<String> keys = null;
    int[] days;

    public Age(Parameter param) {
        super(param);
    }

    public Age(Parameter param, BatchHelper batchHelper, boolean isMergeByFiscalPeriod, PeriodCollection periods) {
        this.batchHelper = batchHelper;
        this.isMergeByFiscalPeriod = isMergeByFiscalPeriod;
        this.periods = periods;
        this.setParameter(param);
    }

    public Age(Age otherAge, Date adjustEndDate, String from, String to) {
        super(otherAge.getParameter());
        this.endDateString = null;
        this.endDate = adjustEndDate;
        this.from = from;
        this.to = to;
        this.fiOrgUnit = otherAge.fiOrgUnit;
        this.acctItem = otherAge.acctItem;
        this.currency = otherAge.currency;
        this.balType = otherAge.balType;
        this.accountDateStr = otherAge.accountDateStr;
        this.accountDate = otherAge.accountDate;
        this.includingUnPosted = otherAge.includingUnPosted;
        this.accountItem = otherAge.accountItem;
        this.companyId = otherAge.companyId;
        this.accountTableId = otherAge.accountTableId;
        this.currencyid = otherAge.currencyid;
        this.amountField = otherAge.amountField;
        this.isGeneralCurrency = otherAge.isGeneralCurrency;
        this.isCalcAll = otherAge.isCalcAll;
        this.fromDate = otherAge.fromDate;
        this.toDate = otherAge.toDate;
        this.isInTimeVerify = otherAge.isInTimeVerify;
        this.noGeneralCurrencyId = otherAge.noGeneralCurrencyId;
        this.isMergeByFiscalPeriod = otherAge.isMergeByFiscalPeriod;
        this.periods = otherAge.periods;
        this.calcType = otherAge.calcType;
        this.isBizunit = otherAge.isBizunit;
        this.keys = otherAge.keys;
        this.days = otherAge.days;
        this.ageType = otherAge.ageType;
    }

    public void initFormulaParam() {
        try {
            this.initArgs();
            this.verifyArgs();
        }
        catch (EASBizException e) {
            logger.error((Object)"initFormulaParam error.", (Throwable)e);
            this.setException((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"initFormulaParam error.", (Throwable)e);
            this.setException((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error((Object)"initFormulaParam error.", (Throwable)e);
            this.setException((Exception)((Object)new ReportException(ReportException.FORMULA_PARAM_ERROR)));
        }
    }

    @Override
    protected void initArgs() throws ReportException {
        int argsIndex;
        Object[] args = this.getParameter().getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        this.orgUnit = ((Variant)args[argsIndex = 0]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.acctItem = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.currency = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.endDateString = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.from = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        this.to = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        String string = this.balType = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        if (args.length >= 8) {
            String string2 = this.accountDateStr = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        }
        if (args.length >= 9) {
            String string3 = this.calcType = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        }
        if (args.length >= 10) {
            this.ageType = ((Variant)args[++argsIndex]).getValue() == null ? null : ((Variant)args[argsIndex]).getValue().toString();
        }
        this.isGeneralCurrency = true;
    }

    @Override
    protected void verifyArgs() throws BOSException, EASBizException {
        int[] result;
        RptPeriodTypeEnum periodTypeEnum;
        int endPeriod;
        int endYear;
        Date sheetEndDate;
        this.includingUnPosted = this.batchHelper.isSheet_IncludePosted(this.getSheetName());
        if (StringUtils.isEmpty((String)this.orgUnit)) {
            this.orgUnit = this.batchHelper.getCompany_Number();
        }
        if (this.currency == null || this.currency.length() <= 0) {
            this.currency = this.batchHelper.getCorrect_Currency_Number(this.getSheetName());
        }
        try {
            DateFormat format = CslRptUtil.getNationalDateFormat((Context)this.batchHelper.getServerContext());
            if (!StringUtils.isEmpty((String)this.endDateString) && format != null) {
                this.endDateString = BatchHelper.dateFormat.format(format.parse(this.endDateString));
            }
            if (!StringUtils.isEmpty((String)this.accountDateStr) && format != null) {
                this.accountDateStr = BatchHelper.dateFormat.format(format.parse(this.accountDateStr));
            }
        }
        catch (ParseException e1) {
            logger.error((Object)"ParseException", (Throwable)e1);
        }
        if (StringUtils.isEmpty((String)this.endDateString)) {
            sheetEndDate = this.batchHelper.getSheet_EndDate(this.getSheetName());
            if (sheetEndDate == null) {
                endYear = this.batchHelper.getSheet_EndYear(this.getSheetName());
                endPeriod = this.batchHelper.getSheet_EndPeriod(this.getSheetName());
                periodTypeEnum = RptPeriodTypeEnum.getEnum((int)this.batchHelper.getReport_PeriodType());
                if (this.isMergeByFiscalPeriod && this.periods != null) {
                    result = FiscalPeriodHelper.getRptYearAndPeriod((PeriodCollection)this.periods, (int)this.batchHelper.getReport_Year(), (int)this.batchHelper.getReport_Period(), (int)periodTypeEnum.getValue(), (int)endYear, (int)endPeriod, (boolean)this.isMergeByFiscalPeriod);
                    this.endDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)this.periods, (int)result[0], (int)result[1], (RptPeriodTypeEnum)periodTypeEnum, (boolean)this.isMergeByFiscalPeriod);
                } else {
                    if (endYear <= 0) {
                        endYear = this.batchHelper.getReport_Year() + endYear;
                    }
                    if (endPeriod <= 0) {
                        endPeriod = this.batchHelper.getReport_Period() + endPeriod;
                    }
                    this.endDate = RPTDateUtil.getPeriodLastDate((int)endYear, (int)endPeriod, (RptPeriodTypeEnum)periodTypeEnum);
                }
            } else {
                this.endDate = sheetEndDate;
            }
            this.endDateString = BatchHelper.dateFormat.format(this.endDate);
        } else {
            try {
                this.endDate = BatchHelper.dateFormat.parse(this.endDateString);
            }
            catch (ParseException e) {
                logger.error((Object)"", (Throwable)e);
                this.setException((Exception)((Object)new ReportException(ReportException.DATEFORMATERROR)));
                return;
            }
        }
        if (StringUtils.isEmpty((String)this.accountDateStr)) {
            sheetEndDate = this.batchHelper.getSheet_EndDate(this.getSheetName());
            if (sheetEndDate == null) {
                endYear = this.batchHelper.getSheet_EndYear(this.getSheetName());
                endPeriod = this.batchHelper.getSheet_EndPeriod(this.getSheetName());
                periodTypeEnum = RptPeriodTypeEnum.getEnum((int)this.batchHelper.getReport_PeriodType());
                if (this.isMergeByFiscalPeriod && this.periods != null) {
                    result = FiscalPeriodHelper.getRptYearAndPeriod((PeriodCollection)this.periods, (int)this.batchHelper.getReport_Year(), (int)this.batchHelper.getReport_Period(), (int)periodTypeEnum.getValue(), (int)endYear, (int)endPeriod, (boolean)this.isMergeByFiscalPeriod);
                    this.accountDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)this.periods, (int)result[0], (int)result[1], (RptPeriodTypeEnum)periodTypeEnum, (boolean)this.isMergeByFiscalPeriod);
                } else {
                    if (endYear <= 0) {
                        endYear = this.batchHelper.getReport_Year() + endYear;
                    }
                    if (endPeriod <= 0) {
                        endPeriod = this.batchHelper.getReport_Period() + endPeriod;
                    }
                    this.accountDate = RPTDateUtil.getPeriodLastDate((int)endYear, (int)endPeriod, (RptPeriodTypeEnum)periodTypeEnum);
                }
                this.accountDateStr = BatchHelper.dateFormat.format(this.accountDate);
            } else {
                this.accountDate = sheetEndDate;
            }
        } else {
            try {
                this.accountDate = BatchHelper.dateFormat.parse(this.accountDateStr);
            }
            catch (ParseException e) {
                logger.error((Object)"", (Throwable)e);
                this.setException((Exception)((Object)new ReportException(ReportException.DATEFORMATERROR)));
                return;
            }
        }
        this.adjust();
        this.isCalAll();
    }

    private void isCalAll() {
        boolean bl = this.isCalcAll = this.from != null && (this.from.equals("0") || this.from.trim().length() == 0) && this.to != null && this.to.equals("0");
        if (!this.isCalcAll) {
            int fromv = -1;
            if (!StringUtils.isEmpty((String)this.from)) {
                fromv = Integer.parseInt(this.from);
            }
            this.fromDate = this.getLastDateByBeforeDay(fromv, this.endDate);
            if (!StringUtils.isEmpty((String)this.to)) {
                int tov = Integer.parseInt(this.to);
                this.toDate = this.getLastDateByBeforeDay(tov, this.endDate);
            }
        } else {
            this.fromDate = new Date(this.endDate.getTime());
        }
    }

    private void adjust() throws ReportException {
        if (this.balType == null || this.balType.trim().length() == 0) {
            this.balType = "E";
        }
        if (!this.balType.equalsIgnoreCase("E") && !this.balType.equalsIgnoreCase("B")) {
            throw new ReportException(ReportException.BALTYPE_ERROR);
        }
        if (this.ageType == null || this.ageType.trim().length() == 0) {
            this.ageType = "O";
        }
        if (!this.ageType.equalsIgnoreCase("O") && !this.ageType.equalsIgnoreCase("U")) {
            throw new ReportException(ReportException.AGETYPE_ERROR);
        }
        this.adjustFromAndTo();
        this.endDate = DateTimeUtils.truncateDate((Date)this.endDate);
    }

    public void parseAcctItem() throws ReportException {
        if (this.acctItem == null || this.acctItem.length() < 1) {
            throw new ReportException(ReportException.PARAM_IS_NOT_INTEGRATED);
        }
        try {
            this.accountItem = new AccountItemExt(this.acctItem);
        }
        catch (ParseException parseEx) {
            throw new ReportException(ReportException.ACCOUNT_PARSE_ERROR);
        }
    }

    private void adjustFromAndTo() {
        int t;
        int f;
        if (this.ageType != null && this.ageType.equalsIgnoreCase("O")) {
            if (this.from != null && this.from.trim().length() > 0 && (f = Integer.parseInt(this.from)) < 0) {
                f = -1 * f;
                this.from = String.valueOf(f);
            }
            if (this.to != null && this.to.trim().length() > 0 && (t = Integer.parseInt(this.to)) < 0) {
                t = -1 * t;
                this.to = String.valueOf(t);
            }
        }
        if (this.ageType != null && this.ageType.equalsIgnoreCase("U")) {
            if (this.from != null && this.from.trim().length() > 0 && (f = Integer.parseInt(this.from)) > 0) {
                f = -1 * f;
                this.from = String.valueOf(f);
            }
            if (this.to != null && this.to.trim().length() > 0 && (t = Integer.parseInt(this.to)) > 0) {
                t = -1 * t;
                this.to = String.valueOf(t);
            }
        }
        if (this.from != null && this.from.trim().length() > 0 && this.to != null && this.to.trim().length() > 0) {
            f = Math.abs(Integer.parseInt(this.from));
            int t2 = Math.abs(Integer.parseInt(this.to));
            if (t2 < f) {
                String temp = this.from;
                this.from = this.to;
                this.to = temp;
            }
        }
    }

    private Date getLastDateByBeforeDay(int beforeDay, Date date) {
        if (beforeDay != -1) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(5, -1 * beforeDay);
            if (cal.getTimeInMillis() < 0L) {
                return new Date(0L);
            }
            return new Date(cal.getTimeInMillis());
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return new Date(cal.getTimeInMillis());
    }

    public int[] getAgeArea() {
        int[] area = new int[]{0, Integer.MAX_VALUE};
        if (this.ageType != null && this.ageType.equalsIgnoreCase("U")) {
            area = new int[]{0, Integer.MIN_VALUE};
        }
        if (this.from != null && !"".equals(this.from)) {
            area[0] = Integer.parseInt(this.from);
        }
        if (this.to != null && !"".equals(this.to)) {
            area[1] = Integer.parseInt(this.to);
        }
        return area;
    }

    public AccountItemExt getAccountItem() {
        return this.accountItem;
    }

    public Boolean isBizunit() {
        return this.isBizunit;
    }

    public String getCompanyIdsForOnlyUnion() {
        return this.companyIdsForOnlyUnion;
    }

    public Age clone(Parameter param, BatchHelper batchHelper, boolean isMergeByFiscalPeriod, PeriodCollection periods) {
        Age newAge = new Age(param, batchHelper, isMergeByFiscalPeriod, periods);
        newAge.initFormulaParam();
        return newAge;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    public int[] getDays() {
        return this.days;
    }

    public void setDays(int[] days) {
        this.days = days;
    }
}

