/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age;

import com.kingdee.bos.Context;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.PsSql;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class DebugModel {
    private static Logger logger = Logger.getLogger(DebugModel.class);
    private Context serverContext = null;
    private List sqls = new LinkedList();
    private List paramsArray = new LinkedList();

    public DebugModel(Context serverContext) {
        this.serverContext = serverContext;
    }

    public boolean meet() {
        return DebugLogger.isDebug;
    }

    public void record(String sql, Object[] params) {
        this.sqls.add(sql);
        this.paramsArray.add(params);
    }

    public void execDebug(List usedDyItemList) {
        String dbType = ContextUtil.getDbType((Context)this.serverContext);
        Iterator it = usedDyItemList.iterator();
        while (it.hasNext()) {
            try {
                IFormulaCalculator formula = (IFormulaCalculator)it.next();
                if (!this.isDebugSheet(formula.getSheetName())) continue;
                String kql = this.buildSql(dbType);
                if (formula.getParameter() == null) continue;
                Object value = formula.getParameter().getValue();
                if (value != null) {
                    formula.getParameter().setValue((Object)(value + "\n" + kql + "\n"));
                    continue;
                }
                formula.getParameter().setValue((Object)(kql + "\n"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String buildSql(String dbType) {
        StringBuffer kql = new StringBuffer();
        String sql = null;
        Object[] params = null;
        for (int i = 0; i < this.sqls.size(); ++i) {
            sql = (String)this.sqls.get(i);
            params = (Object[])this.paramsArray.get(i);
            try {
                if (params.length == 0) {
                    kql.append(sql);
                } else {
                    kql.append(PsSql.getSqlWithParams(sql, params, DbType.getValue((String)dbType), false));
                }
            }
            catch (SQLException e) {
                kql.append(sql.toString() + "\n");
                for (int j = 0; j < params.length; ++j) {
                    kql.append("[" + params[j] + "]");
                }
            }
            kql.append(" \n\n ");
        }
        return kql.toString();
    }

    private boolean isDebugSheet(String sheetName) {
        if (StringUtils.isEmpty((String)sheetName)) {
            return false;
        }
        return sheetName.equalsIgnoreCase("debug");
    }

    public void clear() {
    }
}

