/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.age.balance.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.SimpleAssistantHG;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.util.FileSQL;
import com.kingdee.eas.fi.rpt.batch.age.balance.facade.util.InSQLElement;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ConvertAssistHGID2Number {
    private Context ctx;

    public ConvertAssistHGID2Number(Context ctx) {
        this.ctx = ctx;
    }

    public void exec(Set hgIds) throws BOSException {
        if (hgIds.isEmpty()) {
            return;
        }
        FileSQL sql = new FileSQL("com/kingdee/eas/fi/rpt/batch/age/balance/facade/query_asst_type.sql");
        SimpleAssistantHG hg2 = null;
        InSQLElement inValueExpr = new InSQLElement();
        HashMap<String, SimpleAssistantHG> hgs = new HashMap<String, SimpleAssistantHG>();
        for (SimpleAssistantHG hg2 : hgIds) {
            inValueExpr.add(hg2.getHgId());
            hgs.put(hg2.getHgId(), hg2);
        }
        sql.format(new String[]{inValueExpr.sql()});
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.sql());
        HashMap<String, AsstActTypeWithHg> querys = new HashMap<String, AsstActTypeWithHg>();
        try {
            String typeNumber = null;
            AsstActTypeWithHg queryHG = null;
            while (rs.next()) {
                typeNumber = rs.getString("type_number");
                if (!querys.containsKey(typeNumber)) {
                    queryHG = new AsstActTypeWithHg();
                    queryHG.number = typeNumber;
                    queryHG.mappingFieldName = rs.getString("type_field_name");
                    queryHG.realtionDataObject = rs.getString("type_table_name");
                    querys.put(typeNumber, queryHG);
                } else {
                    queryHG = (AsstActTypeWithHg)querys.get(typeNumber);
                }
                queryHG.hgIds.add(rs.getString("hg_id"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        AsstActTypeWithHg queryHG2 = null;
        FileSQL queryAsstValueSQL = new FileSQL("com/kingdee/eas/fi/rpt/batch/age/balance/facade/query_asst_value.sql");
        String inValues = null;
        IRowSet asstNumbers = null;
        for (AsstActTypeWithHg queryHG2 : querys.values()) {
            inValues = new InSQLElement(queryHG2.hgIds).sql();
            queryAsstValueSQL.format(new String[]{queryHG2.realtionDataObject, queryHG2.mappingFieldName, inValues});
            asstNumbers = DbUtil.executeQuery((Context)this.ctx, (String)queryAsstValueSQL.sql());
            try {
                String hgId = null;
                String asstNumber = null;
                while (asstNumbers.next()) {
                    asstNumber = asstNumbers.getString("asst_value_number");
                    hgId = asstNumbers.getString("hg_id");
                    if (!hgs.containsKey(hgId)) continue;
                    hg2 = (SimpleAssistantHG)hgs.get(hgId);
                    hg2.getAsstTypes().add(queryHG2.number);
                    if (asstNumber != null) {
                        asstNumber = asstNumber.trim();
                    }
                    hg2.getAsstValues().add(asstNumber);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
    }

    private static final class AsstActTypeWithHg {
        public String number;
        public String realtionDataObject;
        public String mappingFieldName;
        public Set hgIds = new HashSet();

        private AsstActTypeWithHg() {
        }
    }
}

