/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.eqtdata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.rpt.ElimInvDataItemsEnum;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.batch.AbstractFormulaCalculatorParameter;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.util.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EqtData
extends AbstractFormulaCalculatorParameter {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    String orgUnitInvest;
    String orgUnitInvested;
    String ItemNum;
    Date InvDate;
    String currencyNum;
    private BatchHelper batchHelper;

    EqtData(Parameter param, BatchHelper batchHelper) {
        this.batchHelper = batchHelper;
        this.setParameter(param);
        try {
            this.initArgs();
            this.verifyArgs();
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    @Override
    protected void initArgs() throws BOSException, EASBizException {
        int index;
        Object[] args = this.getParameter().getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        this.orgUnitInvest = StringUtils.isEmpty((String)((Variant)args[index = 0]).getValue().toString()) ? this.batchHelper.getCompany_Number() : ((Variant)args[index]).getValue().toString();
        String string = this.orgUnitInvested = ((Variant)args[++index]).getValue() == null ? null : ((Variant)args[index]).getValue().toString();
        if (!StringUtils.isEmpty((String)((Variant)args[++index]).getValue().toString())) {
            String date = ((Variant)args[index]).getValue().toString();
            try {
                dateFormat.setLenient(false);
                DateFormat format = CslRptUtil.getNationalDateFormat((Context)this.batchHelper.getServerContext());
                if (format != null) {
                    this.InvDate = dateFormat.parse(dateFormat.format(format.parse(date)));
                }
                this.InvDate = dateFormat.parse(date);
            }
            catch (ParseException e) {
                throw new ReportException(ReportException.INVDATE_INVALID);
            }
        } else {
            this.InvDate = this.batchHelper.getReport_EndDate();
        }
        this.currencyNum = !StringUtils.isEmpty((String)((Variant)args[++index]).getValue().toString()) ? ((Variant)args[index]).getValue().toString() : this.batchHelper.getCorrect_Currency_Number(this.getSheetName());
        this.ItemNum = ((Variant)args[++index]).getValue() == null ? null : ((Variant)args[index]).getValue().toString();
    }

    @Override
    protected void verifyArgs() throws BOSException, EASBizException {
        int ItemValue;
        if (StringUtils.isEmpty((String)this.orgUnitInvest)) {
            throw new ReportException(ReportException.INVEST_COMPANY_NULL);
        }
        if (StringUtils.isEmpty((String)this.orgUnitInvested)) {
            throw new ReportException(ReportException.INVESTED_COMPANY_NULL);
        }
        if (this.InvDate == null) {
            throw new ReportException(ReportException.INVDATE_INVALID);
        }
        int n = ItemValue = ElimInvDataItemsEnum.getEnum(this.ItemNum) == null ? -1 : ElimInvDataItemsEnum.getEnum(this.ItemNum).getValue();
        if (ItemValue == -1) {
            throw new ReportException(ReportException.INVITEM_ERROR);
        }
    }

    public String toString() {
        Object[] args = this.getParameter().getArgs();
        StringBuffer formulaStr = new StringBuffer("InvData(");
        for (int k = 0; k < args.length; ++k) {
            formulaStr.append("\"").append(args[k]).append("\",");
        }
        return formulaStr.deleteCharAt(formulaStr.length() - 1).append(")").toString();
    }
}

