/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.eqtdata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.eqtdata.EqtData;
import com.kingdee.eas.fi.rpt.batch.eqtdata.EqtDataBatchSqlProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EqtDataBatchCalculator
extends AbstractCalculator {
    private List EqtDataList;
    private EqtDataBatchSqlProcessor batchSqlProcessor = null;
    private Map sortEqtDataMap = new HashMap();

    public EqtDataBatchCalculator(ICalculateContextProvider context, Context serverCtx) {
        super(context, serverCtx);
        this.EqtDataList = this.getFormulaCalculatorParameterList();
    }

    @Override
    protected void calculate() throws BOSException, EASBizException {
        this.sortEqtDatas();
        for (String itemNumber : this.sortEqtDataMap.keySet()) {
            this.batchSqlProcessor = new EqtDataBatchSqlProcessor(itemNumber);
            this.batchSqlProcessor.setFormulaList((List)this.sortEqtDataMap.get(itemNumber));
            this.batchHelper.batchCalculateBigDecimal(this.batchSqlProcessor);
        }
    }

    @Override
    protected void clear() {
        this.EqtDataList.clear();
        this.sortEqtDataMap.clear();
    }

    @Override
    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        this.initEqtDatas(params);
    }

    private void initEqtDatas(SortedParameterArray params) {
        int count = params.size();
        for (int i = 0; i < count; ++i) {
            EqtData eqtData = new EqtData(params.getParameter(i), this.batchHelper);
            if (eqtData.isException()) {
                this.addToErrorList(eqtData);
                continue;
            }
            this.EqtDataList.add(eqtData);
        }
    }

    private void sortEqtDatas() {
        if (this.EqtDataList.isEmpty()) {
            return;
        }
        for (EqtData eqtData : this.EqtDataList) {
            String item = eqtData.ItemNum;
            if (this.sortEqtDataMap.containsKey(item)) {
                ((List)this.sortEqtDataMap.get(item)).add(eqtData);
                continue;
            }
            ArrayList<EqtData> temp = new ArrayList<EqtData>();
            temp.add(eqtData);
            this.sortEqtDataMap.put(item, temp);
        }
    }
}

