/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.eqtdata;

import com.kingdee.eas.fi.rpt.batch.IBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IFormulaCombinationPreparedState;
import com.kingdee.eas.fi.rpt.batch.eqtdata.EqtData;
import com.kingdee.eas.fi.rpt.batch.eqtdata.EqtDataCombineState;
import com.kingdee.eas.fi.rpt.batch.eqtdata.EqtDataSelector;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EqtDataBatchSqlProcessor
implements IBatchSQLProcessor {
    protected static final String[] IndexResultSetFields = new String[]{"CNum", "targNum", "curNum"};
    protected static int maxsqlvar = 200;
    protected Set nullFields = new HashSet();
    protected List formulaList;
    private final String itemNumber;
    protected EqtDataCombineState combineState = new EqtDataCombineState();

    public EqtDataBatchSqlProcessor(String itemNumber) {
        this.itemNumber = itemNumber;
    }

    @Override
    public IFormulaCombinationPreparedState getCombineState() {
        return this.combineState;
    }

    @Override
    public Object[][] getIndexFormulaFields(IFormulaCalculator formula) {
        Object[][] result = new Object[1][];
        ArrayList<String> fields = new ArrayList<String>();
        EqtData eqtData = (EqtData)formula;
        fields.add(eqtData.orgUnitInvest);
        fields.add(eqtData.orgUnitInvested);
        fields.add(eqtData.currencyNum);
        result[0] = fields.toArray();
        return result;
    }

    @Override
    public String[] getIndexResultSetFields() {
        return IndexResultSetFields;
    }

    @Override
    public int getMaxSQLVaribleSize() {
        return maxsqlvar;
    }

    @Override
    public void prepareStateForCombine(IRowSet rs, IFormulaCombinationPreparedState combineState) throws SQLException {
        EqtDataCombineState EqtDataCombineState2 = (EqtDataCombineState)combineState;
        ArrayList<BigDecimal> valus = new ArrayList<BigDecimal>(6);
        valus.add(rs.getBigDecimal("honor"));
        valus.add(rs.getBigDecimal("honorSum"));
        valus.add(rs.getBigDecimal("afound"));
        valus.add(rs.getBigDecimal("sfound"));
        valus.add(rs.getBigDecimal("profit"));
        valus.add(rs.getBigDecimal("otherItem"));
        valus.add(rs.getBigDecimal("commonriskreserve"));
        valus.add(rs.getBigDecimal("specialreserve"));
        valus.add(rs.getBigDecimal("foreigncurrencytransdiff"));
        valus.add(rs.getBigDecimal("paidincapital"));
        valus.add(rs.getBigDecimal("treasuryshares"));
        valus.add(rs.getBigDecimal("otherritools"));
        valus.add(rs.getBigDecimal("othercomplexproceeds"));
        valus.add(rs.getBigDecimal("investequity"));
        EqtDataCombineState2.setValue(valus.toArray());
        EqtDataCombineState2.setChgDate(rs.getDate("invDate"));
    }

    @Override
    public void buildFromPart(Set nullSet, StringBuffer sql) {
        sql.append(" from t_csl_ElimInvestDataMaintain m \n").append(" join t_org_baseUnit company on company.fid = m.fcompanyId \n").append(" join t_org_baseUnit targCompany on targCompany.fid = m.ftargetCompanyId \n").append(" join t_bd_currency currency on currency.fid = m.fcurrencyId \n");
    }

    @Override
    public void buildGroupByPart(Set nullSet, StringBuffer sql) {
        sql.append(" order by invDate DESC");
    }

    @Override
    public void buildSelectPart(Set nullSet, StringBuffer sql) {
        sql.append(" select company.fnumber CNum,targCompany.fnumber targNum,currency.fnumber curNum, \n").append(" m.fOtherItem otherItem,m.FHonor honor,m.FCommonRiskReserve commonriskreserve, \n").append(" m.FSpecialReserve specialreserve,m.ForeignCurrencyTransDiff foreigncurrencytransdiff, \n").append(" m.FOtherRITools otherritools,m.FOtherComplexProceeds othercomplexproceeds, \n").append(" m.FPaidInCapital paidincapital,m.FTreasuryShares treasuryshares,m.FHonorSum honorSum,m.FUnsharedProfit profit, \n").append(" m.FAccumulationFound afound,m.FSurplusFound sfound,m.FInvestDate invDate,m.FInvestEquity investEquity \n");
    }

    @Override
    public void buildVariableWherePart(StringBuffer sql, List params, IFormulaCalculator formula) {
        EqtData eqtData = (EqtData)formula;
        sql.append("company.fnumber = ? \n");
        params.add(eqtData.orgUnitInvest);
        sql.append(" and targCompany.fnumber = ? \n");
        params.add(eqtData.orgUnitInvested);
        sql.append(" and currency.fnumber = ? \n");
        params.add(eqtData.currencyNum);
        this.specialHandleField("m", sql);
        sql.append(" and m.fInvestDate = ");
        Date date = new Date(eqtData.InvDate.getTime());
        this.buildWhereMaxChgDateSQL(sql, eqtData, date, params);
    }

    @Override
    public void builderConstantWherePart(Set nullSet, StringBuffer sql, List params) {
        sql.append(" where ");
    }

    @Override
    public Set getAllowedNullFields() {
        return this.nullFields;
    }

    @Override
    public List getFormulaCalculators() {
        return this.formulaList;
    }

    private void buildWhereMaxChgDateSQL(StringBuffer sql, EqtData eqtData, Date date, List params) {
        sql.append("(select  max(InvData2.fInvestDate) from t_csl_ElimInvestDataMaintain InvData2 \n");
        sql.append(" join t_org_baseunit com2 on com2.fid = InvData2.fcompanyid \n");
        sql.append(" join t_org_baseunit targetcom2 on targetcom2.fid = InvData2.ftargetcompanyid \n");
        sql.append(" join t_bd_currency currency2 on currency2.fid = InvData2.fcurrencyid \n");
        sql.append(" where com2.fnumber = ? \n");
        params.add(eqtData.orgUnitInvest);
        sql.append(" and targetcom2.fnumber = ? \n");
        params.add(eqtData.orgUnitInvested);
        sql.append(" and currency2.fnumber = ? \n");
        params.add(eqtData.currencyNum);
        this.specialHandleField("InvData2", sql);
        sql.append(" and InvData2.fInvestDate <= ? ) \n");
        params.add(date);
    }

    private void specialHandleField(String alias, StringBuffer sql) {
        int index = EqtDataSelector.getInstance().getFieldIndex(this.itemNumber);
        String realFieldName = EqtDataSelector.getInstance().getFieldName(index);
        if (alias != null && alias.equals("")) {
            realFieldName = alias + "." + realFieldName;
        }
        sql.append(" and ").append(realFieldName).append(" is not null ");
    }

    protected List getFormulaList() {
        return this.formulaList;
    }

    protected void setFormulaList(List formulaList) {
        this.formulaList = formulaList;
    }
}

