/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.hint;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.batch.hint.ISQLHintSource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SQLHintProvider {
    private static final Logger log = Logger.getLogger(SQLHintProvider.class);
    protected Context ctx;

    protected SQLHintProvider() {
    }

    public SQLHintProvider(Context ctx) {
        this.ctx = ctx;
    }

    public String find(ISQLHintSource source) {
        if (!"Oracle".equalsIgnoreCase(ContextUtil.getDbType((Context)this.ctx))) {
            return null;
        }
        String key = source.defineKey().toUpperCase();
        Properties sourceCondition = source.defineCondition();
        this.upperKey(sourceCondition);
        StringBuffer querySql = new StringBuffer();
        querySql.append(this.getQuerySQLPrefix());
        querySql.append(" AND ( ");
        querySql.append(" UPPER(FKey) = UPPER(?)");
        querySql.append(" ) ");
        log.debug((Object)("find hint for hintKey '" + key + "'"));
        IRowSet rs = this.dbQuery(key, querySql.toString(), new Object[]{key});
        if (rs == null || rs.size() == 0) {
            log.debug((Object)"find hint [empty]");
            return "";
        }
        log.debug((Object)("find " + rs.size() + " hint define"));
        try {
            Object defineCondition = null;
            String hint = null;
            while (rs.next()) {
                if (!this.matchCondition(sourceCondition, rs.getString("FCondition")) || !this.checkHintFormat(hint = rs.getString("FHint")) || hint == null || "".equals(hint.trim())) continue;
                log.debug((Object)("find suited hint define :'" + hint + "'"));
                return hint;
            }
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
        }
        log.debug((Object)"find hint [error]");
        return "";
    }

    private void upperKey(Properties prop) {
        Iterator<Object> en = new HashSet<Object>(prop.keySet()).iterator();
        String key = null;
        String upperKey = null;
        while (en.hasNext()) {
            key = (String)en.next();
            upperKey = key.toUpperCase();
            prop.put(upperKey, prop.get(key));
            prop.remove(key);
        }
    }

    protected boolean checkHintFormat(String hint) throws SQLException {
        return true;
    }

    protected boolean matchCondition(Properties sourceCondition, String defineConditionStr) {
        Properties defineCondition = this.properties(defineConditionStr);
        Enumeration<Object> it = defineCondition.keys();
        String key = null;
        Object nextSourceCondition = null;
        Object nextDefineCondition = null;
        while (it.hasMoreElements()) {
            try {
                key = (String)it.nextElement();
                nextDefineCondition = defineCondition.get(key);
                nextSourceCondition = sourceCondition.get(key);
                if (nextSourceCondition != null && nextSourceCondition.equals(nextDefineCondition)) continue;
                return false;
            }
            catch (NullPointerException e) {
                log.error((Object)"", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected IRowSet dbQuery(String hintKey, String querySql, Object[] params) {
        try {
            return DbUtil.executeQuery((Context)this.ctx, (String)querySql, (Object[])params);
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    protected String getQuerySQLPrefix() {
        StringBuffer querySql = new StringBuffer();
        querySql.append(" SELECT FCONDITION,FHINT FROM T_RPT_HINT WHERE FDISABLESTATUS = 0 ");
        return querySql.toString();
    }

    protected Properties properties(String defineConditionStr) {
        Properties prop = new Properties();
        if (defineConditionStr == null || "".equals(defineConditionStr.trim())) {
            return prop;
        }
        try {
            defineConditionStr = defineConditionStr.replaceAll(",|;", "\r\n");
            ByteArrayInputStream byteStream = new ByteArrayInputStream(defineConditionStr.getBytes());
            prop.load(byteStream);
            this.upperKey(prop);
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
        return prop;
    }
}

