/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.invdata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.invdata.AbstracteInvDataSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.invdata.InvData;
import com.kingdee.eas.fi.rpt.batch.invdata.InvDataEntryTableBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.invdata.InvDataFormulaDynaItemHelp;
import com.kingdee.eas.fi.rpt.batch.invdata.InvDataMastTableBatchSqlProcessor;
import com.kingdee.eas.fi.rpt.batch.invdata.InvDataOthOwnerTableBatchSQLProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvDataBatchCalculator
extends AbstractCalculator {
    private List InvDataList = this.getFormulaCalculatorParameterList();
    private Map sortMap;
    private AbstracteInvDataSQLProcessor batchSqlProcessor = null;

    public InvDataBatchCalculator(ICalculateContextProvider context, Context serverCtx) {
        super(context, serverCtx);
    }

    private void executeCalculate() throws BOSException, EASBizException {
        for (String key : this.sortMap.keySet()) {
            List temp = (List)this.sortMap.get(key);
            if (temp == null || temp.size() <= 0 || "INVALIDATE".equals(key)) continue;
            if ("OWNERTABLE".equals(key)) {
                this.batchSqlProcessor = new InvDataOthOwnerTableBatchSQLProcessor(key);
                this.batchSqlProcessor.setFormulaList(temp);
                this.batchHelper.batchCalculateBigDecimal(this.batchSqlProcessor);
                continue;
            }
            if ("ENTRYTABLE".equals(key)) {
                this.batchSqlProcessor = new InvDataEntryTableBatchSQLProcessor(key);
                this.batchSqlProcessor.setFormulaList(temp);
                this.batchHelper.batchCalculateBigDecimal(this.batchSqlProcessor);
                continue;
            }
            this.batchSqlProcessor = new InvDataMastTableBatchSqlProcessor(key);
            this.batchSqlProcessor.setFormulaList(temp);
            this.batchHelper.batchCalculateBigDecimal(this.batchSqlProcessor);
        }
    }

    @Override
    protected void calculate() throws BOSException, EASBizException {
        this.sortInvDataList();
        this.executeCalculate();
    }

    @Override
    protected void clear() {
        this.InvDataList.clear();
        this.sortMap.clear();
    }

    @Override
    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        this.initInvDatas(params);
    }

    private void initInvDatas(SortedParameterArray params) {
        int count = params.size();
        boolean isMergeByFiscalPeriod = CslRptUtil.isMergeByFiscalPeriod((Context)this.serverContext);
        PeriodCollection periods = null;
        if (isMergeByFiscalPeriod) {
            periods = FiscalPeriodHelper.initFormualFiscalPeriods((Context)this.serverContext, (ICalculateContextProvider)this.calCulateContext);
        }
        for (int i = 0; i < count; ++i) {
            InvData invData = new InvData(params.getParameter(i), this.batchHelper, periods, isMergeByFiscalPeriod);
            if (invData.isException()) {
                this.addToErrorList(invData);
                continue;
            }
            this.InvDataList.add(invData);
        }
    }

    private void sortInvDataList() {
        this.sortMap = new HashMap();
        InvData invData2 = null;
        List<InvData> formulaList = null;
        String ItemNum = "";
        String calType = "";
        for (InvData invData2 : this.InvDataList) {
            ItemNum = invData2.ItemType;
            calType = InvDataFormulaDynaItemHelp.getInstance().mappingSortKey(ItemNum);
            formulaList = this.sortMap.containsKey(calType) ? (List)this.sortMap.get(calType) : new ArrayList<InvData>();
            formulaList.add(invData2);
            this.sortMap.put(calType, formulaList);
        }
    }
}

