/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.iref;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.rpt.batch.iref.AcctItemAsstTranslator;
import com.kingdee.eas.fi.rpt.batch.iref.AsstItemInfo;
import com.kingdee.eas.fi.rpt.batch.iref.IntegrateSchemeHelper;
import com.kingdee.eas.fi.rpt.batch.iref.LRUMap;
import com.kingdee.eas.fi.rpt.client.CustomItemObject;
import com.kingdee.eas.fi.rpt.client.IItemObject;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class AsstItemTypeCache {
    private HashMap<CacheKey, List<IItemObject>> LRUMap = new LRUMap<CacheKey, List<IItemObject>>();
    private static AsstItemTypeCache cache;

    public static AsstItemTypeCache getInstance() {
        if (cache == null) {
            cache = new AsstItemTypeCache();
        }
        return cache;
    }

    public List<IItemObject> getAsstItemTypeList(CacheKey key) throws Exception {
        if (!this.LRUMap.containsKey(key)) {
            this.LRUMap.put(key, this.queryData(key));
        }
        return this.LRUMap.get(key);
    }

    public boolean hasInCache(CacheKey key) {
        return this.LRUMap.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap<CacheKey, List<IItemObject>> hashMap = this.LRUMap;
        synchronized (hashMap) {
            this.LRUMap.clear();
        }
    }

    private String columnName(CacheKey key, String fieldName) throws BOSException {
        return IntegrateSchemeHelper.getInstance().getTableColumnName(null, key.companyNumber, fieldName, key.orgType);
    }

    private List<IItemObject> queryData(CacheKey key) throws Exception {
        ArrayList<IItemObject> list = new ArrayList<IItemObject>();
        String tableName = IntegrateSchemeHelper.getInstance().getTableName(null, key.companyNumber, key.orgType);
        StringBuilder builder = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>(4);
        builder.append(" select distinct " + this.columnName(key, IntegrateSchemeHelper.Fields.fasst_number.name()) + " from ").append(tableName).append(" join T_ORG_BaseUnit unit on unit.FID = ").append(this.columnName(key, IntegrateSchemeHelper.Fields.fcompanynum.name())).append(" where unit.fnumber = ? ").append(" and " + this.columnName(key, IntegrateSchemeHelper.Fields.forgtype.name()) + " = ? ").append(" and " + this.columnName(key, IntegrateSchemeHelper.Fields.fbizdate.name()) + " >= ?").append(" and " + this.columnName(key, IntegrateSchemeHelper.Fields.fbizdate.name()) + " <= ?").append(" and " + this.columnName(key, IntegrateSchemeHelper.Fields.fasst_number.name()) + " is not null ");
        params.add(key.companyNumber);
        params.add(key.orgType.getValue());
        params.add(new java.sql.Date(key.startDate.getTime()));
        params.add(new java.sql.Date(key.endDate.getTime()));
        IRowSet rs = new DBHandler(null).getExecuteSQL().executeQuery(builder.toString(), params.toArray());
        AcctItemAsstTranslator translator = new AcctItemAsstTranslator(null);
        StringBuffer asstTypeNameSerial = new StringBuffer();
        StringBuffer asstTypeNumSerial = new StringBuffer();
        while (rs.next()) {
            translator.translate(rs.getString(this.columnName(key, IntegrateSchemeHelper.Fields.fasst_number.name())), "");
            asstTypeNameSerial.setLength(0);
            asstTypeNumSerial.setLength(0);
            boolean hasMoreOne = false;
            while (translator.hasNext()) {
                AsstItemInfo info = translator.next();
                if (hasMoreOne) {
                    asstTypeNameSerial.append("|");
                    asstTypeNumSerial.append("|");
                }
                asstTypeNameSerial.append(info.getAsstType().getName());
                asstTypeNumSerial.append(info.getAsstType().getNumber());
                hasMoreOne = true;
            }
            list.add((IItemObject)new CustomItemObject(asstTypeNameSerial.toString(), asstTypeNumSerial.toString()));
        }
        return list;
    }

    public static class CacheKey {
        Date startDate;
        Date endDate;
        String companyNumber;
        OrgType orgType;

        public CacheKey(Date startDate, Date endDate, String companyNumber, OrgType orgType) {
            this.startDate = startDate;
            this.endDate = endDate;
            this.companyNumber = companyNumber;
            this.orgType = orgType;
        }

        public int hashCode() {
            return this.companyNumber.hashCode() * 13 + this.orgType.hashCode() * 11;
        }

        public boolean equals(Object anObject) {
            CacheKey another = (CacheKey)anObject;
            return this.companyNumber.equals(another.companyNumber) && another.startDate.compareTo(this.startDate) <= 0 && another.endDate.compareTo(this.endDate) >= 0;
        }

        public String toString() {
            StringBuffer toString = new StringBuffer();
            this.suger(this.companyNumber, toString);
            this.suger(this.orgType.getAlias(), toString);
            this.suger(RPTDateUtil.formateDate((Date)this.startDate, (String)"yyyy-MM-dd"), toString);
            this.suger(RPTDateUtil.formateDate((Date)this.endDate, (String)"yyyy-MM-dd"), toString);
            return toString.toString();
        }

        private void suger(String targ, StringBuffer toString) {
            toString.append("[").append(targ).append("]");
        }
    }
}

