/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.iref;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.csinterface.billmapping.util.BillMappingUtil;
import com.kingdee.eas.fi.gr.cslrpt.IOrgInteMappingEntry;
import com.kingdee.eas.fi.gr.cslrpt.OrgInteMappingEntryCollection;
import com.kingdee.eas.fi.gr.cslrpt.OrgInteMappingEntryFactory;
import com.kingdee.eas.fi.rpt.batch.iref.LRUMap;
import com.kingdee.util.StringUtils;
import java.util.Map;

public class IntegrateSchemeHelper {
    private static IntegrateSchemeHelper helper;
    private static LRUMap<String, MappingInfo> cache;
    private static LRUMap<String, Map<String, String>> fieldCache;

    private IntegrateSchemeHelper() {
    }

    public static IntegrateSchemeHelper getInstance() {
        if (helper == null) {
            helper = new IntegrateSchemeHelper();
        }
        return helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LRUMap<String, Object> lRUMap = cache;
        synchronized (lRUMap) {
            cache.clear();
        }
        lRUMap = fieldCache;
        synchronized (lRUMap) {
            fieldCache.clear();
        }
    }

    public String getTableName(Context ctx, String companyNum, OrgType orgType) throws BOSException {
        return this.getMappingInfoFromCache((Context)ctx, (String)companyNum, (OrgType)orgType).mapTableName;
    }

    public String getTableColumnName(Context ctx, String companyNum, String mapKey, OrgType orgType) throws BOSException {
        return this.getFieldMapFromCache(ctx, companyNum, orgType).get(mapKey.toLowerCase());
    }

    private Map<String, String> getFieldMapFromCache(Context ctx, String companyNum, OrgType orgType) throws BOSException {
        MappingInfo info = this.getMappingInfoFromCache(ctx, companyNum, orgType);
        String cacheKey = this.genKey(companyNum, orgType);
        if (!fieldCache.containsKey(cacheKey)) {
            try {
                fieldCache.put(cacheKey, BillMappingUtil.getReportFieldForColumn((Context)ctx, (String)info.schemeNum));
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return (Map)fieldCache.get(cacheKey);
    }

    private MappingInfo getMappingInfoFromCache(Context ctx, String companyNum, OrgType orgType) throws BOSException {
        String cacheKey = this.genKey(companyNum, orgType);
        if (cache.containsKey(cacheKey)) {
            return (MappingInfo)cache.get(cacheKey);
        }
        StringBuffer oql = new StringBuffer();
        oql.append("select orgInteMapping.billMapping.midBillTable,orgInteMapping.billMapping.number where org.number = '" + companyNum + "'").append(" and orgInteMapping.orgType = ").append(orgType.getValue());
        IOrgInteMappingEntry facade = ctx == null ? OrgInteMappingEntryFactory.getRemoteInstance() : OrgInteMappingEntryFactory.getLocalInstance((Context)ctx);
        OrgInteMappingEntryCollection col = facade.getOrgInteMappingEntryCollection(oql.toString());
        if (col == null || col.size() <= 0) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"IRef_NoMappingFromCompanyToScheme"));
        }
        String tableName = col.get(0).getOrgInteMapping().getBillMapping().getMidBillTable();
        String schemeNum = col.get(0).getOrgInteMapping().getBillMapping().getNumber();
        if (StringUtils.isEmpty((String)tableName)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"IRef_MidTableOfSchemMappedIsNotExists"));
        }
        cache.put(cacheKey, new MappingInfo(tableName, schemeNum));
        return (MappingInfo)cache.get(cacheKey);
    }

    private String genKey(String companyNum, OrgType orgType) {
        return companyNum + ":" + orgType.getValue();
    }

    static {
        cache = new LRUMap();
        fieldCache = new LRUMap();
    }

    class MappingInfo {
        String mapTableName;
        String schemeNum;

        MappingInfo(String mapTableName, String schemeNum) {
            this.mapTableName = mapTableName;
            this.schemeNum = schemeNum;
        }
    }

    public static enum Fields {
        fcompanynum,
        fcurrencynum,
        faccountnum,
        fbizdate,
        fdataelement,
        fvaluetype,
        fasst_number,
        forgtype,
        ftxtvalue,
        famount,
        fasst1_number,
        fasst2_number,
        fasst3_number,
        fasst4_number,
        fasst5_number,
        fasst6_number,
        fasst7_number,
        fasst8_number;

    }
}

