/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batch.iref;

import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.billmapping.ReportType;
import com.kingdee.eas.csinterface.data.process.IReportBillProcess;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.rpt.batch.iref.IntegrateSchemeHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportBillProcessImpl
implements IReportBillProcess {
    public static final String BTWN_ASSTTYPE_SEPERATOR = ";";
    public static final String BTWN_TYPE_ASSTITEM_SEPERATOR = ":";
    public static final String BTWN_NUM_NAME_SEPERATOR = "_!";
    public static final String REGEX_I = "\\|";
    public static final String SEPERATOR_I = "|";
    private List<Checker> checkers = new ArrayList<Checker>();

    public ReportBillProcessImpl() {
        this.checkers.add(new IsNullChecker(IntegrateSchemeHelper.Fields.fcompanynum.name(), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"31_emptyCompany")));
        this.checkers.add(new IsNullChecker(IntegrateSchemeHelper.Fields.fcurrencynum.name(), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"32_emptyCurrency")));
        this.checkers.add(new IsNullChecker(IntegrateSchemeHelper.Fields.fbizdate.name(), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"33_emptyBizDate")));
        this.checkers.add(new IsNullChecker(IntegrateSchemeHelper.Fields.fdataelement.name(), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"34_getAccItemEmpty")));
        this.checkers.add(new IsNullChecker(IntegrateSchemeHelper.Fields.fvaluetype.name(), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"35_valueEmpty")));
        this.checkers.add(new IsNullChecker(IntegrateSchemeHelper.Fields.faccountnum.name(), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"36_emptySubject")));
        this.checkers.add(new AsstTypeChecker(IntegrateSchemeHelper.Fields.fasst_number.name(), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"37_checkTypeOrNumberError")));
        this.checkers.add(new ValueChecker(IntegrateSchemeHelper.Fields.famount.name(), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"38_emptyAmount"), 1));
        this.checkers.add(new ValueChecker(IntegrateSchemeHelper.Fields.ftxtvalue.name(), EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"39_textValueEmpty"), 2));
    }

    public String[] processAssistField(Context ctx, String assistField) throws Exception {
        if (StringUtils.isEmpty((String)assistField)) {
            return new String[0];
        }
        String[] btwnTypeSplit = StringUtils.split((String)assistField, (String)BTWN_ASSTTYPE_SEPERATOR);
        StringBuffer asstTypeSerial = new StringBuffer();
        boolean hasMoreOne = false;
        ArrayList<String> itemList = new ArrayList<String>();
        for (String item : btwnTypeSplit) {
            String[] btwnItemNum2NameSplit;
            String[] btwnTypeNum2NameSplit;
            String[] btwnType2ItemSplit;
            if (StringUtils.isEmpty((String)item) || (btwnType2ItemSplit = StringUtils.split((String)item, (String)BTWN_TYPE_ASSTITEM_SEPERATOR)) == null || btwnType2ItemSplit.length != 2 || (btwnTypeNum2NameSplit = StringUtils.split((String)btwnType2ItemSplit[0], (String)BTWN_NUM_NAME_SEPERATOR)) == null || btwnTypeNum2NameSplit.length != 2 || (btwnItemNum2NameSplit = StringUtils.split((String)btwnType2ItemSplit[1], (String)BTWN_NUM_NAME_SEPERATOR)) == null || btwnItemNum2NameSplit.length != 2 || StringUtils.isEmpty((String)btwnItemNum2NameSplit[0]) || StringUtils.isEmpty((String)btwnItemNum2NameSplit[1])) continue;
            if (hasMoreOne) {
                asstTypeSerial.append(SEPERATOR_I);
            }
            asstTypeSerial.append(btwnTypeNum2NameSplit[0]).append(BTWN_NUM_NAME_SEPERATOR).append(btwnTypeNum2NameSplit[1]);
            itemList.add(btwnItemNum2NameSplit[0] + BTWN_NUM_NAME_SEPERATOR + btwnItemNum2NameSplit[1]);
            hasMoreOne = true;
        }
        if (hasMoreOne) {
            itemList.add(0, asstTypeSerial.toString());
            return itemList.toArray(new String[0]);
        }
        return new String[]{""};
    }

    public String deleteInvalidReport(Context ctx, CoreBaseInfo info, Map<String, String> propertyMap, ReportType formulaType) throws Exception {
        if (ReportType.iref.equals((Object)formulaType)) {
            if (info == null || info == null) {
                return null;
            }
            StringBuffer messageItem = new StringBuffer();
            int zise = this.checkers.size();
            for (int k = 0; k < zise; ++k) {
                String temp = this.checkers.get(k).check(info, propertyMap);
                if (StringUtils.isEmpty((String)temp)) continue;
                messageItem.append(temp);
            }
            return messageItem.toString();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String[] arr;
        String serial = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)"40_serialString");
        ReportBillProcessImpl process = new ReportBillProcessImpl();
        for (String s : arr = process.processAssistField(null, serial)) {
            System.out.println(s);
        }
        AdjustInfo info = new AdjustInfo();
        info.put("companynum", (Object)"001");
        info.put("currencynum", (Object)"c001");
        info.put("valuetype", (Object)1);
        info.put("fasstnumber", (Object)"aa|bb|cc|dd");
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("fcompanynum", "companynum");
        propMap.put("fcurrencynum", "currencynum");
        propMap.put("fvaluetype", "valuetype");
        propMap.put("famount", "amount");
        propMap.put("ftxtvalue", "txtvalue");
        propMap.put("fasstnumber", "fasstnumber");
        System.out.println(process.deleteInvalidReport(null, (CoreBaseInfo)info, propMap, ReportType.iref));
    }

    public String deleteInvalidReport(Context ctx, CoreBaseCollection coll, Map<String, String> propertyMap) throws Exception {
        return null;
    }

    class ValueChecker
    extends Checker {
        int _valueType;

        ValueChecker(String key, String tips, int valueType) {
            super(key, tips);
            this._valueType = valueType;
        }

        @Override
        String check(CoreBaseInfo info, Map<String, String> propertyMap) {
            if (info.get(propertyMap.get(IntegrateSchemeHelper.Fields.fvaluetype.name())) == null) {
                return null;
            }
            int valueType = 1;
            if (info.get(propertyMap.get(IntegrateSchemeHelper.Fields.fvaluetype.name())) instanceof Integer) {
                valueType = (Integer)info.get(propertyMap.get(IntegrateSchemeHelper.Fields.fvaluetype.name()));
            } else if (info.get(propertyMap.get(IntegrateSchemeHelper.Fields.fvaluetype.name())) instanceof String) {
                valueType = Integer.parseInt((String)info.get(propertyMap.get(IntegrateSchemeHelper.Fields.fvaluetype.name())));
            }
            if (valueType == 1 && this._valueType == valueType ? info.get(propertyMap.get(IntegrateSchemeHelper.Fields.famount.name())) == null : valueType == 2 && this._valueType == valueType && info.get(propertyMap.get(IntegrateSchemeHelper.Fields.ftxtvalue.name())) == null) {
                return this.returnExceptionTips();
            }
            return null;
        }
    }

    class AsstTypeChecker
    extends Checker {
        AsstTypeChecker(String key, String tips) {
            super(key, tips);
        }

        @Override
        String check(CoreBaseInfo info, Map<String, String> propertyMap) {
            if (propertyMap.get(this.key) == null || info.get(propertyMap.get(this.key)) == null) {
                return "";
            }
            String asstTypeSerial = (String)info.get(propertyMap.get(this.key));
            String[] typeSplit = StringUtils.split((String)asstTypeSerial, (String)ReportBillProcessImpl.SEPERATOR_I);
            String fieldName = "fasst";
            int index = 1;
            for (int i = 0; i < typeSplit.length; ++i) {
                String tempKey = fieldName + index + "_number";
                if (StringUtils.isEmpty((String)((String)info.get(propertyMap.get(tempKey))))) {
                    return this.returnExceptionTips();
                }
                ++index;
            }
            return "";
        }
    }

    class IsNullChecker
    extends Checker {
        IsNullChecker(String key, String tips) {
            super(key, tips);
        }

        @Override
        String check(CoreBaseInfo info, Map<String, String> propertyMap) {
            if (propertyMap.get(this.key) == null || info.get(propertyMap.get(this.key)) == null) {
                return this.returnExceptionTips();
            }
            return "";
        }
    }

    abstract class Checker {
        String key;
        String tips;

        Checker(String key, String tips) {
            this.key = key;
            this.tips = tips;
        }

        String returnExceptionTips() {
            return this.tips;
        }

        abstract String check(CoreBaseInfo var1, Map<String, String> var2);
    }
}

