/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batchquery;

import com.kingdee.eas.fi.rpt.batchquery.DefaultKeyGenerater;
import com.kingdee.eas.fi.rpt.batchquery.IKeyGenerater;
import com.kingdee.eas.fi.rpt.batchquery.IObjectBulider;
import com.kingdee.eas.fi.rpt.batchquery.IQueryObject;
import com.kingdee.eas.fi.rpt.batchquery.QueryManager;
import com.kingdee.eas.fi.rpt.batchquery.ResultHouderManager;
import com.kingdee.eas.fi.rpt.batchquery.SysConfig;
import com.kingdee.eas.fi.rpt.batchquery.sql.SQL;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItems;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class Solution {
    QueryManager queryManager = null;
    protected SQL sql = null;
    protected ResultHouderManager rm = null;

    public Solution(Connection _conn) {
        this.queryManager = new QueryManager(_conn);
        this.sql = this.queryManager.getQueryParameterManager().getSQL();
        this.rm = this.queryManager.getExportResultManager().getResultHouderManager();
    }

    private void config() throws Exception {
        this.queryManager.getSysContext().put("IdentifyItemIsNeedGroupBy", new Boolean(this.configAutoItemIsNeedGroupBy()));
        String fromPart = this.configFromPart();
        if (fromPart == null) {
            throw new Exception("Config Error : From Part SQL is null");
        }
        this.sql.getFromPartSql().setFromPartSql(fromPart);
        this.sql.getWherePart().setStaticWhereItems(this.configStaticWherePart());
        this.queryManager.getExportResultManager().setDefaultObjectBulider(this.configDefaultObjectBuilder());
        IKeyGenerater kg = this.configKeyGenerater();
        if (kg == null) {
            throw new Exception("Config Error :KeyGenerater is Null ");
        }
        this.queryManager.getExportResultManager().setKeyGenerater(kg);
        this.queryManager.getSysContext().put("isAllQueryQbjectSomeFields", new Boolean(this.configIsAllQueryObjectSelectFieldsIsSame()));
        this.queryManager.getSysContext().put("isParamMode", new Boolean(this.configIsSysParamMode()));
    }

    public abstract WhereItems configStaticWherePart();

    public boolean configIsAllQueryObjectSelectFieldsIsSame() {
        return false;
    }

    public boolean configIsSysParamMode() {
        return SysConfig.isRunInParamMode;
    }

    public abstract String configFromPart();

    public abstract boolean configAutoItemIsNeedGroupBy();

    public IKeyGenerater configKeyGenerater() {
        return new DefaultKeyGenerater(null);
    }

    public IObjectBulider configDefaultObjectBuilder() {
        return null;
    }

    public void configQueryObjectToSolution(IQueryObject queryObject) throws Exception {
        queryObject._configSelectFields(this.sql.getSelectPart());
        queryObject._configGroupByFields(this.sql.getGroupByPart());
        String[] keys = queryObject.configDefaultKeys();
        if (keys == null) {
            queryObject._configWhereItems(this.rm, this.sql.getWherePart());
        } else {
            queryObject._configWhereItems(keys, this.rm, this.sql.getWherePart());
        }
    }

    public void exec() throws SQLException, Exception {
        this.beforeExec();
        this.config();
        if (!this.rm.getResultHoudlers().isEmpty()) {
            this.queryManager.exec();
        }
        this.afterExec();
    }

    public void beforeExec() throws SQLException, Exception {
    }

    public void afterExec() throws SQLException, Exception {
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }
}

