/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.batchquery.sql;

import com.kingdee.eas.fi.rpt.batchquery.sql.IWhereItemSQLGenerater;
import com.kingdee.eas.fi.rpt.batchquery.sql.WhereItem;
import java.util.HashMap;
import java.util.List;

public class StaticWhereItemSQLGenerater
extends IWhereItemSQLGenerater {
    public StaticWhereItemSQLGenerater(HashMap _sysContext) {
        super(_sysContext);
    }

    @Override
    public String getParamedSql(WhereItem whereItem) {
        return this.getSql(whereItem, true);
    }

    @Override
    public String getSqlString(WhereItem whereItem) {
        return this.getSql(whereItem, false);
    }

    private String getSql(WhereItem whereItem, boolean isParamMode) {
        String sql = null;
        if (!whereItem.hasLikeOperator()) {
            sql = (String)whereItem.getContext().get(isParamMode ? "Static_Paremed_SQL" : "Static_Simple_SQL");
            if (sql == null) {
                sql = this.generateSQL(whereItem, isParamMode);
                whereItem.getContext().put(isParamMode ? "Static_Paremed_SQL" : "Static_Simple_SQL", sql);
            }
        } else {
            sql = (String)whereItem.getContext().get("Static_Like_SQL");
            if (sql == null) {
                sql = "(charindex('" + whereItem.getRightOperator() + "'," + whereItem.getLeftOperator() + ")=1)";
                whereItem.getContext().put("Static_Like_SQL", sql);
            }
        }
        return sql;
    }

    private String generateSQL(WhereItem whereItem, boolean isParamMode) {
        if (whereItem.isStaticItem()) {
            return whereItem.getStaticItemString();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        if (whereItem.isLeftOPUPMode()) {
            buf.append("UPPER(");
        }
        buf.append(whereItem.getLeftOperator());
        if (whereItem.isLeftOPUPMode()) {
            buf.append(")");
        }
        buf.append(" ");
        this.appendOperator(whereItem, buf);
        if (whereItem.getOperator() == 6) {
            buf.append('(');
        }
        buf.append(" ");
        if (!isParamMode || !whereItem.getIsSupportParamerModeState()) {
            if (whereItem.getRightOperator() instanceof Integer) {
                if (whereItem.getOperator() == 6) {
                    List rightOperator = whereItem.getRightINOperator();
                    for (int i = 0; i < rightOperator.size(); ++i) {
                        if (i != 0) {
                            buf.append(',');
                        }
                        buf.append(rightOperator.get(i));
                    }
                } else {
                    buf.append(whereItem.getRightOperator());
                }
            } else if (whereItem.getOperator() == 6) {
                List rightOperator = whereItem.getRightINOperator();
                for (int i = 0; i < rightOperator.size(); ++i) {
                    if (i != 0) {
                        buf.append(',');
                    }
                    buf.append('\'').append(rightOperator.get(i)).append('\'');
                }
            } else {
                buf.append("'" + whereItem.getRightOperator() + "'");
            }
        } else if (whereItem.getOperator() == 6) {
            List rightOperator = whereItem.getRightINOperator();
            for (int i = 0; i < rightOperator.size(); ++i) {
                if (i != 0) {
                    buf.append(',');
                }
                buf.append('?');
            }
        } else {
            buf.append("?");
        }
        if (whereItem.getOperator() == 6) {
            buf.append(")");
        }
        buf.append(")");
        return buf.toString();
    }

    private void appendOperator(WhereItem whereItem, StringBuffer buf) {
        switch (whereItem.getOperator()) {
            case 0: {
                buf.append("=");
                break;
            }
            case 1: {
                buf.append("like");
                break;
            }
            case 2: {
                buf.append(">");
                break;
            }
            case 3: {
                buf.append("<");
                break;
            }
            case 4: {
                buf.append(">=");
                break;
            }
            case 5: {
                buf.append("<=");
                break;
            }
            case 6: {
                buf.append("in");
            }
        }
    }

    @Override
    public int size(WhereItem whereItem) throws Exception {
        if (whereItem.isStaticItem()) {
            return whereItem.getStaticItemString().length() + 20;
        }
        if (!whereItem.hasLikeOperator()) {
            return whereItem.getLeftOperator().length() + whereItem.getRightINOperator().toString().length() + 20;
        }
        return whereItem.getSqlString().length();
    }
}

