/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.check;

import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedColumnArray;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.check.CheckExpressionParser;
import com.kingdee.eas.fi.rpt.check.ReportCheck;
import com.kingdee.eas.fi.rpt.excelformula.ParseException;
import java.util.BitSet;
import java.util.List;

public class CheckExrepssionIterator {
    private CheckExpressionParser parser = null;
    private final RptCheckExpression originalExpression;
    private String _line;
    private int _pos;
    private int _end;
    BitSet states = null;

    public CheckExrepssionIterator(Sheet sheet, RptCheckExpression expression) throws ParseException {
        this.originalExpression = expression;
        this.parser = new CheckExpressionParser(this.originalExpression.getContent());
        this._line = this.originalExpression.getContent();
        this.parser.parse();
        if (this.parser.getType() == 1) {
            this._end = ReportCheck.getRealMaxCol(sheet);
        } else if (this.parser.getType() == 2) {
            this._end = ReportCheck.getRealMaxRow(sheet);
        }
        this.initStates(sheet);
        this.cutCondition();
    }

    private void cutCondition() {
        String content = this.originalExpression.getContent();
        StringBuffer ws = new StringBuffer();
        if (this.parser.condition == null) {
            return;
        }
        ws.append(content.substring(0, this.parser.condition.start));
        for (int i = this.parser.condition.start; i < this.parser.condition.end; ++i) {
            ws.append(' ');
        }
        ws.append(content.substring(this.parser.condition.end));
        this.originalExpression.setContent(ws.toString());
    }

    private void initStates(Sheet sheet) {
        if (this._end <= 0) {
            return;
        }
        this.states = new BitSet(this._end);
        if (this.parser.tokens.size() < 1) {
            return;
        }
        if (this.parser.condition == null || this.parser.condition.isEmpty()) {
            this.initNoneIncludeStates(sheet);
            return;
        }
        List include = this.parser.condition.includeRange;
        if (include.size() < 1) {
            this.initNoneIncludeStates(sheet);
        }
        for (int i = 0; i < include.size(); ++i) {
            CheckExpressionParser.RangeExpr r = (CheckExpressionParser.RangeExpr)include.get(i);
            int start = r.startRange.index;
            int end = r.endRange.index + 1;
            if (start > end) {
                int t = start;
                start = end;
                end = t;
            }
            if (end > this._end) {
                end = this._end;
            }
            this.states.set(start, end);
        }
        List exclude = this.parser.condition.excludeRange;
        for (int i = 0; i < exclude.size(); ++i) {
            CheckExpressionParser.RangeExpr r = (CheckExpressionParser.RangeExpr)exclude.get(i);
            if (r.startRange == null || r.endRange == null) continue;
            int start = r.startRange.index;
            int end = r.endRange.index + 1;
            if (start > end) {
                int t = start;
                start = end;
                end = t;
            }
            if (end > this._end) {
                end = this._end;
            }
            this.states.clear(start, end);
        }
    }

    private void initNoneIncludeStates(Sheet sheet) {
        block3: {
            block2: {
                int col;
                if (this.parser.getType() != 1) break block2;
                SortedColumnArray cols = sheet.getCols();
                for (int i = 0; i < cols.size() && (col = cols.getAt(i).getCol()) <= ReportCheck.getRealMaxCol(sheet); ++i) {
                    this.states.set(col);
                }
                break block3;
            }
            if (this.parser.getType() != 2) break block3;
            Sheet.RowsIterator rt = sheet.getRowsIterator(0, ReportCheck.getRealMaxRow(sheet), false);
            while (rt.hasNext()) {
                Row row = rt.next();
                this.states.set(row.getRow());
            }
        }
    }

    public boolean hasNext() {
        if (this._pos > this._end) {
            return false;
        }
        if (this.parser.tokens.size() < 1) {
            this._pos = this._end + 1;
            return true;
        }
        for (int i = this._pos; i < this._end; ++i) {
            if (!this.states.get(i)) continue;
            this._pos = i;
            return true;
        }
        return false;
    }

    public RptCheckExpression next() {
        if (this.parser.tokens.size() < 1) {
            this._pos = this._end + 1;
            return this.originalExpression;
        }
        if (this._pos > this._end) {
            return null;
        }
        for (int i = this._pos; i < this._end; ++i) {
            if (!this.states.get(i)) continue;
            RptCheckExpression me = new RptCheckExpression();
            me.copyFrom(this.originalExpression);
            String content = me.getContent();
            String line = "";
            int lastIdx = 0;
            for (int x = 0; x < this.parser.tokens.size(); ++x) {
                CheckExpressionParser.SiteExpr site = (CheckExpressionParser.SiteExpr)this.parser.tokens.get(x);
                String cell = null;
                if (this.parser.getType() == 1) {
                    cell = TableToolkit.xy2range(i, site.index);
                } else if (this.parser.getType() == 2) {
                    cell = TableToolkit.xy2range(site.index, i);
                }
                line = line + content.substring(lastIdx, site.start) + cell;
                lastIdx = site.end;
            }
            line = line + content.substring(lastIdx);
            me.setContent(line.trim());
            ++this._pos;
            return me;
        }
        ++this._pos;
        return null;
    }

    public static void main(String[] args) throws ParserException {
    }
}

