/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import org.apache.log4j.Logger;

public class AccountSelectForOnlyACT
extends AccountPromptBox {
    private static final Logger log = Logger.getLogger((String)AccountSelectForOnlyACT.class.getName());
    protected IUIWindow acctItemSelectorUI;
    FormulaWizardUI formulaWizardUI = null;
    String paramName = null;
    private KDBizPromptBox cp = null;

    public Object getData() {
        Object o = super.getData();
        return o;
    }

    public FormulaWizardUI getFormulaWizardUI() {
        return this.formulaWizardUI;
    }

    public void setFormulaWizardUI(FormulaWizardUI wizardUI) {
        this.formulaWizardUI = wizardUI;
    }

    public void show() {
        this.setCompanyInfo(this.getCompany());
        if (this.getCompanyInfo() != null) {
            this.tableInfo = this.getCompanyInfo().getAccountTable();
        }
        super.show();
    }

    private CompanyOrgUnitInfo getCompany() {
        CompanyOrgUnitInfo company = null;
        String companyNumber = this.formulaWizardUI.getParam("orgnumber");
        if (companyNumber != null && companyNumber.indexOf(";") > 0) {
            companyNumber = companyNumber.substring(0, companyNumber.indexOf(";")).trim();
        }
        if (companyNumber == null || companyNumber.trim().length() == 0) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        } else {
            try {
                OrgType rptOrgType = this.formulaWizardUI.getRptOrgType();
                company = OrgType.Company.equals((Object)rptOrgType) ? RptUtilForClient.getCompanyOrgUnitInfoByNumber(companyNumber) : RptNewUIUtil.getDelegateCompanyByNumber(null, (OrgType)rptOrgType, (String)companyNumber, null);
                if (company == null) {
                    MsgBox.showWarning((String)RptUtil.getResourceSince51("CompanyNoExists"));
                    SysUtil.abort();
                }
            }
            catch (Exception e) {
                company = SysContext.getSysContext().getCurrentFIUnit();
            }
        }
        return company;
    }

    private void testTable() {
        CompanyOrgUnitInfo company = null;
        String companyNumber = this.formulaWizardUI.getParam("orgnumber");
        if (companyNumber != null && companyNumber.indexOf(";") > 0) {
            companyNumber = companyNumber.substring(0, companyNumber.indexOf(";")).trim();
        }
        if (companyNumber == null || companyNumber.trim().length() == 0) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        } else {
            try {
                company = RptUtilForClient.getCompanyOrgUnitInfoByNumber(companyNumber);
                if (company == null) {
                    MsgBox.showWarning((String)RptUtil.getResourceSince51("CompanyNoExists"));
                    SysUtil.abort();
                }
            }
            catch (Exception e) {
                company = SysContext.getSysContext().getCurrentFIUnit();
            }
        }
        try {
            AccountTableCollection acctTables = AccountTools.getAllAccountTableByCompany(null, (CompanyOrgUnitInfo)company);
            if (acctTables.size() > 1) {
                MsgBox.showWarning((String)RptUtil.getResourceSince51("ThisCompanyExistsMultiAccountTable"));
                SysUtil.abort();
            }
        }
        catch (BOSException e) {
            log.debug((Object)e.getMessage());
        }
    }
}

