/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.RptClientUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGDCondition;
import com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGDUI;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.FormulaStructure;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JViewport;

public class AcctAcFormulaStructure
extends FormulaStructure {
    String company;
    String opCompany;
    String startAccount;
    String endAccount;
    HashMap items;
    ArrayList list = new ArrayList();
    int startYear;
    int endYear;
    int startFiscal;
    int endFiscal;
    String currencyId;
    String currencyName;
    String computetype;
    int levelStart = 1;
    int levelEnd = 1;
    boolean isOnlyUnion = false;
    CurrencyInfo currencyInfo = null;

    public AcctAcFormulaStructure(String formula) {
        super(formula);
    }

    public AcctAcFormulaStructure(FormulaHint hint) {
        super(hint);
    }

    @Override
    public void structure() throws Exception {
        String tempcurrency;
        if (this.parameter == null || this.parameter.isEmpty() || this.parameter.size() != 9) {
            MsgBox.showError((String)RptUtil.getReportResource("RPT_LEDGER_ERROR"));
            SysUtil.abort();
        }
        this.company = (String)this.parameter.get(0);
        if (this.company != null && this.company.trim().length() > 0) {
            this.companyOrg = RptUtilForClient.getCompanyOrgUnitInfoByNumber(this.company);
            if (this.companyOrg == null) {
                if (TableToolkit.isCellRef(this.company)) {
                    MsgBox.showError((String)RptUtil.getReportResource("RPT_NOSUPPORT_LEDGE"));
                } else {
                    MsgBox.showError((String)RptUtil.getResourceSince51("NoExistsCompany"));
                }
                SysUtil.abort();
            }
            this.company = this.companyOrg.getId().toString();
            this.isOnlyUnion = this.companyOrg.isIsOnlyUnion();
        } else {
            this.companyOrg = RptUtilForClient.getCompanyOrgUnitInfoByNumber(this.report.getCompany().getNumber());
            this.company = this.companyOrg.getId().toString();
            this.isOnlyUnion = this.companyOrg.isIsOnlyUnion();
        }
        this.opCompany = (String)this.parameter.get(1);
        String accountAndItem = (String)this.parameter.get(2);
        this.parseAccountItem(accountAndItem);
        this.computetype = (String)this.parameter.get(3);
        String temp = (String)this.parameter.get(4);
        try {
            this.startYear = Integer.parseInt(temp);
        }
        catch (Exception e) {
            this.startYear = 0;
        }
        if (this.startYear <= 0) {
            this.startYear = this.rptSheetParam.getStartYear() == 0 ? this.report.getYear() + this.startYear : this.rptSheetParam.getStartYear() + this.startYear;
        }
        String temp2 = (String)this.parameter.get(5);
        try {
            this.startFiscal = Integer.parseInt(temp2);
        }
        catch (Exception e) {
            this.startFiscal = 0;
        }
        if (this.startFiscal <= 0) {
            this.startFiscal = this.rptSheetParam.getStartPeriod() == 0 ? this.report.getPeriod() + this.startFiscal : this.rptSheetParam.getStartPeriod() + this.startFiscal;
            Date periodLastDate = RPTDateUtil.getPeriodFirstDate((int)this.startYear, (int)this.startFiscal, (RptPeriodTypeEnum)this.report.getPeriodType());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(periodLastDate);
            this.startYear = calendar.get(1);
            this.startFiscal = calendar.get(2) + 1;
        }
        if (this.startFiscal <= 0) {
            --this.startYear;
            this.startFiscal += PeriodUtils.getMaxPeriodNumber(null, (int)this.startYear, (String)this.report.getCompany().getId().toString());
        }
        String temp3 = (String)this.parameter.get(6);
        try {
            this.endYear = Integer.parseInt(temp3);
        }
        catch (Exception e) {
            this.endYear = 0;
        }
        if (this.endYear <= 0) {
            this.endYear = this.rptSheetParam.getEndYear() == 0 ? this.report.getYear() + this.endYear : this.rptSheetParam.getEndYear() + this.endYear;
        }
        String temp4 = (String)this.parameter.get(7);
        try {
            this.endFiscal = Integer.parseInt(temp4);
        }
        catch (Exception e) {
            this.endFiscal = 0;
        }
        if (this.endFiscal <= 0) {
            int[] end;
            if (this.rptSheetParam.getEndPeriod() == 0) {
                end = RPTDateUtil.getRptYearAndPeriod((int)this.endYear, (int)this.report.getPeriod(), (int)this.report.getPeriodType().getValue(), (int)0, (int)this.endFiscal);
                this.endYear = end[0];
                this.endFiscal = end[1];
            } else if (this.rptSheetParam.getEndPeriod() + this.endFiscal <= 0) {
                end = RPTDateUtil.getRptYearAndPeriod((int)this.endYear, (int)this.report.getPeriod(), (int)this.report.getPeriodType().getValue(), (int)0, (int)(this.rptSheetParam.getEndPeriod() + this.endFiscal));
                this.endYear = end[0];
                this.endFiscal = end[1];
            } else {
                this.endFiscal = this.rptSheetParam.getEndPeriod() + this.endFiscal;
            }
            Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)this.endYear, (int)this.endFiscal, (RptPeriodTypeEnum)this.report.getPeriodType());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(periodLastDate);
            this.endYear = calendar.get(1);
            this.endFiscal = calendar.get(2) + 1;
        }
        if (this.endFiscal <= 0) {
            --this.endYear;
            this.endFiscal += PeriodUtils.getMaxPeriodNumber(null, (int)this.startYear, (String)this.report.getCompany().getId().toString());
        }
        this.currencyInfo = (tempcurrency = (String)this.parameter.get(8)) == null || tempcurrency.trim().length() == 0 ? (this.rptSheetParam.getCurrency() != null ? this.rptSheetParam.getCurrency() : this.report.getCurrency()) : RptUtilForClient.getCurrency(tempcurrency.toUpperCase());
        if (this.currencyInfo == null) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("CurrencyOutOfPlace"));
            SysUtil.abort();
        }
        this.currencyId = this.currencyInfo.getId().toString();
        this.currencyName = this.currencyInfo.getName();
    }

    public boolean check() {
        if (this.isOnlyUnion) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("VirtualOrgCannotAssn"));
            return false;
        }
        return true;
    }

    public void parseAccountItem(String accountAndItem) {
        StringTokenizer accountandItemToken = new StringTokenizer(accountAndItem, "|");
        if (accountandItemToken.hasMoreElements()) {
            String account = accountandItemToken.nextToken();
            String[] subAccount = StringUtil.split((String)account, (String)":");
            if (subAccount.length == 2) {
                this.startAccount = subAccount[0];
                this.endAccount = subAccount[1];
                int start = StringUtil.split((String)this.startAccount, (String)".").length;
                int end = StringUtil.split((String)this.endAccount, (String)".").length;
                this.levelEnd = Math.max(start, end);
            } else {
                this.startAccount = account;
                this.endAccount = account;
                if (this.startAccount != null && this.startAccount.length() > 0) {
                    this.levelEnd = StringUtil.split((String)this.startAccount, (String)".").length;
                }
            }
        }
        while (accountandItemToken.hasMoreElements()) {
            String temptype = null;
            String temptypeItem = null;
            if (this.items == null) {
                this.items = new HashMap();
            }
            temptype = accountandItemToken.nextToken();
            if (accountandItemToken.hasMoreElements()) {
                temptypeItem = accountandItemToken.nextToken();
            }
            this.items.put(temptype, temptypeItem);
        }
    }

    public boolean checkIsMuliAcctount() throws Exception {
        AccountTableCollection acctTables;
        if (this.isOnlyUnion && (acctTables = AccountTools.getAllAccountTableByCU(null, (CtrlUnitInfo)this.companyOrg.getCU())).size() > 1) {
            MsgBox.showWarning((String)RptUtil.getResourceSince51("ThisCompanyExistsMultiAccountTable"));
            return false;
        }
        return true;
    }

    @Override
    public void openUI() throws Exception {
        if (this.opCompany == null || this.opCompany.trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"77_AcctAcFormulaStructure"));
            return;
        }
        if (this.companyOrg.getAccountTable() == null) {
            throw new AccountException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE);
        }
        String currentAcctTable = AccountTools.getCurrentAcctTable(null, (String)this.companyOrg.getCU().getId().toString(), (String)this.companyOrg.getAccountTable().getId().toString(), (int)this.endYear, (int)this.endFiscal);
        this.companyOrg.getAccountTable().setId(BOSUuid.read((String)currentAcctTable));
        this.companyOrg.setBaseCurrency(this.currencyInfo);
        this.companyOrg.setReportCurrency(this.currencyInfo);
        List actList = RptClientUtil.queryAsstAct(null, (String)this.companyOrg.getCU().getId().toString());
        if (this.items == null || this.items.keySet().size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"78_AcctAcFormulaStructure"));
            return;
        }
        Iterator it = this.items.keySet().iterator();
        block0: while (it.hasNext()) {
            String number = it.next().toString();
            int size = actList.size();
            for (int j = 0; j < size; ++j) {
                AsstactTypeEntity at = (AsstactTypeEntity)actList.get(j);
                if (!at.getNumber().equals(number)) continue;
                at.setSelectedLevel(at.getMaxLevel());
                at.setSelected(true);
                at.setFrom(null);
                at.setTo(null);
                if (this.opCompany != null && this.opCompany.trim().length() > 0) {
                    CoreBaseCollection c;
                    EntityViewInfo view;
                    if (at.getTableName().equalsIgnoreCase("t_bd_customer")) {
                        view = new EntityViewInfo();
                        view.getSelector().add(new SelectorItemInfo("*"));
                        view.getSelector().add(new SelectorItemInfo("internalCompany.*"));
                        view.setFilter(new FilterInfo());
                        view.getFilter().getFilterItems().add(new FilterItemInfo("internalCompany.number", (Object)this.opCompany));
                        c = CustomerFactory.getRemoteInstance().getCollection(view);
                        if (c != null && c.size() > 0) {
                            at.setFrom((Object)c.get(0));
                            at.setTo((Object)c.get(0));
                        }
                    } else if (at.getTableName().equalsIgnoreCase("t_bd_supplier")) {
                        view = new EntityViewInfo();
                        view.getSelector().add(new SelectorItemInfo("*"));
                        view.getSelector().add(new SelectorItemInfo("internalCompany.*"));
                        view.setFilter(new FilterInfo());
                        view.getFilter().getFilterItems().add(new FilterItemInfo("internalCompany.number", (Object)this.opCompany));
                        c = SupplierFactory.getRemoteInstance().getCollection(view);
                        if (c != null && c.size() > 0) {
                            at.setFrom((Object)c.get(0));
                            at.setTo((Object)c.get(0));
                        }
                    } else if (at.getTableName().equalsIgnoreCase("t_org_company")) {
                        view = new EntityViewInfo();
                        view.getSelector().add(new SelectorItemInfo("*"));
                        view.setFilter(new FilterInfo());
                        view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)this.opCompany));
                        c = CompanyOrgUnitFactory.getRemoteInstance().getCollection(view);
                        if (c != null && c.size() > 0) {
                            at.setFrom((Object)c.get(0));
                            at.setTo((Object)c.get(0));
                        }
                    }
                }
                this.list.add(at);
                continue block0;
            }
        }
        ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getCompany()));
        CompanyOrgUnitInfo company = icompany.getCompanyOrgUnitInfo((IObjectPK)pk);
        if (this.type.equals("1")) {
            if (!this.checkIsMuliAcctount()) {
                this.ledgerSuccess = false;
                return;
            }
            AccountViewInfo fromv = null;
            AccountViewInfo tov = null;
            EntityViewInfo ev = new EntityViewInfo();
            ev.getSelector().add(new SelectorItemInfo("*"));
            ev.setFilter(new FilterInfo());
            ev.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)this.getStartAccount()));
            AccountViewCollection c = AccountViewFactory.getRemoteInstance().getAccountViewCollection(ev);
            if (c.size() > 0) {
                fromv = c.get(0);
            }
            ev = new EntityViewInfo();
            ev.getSelector().add(new SelectorItemInfo("*"));
            ev.setFilter(new FilterInfo());
            ev.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)this.getEndAccount()));
            c = AccountViewFactory.getRemoteInstance().getAccountViewCollection(ev);
            if (c.size() > 0) {
                tov = c.get(0);
            }
            int level = AcctAcFormulaStructure.getAccuntViewLevel(this.getStartAccount(), this.getCompany(), this.companyOrg.getAccountTable().getId().toString());
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("jebAccountFrom", fromv);
            condition.put("jebAccountTo", tov);
            condition.put("jspLevelFrom", new Integer(level));
            condition.put("jspLevelTo", new Integer(level));
            condition.put("jspYearFrom", new Integer(this.getStartYear()));
            condition.put("jspYearTo", new Integer(this.getEndYear()));
            condition.put("jspPeriodFrom", new Integer(this.getStartFiscal()));
            condition.put("jspPeriodTo", new Integer(this.getEndFiscal()));
            condition.put("jbxCurrency", this.currencyInfo);
            condition.put("jcbIncludeUnPost", new Boolean(this.rptSheetParam.isIsIncludingUnposted()));
            condition.put("tableData", this.list);
            condition.put("company", company);
            this.uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
            this.uiContext.put((Object)"JoinQuery_Outer_Params_condition", condition);
            IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGGUI", (Map)this.uiContext, null);
            ui.show();
        } else if (this.type.equals("2")) {
            if (!this.check()) {
                this.ledgerSuccess = false;
                return;
            }
            String accountAndItem = (String)this.parameter.get(2);
            String acount = accountAndItem.split("\\|")[0];
            this.getAccountIds(company.getId().toString(), this.companyOrg.getAccountTable().getId().toString(), acount);
            GLRptAsstactGDCondition cond = new GLRptAsstactGDCondition();
            cond.setPeriodYearStart(this.getStartYear());
            cond.setPeriodYearEnd(this.getEndYear());
            cond.setPeriodNumberStart(this.getStartFiscal());
            cond.setPeriodNumberEnd(this.getEndFiscal());
            cond.setCurrencyID(this.getCurrencyId());
            cond.setCompany(this.companyOrg);
            cond.setCompanyId(this.getCompany());
            cond.setCurrencyName(this.getCurrencyName());
            cond.setAccountLevelStart(this.startLevel);
            cond.setAccountLevelEnd(this.endLevel);
            cond.setOptionPosting(this.rptSheetParam.isIsIncludingUnposted());
            cond.setAccountIdSet(this.accountIdSet);
            cond.setAsstActList((List)this.list);
            cond.setAccountTableId(currentAcctTable);
            cond.setOptionAmountAndBalZero(true);
            if (this.accountIdSet != null && this.accountIdSet.size() == 1 && !StringUtils.isEmpty((String)this.accountNumber)) {
                cond.setAccountCodeStart(this.accountNumber);
                cond.setAccountCodeEnd(this.accountNumber);
                cond.setAccountIdSet(null);
            }
            this.uiContext.put((Object)"JoinQuery", (Object)Boolean.TRUE);
            this.uiContext.put((Object)"com.kingdee.eas.framework.report.client.CommRptBaseUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)cond);
            Object jViewport = this.getUIContext().get((Object)"Viewport");
            if (jViewport != null) {
                GLRptAsstactGDUI acctDetailUI = new GLRptAsstactGDUI();
                acctDetailUI.getUIContext().putAll(this.uiContext);
                acctDetailUI.initLayout();
                acctDetailUI.onLoad();
                acctDetailUI.onShow();
                ((JViewport)jViewport).add((Component)acctDetailUI, null);
            } else {
                IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create("com.kingdee.eas.fi.gl.rpt.client.GLRptAsstactGDUI", (Map)this.uiContext, null);
                ui.show();
            }
        }
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String getCurrencyName() {
        return this.currencyName;
    }

    public void setCurrencyName(String currencyName) {
        this.currencyName = currencyName;
    }

    public String getEndAccount() {
        return this.endAccount;
    }

    public void setEndAccount(String endAccount) {
        this.endAccount = endAccount;
    }

    public int getEndFiscal() {
        return this.endFiscal;
    }

    public void setEndFiscal(int endFiscal) {
        this.endFiscal = endFiscal;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public HashMap getItems() {
        return this.items;
    }

    public void setItems(HashMap items) {
        this.items = items;
    }

    public String getStartAccount() {
        return this.startAccount;
    }

    public void setStartAccount(String startAccount) {
        this.startAccount = startAccount;
    }

    public int getStartFiscal() {
        return this.startFiscal;
    }

    public void setStartFiscal(int startFiscal) {
        this.startFiscal = startFiscal;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public String getComputetype() {
        return this.computetype;
    }

    public void setComputetype(String computetype) {
        this.computetype = computetype;
    }

    public int getLevelEnd() {
        return this.levelEnd;
    }

    public void setLevelEnd(int levelEnd) {
        this.levelEnd = levelEnd;
    }

    public int getLevelStart() {
        return this.levelStart;
    }

    public void setLevelStart(int levelStart) {
        this.levelStart = levelStart;
    }

    public static int getAccuntViewLevel(String accountNumber, String companyId, String accountTableId) throws SQLException, EASBizException, BOSException {
        String sql = "select FLevel from T_BD_AccountView where FCompanyID=? and FAccountTableID=? and FNumber=?";
        SqlParams sp = new SqlParams().setString(1, companyId).setString(2, accountTableId).setString(3, accountNumber);
        RptRowSet rst = CommRptBaseFactory.getRemoteInstance().executeQuery(sql, sp, 0, -1);
        if (rst.next()) {
            return rst.getInt(0);
        }
        throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("Account") + accountNumber + " " + RptUtil.getResourceSince51("NoExists")});
    }

    public String getOpCompany() {
        return this.opCompany;
    }

    public void setOpCompany(String opCompany) {
        this.opCompany = opCompany;
    }
}

