/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.client.AcctItemSelectorUI;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class AcctItemSelector
extends JDialog
implements KDPromptSelector {
    private static final Logger log = Logger.getLogger((String)AcctItemSelector.class.getName());
    protected IUIWindow acctItemSelectorUI;
    protected boolean isCanceled = false;
    FormulaWizardUI formulaWizardUI = null;
    CompanyOrgUnitInfo company = null;
    String paramName = null;

    @Override
    public void show() {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this.formulaWizardUI);
        IUIFactory uiFactory = null;
        uiContext.put((Object)"ID", null);
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            this.acctItemSelectorUI = uiFactory.create("com.kingdee.eas.fi.rpt.client.AcctItemSelectorUI", (Map)uiContext, null, OprtState.VIEW);
            CompanyOrgUnitCollection companyOrgUnitCollection = this.getFICompany();
            KDBizPromptBox accountTablePromptBox = (KDBizPromptBox)this.formulaWizardUI.getParamComponent("accountTable");
            AccountTableInfo accountTable = null;
            if (accountTablePromptBox != null && accountTablePromptBox.getData() instanceof AccountTableInfo) {
                accountTable = (AccountTableInfo)accountTablePromptBox.getData();
            } else if (accountTablePromptBox != null && accountTablePromptBox.getData() instanceof String) {
                String accountNum = (String)accountTablePromptBox.getData();
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                viewInfo.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountNum));
                AccountTableCollection accountTableCollection = AccountTableFactory.getRemoteInstance().getAccountTableCollection(viewInfo);
                accountTable = !accountTableCollection.isEmpty() ? accountTableCollection.get(0) : this.company.getAccountTable();
            }
            AcctItemSelectorUI chooser = (AcctItemSelectorUI)this.acctItemSelectorUI.getUIObject();
            if (accountTable != null) {
                chooser.f7StartAccount.setSelector((KDPromptSelector)new AccountPromptBox(this.acctItemSelectorUI.getUIObject(), accountTable));
                chooser.f7EndAccount.setSelector((KDPromptSelector)new AccountPromptBox(this.acctItemSelectorUI.getUIObject(), accountTable));
            } else {
                chooser.f7StartAccount.setSelector((KDPromptSelector)new AccountPromptBox(this.acctItemSelectorUI.getUIObject(), this.company));
                chooser.f7EndAccount.setSelector((KDPromptSelector)new AccountPromptBox(this.acctItemSelectorUI.getUIObject(), this.company));
            }
            chooser.setCompany(this.company);
            chooser.setMultiCompanys(companyOrgUnitCollection);
            chooser.setParamName(this.paramName);
            this.acctItemSelectorUI.show();
        }
        catch (BOSException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        catch (EASBizException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    protected CompanyOrgUnitCollection getFICompany() throws BOSException, EASBizException {
        String companyNumber = this.formulaWizardUI.getParam("fiOrgUnit");
        CompanyOrgUnitCollection companyOrgUnitCollection = null;
        String orgType = this.formulaWizardUI.getParam("orgType");
        OrgType orgTypeInContext = this.formulaWizardUI.getRptOrgType();
        if (orgType != null && this.formulaWizardUI.getRptContext() != null && this.formulaWizardUI.getRptContext().getPropertyAdapter() != null) {
            orgTypeInContext = this.formulaWizardUI.getRptContext().getPropertyAdapter().getReportProperty("orgType") == null || orgType.equals("Company") ? OrgType.Company : OrgType.ProfitCenter;
        }
        if (StringUtils.isEmpty((String)companyNumber) || !StringUtils.isEmpty((String)companyNumber) && companyNumber.indexOf(";") <= 0) {
            if (this.formulaWizardUI.getRptContext() == null || this.formulaWizardUI.getRptContext() != null && this.formulaWizardUI.getRptContext().getPropertyAdapter() == null) {
                this.company = RptUtilForClient.getCurrentCompany();
                companyOrgUnitCollection = new CompanyOrgUnitCollection();
                companyOrgUnitCollection.add(this.company);
            } else {
                if (StringUtils.isEmpty((String)companyNumber)) {
                    companyNumber = (String)this.formulaWizardUI.getRptContext().getPropertyAdapter().getReportProperty("Company.Number");
                }
                if (companyNumber != null && companyNumber.length() > 0) {
                    if (orgTypeInContext.equals((Object)OrgType.Company)) {
                        companyOrgUnitCollection = RptUtilForClient.getCompanyOrgUnitCollectionByByNumber(companyNumber);
                        if (!companyOrgUnitCollection.isEmpty()) {
                            this.company = companyOrgUnitCollection.get(0);
                        }
                    } else {
                        this.company = RptNewUIUtil.getDelegateCompanyByNumber(null, (OrgType)orgTypeInContext, (String)companyNumber, null);
                        companyOrgUnitCollection = new CompanyOrgUnitCollection();
                        companyOrgUnitCollection.add(this.company);
                    }
                } else {
                    this.company = RptUtilForClient.getCurrentCompany();
                    companyOrgUnitCollection = new CompanyOrgUnitCollection();
                    companyOrgUnitCollection.add(this.company);
                }
            }
        }
        HashSet<String> companySet = new HashSet<String>();
        if (companyNumber != null && companyNumber.indexOf(";") > 0) {
            String[] companyNumbers = companyNumber.split(";");
            for (int i = 0; i < companyNumbers.length; ++i) {
                companySet.add(companyNumbers[i].trim());
            }
            FilterItemInfo filter = new FilterItemInfo("bu.fnumber", companySet, CompareType.INCLUDE);
            companyOrgUnitCollection = orgTypeInContext.equals((Object)OrgType.Company) ? RptUtilForClient.getCompanyOrgUnitCollectionByByNumber(companyNumber) : RptNewUIUtil.getDelegateCompany(null, (OrgType)orgTypeInContext, (String)filter.toString(), (String)"bu", null);
            if (!companyOrgUnitCollection.isEmpty() && this.company != null) {
                this.company = companyOrgUnitCollection.get(0);
            }
        }
        return companyOrgUnitCollection;
    }

    public Object getData() {
        if (this.acctItemSelectorUI == null) {
            return null;
        }
        try {
            AcctItemSelectorUI selectorUI = (AcctItemSelectorUI)this.acctItemSelectorUI.getUIObject();
            String result = selectorUI.getData();
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isCanceled() {
        AcctItemSelectorUI selectorUI = (AcctItemSelectorUI)this.acctItemSelectorUI.getUIObject();
        this.isCanceled = selectorUI.isCanceled();
        return this.isCanceled;
    }

    public FormulaWizardUI getFormulaWizardUI() {
        return this.formulaWizardUI;
    }

    public void setFormulaWizardUI(FormulaWizardUI wizardUI) {
        this.formulaWizardUI = wizardUI;
    }

    public void setCtrlComponent(JComponent pb) {
        this.paramName = pb.getName();
        if (this.paramName.equalsIgnoreCase("acctItem")) {
            ((KDBizPromptBox)pb).setCommitParser(null);
        }
        ((KDBizPromptBox)pb).addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                boolean pass = false;
                try {
                    pass = this.checkHasMutilAccountTable();
                }
                catch (Exception x) {
                    log.debug((Object)x.getMessage());
                    pass = true;
                }
                if (pass) {
                    e.setCanceled(true);
                }
            }

            private boolean checkHasMutilAccountTable() throws Exception {
                String companyNumber = AcctItemSelector.this.formulaWizardUI.getParam("fiOrgUnit");
                if (companyNumber != null && companyNumber.indexOf(";") > 0) {
                    companyNumber = companyNumber.substring(0, companyNumber.indexOf(";")).trim();
                }
                if (StringUtils.isEmpty((String)companyNumber) && AcctItemSelector.this.formulaWizardUI.getRptContext() != null && AcctItemSelector.this.formulaWizardUI.getRptContext().getPropertyAdapter() != null) {
                    companyNumber = (String)AcctItemSelector.this.formulaWizardUI.getRptContext().getPropertyAdapter().getReportProperty("Company.Number");
                }
                if (companyNumber == null || companyNumber.trim().length() == 0) {
                    AcctItemSelector.this.company = SysContext.getSysContext().getCurrentFIUnit();
                } else {
                    try {
                        if (AcctItemSelector.this.formulaWizardUI.getRptContext() != null && AcctItemSelector.this.formulaWizardUI.getRptContext().getPropertyAdapter() != null) {
                            String orgType = AcctItemSelector.this.formulaWizardUI.getParam("orgType");
                            AcctItemSelector.this.company = AcctItemSelector.this.formulaWizardUI.getRptContext().getPropertyAdapter().getReportProperty("orgType") == null && orgType.equals("Company") ? RptUtilForClient.getCompanyOrgUnitInfoByNumber(companyNumber) : RptNewUIUtil.getDelegateCompanyByNumber(null, (OrgType)OrgType.ProfitCenter, (String)companyNumber, null);
                        } else {
                            AcctItemSelector.this.company = RptUtilForClient.getCompanyOrgUnitInfoByNumber(companyNumber);
                        }
                        if (AcctItemSelector.this.company == null) {
                            MsgBox.showWarning((String)RptUtil.getResourceSince51("CompanyNoExists"));
                            return true;
                        }
                    }
                    catch (Exception e) {
                        AcctItemSelector.this.company = SysContext.getSysContext().getCurrentFIUnit();
                    }
                }
                return false;
            }
        });
    }
}

