/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.client.AbstractAdjustCompanyEditUI;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class AdjustCompanyEditUI
extends AbstractAdjustCompanyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AdjustCompanyEditUI.class);

    protected void initCSLContext() {
        this.cslCtx = (ICSLContext)this.getUIContext().get("companyCtx");
    }

    protected void initcomboDataSource() {
        this.comboDataSource.addItem((Object)RptSrcTypeEnum.NORMAL);
        this.comboDataSource.setEnabled(false);
    }

    protected void initbizPromptCompany() throws BOSException, EASBizException {
        this.bizPromptCompany.setValue((Object)SysContext.getSysContext().getCurrentOrgUnit());
        this.bizPromptCompany.setEnabled(false);
    }

    protected void initCurrency(String defCurrencyId) {
        try {
            this.comboCurrency.setSelectedIndex(this.getCurrencyInfoIndex((JComboBox)this.comboCurrency));
            this.comboSourceCurrency.setSelectedIndex(this.getCurrencyInfoIndex((JComboBox)this.comboSourceCurrency));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            logger.error((Object)"initHeadData_EASBizException", (Throwable)e);
        }
    }

    protected void infoSetCurrency(AdjustInfo info, Boolean isCurrency) {
        try {
            if (isCurrency.booleanValue()) {
                this.comboCurrency.setSelectedIndex(this.getCurrencyInfoIndex((JComboBox)this.comboCurrency));
                info.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
            } else {
                this.comboSourceCurrency.setSelectedIndex(this.getCurrencyInfoIndex((JComboBox)this.comboSourceCurrency));
                info.setSourceCurrency((CurrencyInfo)this.comboSourceCurrency.getSelectedItem());
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            logger.error((Object)"infoSetCurrency_EASBizException", (Throwable)e);
        }
    }

    private int getCurrencyInfoIndex(JComboBox comboCurrency) throws EASBizException, BOSException {
        OrgUnitInfo OrgUnitInfo2 = SysContext.getSysContext().getCurrentOrgUnit();
        ObjectStringPK pk = new ObjectStringPK(OrgUnitInfo2.getId().toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("baseCurrency.id"));
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)pk, selector);
        if (comboCurrency.getItemCount() != 0) {
            for (int i = 0; i < comboCurrency.getItemCount(); ++i) {
                String currencyID = ((CurrencyInfo)comboCurrency.getItemAt(i)).getId().toString();
                if (!currencyID.equals(companyOrgUnitInfo.getBaseCurrency().getId().toString())) continue;
                return i;
            }
        }
        return 0;
    }

    protected void setUIContext(UIContext uiContext) {
        uiContext.put((Object)"isFromCompanyEdit", (Object)true);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return this.getAdjustSelectors();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeAdjustFields();
    }

    @Override
    public void loadFields() {
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.bizPromptCompany.getValue();
        this.loadAdjustFields();
        if (this.bizPromptCompany.getValue() == null) {
            this.bizPromptCompany.setValue((Object)orgUnitInfo);
        }
    }
}

