/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DataCatcherListener;
import com.kingdee.eas.fi.gr.rptintegration.client.itask.CommitAndDispenseUtils;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.client.AbstractAdjustCompanyListUI;
import com.kingdee.eas.fi.rpt.client.AdjustCompanyFilterUI;
import com.kingdee.eas.fi.rpt.client.CopyHisDataCompanyListUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdjustCompanyListUI
extends AbstractAdjustCompanyListUI {
    private static final Logger logger = CoreUIObject.getLogger(AdjustCompanyListUI.class);

    protected void initCSLContext() {
        try {
            this.cslCtx = this.conditionPanel != null && this.conditionPanel.getUIContext().get("companyCtx") != null ? (ICSLContext)this.conditionPanel.getUIContext().get("companyCtx") : this.getCslCtx();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected ICSLContext getCSLContext() {
        if (this.cslCtx == null) {
            this.initCSLContext();
        }
        return this.cslCtx;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        super.initMegeType();
    }

    private void currentOrgUnitIsCompanyOrgUnit() throws EASBizException, BOSException {
        OrgUnitInfo UnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        ObjectUuidPK pk = new ObjectUuidPK(UnitInfo.getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("IsBizUnit"));
        selector.add(new SelectorItemInfo("IsCompanyOrgUnit"));
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)pk, selector);
        if (companyOrgUnitInfo == null || !companyOrgUnitInfo.isIsBizUnit() || !companyOrgUnitInfo.isIsCompanyOrgUnit()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"372_OnlyCompanyOrgUnitInfo"));
            SysUtil.abort();
        }
    }

    private ICSLContext getCslCtx() throws Exception {
        if (this.getMainQuery() != null) {
            FilterInfo filter = this.getMainQuery().getFilter();
            CSLContext cslContext = new CSLContext();
            for (int i = 0; filter != null && i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo item = filter.getFilterItems().get(i);
                if ("orgBound.id".equalsIgnoreCase(item.getPropertyName())) {
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)item.getCompareValue())));
                    OrgTreeInfo orgTreeInfo = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)pk, this.getNeedOrgTreeFieldsSelector());
                    cslContext.setCurOrgBound(orgTreeInfo);
                    cslContext.setCurOrgGroup((OrgUnitInfo)this.getOrgUnitByTreeAndUnit(orgTreeInfo.getId().toString()));
                }
                if ("Period".equalsIgnoreCase(item.getPropertyName())) {
                    cslContext.setCurRptPeriod(((Integer)item.getCompareValue()).intValue());
                }
                if ("PeriodType".equalsIgnoreCase(item.getPropertyName())) {
                    cslContext.setCurRptPeriodType(RptPeriodTypeEnum.getEnum((int)((Integer)item.getCompareValue())));
                }
                if (!"Year".equalsIgnoreCase(item.getPropertyName())) continue;
                cslContext.setCurRptYear(((Integer)item.getCompareValue()).intValue());
            }
            PeriodCollection periods = null;
            Date curRptDate = FiscalPeriodHelper.getRptDate(periods, (int)cslContext.getCurRptYear(), (int)cslContext.getCurRptPeriod(), (RptPeriodTypeEnum)cslContext.getCurRptPeriodType(), (boolean)false);
            cslContext.setCurReportDate(curRptDate);
            cslContext.setQueryBudget(false);
            cslContext.setCurDataCollect(DataCollectConstant.getActualDC());
            return cslContext;
        }
        return null;
    }

    private SelectorItemCollection getNeedOrgTreeFieldsSelector() {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add("id");
        sc.add("name");
        sc.add("number");
        sc.add("IsHide");
        sc.add("IsForBudget");
        sc.add("status");
        sc.add("layerType");
        return sc;
    }

    private FullOrgUnitInfo getOrgUnitByTreeAndUnit(String treeId) {
        if (!StringUtils.isEmpty((String)treeId)) {
            try {
                String permFilterSql = this.getUnionSQLByCompanyPKAndTreePK(CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentOrgUnit()), (IObjectPK)new ObjectStringPK(treeId));
                FullOrgUnitCollection coll = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection("select id,name,number where id in (" + permFilterSql + ")");
                return coll.get(0);
            }
            catch (BOSException e) {
                logger.error((Object)("getOrgUnitByTreeAndUnit:" + treeId), (Throwable)e);
            }
        }
        return null;
    }

    private String getUnionSQLByCompanyPKAndTreePK(IObjectPK companyPK, IObjectPK treeID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT unit.fid ").append("FROM T_ORG_BASEUNIT unit ").append("INNER JOIN T_ORG_STRUCTURE structure ON structure.funitid = unit.fid ").append("WHERE unit.fisunion = 1 and structure.FID in").append("(SELECT FPARENTID FROM T_ORG_Structure where FunitId='").append(companyPK).append("'").append(" AND FTreeId = '").append(treeID).append("')");
        return sql.toString();
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.conditionDialog.setOwner((Component)((Object)this));
            }
            MetaDataPK mainQueryPK1 = MetaDataPK.create((String)"com.kingdee.eas.fi.gr.cslrpt.app", (String)"AdjustCompanyForProgrammeQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK1);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(455);
            this.conditionDialog.setHeight(430);
            this.conditionDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Adjust_FilterUI_Title"));
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.rpt.client.AdjustCompanyListUI");
        }
        return this.conditionDialog;
    }

    public CustomerQueryPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new AdjustCompanyFilterUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
        }
        return this.conditionPanel;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fi.rpt.client.AdjustCompanyEditUI";
    }

    public MetaDataPK initQueryBudget() {
        return (MetaDataPK)this.mainQueryPK;
    }

    protected void setFilterByOrgUnit() {
        FullOrgUnitInfo orgUnit = this.getSelectOrgUnit();
        String compareValue = orgUnit.getId().toString();
        CompareType compareType = CompareType.EQUALS;
        FilterInfo filter = this.getMainQuery().getFilter();
        if (filter == null || filter.getFilterItems().size() == 0) {
            return;
        }
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!"ORGUNIT.ID".equals(item.getPropertyName())) continue;
            item.setCompareValue((Object)compareValue);
            item.setCompareType(compareType);
            return;
        }
        FilterItemInfo itemInfo = new FilterItemInfo("ORGUNIT.ID", (Object)compareValue, compareType);
        filter.getFilterItems().add(itemInfo);
        String maskString = filter.getMaskString();
        maskString = maskString + " and #" + (filter.getFilterItems().size() - 1);
        filter.setMaskString(maskString);
    }

    protected FullOrgUnitInfo getSelectOrgUnit() {
        return (FullOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit();
    }

    protected void initOrgTree() throws Exception {
    }

    protected void updateCslCtxFilter() throws BOSException {
    }

    protected void initOrgBound(OrgTreeInfo value) {
        this.cmbOrgBound.removeAllItems();
        this.cmbOrgBound.addItem((Object)value);
    }

    protected void initOrgUnit(OrgUnitInfo value) {
        this.pmptOrgUnit.setEnabled(false);
        try {
            this.pmptOrgUnit.setData((Object)this.getCSLContext().getCurOrgGroup());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"companyCtx", (Object)this.cslCtx);
    }

    public void putUIContext(UIContext uiContext) {
        uiContext.put((Object)"companyCtx", (Object)this.getCSLContext());
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.currentOrgUnitIsCompanyOrgUnit();
        super.actionQuery_actionPerformed(e);
        this.initCSLContext();
        this.refreshHead();
    }

    protected void setUIContext(UIContext uiContext) {
        super.setUIContext(uiContext);
        uiContext.put((Object)"companyCtx", (Object)this.getCSLContext());
        uiContext.put((Object)"isFromAdjustCompanyListUI", (Object)this.getCSLContext());
    }

    private void refreshHead() throws BOSException {
        this.cmbOrgBound.removeAllItems();
        this.cmbOrgBound.addItem((Object)this.getCSLContext().getCurOrgBound());
        this.cmbOrgBound.setSelectedItem((Object)this.getCSLContext().getCurOrgBound());
        this.cmbOrgBound.setEnabled(false);
        this.pmptOrgUnit.setEnabled(false);
        this.pmptOrgUnit.setData((Object)this.getCSLContext().getCurOrgGroup());
        this.cmbPeriodType.setSelectedItem((Object)this.getCSLContext().getCurRptPeriodType());
        this.dpDate.setValue((Object)this.getCSLContext().getCurReportDate());
        this.spCurYear.setValue((Object)this.getCSLContext().getCurRptYear());
        this.spCurPeriod.setValue((Object)this.getCSLContext().getCurRptPeriod());
    }

    protected UIContext getDynamicUIContext() throws BOSException {
        UIContext uiContext = super.getDynamicUIContext();
        uiContext.put((Object)"companyCtx", (Object)this.cslCtx);
        return uiContext;
    }

    public void actionCopyHisData_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = super.initUIContext();
        IUIWindow curUIWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(CopyHisDataCompanyListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        CopyHisDataCompanyListUI copyHisDataCompanyListUI = (CopyHisDataCompanyListUI)curUIWindow.getUIObject();
        copyHisDataCompanyListUI.bindDataListener((DataCatcherListener)this);
        curUIWindow.show();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        CommitAndDispenseUtils.addCommitToParentDataCenterButton((KDToolBar)this.toolBar, (ListUI)this, (CommitAndDispenseUtils.HandleType)CommitAndDispenseUtils.HandleType.adjust);
    }

    protected void initMegeType() throws Exception {
    }

    private OrgTreeInfo refreshOrgBound() throws EASBizException, BOSException {
        OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection((Date)CslRptUIUtil.getLastPeriodDate(null));
        if (otc == null) {
            return null;
        }
        ArrayList<String> orgTreeIDList = new ArrayList<String>();
        OrgTreeInfo info = null;
        for (int i = 0; i < otc.size(); ++i) {
            info = otc.get(i);
            if (info.isIsHide() || info.getLayerType() == OrgViewType.PROFITCENTER || UnionVersionStatusEnum.UNSTART.equals((Object)info.getStatus())) continue;
            orgTreeIDList.add(info.getId().toString());
        }
        OrgUnitInfo currentOrgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        if (!orgTreeIDList.isEmpty()) {
            OrgTreeCollection orgTreeColl = this.getOrgTreeCollectionByCompanyPK(CslRptUtil.getPK((IObjectValue)currentOrgUnitInfo), orgTreeIDList);
            return orgTreeColl.get(0);
        }
        return null;
    }

    private String getOrgTreeSQLByCompanyPK(IObjectPK companyPK, ArrayList orgTreeIDList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT tree.fid ").append("FROM T_ORG_Tree tree ").append("INNER JOIN T_ORG_STRUCTURE structure ON structure.FTreeId =tree.fid ").append("WHERE structure.FunitId='").append(companyPK).append("' and tree.FTYPE=8 ").append("and tree.fid in (").append(CslRptUtil.collection2String((Collection)orgTreeIDList, (String)",", (boolean)true)).append(")");
        return sql.toString();
    }

    private OrgTreeCollection getOrgTreeCollectionByCompanyPK(IObjectPK companyPK, ArrayList orgTreeIDList) throws BOSException {
        ArrayList OrgTreeList = new ArrayList();
        if (!StringUtils.isEmpty((String)companyPK.toString())) {
            String permFilterSql = this.getOrgTreeSQLByCompanyPK(companyPK, orgTreeIDList);
            OrgTreeCollection coll = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection("select id,name,status,startDate,endDate,number where id in (" + permFilterSql + ")");
            return coll;
        }
        return null;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        OrgTreeInfo orgTreeInfo = null;
        try {
            orgTreeInfo = this.refreshOrgBound();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            logger.error((Object)"getInitDefaultSolution_EASBizException", (Throwable)e);
        }
        if (orgTreeInfo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrptrpt.RPTAutoGenerateResource", (String)"372_OrgBroundIsNull"));
            try {
                this.getConditionDialog().show();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            SysUtil.abort();
        }
        int formulaIndex = 0;
        StringBuffer sbFormula = new StringBuffer();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        RptPeriodTypeEnum p = RptPeriodTypeEnum.MONTHLY;
        List times = RPTDateUtil.getRptPeriod((Date)CslRptUIUtil.getLastPeriodDate(null), (RptPeriodTypeEnum)p);
        FilterItemInfo filterItem0 = null;
        filterItem0 = new FilterItemInfo("orgBound.id", (Object)orgTreeInfo.getId().toString(), CompareType.EQUALS);
        FilterItemInfo filterItem1 = new FilterItemInfo("periodType", (Object)new Integer(p.getValue()), CompareType.EQUALS);
        FilterItemInfo filterItem2 = new FilterItemInfo("year", (Object)((Integer)times.get(0)), CompareType.EQUALS);
        FilterItemInfo filterItem3 = new FilterItemInfo("period", (Object)((Integer)times.get(1)), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItem0);
        sbFormula.append(" #" + formulaIndex++);
        filterInfo.getFilterItems().add(filterItem1);
        sbFormula.append(" and #" + formulaIndex++);
        filterInfo.getFilterItems().add(filterItem2);
        sbFormula.append(" and #" + formulaIndex++);
        filterInfo.getFilterItems().add(filterItem3);
        sbFormula.append(" and #" + formulaIndex++);
        FilterItemInfo filterItem5 = new FilterItemInfo("dataCollect.number", (Object)"ACTUALDATA", CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItem5);
        sbFormula.append(" and #" + formulaIndex++);
        filterInfo.getFilterItems().add(new FilterItemInfo("entries.isVisible", (Object)"1"));
        sbFormula.append(" and #").append(formulaIndex++);
        filterInfo.setMaskString(sbFormula.toString());
        evi.setFilter(filterInfo);
        evi.getSorter().add(new SorterItemInfo("number"));
        evi.getSorter().add(new SorterItemInfo("entries.seq"));
        return evi;
    }

    public String[] getMergeColumnKeys() {
        ArrayList<String> mergeColumnKeys = new ArrayList<String>();
        mergeColumnKeys.add("id");
        mergeColumnKeys.add("number");
        String[] columns = new String[mergeColumnKeys.size()];
        mergeColumnKeys.toArray(columns);
        return columns;
    }

    public void setImportRecordUIContext(UIContext uiContext) {
        uiContext.put((Object)"AdjustCompanyImportRecord", (Object)true);
    }
}

