/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.client.AbstractAdjustCompanyViewListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AdjustCompanyViewListUI
extends AbstractAdjustCompanyViewListUI {
    private static final Logger logger = CoreUIObject.getLogger(AdjustCompanyViewListUI.class);
    private static final long serialVersionUID = 1L;

    private void currentOrgUnitIsCompanyOrgUnit() throws EASBizException, BOSException {
        OrgUnitInfo UnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        ObjectUuidPK pk = new ObjectUuidPK(UnitInfo.getId());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("IsBizUnit"));
        selector.add(new SelectorItemInfo("IsCompanyOrgUnit"));
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)pk, selector);
        if (companyOrgUnitInfo == null || !companyOrgUnitInfo.isIsBizUnit() || !companyOrgUnitInfo.isIsCompanyOrgUnit()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"372_OnlyCompanyOrgUnitInfo"));
            SysUtil.abort();
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("isFromAdjustWorkSelectOrg") == null) {
            this.currentOrgUnitIsCompanyOrgUnit();
        }
        super.actionQuery_actionPerformed(e);
        this.initCSLContext();
    }

    public void onLoad() throws Exception {
        this.menuItemShowOrgTree.setSelected(false);
        super.onLoad();
        this.menuItemShowOrgTree.setEnabled(false);
        this.menuItemShowOrgTree.setVisible(false);
        this.OrgTree.setEnabled(false);
        this.OrgTree.setVisible(false);
        this.menuItemExportData.setEnabled(true);
        this.menuItemExportData.setVisible(true);
    }

    protected void setUIContext(UIContext uiContext) {
        super.setUIContext(uiContext);
        uiContext.put((Object)"companyCtx", (Object)this.getCSLContext());
    }

    protected Set AllPermOrgUnit() {
        HashSet<String> union = new HashSet<String>();
        if (this.getUIContext().get("isFromAdjustWorkSelectOrg") != null) {
            union.add(((FullOrgUnitInfo)this.getUIContext().get("isFromAdjustWorkSelectOrg")).getId().toString());
        } else {
            union.add(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        }
        return union;
    }

    protected void initHeadControl() throws Exception {
    }

    protected void initAdjustUI() throws Exception {
    }

    protected void initMegeType() throws Exception {
    }

    public CustomerQueryPanel getConditionPanel() throws Exception {
        this.getUIContext().put("isAdjustCompanyViewList", true);
        return super.getConditionPanel();
    }

    protected void initCSLContext() {
        if (this.getUIContext().get("isFromAdjustWorkTableUI") != null) {
            this.cslCtx = (ICSLContext)this.getUIContext().get("cslCtx");
        } else {
            try {
                this.cslCtx = this.getCslCtx();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected ICSLContext getCSLContext() {
        this.initCSLContext();
        return this.cslCtx;
    }

    protected UIContext getDynamicUIContext() {
        UIContext uiContext = super.getDynamicUIContext();
        uiContext.put((Object)"companyCtx", (Object)this.cslCtx);
        return uiContext;
    }

    private ICSLContext getCslCtx() throws Exception {
        if (this.getMainQuery() != null) {
            FilterInfo filter = this.getMainQuery().getFilter();
            CSLContext cslContext = new CSLContext();
            for (int i = 0; filter != null && i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo item = filter.getFilterItems().get(i);
                if ("orgBound.id".equalsIgnoreCase(item.getPropertyName())) {
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)item.getCompareValue())));
                    OrgTreeInfo orgTreeInfo = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)pk, this.getNeedOrgTreeFieldsSelector());
                    cslContext.setCurOrgBound(orgTreeInfo);
                    cslContext.setCurOrgGroup((OrgUnitInfo)this.getOrgUnitByTreeAndUnit(orgTreeInfo.getId().toString()));
                }
                if (!"PeriodType".equalsIgnoreCase(item.getPropertyName())) continue;
                cslContext.setCurRptPeriodType(RptPeriodTypeEnum.getEnum((int)((Integer)item.getCompareValue())));
            }
            cslContext.setQueryBudget(false);
            cslContext.setCurDataCollect(DataCollectConstant.getActualDC());
            return cslContext;
        }
        return null;
    }

    private FullOrgUnitInfo getOrgUnitByTreeAndUnit(String treeId) {
        if (!StringUtils.isEmpty((String)treeId)) {
            try {
                String permFilterSql = this.getUnionSQLByCompanyPKAndTreePK(CslRptUtil.getPK((IObjectValue)SysContext.getSysContext().getCurrentOrgUnit()), (IObjectPK)new ObjectStringPK(treeId));
                FullOrgUnitCollection coll = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection("select id,name,number where id in (" + permFilterSql + ")");
                return coll.get(0);
            }
            catch (BOSException e) {
                logger.error((Object)("getOrgUnitByTreeAndUnit:" + treeId), (Throwable)e);
            }
        }
        return null;
    }

    private String getUnionSQLByCompanyPKAndTreePK(IObjectPK companyPK, IObjectPK treeID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT unit.fid ").append("FROM T_ORG_BASEUNIT unit ").append("INNER JOIN T_ORG_STRUCTURE structure ON structure.funitid = unit.fid ").append("WHERE unit.fisunion = 1 and structure.FID in").append("(SELECT FPARENTID FROM T_ORG_Structure where FunitId='").append(companyPK).append("'").append(" AND FTreeId = '").append(treeID).append("')");
        return sql.toString();
    }

    private SelectorItemCollection getNeedOrgTreeFieldsSelector() {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add("id");
        sc.add("name");
        sc.add("number");
        return sc;
    }

    public MetaDataPK initQueryBudget() {
        return (MetaDataPK)this.mainQueryPK;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.getUIContext().get("isFromAdjustWorkSelectOrg") != null) {
            return new ObjectUuidPK(((FullOrgUnitInfo)this.getUIContext().get("isFromAdjustWorkSelectOrg")).getId().toString());
        }
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
    }
}

