/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.AutoNewReportLogCollection;
import com.kingdee.eas.fi.rpt.AutoNewReportLogFactory;
import com.kingdee.eas.fi.rpt.AutoNewReportLogInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.AbstractAutoReportNewLogUI;
import com.kingdee.eas.util.client.EASResource;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class AutoReportNewLogUI
extends AbstractAutoReportNewLogUI {
    private static final Logger logger = CoreUIObject.getLogger(AutoReportNewLogUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"85_AutoReportNewLogUI"));
        this.kDTable1.checkParsed();
        this.kDComboBox2.setEditable(false);
        this.kDComboBox1.setEditable(false);
        this.btnQuery.setVisible(false);
        this.kDDatePicker1.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                AutoReportNewLogUI.this.updateYearAndPeriod();
                AutoReportNewLogUI.this.query();
            }
        });
        this.updateYearAndPeriod();
        this.query();
    }

    void query() {
        TemplateInfo info = (TemplateInfo)this.getUIContext().get("info");
        int[] yp = this.getYearAndPeriod();
        this.kDTable1.removeRows();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("company.*"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("template.id", (Object)info.getId().toString()));
        view.getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(yp[0])));
        view.getFilter().getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(yp[1])));
        try {
            AutoNewReportLogCollection c = AutoNewReportLogFactory.getRemoteInstance().getCollection(view);
            if (c != null && c.size() > 0) {
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    AutoNewReportLogInfo v = (AutoNewReportLogInfo)it.next();
                    IRow r = this.kDTable1.addRow();
                    r.getCell(0).setValue((Object)v.getCompany().getName());
                    r.getCell(0).getStyleAttributes().setLocked(true);
                    r.getCell(1).setValue((Object)v.getReportNumber());
                    r.getCell(1).getStyleAttributes().setLocked(true);
                    r.getCell(2).setValue((Object)new Integer(v.getYear()));
                    r.getCell(2).getStyleAttributes().setLocked(true);
                    r.getCell(3).setValue((Object)new Integer(v.getPeriod()));
                    r.getCell(3).getStyleAttributes().setLocked(true);
                    r.getCell(4).setValue((Object)v.getMessage());
                    r.getCell(4).getStyleAttributes().setLocked(true);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void updateYearAndPeriod() {
        this.kDComboBox1.removeAllItems();
        this.kDComboBox2.removeAllItems();
        int[] yp = this.getYearAndPeriod();
        if (yp != null) {
            this.kDComboBox1.addItem((Object)new Integer(yp[0]));
            this.kDComboBox2.addItem((Object)new Integer(yp[1]));
            this.kDComboBox1.setSelectedIndex(0);
            this.kDComboBox2.setSelectedIndex(0);
        }
    }

    private int[] getYearAndPeriod() {
        TemplateInfo info = (TemplateInfo)this.getUIContext().get("info");
        RptPeriodTypeEnum RptPeriodTypeE = info.getPeriodType();
        if (RptPeriodTypeE != null) {
            Date date1 = (Date)this.kDDatePicker1.getValue();
            if (date1 != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date1);
                int year = cal.get(1);
                int month = cal.get(2) + 1;
                int day = cal.get(5);
                int[] yp = new int[]{year, RPTDateUtil.getPeriod((int)year, (int)month, (int)day, (RptPeriodTypeEnum)RptPeriodTypeE)};
                return yp;
            }
            return null;
        }
        return null;
    }
}

