/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.OrgViewF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.CellReference;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.AbstractBgFormulaBatchFill;
import com.kingdee.eas.fi.rpt.client.BgFormulaBatchFillHelper;
import com.kingdee.eas.fi.rpt.client.ReportProcessUI;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgManagerFactory;
import com.kingdee.eas.ma.bg.BgSchemeCollection;
import com.kingdee.eas.ma.bg.BgSchemeFactory;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgManager;
import com.kingdee.eas.ma.bg.IBgScheme;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.ReferencedCurrencyCollection;
import com.kingdee.eas.ma.bg.client.BgTypeDialogForFill;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Hashtable;

public class BgFormulaBatchFill
extends AbstractBgFormulaBatchFill {
    private ReportProcessUI reportProcessUI;
    private BgTemplateInfo bgTemInfo = null;
    private String comId;
    private Hashtable hashTable = new Hashtable();
    public final String ITEM_KEY = "item_key";
    private KDTable currencyTable;
    private int reportRowNumber;
    private int reportColNumber;
    private static String RESOURCE = "com.kingdee.eas.ma.bg.BgFormulaBatchFillResource";
    private boolean isLoad = false;

    @Override
    protected void bizOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.bizOrgUnit_dataChanged(e);
        if (this.bizOrgUnit.getData() == null) {
            return;
        }
        if (!this.isLoad) {
            this.isLoad = true;
        }
        OrgUnitInfo orgInfo = (OrgUnitInfo)this.bizOrgUnit.getData();
        this.cbxScheme.removeAllItems();
        this.clear(this.itemTable);
        this.clear(this.selectedItemTable);
        this.hashTable.clear();
        this.initBgScheme(orgInfo.getId().toString());
        this.initPeriod();
        this.initBgTem();
        this.initCurrency();
    }

    @Override
    protected void bizBgType_dataChanged(DataChangeEvent e) throws Exception {
        super.bizBgType_dataChanged(e);
        if (this.isLoad) {
            if (this.bizBgType.getData() == null) {
                this.cbxScheme.removeAllItems();
                this.clear(this.itemTable);
                this.clear(this.selectedItemTable);
                this.hashTable.clear();
                return;
            }
            OrgUnitInfo orgInfo = (OrgUnitInfo)this.bizOrgUnit.getData();
            this.cbxScheme.removeAllItems();
            this.clear(this.itemTable);
            this.clear(this.selectedItemTable);
            this.hashTable.clear();
            this.initBgScheme(orgInfo.getId().toString());
            this.initPeriod();
            this.initBgTem();
            this.initCurrency();
        }
    }

    private void initCurrency() {
        if (this.bgTemInfo != null) {
            ReferencedCurrencyCollection currencyColl = this.bgTemInfo.getRefCurrencies();
            int size = currencyColl.size();
            for (int i = 0; i < size; ++i) {
                this.cbxCurrency.addItem((Object)currencyColl.get(i).getCurrency());
            }
        }
    }

    private void initBgTem() throws EASBizException, BOSException {
        BOSUuid orgId = ((OrgUnitInfo)this.bizOrgUnit.getData()).getId();
        BgTypeInfo bgTypeInfo = (BgTypeInfo)this.bizBgType.getData();
        BOSUuid bgTypeId = null;
        if (bgTypeInfo == null) {
            return;
        }
        bgTypeId = bgTypeInfo.getId();
        int year = (Integer)this.beginYear.getValue();
        int period = (Integer)this.beginPeriod.getValue();
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((int)year, (int)period, (IObjectPK)new ObjectUuidPK(this.comId));
        if (periodInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"noPeriod"));
            SysUtil.abort();
        }
        BOSUuid periodId = periodInfo.getId();
        IBgManager iBgManager = BgManagerFactory.getRemoteInstance();
        BgFormInfo bgFormInfo = iBgManager.getExecutiveBgForm(orgId, bgTypeId, periodId);
        if (bgFormInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"noExecBgForm"));
            SysUtil.abort();
        } else if (!bgFormInfo.getOrgUnit().getId().equals((Object)orgId)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"noExecBgForm"));
            SysUtil.abort();
        } else {
            this.bgTemInfo = BgTemplateDAFactory.getRemoteInstance().getBgTemplate(bgFormInfo.getBgTemplate().getId().toString());
            BgFormulaBatchFillHelper.initBgItemColumnAndRow(this.bgTemInfo, this.itemTable);
            IColumn col = this.itemTable.addColumn();
            col.setKey("item_key");
            col.getStyleAttributes().setHided(true);
            for (int i = 0; i < this.itemTable.getRowCount(); ++i) {
                String tempString = "";
                IRow row = this.itemTable.getRow(i);
                for (int j = 0; j < this.itemTable.getColumnCount(); ++j) {
                    if (j == this.itemTable.getColumnCount() - 1) continue;
                    tempString = tempString + row.getCell(j).getValue().toString();
                }
                row.getCell(this.itemTable.getColumnCount() - 1).setValue((Object)tempString);
            }
            BgFormulaBatchFillHelper.initBgItemColumn(this.bgTemInfo, this.selectedItemTable);
        }
    }

    private void initPeriod() {
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.cbxScheme.getSelectedItem();
        this.beginYear.setEnabled(false);
        this.beginPeriod.setEnabled(false);
        this.beginYear.setValue((Object)new Integer(bgSchemeInfo.getPeriodFrom().getPeriodYear()));
        this.beginPeriod.setValue((Object)new Integer(bgSchemeInfo.getPeriodFrom().getPeriodNumber()));
        this.endYear.setValue((Object)new Integer(bgSchemeInfo.getPeriodTo().getPeriodYear()));
        this.endPeriod.setValue((Object)new Integer(bgSchemeInfo.getPeriodTo().getPeriodNumber()));
        this.beginYear.setEnabled(true);
        this.beginPeriod.setEnabled(true);
    }

    private void initBgScheme(String orgId) throws EASBizException, BOSException {
        IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitInfo orgInfo = iFull.getFullOrgUnitInfo("select id,CU.id where id='" + orgId + "'");
        this.comId = orgInfo.getCU().getId().toString();
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        String oql = "select id,name,periodFrom.periodYear,periodFrom.periodNumber,  periodTo.periodYear,periodTo.periodNumber where orgUnit.id='" + this.comId + "' and isFormal=1";
        BgSchemeCollection bgSchemeColl = iBgScheme.getCollectionByOrgUnit(orgInfo);
        if (bgSchemeColl == null || bgSchemeColl.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"noBgScheme"));
            SysUtil.abort();
        } else {
            this.cbxScheme.setEnabled(false);
            int size = bgSchemeColl.size();
            for (int i = 0; i < size; ++i) {
                this.cbxScheme.addItem((Object)bgSchemeColl.get(i));
            }
            this.cbxScheme.setEnabled(true);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnEnter_actionPerformed(ActionEvent e) throws Exception {
        super.btnEnter_actionPerformed(e);
        this.verifyInput();
        this.enterBefore();
        if (((Type)this.cbxDirection.getSelectedItem()).intType == 2) {
            this.verticalFill();
        } else {
            this.horizontalFill();
        }
        this.disposeUIWindow();
    }

    protected void enterBefore() {
        this.currencyTable = this.reportProcessUI.getPnlTables().getCurrentPage();
        if (this.currencyTable.getStyleAttributes().isLocked()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.BatchFill_Lock_NoFill"));
            SysUtil.abort();
        }
        CellReference cellReference = TableToolkit.parsePosition(this.txtStartPoint.getText());
        this.reportRowNumber = cellReference.region.y1;
        this.reportColNumber = cellReference.region.x1;
    }

    private void verifyInput() throws Exception {
        if (this.txtStartPoint.getText() == null || this.txtStartPoint.getText().trim().equals("")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputStartPoint"));
            SysUtil.abort();
        }
        if (this.bizOrgUnit.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputOrgUnit"));
            SysUtil.abort();
        }
        if (this.cbxScheme.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputBgScheme"));
            SysUtil.abort();
        }
        if (this.cbxCurrency.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputCurrency"));
            SysUtil.abort();
        }
        if (this.beginYear.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputBeginYear"));
            SysUtil.abort();
        } else if (!(this.beginYear.getValue() instanceof Integer)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputBeginYearNum"));
            SysUtil.abort();
        }
        if (this.beginPeriod.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputBeginPeriod"));
            SysUtil.abort();
        } else if (!(this.beginPeriod.getValue() instanceof Integer)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputBeginPeriodNum"));
            SysUtil.abort();
        }
        if (this.endYear.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputEndYear"));
            SysUtil.abort();
        } else if (!(this.endYear.getValue() instanceof Integer)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputEndYearNum"));
            SysUtil.abort();
        }
        if (this.endPeriod.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputEndPeriod"));
            SysUtil.abort();
        } else if (!(this.endPeriod.getValue() instanceof Integer)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputEndPeriodNum"));
            SysUtil.abort();
        }
        if (this.selectedItemTable.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"inputProject"));
            SysUtil.abort();
        }
    }

    private void setCellValue(ICell cell, Object content, int type) {
        if (cell == null || cell.getStyleAttributes().isLocked()) {
            return;
        }
        if (type == 1) {
            cell.setValue(content);
            cell.setExpressions(null);
        } else {
            cell.setExpressions(content.toString());
            cell.setValue(null);
        }
    }

    private void horizontalFill() {
        String name;
        int i;
        int formulaRowCount = this.selectedItemTable.getRowCount();
        if (this.currencyTable.getColumnCount() < formulaRowCount) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.BatchFill_ColTooBig"));
            SysUtil.abort();
        }
        int headIndex = 0;
        for (i = 0; i < this.selectedItemTable.getColumnCount(); ++i) {
            this.setCellValue(this.currencyTable.getRow(this.reportRowNumber).getCell(this.reportColNumber + headIndex++), this.selectedItemTable.getHeadRow(0).getCell(i).getValue(), 1);
        }
        if (((Type)this.cbxFormula.getSelectedItem()).typeName.equals("BgAcct")) {
            for (i = 0; i < this.bgTemInfo.getBgTpColumns().size(); ++i) {
                name = this.bgTemInfo.getBgTpColumns().get(i).getBgElement().getName();
                this.setCellValue(this.currencyTable.getRow(this.reportRowNumber).getCell(this.reportColNumber + headIndex++), name, 1);
            }
        } else if (((Type)this.cbxFormula.getSelectedItem()).typeName.equals("BgBalance")) {
            for (i = 0; i < this.bgTemInfo.getBgTpColumns().size(); ++i) {
                name = this.bgTemInfo.getBgTpColumns().get(i).getBgElement().getName();
                this.setCellValue(this.currencyTable.getRow(this.reportRowNumber).getCell(this.reportColNumber + headIndex++), name, 1);
            }
        }
        String orgNumber = ((OrgUnitInfo)this.bizOrgUnit.getData()).getNumber();
        String bgTypeNumber = ((BgTypeInfo)this.bizBgType.getData()).getNumber();
        String[] eleNumber = new String[this.bgTemInfo.getBgTpColumns().size()];
        for (int i2 = 0; i2 < this.bgTemInfo.getBgTpColumns().size(); ++i2) {
            eleNumber[i2] = this.bgTemInfo.getBgTpColumns().get(i2).getBgElement().getNumber();
        }
        String currencyNumber = ((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getNumber();
        int year1 = (Integer)this.beginYear.getValue();
        int period1 = (Integer)this.beginPeriod.getValue();
        int year2 = (Integer)this.endYear.getValue();
        int period2 = (Integer)this.endPeriod.getValue();
        String formulaType = ((Type)this.cbxFormula.getSelectedItem()).typeName;
        for (int i3 = 0; i3 < this.selectedItemTable.getRowCount(); ++i3) {
            int j;
            IRow row = this.selectedItemTable.getRow(i3);
            String dimAndItemNumber = "";
            for (j = 0; j < this.selectedItemTable.getColumnCount(); ++j) {
                this.setCellValue(this.currencyTable.getRow(this.reportRowNumber + i3 + 1).getCell(this.reportColNumber + j), row.getCell(j).getValue(), 1);
                if (this.selectedItemTable.getColumnKey(j).indexOf("_name") != -1) continue;
                dimAndItemNumber = this.selectedItemTable.getColumnKey(j).indexOf("_number") != -1 ? dimAndItemNumber + 1100 + "&" + (String)row.getCell(j).getValue() + ":" : dimAndItemNumber + ((BgDimensionEnum)this.selectedItemTable.getHeadRow(0).getCell(j).getValue()).getValue() + "&" + ((BgItemInfo)row.getCell(j).getValue()).getItemNumber() + ":";
            }
            dimAndItemNumber = dimAndItemNumber.substring(0, dimAndItemNumber.length() - 1);
            for (j = 0; j < this.bgTemInfo.getBgTpColumns().size(); ++j) {
                String formula = "=" + formulaType + "(\"" + orgNumber + "\",\"" + bgTypeNumber + "\",\"" + eleNumber[j] + "\",\"" + dimAndItemNumber + "\",\"" + currencyNumber + "\"," + year1 + "," + period1 + "," + year2 + "," + period2 + ")";
                this.setCellValue(this.currencyTable.getRow(this.reportRowNumber + i3 + 1).getCell(this.reportColNumber + this.selectedItemTable.getColumnCount() + j), formula, 2);
            }
        }
    }

    private void verticalFill() {
        String name;
        int i;
        int formulaRowCount = this.selectedItemTable.getRowCount();
        if (this.currencyTable.getColumnCount() < formulaRowCount) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.BatchFill_ColTooBig"));
            SysUtil.abort();
        }
        int headIndex = 0;
        for (i = 0; i < this.selectedItemTable.getColumnCount(); ++i) {
            this.setCellValue(this.currencyTable.getRow(this.reportRowNumber + headIndex++).getCell(this.reportColNumber), this.selectedItemTable.getHeadRow(0).getCell(i).getValue(), 1);
        }
        if (((Type)this.cbxFormula.getSelectedItem()).typeName.equals("BgAcct")) {
            for (i = 0; i < this.bgTemInfo.getBgTpColumns().size(); ++i) {
                name = this.bgTemInfo.getBgTpColumns().get(i).getBgElement().getName();
                this.setCellValue(this.currencyTable.getRow(this.reportRowNumber + headIndex++).getCell(this.reportColNumber), name, 1);
            }
        } else if (((Type)this.cbxFormula.getSelectedItem()).typeName.equals("BgBalance")) {
            for (i = 0; i < this.bgTemInfo.getBgTpColumns().size(); ++i) {
                name = this.bgTemInfo.getBgTpColumns().get(i).getBgElement().getName();
                this.setCellValue(this.currencyTable.getRow(this.reportRowNumber + headIndex++).getCell(this.reportColNumber), name, 1);
            }
        }
        String orgNumber = ((OrgUnitInfo)this.bizOrgUnit.getData()).getNumber();
        String bgTypeNumber = ((BgTypeInfo)this.bizBgType.getData()).getNumber();
        String[] eleNumber = new String[this.bgTemInfo.getBgTpColumns().size()];
        for (int i2 = 0; i2 < this.bgTemInfo.getBgTpColumns().size(); ++i2) {
            eleNumber[i2] = this.bgTemInfo.getBgTpColumns().get(i2).getBgElement().getNumber();
        }
        String currencyNumber = ((CurrencyInfo)this.cbxCurrency.getSelectedItem()).getNumber();
        int year1 = (Integer)this.beginYear.getValue();
        int period1 = (Integer)this.beginPeriod.getValue();
        int year2 = (Integer)this.endYear.getValue();
        int period2 = (Integer)this.endPeriod.getValue();
        String formulaType = ((Type)this.cbxFormula.getSelectedItem()).typeName;
        for (int i3 = 0; i3 < this.selectedItemTable.getRowCount(); ++i3) {
            int j;
            IRow row = this.selectedItemTable.getRow(i3);
            String dimAndItemNumber = "";
            for (j = 0; j < this.selectedItemTable.getColumnCount(); ++j) {
                this.setCellValue(this.currencyTable.getRow(this.reportRowNumber + j).getCell(this.reportColNumber + i3 + 1), row.getCell(j).getValue(), 1);
                if (this.selectedItemTable.getColumnKey(j).indexOf("_name") != -1) continue;
                dimAndItemNumber = this.selectedItemTable.getColumnKey(j).indexOf("_number") != -1 ? dimAndItemNumber + 1100 + "&" + (String)row.getCell(j).getValue() + ":" : dimAndItemNumber + ((BgDimensionEnum)this.selectedItemTable.getHeadRow(0).getCell(j).getValue()).getValue() + "&" + ((BgItemInfo)row.getCell(j).getValue()).getItemNumber() + ":";
            }
            dimAndItemNumber = dimAndItemNumber.substring(0, dimAndItemNumber.length() - 1);
            for (j = 0; j < this.bgTemInfo.getBgTpColumns().size(); ++j) {
                String formula = "=" + formulaType + "(\"" + orgNumber + "\",\"" + bgTypeNumber + "\",\"" + eleNumber[j] + "\",\"" + dimAndItemNumber + "\",\"" + currencyNumber + "\"," + year1 + "," + period1 + "," + year2 + "," + period2 + ")";
                this.setCellValue(this.currencyTable.getRow(this.reportRowNumber + this.selectedItemTable.getColumnCount() + j).getCell(this.reportColNumber + i3 + 1), formula, 2);
            }
        }
    }

    @Override
    protected void cbxScheme_actionPerformed(ActionEvent e) throws Exception {
        super.cbxScheme_actionPerformed(e);
        if (this.cbxScheme.getSelectedItem() == null || !this.cbxScheme.isEnabled()) {
            return;
        }
        this.clear(this.itemTable);
        this.clear(this.selectedItemTable);
        this.hashTable.clear();
        this.initPeriod();
        this.initBgTem();
        this.initCurrency();
    }

    public void clear(KDTable table) {
        table.removeRows();
        table.removeColumns();
        table.addHeadRow();
    }

    public BgFormulaBatchFill() throws Exception {
        this.btnGoRight.setText(null);
        this.btnGoRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnGoLeft.setText(null);
        this.btnGoLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.cbxFormula.removeAllItems();
        Type bgAcct = new Type(1, "BgAcct");
        Type bgBalance = new Type(2, "BgBalance");
        this.cbxFormula.addItem((Object)bgAcct);
        this.cbxFormula.addItem((Object)bgBalance);
        this.cbxFormula.setSelectedIndex(0);
        Type dircVertical = new Type(1, EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.BatchFill_Vertical"));
        Type dircHorizantal = new Type(2, EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.BatchFill_Horizontal"));
        this.cbxDirection.addItem((Object)dircVertical);
        this.cbxDirection.addItem((Object)dircHorizantal);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnGoRight_actionPerformed(ActionEvent e) throws Exception {
        super.btnGoRight_actionPerformed(e);
        KDTSelectBlock sb = this.itemTable.getSelectManager().get();
        if (sb == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"leftToRight"));
            return;
        }
        int beginIndex = sb.getBeginRow();
        int endIndex = sb.getEndRow();
        int colCount = this.selectedItemTable.getColumnCount();
        for (int i = endIndex; i >= beginIndex; --i) {
            IRow row = null;
            if (this.itemTable.getRow(i) == null) {
                return;
            }
            String key = (String)this.itemTable.getRow(i).getCell("item_key").getValue();
            if (this.hashTable.containsKey(key)) continue;
            this.hashTable.put(key, key);
            row = this.selectedItemTable.addRow();
            for (int j = 0; j < colCount; ++j) {
                row.getCell(j).setValue(this.itemTable.getRow(i).getCell(j).getValue());
            }
        }
    }

    @Override
    protected void btnGoLeft_actionPerformed(ActionEvent e) throws Exception {
        super.btnGoLeft_actionPerformed(e);
        KDTSelectBlock sb = this.selectedItemTable.getSelectManager().get();
        if (sb == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"rightToLeft"));
            return;
        }
        int beginIndex = sb.getBeginRow();
        int endIndex = sb.getEndRow();
        if (beginIndex != -1) {
            for (int i = endIndex; i >= beginIndex; --i) {
                String key = "";
                IRow row = this.selectedItemTable.getRow(i);
                for (int j = 0; j < this.selectedItemTable.getColumnCount(); ++j) {
                    key = key + row.getCell(j).getValue().toString();
                }
                this.hashTable.remove(key);
                this.selectedItemTable.removeRow(i);
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"rightToLeft"));
            return;
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.reportProcessUI = (ReportProcessUI)((Object)this.getUIContext().get("Owner"));
        int curcol = this.reportProcessUI.getPnlTables().getCurrentPage().getSelectManager().getActiveColumnIndex();
        int currow = this.reportProcessUI.getPnlTables().getCurrentPage().getSelectManager().getActiveRowIndex();
        if (currow >= 0 && curcol >= 0) {
            this.txtStartPoint.setText(TableToolkit.xy2range(curcol, currow));
        } else {
            this.txtStartPoint.setText("A1");
        }
        this.loadFields();
        OrgViewF7 orgBox = new OrgViewF7((IUIObject)this);
        OrgViewType[] orgView = new OrgViewType[]{OrgViewType.ADMIN, OrgViewType.COMPANY, OrgViewType.RESPONSECENTER, OrgViewType.SALE, OrgViewType.PURCHASE, OrgViewType.STORAGE};
        orgBox.setOrgViewTypes(orgView);
        orgBox.setIsShowSub(true);
        orgBox.setMultiSelect(false);
        orgBox.setTitle(EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"SelectOrgUnit"));
        this.bizOrgUnit.setSelector((KDPromptSelector)orgBox);
        IBgType iBgType = BgTypeFactory.getRemoteInstance();
        BgTypeInfo info = iBgType.getBgTypeInfo("select id,name,number where id='c292cd11-00fb-1000-e000-0013c0a8129f530DC15D'");
        this.bizBgType.setData((Object)info);
        BgTypeDialogForFill f7 = new BgTypeDialogForFill((IUIObject)this);
        this.bizBgType.setSelector((KDPromptSelector)f7);
    }

    protected class Type {
        public int intType;
        String typeName;

        public Type(int type, String name) {
            this.intType = type;
            this.typeName = name;
        }

        public String toString() {
            return this.typeName;
        }
    }
}

