/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.eas.fi.rpt.TableToolkit;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class BlockMapingData
implements Serializable {
    private String easColRange = null;
    private String easRowRange = null;
    private String jqRowRange = null;
    private String jqColRange = null;
    public String blockMaping = null;

    public BlockMapingData(String blockMaping) {
        this.blockMaping = blockMaping;
    }

    public BlockMapingData() {
    }

    public void setEasRowRange(String str) {
        this.easRowRange = str;
    }

    public void setEasColRange(String str) {
        this.easColRange = str;
    }

    public void setJQRowRange(String str) {
        this.jqRowRange = str;
    }

    public void setJQColRange(String str) {
        this.jqColRange = str;
    }

    public String getEasRowRange() {
        return this.easRowRange;
    }

    public String getEasColRange() {
        return this.easColRange;
    }

    public String getJQRowRange() {
        return this.jqRowRange;
    }

    public String getJQColRange() {
        return this.jqColRange;
    }

    public String toString() {
        if (this.blockMaping != null) {
            return this.blockMaping;
        }
        return "{" + this.jqRowRange + "}{" + this.jqColRange + "}={" + this.easRowRange + "}{" + this.easColRange + "}";
    }

    public void writeBlockMapingData(OutputStreamWriter writer) throws IOException {
        writer.write(this.toString());
    }

    public boolean check() {
        return true;
    }

    private ArrayList procesStringToList(String str, boolean isNumberFormed) throws Exception {
        ArrayList<Node> list = new ArrayList<Node>();
        StringTokenizer token = new StringTokenizer(str, ",");
        while (token.hasMoreElements()) {
            String element = token.nextToken();
            if (element.indexOf(126) == -1) {
                SingleNode node = new SingleNode();
                node.value = isNumberFormed ? Integer.parseInt(element.trim()) : TableToolkit.pos2int(element.trim());
                list.add(node);
                continue;
            }
            StringTokenizer subToken = new StringTokenizer(element, "~");
            int index = 0;
            Range range = new Range();
            while (subToken.hasMoreElements()) {
                String subElement = subToken.nextToken();
                if (++index > 2) {
                    throw new Exception("ERROR : ~");
                }
                if (index == 1) {
                    range.start = isNumberFormed ? Integer.parseInt(subElement.trim()) : TableToolkit.pos2int(subElement.trim());
                    continue;
                }
                range.end = isNumberFormed ? Integer.parseInt(subElement.trim()) : TableToolkit.pos2int(subElement.trim());
            }
            list.add(range);
        }
        return list;
    }

    private class SingleNode
    extends Node {
        private int value;

        private SingleNode() {
        }

        @Override
        public boolean equals(Node node) {
            return node instanceof SingleNode;
        }
    }

    private class Range
    extends Node {
        int start;
        int end;

        private Range() {
        }

        int getRangeSize() {
            return Math.abs(this.start - this.end);
        }

        @Override
        public boolean equals(Node node) {
            if (node instanceof Range) {
                return this.getRangeSize() == ((Range)node).getRangeSize();
            }
            return false;
        }
    }

    private abstract class Node {
        private Node() {
        }

        public abstract boolean equals(Node var1);
    }
}

