/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.client.AbstractCSLTreeSelUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;

public class CSLTreeSelUI
extends AbstractCSLTreeSelUI {
    private static final Logger logger = CoreUIObject.getLogger(CSLTreeSelUI.class);
    private OrgTreeCollection orgTreeColl;

    public void onLoad() throws Exception {
        this.refreshOrgBound();
    }

    private void refreshOrgBound() throws Exception {
        OrgTreeCollection otc = CslRptUIUtil.getOrgTreeCollection((Date)((Date)this.getUIContext().get("date")));
        if (otc == null) {
            return;
        }
        ArrayList<String> orgTreeIDList = new ArrayList<String>();
        OrgTreeInfo info = null;
        for (int i = 0; i < otc.size(); ++i) {
            info = otc.get(i);
            if (info.isIsHide() || info.getLayerType() == OrgViewType.PROFITCENTER || UnionVersionStatusEnum.UNSTART.equals((Object)info.getStatus())) continue;
            orgTreeIDList.add(info.getId().toString());
        }
        this.cmbOrgBound.removeAllItems();
        if (!orgTreeIDList.isEmpty()) {
            OrgUnitInfo currentOrgUnitInfo = (OrgUnitInfo)this.getUIContext().get("company");
            this.orgTreeColl = this.getOrgTreeCollectionByCompanyPK(CslRptUtil.getPK((IObjectValue)currentOrgUnitInfo), orgTreeIDList);
            if (this.orgTreeColl != null && this.orgTreeColl.size() != 0) {
                this.cmbOrgBound.addItems(this.orgTreeColl.toArray());
            }
            if (this.orgTreeColl.size() == 1) {
                this.orgTreeColl.get(0).put("isOnlyOrgTree", (Object)true);
            }
            this.setUserObject(this.orgTreeColl.get(0));
        }
    }

    private String getOrgTreeSQLByCompanyPK(IObjectPK companyPK, ArrayList orgTreeIDList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT tree.fid ").append("FROM T_ORG_Tree tree ").append("INNER JOIN T_ORG_STRUCTURE structure ON structure.FTreeId =tree.fid ").append("WHERE structure.FunitId='").append(companyPK).append("' and tree.FTYPE=8 ").append("and tree.fid in (").append(CslRptUtil.collection2String((Collection)orgTreeIDList, (String)",", (boolean)true)).append(")");
        return sql.toString();
    }

    private OrgTreeCollection getOrgTreeCollectionByCompanyPK(IObjectPK companyPK, ArrayList orgTreeIDList) throws BOSException {
        if (!StringUtils.isEmpty((String)companyPK.toString())) {
            String permFilterSql = this.getOrgTreeSQLByCompanyPK(companyPK, orgTreeIDList);
            OrgTreeCollection coll = OrgTreeFactory.getRemoteInstance().getOrgTreeCollection("select id,name,status,startDate,endDate,number where id in (" + permFilterSql + ")");
            return coll;
        }
        return null;
    }

    @Override
    protected void cmdOK_actionPerformed(ActionEvent e) throws Exception {
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.cmbOrgBound.getSelectedItem();
        if (orgTreeInfo == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"904_CSLTreeSelUI"));
        } else {
            orgTreeInfo.put("isOnlyOrgTree", (Object)true);
            this.setUserObject(orgTreeInfo);
            this.getUIWindow().close();
        }
    }

    @Override
    protected void cmdCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setUserObject(null);
        this.getUIWindow().close();
    }
}

