/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.CashFlowFilterPara;
import com.kingdee.eas.fi.gl.GLFlagFactory;
import com.kingdee.eas.fi.gl.client.CashFlowListUI;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.newrpt.OrgUnitConvtHelper;
import com.kingdee.eas.fi.rpt.AcctCashQueryFacadeFactory;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.client.FormulaStructure;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CashFlowFormulaStructure
extends FormulaStructure {
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final Logger logger = Logger.getLogger(CashFlowFormulaStructure.class);
    String company;
    String oppCompany;
    int startYear;
    int endYear;
    int startFiscal;
    int endFiscal;
    Date startDate;
    Date endDate;
    String currencyId;
    String project;
    HashMap items;
    boolean isOnlyUnion = false;
    String oppAccount;
    CurrencyInfo currencyInfo = null;
    boolean hasCombineInitValue = false;
    private String accountAndItem = null;

    public CashFlowFormulaStructure(String formula) {
        super(formula);
    }

    public CashFlowFormulaStructure(FormulaHint hint) {
        super(hint);
    }

    public void parseAccountItem(String accountAndItem) {
        this.accountAndItem = accountAndItem;
        StringTokenizer accountandItemToken = new StringTokenizer(accountAndItem, "|");
        if (accountandItemToken.hasMoreElements()) {
            this.project = accountandItemToken.nextToken();
        }
        while (accountandItemToken.hasMoreElements()) {
            String temptype = null;
            String temptypeItem = null;
            String[] temptypeItemList = new String[2];
            if (this.items == null) {
                this.items = new HashMap();
            }
            temptype = accountandItemToken.nextToken();
            if (accountandItemToken.hasMoreElements()) {
                temptypeItem = accountandItemToken.nextToken();
                StringTokenizer temptypeItemToken = new StringTokenizer(temptypeItem, ":");
                int i = 0;
                while (temptypeItemToken.hasMoreElements()) {
                    temptypeItemList[i] = temptypeItemToken.nextToken();
                    ++i;
                }
            }
            this.items.put(temptype, temptypeItemList);
        }
    }

    @Override
    public void openUI() throws Exception {
        if (this.type.equals("10")) {
            String filterString = null;
            FilterInfo filterParam = new FilterInfo();
            boolean isInCash = false;
            if (this.items != null) {
                Iterator iterator = this.items.entrySet().iterator();
                Object info = null;
                String[] value = null;
                String asst = "";
                if (iterator.hasNext()) {
                    Map.Entry itm = iterator.next();
                    String number = (String)itm.getKey();
                    if (number.equals("C")) {
                        asst = "customer";
                        isInCash = true;
                        value = (String[])itm.getValue();
                    } else if (number.equals("S")) {
                        asst = "provider";
                        isInCash = true;
                        value = (String[])itm.getValue();
                    } else if (number.equals("I")) {
                        isInCash = true;
                        asst = "companyOrg";
                        value = (String[])itm.getValue();
                    } else {
                        filterParam = AcctCashQueryFacadeFactory.getRemoteInstance().submitAssistantQuery(this.accountAndItem, this.oppAccount);
                    }
                }
                if (isInCash && this.oppCompany != null && this.oppCompany.trim().length() > 0) {
                    filterString = asst.equals("customer") || asst.equals("provider") ? "voucher.entries.cashflowRecords.assGrp." + asst + ".internalCompany.id" : "voucher.entries.cashflowRecords.assGrp." + asst + ".id";
                    filterParam = new FilterInfo();
                    filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)this.oppCompany));
                }
                if (value != null && value[0] != null && isInCash) {
                    filterString = "voucher.entries.cashflowRecords.assGrp." + asst + ".number";
                    if (value[1] == null) {
                        filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)value[0]));
                    } else {
                        filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)value[0], CompareType.GREATER_EQUALS));
                        filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)value[1], CompareType.LESS_EQUALS));
                    }
                }
                if (isInCash) {
                    filterString = "voucher.entries.cashflowRecords.type";
                    filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)3));
                }
            }
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("*"));
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)this.project));
            CashFlowItemCollection collect = CashFlowItemFactory.getRemoteInstance().getCashFlowItemCollection(view);
            CashFlowItemInfo item = null;
            if (collect == null || collect != null && collect.size() == 0) {
                return;
            }
            item = collect.get(0);
            if (item.isIsProfit()) {
                filterParam.getFilterItems().add(new FilterItemInfo("voucher.entries.account.PLType", (Object)new Integer(0), CompareType.NOTEQUALS));
                FilterInfo filterParam2 = new FilterInfo(" voucher.entries.account.id not in(select fdiffaccountid from t_bd_cashflowaccountdiff)");
                filterParam.mergeFilter(filterParam2, "and");
            }
            CashFlowFilterPara cashFlowFilterPara = this.getCashFlowFilterPara();
            UIContext uiContext = new UIContext((Object)this.getParentUI());
            uiContext.put((Object)"cashFlowListConditon", (Object)cashFlowFilterPara);
            if (!item.isIsProfit()) {
                uiContext.put((Object)"item", (Object)item);
            }
            uiContext.put((Object)"filter", (Object)filterParam);
            uiContext.put((Object)"company", (Object)this.companyOrg);
            if (item != null) {
                String change = item.getId().toString();
                if (filterParam != null) {
                    change = change + filterParam.toSql();
                }
                uiContext.put((Object)change, (Object)"");
            }
            CashFlowListUI.showCashFlow((Map)uiContext);
        } else {
            MsgBox.showWarning((Component)((CoreUI)this.getUIContext().get((Object)"Owner")), (String)RptUtil.getReportResource("Only_CashFlow"));
            this.isCanshow = false;
        }
    }

    private CashFlowFilterPara getCashFlowFilterPara() {
        if (!this.companyOrg.isIsBizUnit()) {
            return null;
        }
        CashFlowFilterPara cashFlowFilterPara = new CashFlowFilterPara();
        if ("ACCTCASH".equalsIgnoreCase(this.formulaType) || "INCASHFLOW".equalsIgnoreCase(this.formulaType)) {
            cashFlowFilterPara.setYearFrom((short)this.startYear);
            cashFlowFilterPara.setYearTo((short)this.endYear);
            cashFlowFilterPara.setMonthFrom((short)this.startFiscal);
            cashFlowFilterPara.setMonthTo((short)this.endFiscal);
        }
        if ("ACCTCASHEXT".equalsIgnoreCase(this.formulaType)) {
            cashFlowFilterPara.setDateFrom(this.startDate);
            cashFlowFilterPara.setDateTo(this.endDate);
            cashFlowFilterPara.setTermOrDate(false);
        }
        cashFlowFilterPara.setCurrency(this.currencyInfo);
        cashFlowFilterPara.setCurrencyId(this.currencyId);
        cashFlowFilterPara.setDisplayAsst(true);
        cashFlowFilterPara.setAllVoucher(this.rptSheetParam.isIsIncludingUnposted());
        cashFlowFilterPara.setSelectedCompanyId(this.companyOrg.getId().toString());
        return cashFlowFilterPara;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String getProject() {
        return this.project;
    }

    public int getEndFiscal() {
        return this.endFiscal;
    }

    public void setEndFiscal(int endFiscal) {
        this.endFiscal = endFiscal;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public HashMap getItems() {
        return this.items;
    }

    public void setItems(HashMap items) {
        this.items = items;
    }

    public int getStartFiscal() {
        return this.startFiscal;
    }

    public void setStartFiscal(int startFiscal) {
        this.startFiscal = startFiscal;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    @Override
    public void structure() throws Exception {
        this.checkParameter();
        this.company = (String)this.parameter.get(0);
        if (this.company != null && this.company.trim().length() > 0) {
            this.companyOrg = RptUtilForClient.getCompanyOrgUnitInfoByNumber(this.company);
            if (this.companyOrg == null) {
                if (TableToolkit.isCellRef(this.company)) {
                    MsgBox.showError((String)RptUtil.getReportResource("RPT_NOSUPPORT_LEDGE"));
                } else {
                    MsgBox.showError((String)RptUtil.getResourceSince51("NoExistsCompany"));
                }
                SysUtil.abort();
            }
            this.company = this.companyOrg.getId().toString();
            this.isOnlyUnion = this.companyOrg.isIsOnlyUnion();
            if (!this.companyOrg.getId().equals((Object)this.report.getCompany().getId())) {
                MsgBox.showError((String)RptUtil.getReportResource("RPT_NON_REPORT_COMPANY_NOSUPPORT_LEDGE"));
                SysUtil.abort();
            }
        } else {
            this.companyOrg = OrgUnitConvtHelper.convtFullToCompanyByRemote(null, (FullOrgUnitInfo)this.report.getCompany());
            this.companyOrg = RptUtilForClient.getCompanyOrgUnitInfoByNumber(this.companyOrg.getNumber());
            this.company = this.companyOrg.getId().toString();
            this.isOnlyUnion = this.companyOrg.isIsOnlyUnion();
        }
        if ("ACCTCASH".equalsIgnoreCase(this.formulaType)) {
            this.setAcctCashStructure();
            if (this.hasCombineInitValue) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"95_CashFlowFormulaStructure"));
                SysUtil.abort();
            }
        } else if ("ACCTCASHEXT".equalsIgnoreCase(this.formulaType)) {
            this.setAcctCashExtStructure();
        }
    }

    private void checkParameter() {
        if ("ACCTCASH".equalsIgnoreCase(this.formulaType)) {
            if (this.parameter == null || this.parameter.isEmpty() || this.parameter.size() != 7 && this.parameter.size() != 8) {
                MsgBox.showError((String)RptUtil.getReportResource("RPT_LEDGER_ERROR"));
                SysUtil.abort();
            }
        } else if ("ACCTCASHEXT".equalsIgnoreCase(this.formulaType) && (this.parameter == null || this.parameter.isEmpty() || this.parameter.size() != 5)) {
            MsgBox.showError((String)RptUtil.getReportResource("RPT_LEDGER_ERROR"));
            SysUtil.abort();
        }
    }

    private void setAcctCashStructure() throws Exception {
        Integer Period_Type = new Integer(this.report.getPeriodType().getValue());
        String temp = (String)this.parameter.get(3);
        try {
            this.startYear = Integer.parseInt(temp);
        }
        catch (Exception e) {
            this.startYear = 0;
        }
        if (this.startYear <= 0) {
            this.startYear = this.rptSheetParam.getStartYear() + this.startYear;
            if (this.startYear <= 0) {
                this.startYear = this.report.getYear() + this.startYear;
            }
        }
        String temp2 = (String)this.parameter.get(4);
        try {
            this.startFiscal = Integer.parseInt(temp2);
        }
        catch (Exception e) {
            this.startFiscal = 0;
        }
        if (this.startFiscal <= 0) {
            this.startFiscal = this.rptSheetParam.getStartPeriod() + this.startFiscal;
            if (this.startFiscal <= 0) {
                this.startFiscal = this.report.getPeriod() + this.startFiscal;
            }
            if (this.startFiscal <= 0) {
                --this.startYear;
                this.startFiscal += PeriodUtils.getMaxPeriodNumber(null, (int)this.startYear, (String)this.companyOrg.getId().toString());
            } else if (Period_Type != null && (Period_Type != 3 || this.startFiscal <= 12)) {
                Date periodLastDate = RPTDateUtil.getPeriodFirstDate((int)this.startYear, (int)this.startFiscal, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)Period_Type));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(periodLastDate);
                this.startYear = calendar.get(1);
                this.startFiscal = calendar.get(2) + 1;
            }
        }
        String temp3 = (String)this.parameter.get(3);
        try {
            this.endYear = Integer.parseInt(temp3);
        }
        catch (Exception e) {
            this.endYear = 0;
        }
        if (this.endYear <= 0) {
            this.endYear = this.rptSheetParam.getEndYear() + this.endYear;
            if (this.endYear <= 0) {
                this.endYear = this.report.getYear() + this.endYear;
            }
        }
        String temp4 = (String)this.parameter.get(5);
        try {
            this.endFiscal = Integer.parseInt(temp4);
        }
        catch (Exception e) {
            this.endFiscal = 0;
        }
        if (this.endFiscal <= 0) {
            this.endFiscal = this.rptSheetParam.getEndPeriod() + this.endFiscal;
            if (this.endFiscal <= 0) {
                this.endFiscal = this.report.getPeriod() + this.endFiscal;
            }
            if (this.endFiscal <= 0) {
                --this.endYear;
                this.endFiscal += PeriodUtils.getMaxPeriodNumber(null, (int)this.startYear, (String)this.companyOrg.getId().toString());
            } else if (Period_Type != null) {
                Calendar calendar = Calendar.getInstance();
                if (Period_Type != 3 || this.endFiscal <= 12) {
                    Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)this.endYear, (int)this.endFiscal, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)Period_Type));
                    calendar.setTime(periodLastDate);
                    this.endYear = calendar.get(1);
                    this.endFiscal = calendar.get(2) + 1;
                }
            }
        }
        if (this.endYear < this.startYear) {
            int t = this.startYear;
            this.startYear = this.endYear;
            this.endYear = t;
        } else if (this.endFiscal < this.startFiscal) {
            int t = this.startFiscal;
            this.startFiscal = this.endFiscal;
            this.endFiscal = t;
        }
        String tempcurrency = (String)this.parameter.get(2);
        this.currencyInfo = tempcurrency == null || tempcurrency.trim().length() == 0 ? (this.rptSheetParam.getCurrency() != null ? this.rptSheetParam.getCurrency() : this.report.getCurrency()) : RptUtilForClient.getCurrency(tempcurrency);
        if (this.currencyInfo == null) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("CurrencyOutOfPlace"));
            SysUtil.abort();
        }
        this.currencyId = this.currencyInfo.getId().toString();
        this.parseAccountItem((String)this.parameter.get(6));
        if (this.parameter.size() > 7) {
            this.oppAccount = (String)this.parameter.get(7);
            if (this.oppAccount.contains(":") || this.oppAccount.contains("|")) {
                MsgBox.showError((String)RptUtil.getReportResource("NOT_SUPPORT_OPPACCOUNT"));
                SysUtil.abort();
            }
        }
        if (this.company != null) {
            boolean isClose;
            if (this.items != null && this.items.size() > 0) {
                this.hasCombineInitValue = false;
            }
            if (!(isClose = GLFlagFactory.getRemoteInstance().getCashflowInitClosed(this.company))) {
                this.hasCombineInitValue = false;
                return;
            }
            PeriodInfo beginPeriod = SystemStatusCtrolFactory.getRemoteInstance().getStartPeriod(6, this.company);
            if (1 == this.startFiscal && this.startYear == beginPeriod.getPeriodYear()) {
                this.hasCombineInitValue = true;
                return;
            }
        }
    }

    private void setAcctCashExtStructure() throws Exception {
        String endDateParam;
        String tempcurrency = (String)this.parameter.get(1);
        this.currencyInfo = tempcurrency == null || tempcurrency.trim().length() == 0 ? (this.rptSheetParam.getCurrency() != null ? this.rptSheetParam.getCurrency() : this.report.getCurrency()) : RptUtilForClient.getCurrency(tempcurrency.toUpperCase());
        if (this.currencyInfo == null) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("CurrencyOutOfPlace"));
            SysUtil.abort();
        }
        this.currencyId = this.currencyInfo.getId().toString();
        String startDateParam = (String)this.parameter.get(2);
        DateFormat format = CslRptUIUtil.getNationalDateFormat();
        if (!StringUtils.isEmpty((String)startDateParam)) {
            try {
                this.startDate = format == null ? BatchHelper.dateFormat.parse(startDateParam) : BatchHelper.dateFormat.parse(BatchHelper.dateFormat.format(format.parse(startDateParam)));
            }
            catch (Exception e) {
                logger.error((Object)"startDate_parseError:", (Throwable)e);
                startDateParam = null;
            }
        }
        if (StringUtils.isEmpty((String)startDateParam)) {
            this.startDate = this.rptSheetParam.getStartDate();
            if (this.startDate == null && !RptPeriodTypeEnum.DAILY.equals((Object)this.report.getPeriodType())) {
                this.startDate = CashFlowFormulaStructure.getDateByYearPeriod(null, this.companyOrg.getId().toString(), true, this.rptSheetParam.getStartYear(), this.rptSheetParam.getStartPeriod(), this.report.getYear(), this.report.getPeriod(), this.report.getPeriodType());
                if (this.startDate == RPTDateUtil.NON_PERIOD_BE_FOUND) {
                    MsgBox.showInfo((String)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"58_CsRefBatchCalculater", (Locale)SysContext.getSysContext().getLocale()));
                    SysUtil.abort();
                }
            }
            if (this.startDate == null) {
                this.startDate = this.report.getStartDate();
            }
        }
        if (!StringUtils.isEmpty((String)(endDateParam = (String)this.parameter.get(3)))) {
            try {
                this.endDate = format == null ? dateFormat.parse(endDateParam) : BatchHelper.dateFormat.parse(BatchHelper.dateFormat.format(format.parse(endDateParam)));
            }
            catch (Exception e) {
                logger.error((Object)"endDate_parseError:", (Throwable)e);
                endDateParam = null;
            }
        }
        if (StringUtils.isEmpty((String)endDateParam)) {
            this.endDate = this.rptSheetParam.getEndDate();
            if (this.endDate == null && !RptPeriodTypeEnum.DAILY.equals((Object)this.report.getPeriodType())) {
                this.endDate = CashFlowFormulaStructure.getDateByYearPeriod(null, this.companyOrg.getId().toString(), false, this.rptSheetParam.getEndYear(), this.rptSheetParam.getEndPeriod(), this.report.getYear(), this.report.getPeriod(), this.report.getPeriodType());
                if (this.endDate == RPTDateUtil.NON_PERIOD_BE_FOUND) {
                    MsgBox.showInfo((String)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"58_CsRefBatchCalculater", (Locale)SysContext.getSysContext().getLocale()));
                    SysUtil.abort();
                }
            }
            if (this.endDate == null) {
                this.endDate = this.report.getEndDate();
            }
        }
        this.parseAccountItem((String)this.parameter.get(4));
    }

    public static Date getDateByYearPeriod(Context ctx, String companyId, boolean isStartDate, int year, int period, int defaultYear, int defaultPeriod, RptPeriodTypeEnum periodType) throws BOSException, EASBizException {
        if (year == 0 && period == 0) {
            return null;
        }
        if (periodType == null) {
            return RPTDateUtil.NON_PERIOD_BE_FOUND;
        }
        if (year <= 0 && (year = defaultYear + year) <= 0) {
            return RPTDateUtil.NON_PERIOD_BE_FOUND;
        }
        if (period <= 0) {
            period = defaultPeriod + period > 0 ? defaultPeriod + period : defaultPeriod + period - 1;
        }
        return RPTDateUtil.getDateByYearOrPreYear((Context)ctx, (String)companyId, null, (int)year, (int)period, (boolean)isStartDate);
    }
}

