/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.PublicStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptHandleStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.AbstractCustomListUI;
import com.kingdee.eas.fi.rpt.client.CustomQueryUI;
import com.kingdee.eas.fi.rpt.client.RptReportProcessUI;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class CustomListUI
extends AbstractCustomListUI {
    private static final Logger logger = CoreUIObject.getLogger(CustomListUI.class);
    CommonQueryDialog conditionDialog = null;
    CustomQueryUI conditionPanel = null;
    Map mapParams = null;

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private void searchReport(Map mapParams, EntityViewInfo mainQuery) throws Exception {
        Map sumMap;
        HashMap mapBase = (HashMap)mapParams.get("KEY_BASE");
        TemplateInfo templateInfo = (TemplateInfo)mapBase.get("template");
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)mapBase.get("periodType");
        int year = new Integer((String)mapBase.get("year"));
        int period = new Integer((String)mapBase.get("period"));
        Date reportDate = (Date)mapBase.get("KEY_BASE_DATE");
        HashMap mapCompany = (HashMap)mapParams.get("KEY_COMPANY");
        HashMap map = null;
        ArrayList companyList = new ArrayList();
        if (!mapCompany.isEmpty()) {
            int size = mapCompany.size();
            for (int i = 0; i < size; ++i) {
                map = (HashMap)mapCompany.get(new Integer(i));
                companyList.add(map.get("KEY_COMPANY_ID"));
            }
        }
        if (companyList == null || companyList.size() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"102_CustomListUI"));
            SysUtil.abort();
        }
        if (templateInfo == null || templateInfo.getId() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"103_CustomListUI"));
            SysUtil.abort();
        }
        if (!((Boolean)(sumMap = ReportFactory.getRemoteInstance().getSumFromRela(companyList, templateInfo.getId().toString(), periodType, year, period)).get("isExistGroupRpt")).booleanValue()) {
            return;
        }
        if (!((Boolean)sumMap.get("isSum")).booleanValue()) {
            ArrayList rptList = (ArrayList)sumMap.get("groupRep");
            this.sumBySheet(templateInfo, rptList, year, period, reportDate);
        } else if (((Boolean)sumMap.get("isSum")).booleanValue()) {
            String sumReport = (String)sumMap.get("sumReport");
            this.openReport(sumReport);
            this.setQuery(sumReport);
        }
    }

    private void setQuery(String sumReportId) {
        FilterInfo filter = new FilterInfo();
        if (StringUtil.isEmptyString((String)sumReportId)) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sumReportId, CompareType.EQUALS));
        }
        this.mainQuery.setFilter(filter);
    }

    private void sumBySheet(TemplateInfo templateInfo, ArrayList rptList, int year, int period, Date reportDate) throws Exception {
        int i;
        Book book;
        IReport calculator = ReportFactory.getRemoteInstance();
        ReportInfo info = ReportFactory.getRemoteInstance().getReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rptList.get(0).toString())));
        int precision = CslRptUIUtil.getPrecisionByCry((CurrencyInfo)info.getCurrency());
        Book curSheets = book = templateInfo.getBook();
        HashMap<String, Sheet> tables = new HashMap<String, Sheet>();
        HashMap<String, SumcalcRange> sheetIDs = new HashMap<String, SumcalcRange>();
        for (i = 0; i < curSheets.getSheetCount(); ++i) {
            Sheet tmpSheet = curSheets.getSheet(i);
            if (!tmpSheet.isEnableCalculation()) continue;
            sheetIDs.put(tmpSheet.getSheetName(), null);
            tables.put(tmpSheet.getSheetName(), tmpSheet);
        }
        for (i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            if (sheet == null) continue;
            String sheetName = sheet.getSheetName();
            SumcalcRange sumZone = (SumcalcRange)sheet.getUserObjectValue("SUMCALCZONE");
            if (!sheetIDs.containsKey(sheetName)) continue;
            sheetIDs.put(sheetName, sumZone);
        }
        HashMap result = calculator.calculateSumRptBySheets(rptList, sheetIDs);
        this.refreshTableData(tables, result, precision);
        String sumrptId = this.storeReport(rptList, templateInfo, book, info, year, period, reportDate);
        this.openReport(sumrptId);
        this.setQuery(sumrptId);
    }

    private void openReport(String sumrptId) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)sumrptId);
        uiContext.put((Object)"superParent", this.getUIContext().get("Owner"));
        uiContext.put((Object)"isView", (Object)Boolean.TRUE);
        uiContext.put((Object)"selectIds", null);
        uiContext.put((Object)"OpenReport", (Object)new Boolean(true));
        uiContext.put((Object)"CanEdit", (Object)Boolean.FALSE);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(RptReportProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void refreshTableData(Map sheets, Map sheetData, int precision) throws Exception {
        if (sheets == null || sheets.size() == 0 || sheetData == null || sheetData.size() == 0) {
            return;
        }
        for (String tableID : sheetData.keySet()) {
            if (tableID == null || tableID.trim().length() == 0) continue;
            Sheet curSheet = (Sheet)sheets.get(tableID);
            HashMap curSheetData = (HashMap)sheetData.get(tableID);
            Iterator iterCell = curSheetData.keySet().iterator();
            Object o = null;
            HashMap v = new HashMap();
            Cell cell = null;
            while (iterCell.hasNext()) {
                BigDecimal cellValue;
                Point position = (Point)iterCell.next();
                cell = curSheet.getCell(position.y, position.x, true);
                Variant oldValue = cell.getValue();
                BigDecimal old = null;
                try {
                    old = oldValue.toBigDecimal();
                }
                catch (Exception e) {
                    old = new BigDecimal("0");
                }
                Variant varValue = null;
                o = curSheetData.get(position);
                if (o != null && o instanceof HashMap) {
                    v = (HashMap)curSheetData.get(position);
                    if (v != null && v.get("value") != null) {
                        cellValue = ((BigDecimal)v.get("value")).setScale(2, 4);
                        varValue = new Variant((Object)cellValue.add(old));
                    } else {
                        varValue = Variant.nullVariant;
                    }
                } else if (o != null) {
                    cellValue = ((BigDecimal)o).setScale(2, 4);
                    varValue = new Variant((Object)cellValue.add(old));
                } else {
                    varValue = Variant.nullVariant;
                }
                if (varValue == null) {
                    varValue = Variant.nullVariant;
                }
                cell.setValue(varValue);
            }
        }
    }

    private Object deepClone(Book book) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bo);
        out.writeObject(book);
        ByteArrayInputStream boin = new ByteArrayInputStream(bo.toByteArray());
        ObjectInputStream in = new ObjectInputStream(boin);
        return in.readObject();
    }

    private String storeReport(ArrayList rptList, TemplateInfo temInfo, Book bookCopy, ReportInfo groupInfo, int year, int period, Date reportDate) throws IOException, BOSException, CodingRuleException, EASBizException {
        ReportInfo sumReport = new ReportInfo();
        sumReport.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        sumReport.setCreateTime(new Timestamp(System.currentTimeMillis()));
        sumReport.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        sumReport.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        sumReport.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        sumReport.setName(temInfo.getName());
        sumReport.setBook(bookCopy);
        sumReport.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        sumReport.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        sumReport.setAuditTime(null);
        sumReport.setCurrency(groupInfo.getCurrency());
        sumReport.setOrgTree(null);
        sumReport.setSourceType(RptSrcTypeEnum.SUM);
        sumReport.setHandleStatus(RptHandleStatusEnum.UNHANDLED);
        sumReport.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        sumReport.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        sumReport.setPublicStatus(PublicStatusEnum.PUBLIC);
        sumReport.setPeriodType(groupInfo.getPeriodType());
        sumReport.setCompany(temInfo.getCompany());
        sumReport.setTemplate(temInfo);
        sumReport.setAuditor(null);
        sumReport.setEndDate(new Timestamp(System.currentTimeMillis()));
        sumReport.setStartDate(reportDate);
        sumReport.setPeriod((short)period);
        sumReport.setYear(year);
        sumReport.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        sumReport.setCslReport(null);
        sumReport.setIsOpenAutoCalc(false);
        sumReport.setExchangeRate(groupInfo.getExchangeRate());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (iCodingRuleManager.getCodingRule((IObjectValue)sumReport, temInfo.getCU().getId().toString()) != null) {
            sumReport.setNumber(iCodingRuleManager.readNumber((IObjectValue)sumReport, temInfo.getCU().getId().toString()));
        } else {
            String s = temInfo.getNumber() + System.currentTimeMillis();
            sumReport.setNumber(s);
        }
        IObjectPK pk = ReportFactory.getRemoteInstance().addnew((CoreBaseInfo)sumReport);
        sumReport.setId(BOSUuid.read((String)pk.toString()));
        this.restoreRela(rptList, sumReport);
        return pk.toString();
    }

    private void restoreRela(ArrayList rptList, ReportInfo sumReport) throws EASBizException, BOSException {
        ReportFactory.getRemoteInstance().saveToSumRela(rptList, (IObjectValue)sumReport);
    }

    public CommonQueryDialog getConditionDialog() throws Exception {
        if (this.conditionDialog == null) {
            this.conditionDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.conditionDialog.setOwner((Component)((Object)this));
            }
            MetaDataPK mainQueryPK1 = new MetaDataPK("com.kingdee.eas.fi.rpt.app", "ReportQuery");
            this.conditionDialog.setQueryObjectPK((IMetaDataPK)mainQueryPK1);
            this.conditionDialog.setShowFilter(false);
            this.conditionDialog.setShowSorter(false);
            this.conditionDialog.setWidth(455);
            this.conditionDialog.setHeight(300);
            this.conditionDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"104_CustomListUI"));
            this.conditionDialog.addUserPanel((KDPanel)this.getConditionPanel());
            this.conditionDialog.setParentUIClassName("com.kingdee.eas.fi.rpt.Client.CustomeListUI");
            this.conditionDialog.setHeight(350);
        }
        return this.conditionDialog;
    }

    public CustomQueryUI getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new CustomQueryUI();
            this.conditionPanel.setPanelName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Title_Condition"));
        }
        return this.conditionPanel;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReportFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionEdit.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.actionRemove.setVisible(false);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"superParent", this.getUIContext().get("Owner"));
        uiContext.put((Object)"isView", (Object)Boolean.FALSE);
        uiContext.put((Object)"selectIds", (Object)this.getSelectIds());
        uiContext.put((Object)"OpenReport", (Object)new Boolean(true));
        uiContext.put((Object)"CanEdit", (Object)Boolean.FALSE);
        IUIWindow window2 = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(RptReportProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        window2.show();
    }

    private ArrayList getSelectIds() throws Exception {
        int selectRowCount = this.tblMain.getSelectManager().size();
        KDTSelectBlock selectBlock = null;
        ArrayList<Object> selectIds = new ArrayList<Object>();
        for (int i = 0; i < selectRowCount; ++i) {
            selectBlock = this.tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                String id = this.tblMain.getRow(j).getCell(0).getValue().toString();
                if (id == null || !this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)))) continue;
                selectIds.add(this.tblMain.getRow(j).getCell(0).getValue());
            }
        }
        return selectIds;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.getConditionDialog().show()) {
            EntityViewInfo mainQuery = this.getConditionDialog().getEntityViewInfoResult();
            this.mapParams = (HashMap)((CustomQueryUI)this.getConditionDialog().getUserPanel(0)).getParam();
            this.searchReport(this.mapParams, mainQuery);
        } else {
            SysUtil.abort();
        }
        this.tblMain.removeRows();
    }

    protected String getKeyFieldName() {
        return "Report.id";
    }
}

