/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.fi.gr.cslrpt.ICSLContext;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.client.AbstractCustomQueryUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CustomQueryUI
extends AbstractCustomQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(CustomQueryUI.class);
    private ICSLContext ctx = null;
    CommonQueryDialog conditionDialog = null;
    CustomQueryUI conditionPanel = null;
    Map mapParams = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.ctx = CSLContextHelper.getCSLContext();
        this.initControl();
    }

    private Object deepClone(Book book) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bo);
        out.writeObject(book);
        ByteArrayInputStream boin = new ByteArrayInputStream(bo.toByteArray());
        ObjectInputStream in = new ObjectInputStream(boin);
        return in.readObject();
    }

    private void initControl() throws BOSException {
        this.bizRepTemp.setQueryInfo("com.kingdee.eas.fi.rpt.app.TemplateQuery");
        this.bizRepTemp.setEditFormat("$number$");
        this.bizRepTemp.setDisplayFormat("$name$");
        this.bizRepTemp.setEditable(true);
        this.bizRepTemp.setCommitFormat("$number$");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(new FilterItemInfo("isGroup", (Object)new Integer(0), CompareType.EQUALS));
        viewInfo.setFilter(info);
        this.bizRepTemp.setEntityViewInfo(viewInfo);
        this.initPeriodType();
        this.dpkRepDate.setEnabled(true);
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    private void initPeriodType() {
        Iterator iter = RptPeriodTypeEnum.iterator();
        while (iter.hasNext()) {
            this.cmbPeriodType.addItem(iter.next());
        }
    }

    @Override
    protected void dpkRepDate_dataChanged(DataChangeEvent e) throws Exception {
        super.dpkRepDate_dataChanged(e);
        this.refreshTimeInfo(this.dpkRepDate.getSqlDate());
    }

    private void refreshTimeInfo(Date newDate) {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.cmbPeriodType.getSelectedItem();
        if (p == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod((Date)newDate, (RptPeriodTypeEnum)p);
        this.lblYear.setText(new Integer(times.get(0).toString()).toString());
        this.lblPeriod.setText(new Integer(times.get(1).toString()).toString());
        this.dpkRepDate.setValue(times.get(2));
    }

    @Override
    protected void cmbPeriodType_actionPerformed(ActionEvent e) throws Exception {
        super.cmbPeriodType_actionPerformed(e);
        this.refreshTimeInfo(this.dpkRepDate.getSqlDate());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemove_actionPerformed(e);
    }

    @Override
    public void actionAddCompay_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddCompay_actionPerformed(e);
        OrgUnitInfo orgUnit = this.ctx.getCurOrgGroup();
        Object[] arrObj = this.showOrgUnitAndSubTree((IUIObject)this, orgUnit, true);
        this.addArrayValueToTable(this.kDTable1, arrObj);
    }

    private void addArrayValueToTable(KDTable kdt, Object[] arrObj) {
        if (arrObj == null) {
            return;
        }
        int arrCount = arrObj.length;
        for (int i = 0; i < arrCount; ++i) {
            this.adObjValueToTable(kdt, arrObj[i]);
        }
    }

    private Object[] showOrgUnitAndSubTree(IUIObject owner, OrgUnitInfo rootInfo, boolean isMultiSelect) {
        NewCompanyF7 f7 = new NewCompanyF7((IUIObject)this);
        f7.setRootUnitID("00000000-0000-0000-0000-000000000000CCE7AED4");
        f7.setMultiSelect(isMultiSelect);
        f7.show();
        if (f7.isCanceled()) {
            return null;
        }
        Object[] objArray = (Object[])f7.getData();
        if (objArray == null) {
            return new Object[0];
        }
        return objArray;
    }

    private void adObjValueToTable(KDTable kdt, Object obj) {
        IRow row = null;
        if (obj instanceof HashMap) {
            HashMap mapTmp = (HashMap)obj;
            if (this.isExistsDouble(kdt, mapTmp.get("KEY_COMPANY_ID").toString())) {
                return;
            }
            row = kdt.addRow();
            row.getCell(0).setValue(mapTmp.get("KEY_COMPANY_ID"));
            row.getCell(1).setValue(mapTmp.get("KEY_COMPANY_NUMBER"));
            row.getCell(2).setValue(mapTmp.get("KEY_COMPANY_NAME"));
        } else {
            OrgUnitInfo company = (OrgUnitInfo)obj;
            if (this.isExistsDouble(kdt, company.getId().toString())) {
                return;
            }
            row = kdt.addRow();
            row.getCell(0).setValue((Object)company.getId().toString());
            row.getCell(1).setValue((Object)company.getNumber());
            row.getCell(2).setValue((Object)company.getName());
            row.getCell(3).setValue((Object)company);
        }
    }

    private boolean isExistsDouble(KDTable kdt, String strID) {
        for (int i = 0; i < kdt.getRowCount(); ++i) {
            if (!kdt.getCell(i, 0).getValue().toString().equals(strID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionRemoveCompay_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveCompay_actionPerformed(e);
        this.deleteKdTableSelectedRows(this.kDTable1);
    }

    private void deleteKdTableSelectedRows(KDTable kdt) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)kdt);
        if (selectRows != null && selectRows.length > 0) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < selectRows.length; ++i) {
                list.add(kdt.getCell(selectRows[i], 0).getValue());
            }
            block1: while (list.size() > 0) {
                for (int j = 0; j < kdt.getRowCount(); ++j) {
                    if (!list.contains(kdt.getCell(j, 0).getValue())) continue;
                    list.remove(kdt.getCell(j, 0).getValue());
                    kdt.removeRow(j);
                    continue block1;
                }
            }
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        Object param = this.getFilterObject(cp, null);
        this.setParam(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFilterObject(CustomerParams cp, String key) {
        if (cp == null) {
            return null;
        }
        Object param = null;
        String objStr = null;
        objStr = key == null || key.length() == 0 ? cp.getCustomerParam("FilterParam") : cp.getCustomerParam(key);
        byte[] objByte = Base64.decode((String)objStr);
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])objByte);
            bais = new ObjectInputStream(is);
            param = bais.readObject();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        this.kDTable1.removeRows();
        HashMap mapAll = (HashMap)param;
        HashMap mapTmp = null;
        if (mapAll.containsKey("KEY_BASE")) {
            mapTmp = (HashMap)mapAll.get("KEY_BASE");
            this.bizRepTemp.setValue(mapTmp.get("template"));
            this.initPeriodType();
            this.cmbPeriodType.setSelectedItem(mapTmp.get("periodType"));
            this.lblYear.setText(mapTmp.get("year").toString());
            this.lblPeriod.setText(mapTmp.get("period").toString());
            this.dpkRepDate.setValue(mapTmp.get("KEY_BASE_DATE"));
        }
        if (mapAll.containsKey("KEY_COMPANY")) {
            mapTmp = (HashMap)mapAll.get("KEY_COMPANY");
            for (int i = 0; i < mapTmp.size(); ++i) {
                this.adObjValueToTable(this.kDTable1, mapTmp.get(new Integer(i)));
            }
        }
    }

    public Object getParam() {
        HashMap mapAll = new HashMap();
        HashMap<String, Object> mapTmp = new HashMap<String, Object>();
        HashMap<String, Object> mapBase = new HashMap<String, Object>();
        mapBase.put("template", this.bizRepTemp.getValue());
        mapBase.put("periodType", this.cmbPeriodType.getSelectedItem());
        mapBase.put("year", this.lblYear.getText());
        mapBase.put("period", this.lblPeriod.getText());
        mapBase.put("KEY_BASE_DATE", this.dpkRepDate.getValue());
        mapAll.put("KEY_BASE", mapBase);
        HashMap<Integer, HashMap<String, Object>> mapCompany = new HashMap<Integer, HashMap<String, Object>>();
        for (int i = 0; i < this.kDTable1.getRowCount(); ++i) {
            mapTmp = new HashMap();
            mapTmp.put("KEY_COMPANY_ID", this.kDTable1.getCell(i, 0).getValue());
            mapTmp.put("KEY_COMPANY_NUMBER", this.kDTable1.getCell(i, 1).getValue());
            mapTmp.put("KEY_COMPANY_NAME", this.kDTable1.getCell(i, 2).getValue());
            mapCompany.put(new Integer(i), mapTmp);
        }
        mapAll.put("KEY_COMPANY", mapCompany);
        return mapAll;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Object param = this.getParam();
        this.setFilterObject(cp, param, null);
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilterObject(CustomerParams cp, Object param, String key) {
        if (cp == null || param == null) {
            return;
        }
        byte[] objByte = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream out = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(param);
            objByte = ZipUtil.pack((ByteArrayOutputStream)baos);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
        }
        if (key == null || key.length() == 0) {
            cp.addCustomerParam("FilterParam", Base64.encodeBytes((byte[])objByte));
        } else {
            cp.addCustomerParam(key, Base64.encodeBytes((byte[])objByte));
        }
    }
}

