/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.rpt.client.FitchTreeNode;
import com.kingdee.eas.fi.rpt.client.FitchXMLParse;
import com.kingdee.eas.fi.rpt.client.IDataFitcher;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DataFitcher
implements IDataFitcher {
    private String fitcherFormatString = null;
    private Collection tbls = null;
    private FitchXMLParse fitchXMLParse = new FitchXMLParse();
    private FitchTreeNode fitchTreeNode = null;
    private FitchIterator fitchIterator = null;

    @Override
    public void bindTable(Collection obj) {
        this.tbls = obj;
    }

    @Override
    public void setFitcherString(String fter) {
        this.fitcherFormatString = fter;
        this.fitchTreeNode = this.fitchXMLParse.Parse(fter);
        this.fitchIterator = new FitchIterator();
    }

    @Override
    public String nextData() {
        FitchPoint fitchPoint = this.fitchIterator.next();
        if (fitchPoint != null) {
            Sheet tbl = (Sheet)fitchPoint.table;
            Variant obj = tbl.getCell(fitchPoint.row, fitchPoint.col, true).getValue();
            if (obj == null || obj.toString().trim().length() == 0) {
                return "0";
            }
            return tbl.getCell(fitchPoint.row, fitchPoint.col, true).getValue().toString().trim();
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.fitchIterator.hasNext();
    }

    private class Block {
        public int tableId;
        public int colFrom;
        public int colTo;
        public int rowFrom;
        public int rowTo;
        private int rowIndex = -1;
        private int colIndex = -1;

        private Block() {
        }

        public void reset() {
            int a = this.colFrom;
            int b = this.colTo;
            this.colTo = Math.max(a, b);
            this.colFrom = Math.min(a, b);
            a = this.rowFrom;
            b = this.rowTo;
            this.rowTo = Math.max(a, b);
            this.rowIndex = this.rowFrom = Math.min(a, b);
            this.colIndex = this.colFrom;
        }

        public boolean hasNext() {
            return this.rowIndex <= this.rowTo;
        }

        public FitchPoint next() {
            if (!this.hasNext()) {
                return null;
            }
            FitchPoint point = new FitchPoint();
            point.col = this.colIndex;
            point.row = this.rowIndex;
            point.table = null;
            if (DataFitcher.this.tbls != null) {
                Iterator it = DataFitcher.this.tbls.iterator();
                for (int i = 1; it.hasNext() && i != this.tableId; ++i) {
                    it.next();
                }
                if (it.hasNext()) {
                    point.table = it.next();
                } else {
                    MsgBox.showConfirm2((String)(RptUtil.getResourceSince51("ReportHeaderBindToTable") + "XML" + RptUtil.getResourceSince51("HasWhat") + "table id" + RptUtil.getResourceSince51("res_44")));
                    SysUtil.abort();
                }
            }
            ++this.colIndex;
            if (this.colIndex > this.colTo) {
                this.colIndex = this.colFrom;
                ++this.rowIndex;
            }
            return point;
        }
    }

    public class FitchIterator {
        private ArrayList blocks = new ArrayList();
        private int currentBlockIndex = 0;

        public FitchPoint next() {
            if (this.hasNext()) {
                Block block = (Block)this.blocks.get(this.currentBlockIndex);
                return block.next();
            }
            return null;
        }

        public boolean hasNext() {
            while (this.currentBlockIndex < this.blocks.size()) {
                Block block = (Block)this.blocks.get(this.currentBlockIndex);
                if (block.hasNext()) {
                    return true;
                }
                ++this.currentBlockIndex;
            }
            return false;
        }

        public FitchIterator() {
            ArrayList[] tempTables = null;
            if (DataFitcher.this.fitchTreeNode != null && DataFitcher.this.fitchTreeNode.getNodeName().equals("tables")) {
                Collection c = DataFitcher.this.fitchTreeNode.getSubNodes();
                tempTables = new ArrayList[c.size()];
                for (int i = 0; i < c.size(); ++i) {
                    tempTables[i] = new ArrayList();
                }
                for (FitchTreeNode tableNode : c) {
                    if (!tableNode.getNodeName().equals("table")) continue;
                    Collection c1 = tableNode.getSubNodes();
                    for (FitchTreeNode blocksNode : c1) {
                        if (!blocksNode.getNodeName().equals("blocks")) continue;
                        Collection c2 = blocksNode.getSubNodes();
                        for (FitchTreeNode blockNode : c2) {
                            Block block = new Block();
                            block.tableId = Integer.parseInt(tableNode.getProperty("id"));
                            block.colFrom = Integer.parseInt(blockNode.getProperty("colfrom"));
                            block.colTo = Integer.parseInt(blockNode.getProperty("colto"));
                            block.rowFrom = Integer.parseInt(blockNode.getProperty("rowfrom"));
                            block.rowTo = Integer.parseInt(blockNode.getProperty("rowto"));
                            block.reset();
                            if (block.tableId <= tempTables.length) {
                                tempTables[block.tableId - 1].add(block);
                                continue;
                            }
                            MsgBox.showConfirm2((String)(RptUtil.getResourceSince51("ReportHeaderBindToTable") + "XML" + RptUtil.getResourceSince51("HasWhat") + "table id" + RptUtil.getResourceSince51("res_44")));
                            SysUtil.abort();
                        }
                    }
                }
            }
            if (tempTables != null) {
                for (int j = 0; j < tempTables.length; ++j) {
                    this.blocks.addAll(tempTables[j]);
                }
            }
        }
    }

    private class FitchPoint {
        public int col;
        public int row;
        public Object table;

        private FitchPoint() {
        }
    }
}

