/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.IFormulaValidate;
import com.kingdee.eas.fi.rpt.ValidatorResults;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultValidator
implements IFormulaValidate {
    private String formulaName;
    private Map values;
    private ValidatorResults results;
    private static Logger logger = Logger.getLogger(DefaultValidator.class);

    public static boolean compareDateLessEquals(String startDate, String endDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        DateFormat format = CslRptUIUtil.getNationalDateFormat();
        Date date1 = null;
        Date date2 = null;
        try {
            if (StringUtils.isEmpty((String)startDate) || StringUtils.isEmpty((String)endDate)) {
                return true;
            }
            if (format != null) {
                date1 = formatter.parse(formatter.format(format.parse(startDate)));
                date2 = formatter.parse(formatter.format(format.parse(endDate)));
            } else {
                date1 = formatter.parse(startDate);
                date2 = formatter.parse(endDate);
            }
            return !date2.before(date1);
        }
        catch (ParseException e) {
            logger.debug((Object)e.getMessage());
            logger.error((Object)e);
            return false;
        }
    }

    public boolean compareYearMonthLessEquals() {
        if (this.formulaName.equalsIgnoreCase("acct")) {
            return this.validateAcctCompareYearMonthLessEquals();
        }
        return false;
    }

    private boolean validateAcctCompareYearMonthLessEquals() {
        String startYear = (String)this.values.get("startYear");
        String startPeriod = (String)this.values.get("startPeriod");
        String endYear = (String)this.values.get("endYear");
        String endPeriod = (String)this.values.get("endPeriod");
        boolean isvalid = false;
        try {
            int ep;
            int sy = StringUtils.isEmpty((String)startYear) ? 0 : Integer.parseInt(startYear);
            int sp = StringUtils.isEmpty((String)startPeriod) ? 0 : Integer.parseInt(startPeriod);
            int ey = StringUtils.isEmpty((String)endYear) ? 0 : Integer.parseInt(endYear);
            int n = ep = StringUtils.isEmpty((String)endPeriod) ? 0 : Integer.parseInt(endPeriod);
            isvalid = sy > ey ? false : sy != ey || sp <= ep;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!isvalid) {
            this.results.addValidateResult(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"105_DefaultValidator"));
        }
        return isvalid;
    }

    public boolean validateAgeFromToValue(String from, String to) throws Exception {
        boolean isvalid = true;
        int fromv = 0;
        int tov = 0;
        if (!StringUtils.isEmpty((String)from)) {
            try {
                fromv = Integer.parseInt(from);
            }
            catch (Throwable t) {
                return false;
            }
        }
        if (!StringUtils.isEmpty((String)to)) {
            try {
                tov = Integer.parseInt(to);
            }
            catch (Throwable t) {
                return false;
            }
        }
        if (!StringUtils.isEmpty((String)from) && !StringUtils.isEmpty((String)to) && Math.abs(fromv) > Math.abs(tov)) {
            isvalid = false;
        }
        return isvalid;
    }

    public void initValidator(String formulaName, Map values, ValidatorResults results) {
        this.formulaName = formulaName;
        this.values = values;
        this.results = results;
    }
}

