/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.client.AbstractFindLedger;
import com.kingdee.eas.fi.rpt.client.FormulaStructure;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FindLedger
extends AbstractFindLedger {
    public static final String WINDOW_VISIBLE = "Window_Visible";
    ReportBaseInfo editdata;
    RptSheetParamInfo rptSheetParam;
    private static final Logger logger = CoreUIObject.getLogger(FindLedger.class);
    String type;
    String computeType;
    List formulaList = new ArrayList();
    public static Set supportExamine = new HashSet();

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        List expressions = (List)this.getUIContext().get("expressions");
        this.editdata = (ReportBaseInfo)this.getUIContext().get("report");
        this.rptSheetParam = (RptSheetParamInfo)this.getUIContext().get("rptSheetParam");
        this.type = (String)this.getUIContext().get("type");
        if ("2".equals(this.type)) {
            try {
                expressions = this.spliceFormula(expressions);
                if (expressions != null && expressions.size() <= 1) {
                    this.getUIContext().put(WINDOW_VISIBLE, Boolean.FALSE);
                }
            }
            catch (BOSException e1) {
                logger.error((Object)"spliceFormula_error", (Throwable)e1);
            }
        }
        Vector<String> typeList = new Vector<String>();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            FormulaHint hint = (FormulaHint)expressions.get(i);
            FormulaStructure formulaStructure = FormulaStructure.getFormulaInstance(hint);
            this.formulaList.add(formulaStructure);
            if (typeList.contains(formulaStructure.formulaType)) continue;
            typeList.add(formulaStructure.formulaType);
        }
        this.cbxFormulaType.addItems(typeList);
        this.selfInitListener();
        if (typeList.size() > 0) {
            this.cbxFormulaType.setSelectedIndex(0);
            this.cbxTypeChange();
        }
        if (expressions.size() == 1) {
            this.actionEnter_actionPerformed(null);
        } else {
            boolean isFailure = this.checkFormulaType(typeList);
            if (isFailure) {
                this.getUIContext().put(WINDOW_VISIBLE, Boolean.FALSE);
                SysUtil.abort();
                return;
            }
        }
    }

    private List spliceFormula(List resultList) throws BOSException {
        if (resultList == null) {
            return null;
        }
        HashMap<String, FormulaHint> map = new HashMap<String, FormulaHint>();
        HashMap exsitNumberMap = new HashMap();
        ArrayList<FormulaHint> res = new ArrayList<FormulaHint>();
        String companyNumber = this.editdata.getCompany().getNumber();
        String currencyNumber = this.editdata.getCurrency().getNumber();
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            int x;
            String[] split;
            String asItem;
            FormulaHint hint = (FormulaHint)resultList.get(i);
            String key = "";
            String company = hint.params[0];
            if ("acct".equalsIgnoreCase(hint.name)) {
                String asstItem = hint.params[1];
                String deNumber = hint.params[2].toLowerCase();
                String startYear = hint.params[3];
                String startFiscal = hint.params[4];
                String endYear = hint.params[5];
                String endFiscal = hint.params[6];
                String currency = hint.params[7];
                String orgType = hint.params.length > 8 ? hint.params[8].toLowerCase() : OrgType.Company.getName().toLowerCase();
                asItem = "";
                split = asstItem.split(";");
                for (x = 0; x < split.length; ++x) {
                    asstItem = split[x];
                    if (asstItem.contains("|")) {
                        int indexOf = asstItem.indexOf("|");
                        asItem = asstItem.substring(indexOf);
                        asstItem = asstItem.substring(0, indexOf);
                    }
                    StringTokenizer stoken = new StringTokenizer(StringUtils.isEmpty((String)company) ? companyNumber : company, "\\||\\,|\\;");
                    while (stoken.hasMoreElements()) {
                        String companyNum = stoken.nextElement().toString().trim();
                        if (!StringUtils.isEmpty((String)company)) {
                            company = companyNum;
                        }
                        if (map.containsKey(key = "acct-" + companyNum + asItem + "-" + deNumber + "-" + startYear + "-" + startFiscal + "-" + endYear + "-" + endFiscal + "-" + (StringUtils.isEmpty((String)currency) ? currencyNumber : currency) + "-" + orgType)) {
                            FormulaHint foHint = (FormulaHint)map.get(key);
                            if (StringUtils.isEmpty((String)foHint.params[0]) && !StringUtils.isEmpty((String)company)) {
                                foHint.params[0] = company;
                            }
                            if (!StringUtils.isEmpty((String)currency) && StringUtils.isEmpty((String)foHint.params[7])) {
                                foHint.params[7] = currency;
                            }
                            String accountAndAsstItem = foHint.params[1];
                            Set set = (Set)exsitNumberMap.get(key);
                            if (accountAndAsstItem.contains("|")) {
                                int indexOf = accountAndAsstItem.indexOf("|");
                                String item = accountAndAsstItem.substring(indexOf);
                                String account = accountAndAsstItem.substring(0, indexOf);
                                if (!set.contains(asstItem) && !StringUtils.isEmpty((String)asstItem)) {
                                    foHint.params[1] = account + ";" + asstItem + item;
                                    set.add(asstItem);
                                }
                            } else if (!set.contains(asstItem)) {
                                foHint.params[1] = accountAndAsstItem + ";" + asstItem;
                                set.add(asstItem);
                            }
                            this.spliceFormulaText(foHint, hint);
                            foHint.text = this.spliceFormulaText(foHint, hint);
                            continue;
                        }
                        FormulaHint newHint = hint.copy();
                        newHint.params[0] = company;
                        newHint.params[1] = asstItem + asItem;
                        newHint.text = this.spliceFormulaText(newHint, newHint);
                        HashSet<String> set = (HashSet<String>)exsitNumberMap.get(key);
                        if (set == null) {
                            set = new HashSet<String>();
                            exsitNumberMap.put(key, set);
                        }
                        set.add(newHint.params[1]);
                        map.put(key, newHint);
                    }
                }
                continue;
            }
            if ("acctac".equalsIgnoreCase(hint.name)) {
                String otherCompany = hint.params[1];
                String asstItem = hint.params[2];
                String deNumber = hint.params[3].toLowerCase();
                String startYear = hint.params[4];
                String startFiscal = hint.params[5];
                String endYear = hint.params[6];
                String endFiscal = hint.params[7];
                String currency = hint.params[8].toLowerCase();
                asItem = "";
                if (asstItem.contains(",")) {
                    asstItem = asstItem.replaceAll(",", ";");
                }
                split = asstItem.split(";");
                for (x = 0; x < split.length; ++x) {
                    asstItem = split[x];
                    if (!asstItem.contains("|")) {
                        if (x + 1 >= split.length) continue;
                        split[x + 1] = asstItem + ";" + split[x + 1];
                        continue;
                    }
                    int indexOf = asstItem.indexOf("|");
                    asItem = asstItem.substring(indexOf);
                    asstItem = asstItem.substring(0, indexOf);
                    key = "acctac-" + (StringUtils.isEmpty((String)company) ? companyNumber : company) + "-" + otherCompany + "-" + asItem + "-" + deNumber + "-" + startYear + "-" + startFiscal + "-" + endYear + "-" + endFiscal + "-" + (StringUtils.isEmpty((String)currency) ? currencyNumber : currency);
                    if (map.containsKey(key)) {
                        FormulaHint foHint = (FormulaHint)map.get(key);
                        if (StringUtils.isEmpty((String)foHint.params[0]) && !StringUtils.isEmpty((String)company)) {
                            foHint.params[0] = company;
                        }
                        if (!StringUtils.isEmpty((String)currency) && StringUtils.isEmpty((String)foHint.params[8])) {
                            foHint.params[8] = currency;
                        }
                        String accountAndAsstItem = foHint.params[2];
                        Set set = (Set)exsitNumberMap.get(key);
                        if (accountAndAsstItem.contains("|")) {
                            int indexOf2 = accountAndAsstItem.indexOf("|");
                            String item = accountAndAsstItem.substring(indexOf2);
                            String account = accountAndAsstItem.substring(0, indexOf2);
                            StringTokenizer st = new StringTokenizer(asstItem, ";");
                            while (st.hasMoreTokens()) {
                                String nextAsstItem = st.nextToken();
                                if (set.contains(nextAsstItem) || StringUtils.isEmpty((String)nextAsstItem)) continue;
                                account = account + ";" + nextAsstItem;
                                set.add(nextAsstItem);
                            }
                            foHint.params[2] = account + item;
                        } else if (!set.contains(asstItem)) {
                            foHint.params[2] = accountAndAsstItem + ";" + asstItem;
                            set.add(asstItem);
                        }
                        StringBuffer sb = new StringBuffer();
                        sb.append(foHint.name + "(\"");
                        sb.append(foHint.params[0] + "\", \"");
                        sb.append(foHint.params[1] + "\", \"");
                        sb.append(foHint.params[2] + "\", \"");
                        sb.append(foHint.params[3] + "\", ");
                        sb.append(foHint.params[4] + ", ");
                        sb.append(foHint.params[5] + ", ");
                        sb.append(foHint.params[6] + ", ");
                        sb.append(foHint.params[7] + ", \"");
                        sb.append(foHint.params[8] + "\")");
                        foHint.text = sb.toString();
                        continue;
                    }
                    hint.params[2] = asstItem + asItem;
                    HashSet set = (HashSet)exsitNumberMap.get(key);
                    if (set == null) {
                        set = new HashSet();
                        exsitNumberMap.put(key, set);
                    }
                    map.put(key, hint);
                }
                continue;
            }
            res.add(hint);
        }
        for (FormulaHint formulaHint : map.values()) {
            res.add(formulaHint);
        }
        return res;
    }

    private String spliceFormulaText(FormulaHint foHint, FormulaHint hint) {
        StringBuilder sb = new StringBuilder();
        sb.append(foHint.name + "(\"");
        sb.append(foHint.params[0] + "\", \"");
        sb.append(foHint.params[1] + "\", \"");
        sb.append(foHint.params[2] + "\", ");
        sb.append(foHint.params[3] + ", ");
        sb.append(foHint.params[4] + ", ");
        sb.append(foHint.params[5] + ", ");
        sb.append(foHint.params[6] + ", \"");
        if (hint.params.length > 8) {
            sb.append(foHint.params[7] + "\", \"");
            sb.append(hint.params[8] + "\")");
        } else if (foHint.params.length > 8) {
            sb.append(foHint.params[7] + "\", \"");
            sb.append(foHint.params[8] + "\")");
        } else {
            sb.append(foHint.params[7] + "\")");
        }
        return sb.toString();
    }

    public void selfInitListener() {
        this.cbxFormulaType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FindLedger.this.cbxTypeChange();
                }
            }
        });
        this.lstFormula.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                KDList lst;
                if (e.getClickCount() == 2 && (lst = (KDList)e.getSource()).getSelectedIndex() > -1) {
                    try {
                        FindLedger.this.actionEnter_actionPerformed(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void cbxTypeChange() {
        this.lstFormula.removeAllElements();
        String selectType = (String)this.cbxFormulaType.getSelectedItem();
        int size = this.formulaList.size();
        for (int i = 0; i < size; ++i) {
            if (!((FormulaStructure)this.formulaList.get((int)i)).formulaType.equalsIgnoreCase(selectType)) continue;
            this.lstFormula.addElement(this.formulaList.get(i));
        }
        this.lstFormula.setSelectedIndex(0);
    }

    @Override
    public void actionEnter_actionPerformed(ActionEvent e) throws Exception {
        FormulaStructure formulaStructure = (FormulaStructure)this.lstFormula.getSelectedValue();
        if (this.getUIContext().get("_IndexItemFireFlag") != null && formulaStructure.formulaType.equalsIgnoreCase("AcctExt")) {
            this.type = "4";
            this.getUIContext().put("type", "4");
            this.getUIContext().put("_IndexItemFireFlag", null);
        }
        if (formulaStructure == null) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("PleaseChooseFormula"));
            return;
        }
        if (this.editdata != null && OrgType.ProfitCenter.equals((Object)this.editdata.getOrgType()) && (formulaStructure.formulaType.toLowerCase().indexOf("acct") != -1 && formulaStructure.getParameter().size() == 8 || formulaStructure.formulaType.toLowerCase().indexOf("acctext") != -1 && formulaStructure.getParameter().size() == 8)) {
            MsgBox.showError((String)RptUtil.getReportResource("442_ProfitCenterNotSupportFindLeger"));
            return;
        }
        if (formulaStructure.formulaType.toLowerCase().indexOf("acctac") != -1 && !this.type.equals("1") && !this.type.equals("2")) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("onlyGLabdDetial"));
            return;
        }
        if (this.type.equals("10") && formulaStructure.formulaType.toUpperCase().indexOf("INCASHFLOW") == -1 && formulaStructure.formulaType.toUpperCase().indexOf("ACCTCASH") == -1) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("onlyInCashflow"));
            return;
        }
        this.computeType = formulaStructure.getFormulaType();
        if (!this.isSupportExamine(this.computeType)) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("NoSupportAssnThisKindFormula"));
            return;
        }
        this.disposeUIWindow();
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"Viewport", this.getUIContext().get("Viewport"));
        uiContext.put((Object)"detailUI", this.getUIContext().get("detailUI"));
        formulaStructure.setUIContext(uiContext);
        this.open(formulaStructure);
    }

    private boolean isSupportExamine(String computeType) {
        return computeType != null && supportExamine.contains(computeType.toUpperCase());
    }

    public void open(FormulaStructure formulaStructure) throws Exception {
        if (this.computeType.equalsIgnoreCase("acct") || this.computeType.equalsIgnoreCase("racct")) {
            if (this.type.equals("4")) {
                MsgBox.showInfo((String)(this.computeType.toLowerCase() + RptUtil.getResourceSince51("FormulaCannotAssn")));
                return;
            }
        } else if (this.computeType.equalsIgnoreCase("acctext")) {
            // empty if block
        }
        formulaStructure.setReport(this.editdata);
        formulaStructure.setRptSheetParam(this.rptSheetParam);
        formulaStructure.setParentUI(this);
        formulaStructure.setParentUI((CoreUIObject)this.getUIContext().get("Owner"));
        formulaStructure.setType(this.type);
        try {
            formulaStructure.open();
        }
        catch (EASBizException e) {
            MsgBox.showWarning((Component)((Object)this), (String)e.getMessage());
            return;
        }
    }

    private boolean checkFormulaType(Vector typeList) {
        String formulaType = null;
        for (int i = 0; i < typeList.size(); ++i) {
            formulaType = (String)typeList.get(i);
            if (formulaType == null) continue;
            if ("10".equals(this.type) && (formulaType.toUpperCase().indexOf("INCASHFLOW") != -1 || formulaType.toUpperCase().indexOf("ACCTCASH") != -1)) {
                return false;
            }
            if (!"4".equals(this.type) || "acct".equalsIgnoreCase(formulaType) || "racct".equalsIgnoreCase(formulaType)) continue;
            return false;
        }
        if ("10".equals(this.type)) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("onlyInCashflow"));
        } else if ("4".equals(this.type)) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("FormulaCannotAssn"));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    public String getUITitle() {
        return RptUtil.getResourceSince51("FormulaAssn");
    }

    static {
        supportExamine.add("ACCT");
        supportExamine.add("RACCT");
        supportExamine.add("INCASHFLOW");
        supportExamine.add("ACCTCASH");
        supportExamine.add("ACCTCASHEXT");
        supportExamine.add("ACCTAC");
        supportExamine.add("ACCTEXT");
    }
}

