/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.api.IRptContextManager;
import com.kingdee.eas.fi.rpt.client.AbstractFormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.FormulaFilter;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.fi.rpt.client.IFormulaWizardListener;
import com.kingdee.eas.fi.rpt.client.IValidator;
import com.kingdee.eas.fi.rpt.client.RptFormula;
import com.kingdee.eas.fi.rpt.client.RptFormulaCategory;
import com.kingdee.eas.fi.rpt.client.RptFormulaComp;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FormulaPickerUI
extends AbstractFormulaPickerUI
implements IFormulaWizardListener {
    private boolean isAdvMode;
    private boolean canBeAdvance;
    private HashSet listeners;
    private String formulaLine;
    private Point basePos;
    private Point wizardPos;
    protected RptContextManager context;
    private HashMap onlyInclude = null;
    private boolean alart = true;
    private List<String> formulaNames = null;
    private boolean isK3 = false;
    private Set validatorChain = null;
    private FormulaFilter fmFilter = null;
    private boolean showAdvance;
    private boolean isShowAdvance = true;
    private Dimension normalSize = null;
    private Dimension advanceSize = null;

    public void openAlart() {
        this.alart = true;
    }

    public void closeAlart() {
        this.alart = false;
    }

    public void setK3(boolean isK3) {
        this.isK3 = isK3;
    }

    public static FormulaPickerUI creatFormulaPicker(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(FormulaPickerUI.class.getName(), (Map)new UIContext((Object)parentUI));
        return wnd != null ? (FormulaPickerUI)wnd.getUIObject() : null;
    }

    public void open(String filter, boolean showAdvance, HashMap olInclude) {
        this.onlyInclude = olInclude;
        this.fireListenersSetout();
        this.isAdvMode = false;
        this.LoadFormulaComp(filter);
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            d.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    FormulaPickerUI.this.endPicker(false);
                }

                @Override
                public void windowActivated(WindowEvent e) {
                    if (FormulaPickerUI.this.showAdvance) {
                        FormulaPickerUI.this.setAdvance();
                    }
                }
            });
            this.showAdvance = showAdvance;
        }
        w.show();
    }

    public void open(String filter, HashMap map) {
        this.open(filter, false, map);
    }

    public void open() {
        this.isShowAdvance = true;
        this.open(null, null);
    }

    public void open(boolean isShowAdvance) {
        this.isShowAdvance = isShowAdvance;
        this.open(null, null);
    }

    public synchronized void addFormulaPickerListener(IFormulaPickerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void addValidator(IValidator v) {
        if (this.validatorChain == null) {
            this.validatorChain = new HashSet();
        }
        this.validatorChain.add(v);
    }

    private void fireListenersReturnee(boolean isOk) {
        for (IFormulaPickerListener l : this.listeners) {
            if (l == null) continue;
            l.pickerReturnee(this, this.formulaLine, isOk);
        }
    }

    private void fireListenersSetout() {
        for (IFormulaPickerListener l : this.listeners) {
            if (l == null) continue;
            l.pickerSetout(this);
        }
    }

    public void setExtendable(boolean canExtend) {
        this.canBeAdvance = canExtend;
        this.btnAdvance.setEnabled(this.canBeAdvance);
    }

    public boolean isAdvMode() {
        return this.isAdvMode;
    }

    public void setLocation(Point p) {
        if (p != null) {
            this.basePos.x = p.x;
            this.basePos.y = p.y;
        }
    }

    public FormulaPickerUI() throws Exception {
        this.btnPlus.setIcon(RptResourceHelper.getIcon("imgTbtn_plussign"));
        this.btnMinus.setIcon(RptResourceHelper.getIcon("imgTbtn_minussign"));
        this.btnMultiply.setIcon(RptResourceHelper.getIcon("imgTbtn_multiplysign"));
        this.btnDivision.setIcon(RptResourceHelper.getIcon("imgTbtn_dividesign"));
        this.btnBracket.setIcon(RptResourceHelper.getIcon("imgTbtn_unequaltosign"));
        this.btnInsert.setIcon(RptResourceHelper.getIcon("imgTbtn_showformula"));
        this.btnClear.setIcon(RptResourceHelper.getIcon("imgTbtn_delete"));
        this.btnSearch.setIcon(RptResourceHelper.getIcon("imgTbtn_find"));
        this.btnPlus.setText(null);
        this.btnMinus.setText(null);
        this.btnMultiply.setText(null);
        this.btnDivision.setText(null);
        this.btnBracket.setText(null);
        this.btnInsert.setText(null);
        this.btnClear.setText(null);
        this.btnSearch.setText(null);
        this.isAdvMode = false;
        this.canBeAdvance = true;
        this.listeners = new HashSet(1, 0.75f);
        this.basePos = new Point(100, 100);
        this.wizardPos = new Point(100, 100);
        this.txtSearch.setEnabledPopup(false);
        this.lstFormula.setFixedCellHeight(18);
        this.lstFormula.setModel(new DefaultListModel());
        this.lstFormula.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FormulaPickerUI.this.lstFormula.ensureIndexIsVisible(FormulaPickerUI.this.lstFormula.getSelectedIndex());
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int cnt = FormulaPickerUI.this.lstFormula.getElementCount();
                RptFormula fm = cnt < 1 || FormulaPickerUI.this.lstFormula.getSelectedIndex() >= cnt ? null : (RptFormula)((Object)FormulaPickerUI.this.lstFormula.getSelectedValue());
                FormulaPickerUI.this.txtDescription.setText(fm == null ? null : fm.getDescription());
            }
        });
        this.lstFormula.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    try {
                        FormulaPickerUI.this.callWizard();
                    }
                    catch (Exception ex) {
                        FormulaPickerUI.this.handUIException(ex);
                    }
                }
            }
        });
        this.cbxGroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptFormulaCategory cat = (RptFormulaCategory)((Object)e.getItem());
                    RptFormulaComp.getInstance().setCurCategory(cat);
                    FormulaPickerUI.this.showFormulas(cat.getName());
                }
            }
        });
        this.btnInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FormulaPickerUI.this.callWizard();
                }
                catch (Exception ex) {
                    FormulaPickerUI.this.handUIException(ex);
                }
            }
        });
        SearchAction sa = new SearchAction();
        this.txtSearch.addActionListener((ActionListener)sa);
        this.btnSearch.addActionListener((ActionListener)sa);
        HelpUtils.addCSHelp((JComponent)this.getRootPane());
        HelpUtils.addCSHelpforBtn((JButton)this.btnHelp);
    }

    protected void searchFormula() {
        String text = this.txtSearch.getText();
        if (text != null && text.length() > 0) {
            text = text.trim().toLowerCase();
            DefaultListModel listModel = (DefaultListModel)this.lstFormula.getModel();
            int curPos = this.lstFormula.getSelectedIndex();
            boolean isFound = false;
            int size = listModel.size();
            for (int i = 0; i < size; ++i) {
                String item = listModel.elementAt(curPos = this.getNextPos(curPos, 0, size - 1)).toString().toLowerCase();
                if (item.indexOf(text) == -1) continue;
                isFound = true;
                break;
            }
            if (isFound) {
                this.lstFormula.setSelectedIndex(curPos);
                this.lstFormula.ensureIndexIsVisible(curPos);
                this.lstFormula.requestFocus();
                return;
            }
        }
        this.txtSearch.requestFocus();
    }

    private int getNextPos(int curPos, int minPos, int maxPos) {
        if (curPos < minPos || curPos >= maxPos) {
            curPos = minPos - 1;
        }
        return curPos + 1;
    }

    public void LoadFormulaComp(String filter) {
        ItemListener[] its;
        if (this.fmFilter == null) {
            this.fmFilter = new FormulaFilter();
        }
        if (filter != null) {
            this.fmFilter.setFilter(filter);
        }
        RptFormulaComp comp = RptFormulaComp.getInstance();
        comp.setK3(this.isK3);
        if (!comp.isLoaded()) {
            try {
                comp.load();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if ((its = this.cbxGroup.getItemListeners()) != null && its.length > 0) {
            this.cbxGroup.removeItemListener(its[0]);
        }
        Object clientProperty = this.getClientProperty("selectCategory");
        RptFormulaCategory selectedRptFormulaCa = null;
        for (RptFormulaCategory ct : comp.getFormulaCategory()) {
            if (selectedRptFormulaCa == null && ct.getName().equals(clientProperty)) {
                selectedRptFormulaCa = ct;
            }
            if (this.fmFilter.filtrateCate(ct.getName())) continue;
            this.cbxGroup.removeItem((Object)ct);
            this.cbxGroup.addItem((Object)ct);
        }
        comp.setCurCategory(null);
        RptFormulaCategory cn = comp.getCurCategory();
        if (cn != null) {
            this.cbxGroup.removeItem((Object)cn);
            this.cbxGroup.insertItemAt((Object)cn, 0);
        }
        if (selectedRptFormulaCa != null) {
            comp.setCurCategory(selectedRptFormulaCa);
            this.cbxGroup.removeItem((Object)selectedRptFormulaCa);
            this.cbxGroup.insertItemAt((Object)selectedRptFormulaCa, 1);
        }
        if (this.cbxGroup.getItemCount() > 0) {
            if (selectedRptFormulaCa != null) {
                this.cbxGroup.setSelectedIndex(1);
            } else {
                this.cbxGroup.setSelectedIndex(0);
            }
        }
        if (its != null && its.length > 0) {
            this.cbxGroup.addItemListener(its[0]);
        }
        this.showFormulas((String)(selectedRptFormulaCa != null ? selectedRptFormulaCa.getName() : (cn == null ? null : cn.getName())));
    }

    public void setFilter(String filter) {
        if (this.fmFilter == null) {
            this.fmFilter = new FormulaFilter();
        }
        this.fmFilter.setFilter(filter);
    }

    public Dimension getPreferredSize() {
        IUIWindow w;
        if (!this.isPreferredSizeSet() && (w = this.getUIWindow()) != null && w instanceof UIModelDialog) {
            UIModelDialog d = (UIModelDialog)w;
            d.setResizable(false);
            d.setModal(true);
            Dimension stoneSize = this.preferredSize();
            stoneSize.width -= this.pnlAdvance.getSize().width;
            this.setPreferredSize(stoneSize);
        }
        return super.getPreferredSize();
    }

    public void initSize() {
        IUIWindow w;
        if (this.normalSize == null && (w = this.getUIWindow()) != null && w instanceof UIModelDialog) {
            UIModelDialog d = (UIModelDialog)w;
            this.normalSize = d.getSize();
            this.advanceSize = new Dimension();
            this.advanceSize.width = this.normalSize.width + this.pnlAdvance.getSize().width;
            this.advanceSize.height = this.normalSize.height;
        }
    }

    public void setAdvance() {
        this.initSize();
        IUIWindow w = this.getUIWindow();
        if (w != null && w instanceof UIModelDialog) {
            UIModelDialog d = (UIModelDialog)w;
            this.isAdvMode = true;
            d.setSize(this.advanceSize);
            this.btnOk.setText(this.resHelper.getString("btnFinish.text"));
            this.txtExpression.setSelectAllOnFocus(false);
            this.txtExpression.requestFocus();
            if (StringUtils.isEmpty((String)this.txtExpression.getText()) && this.formulaLine != null && this.formulaLine.length() > 1 && this.formulaLine.charAt(0) == '=') {
                this.txtExpression.setText(this.formulaLine.substring(1));
            }
        }
    }

    @Override
    protected void btnAdvance_actionPerformed(ActionEvent e) throws Exception {
        this.initSize();
        IUIWindow w = this.getUIWindow();
        if (w != null && w instanceof UIModelDialog) {
            UIModelDialog d = (UIModelDialog)w;
            Dimension AdvSize = d.getSize();
            if (AdvSize.equals(this.advanceSize)) {
                this.isAdvMode = false;
                d.setSize(this.normalSize);
                this.btnOk.setText(this.resHelper.getString("btnOk.text"));
            } else {
                this.isAdvMode = true;
                d.setSize(this.advanceSize);
                this.btnOk.setText(this.resHelper.getString("btnFinish.text"));
                this.txtExpression.setSelectAllOnFocus(false);
                this.txtExpression.requestFocus();
                if (StringUtils.isEmpty((String)this.txtExpression.getText()) && this.formulaLine != null && this.formulaLine.length() > 1 && this.formulaLine.charAt(0) == '=') {
                    this.txtExpression.setText(this.formulaLine.substring(1));
                }
            }
        }
        super.btnAdvance_actionPerformed(e);
    }

    protected void showFormulas(String cateName) {
        if ("all formulas".equalsIgnoreCase(cateName)) {
            cateName = null;
        }
        if (cateName == null) {
            this.formulaNames = new ArrayList<String>();
        }
        RptFormulaComp comp = RptFormulaComp.getInstance();
        Iterator fms = comp.getFormulasByCategory(cateName).iterator();
        DefaultListModel listModel = (DefaultListModel)this.lstFormula.getModel();
        listModel.removeAllElements();
        int index = -1;
        int pos = 0;
        while (fms.hasNext()) {
            RptFormula fm = (RptFormula)((Object)fms.next());
            if (cateName == null) {
                this.formulaNames.add(fm.getName().toUpperCase());
            }
            if (this.fmFilter.filtrateFormula(fm) || this.onlyInclude != null && this.onlyInclude.get(fm.getName().toLowerCase().trim()) == null) continue;
            if (index == -1 && fm.equals((Object)comp.getCurFormula())) {
                index = pos;
            }
            ++pos;
            listModel.addElement(fm);
        }
        if (index >= 0) {
            this.lstFormula.setSelectedIndex(index);
            this.lstFormula.ensureIndexIsVisible(index);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.endPicker(false);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (this.isAdvMode) {
            this.endPicker(true);
        } else {
            this.callWizard();
        }
    }

    private void endPicker(boolean isOk) {
        if (isOk) {
            if (this.isAdvMode) {
                this.formulaLine = this.txtExpression.getText().trim();
            }
        } else {
            this.formulaLine = null;
        }
        this.disposeUIWindow();
        this.fireListenersReturnee(isOk);
        this.formulaLine = null;
        this.txtExpression.setText("");
    }

    private void callWizard() throws Exception {
        if (this.lstFormula.getModel().getSize() < 1) {
            return;
        }
        RptFormula fm = (RptFormula)((Object)this.lstFormula.getSelectedValue());
        if (fm == null) {
            return;
        }
        RptFormulaComp.getInstance().setCurFormula(fm);
        FormulaWizardUI wizard = FormulaWizardUI.creatFormulaWizard((String)fm.wizard, (Object)((Object)this));
        wizard.addFormulaWizardListener((IFormulaWizardListener)this);
        wizard.setRptContext((IRptContextManager)this.context);
        wizard.addValidatorChain((Collection)this.validatorChain);
        if (this.alart) {
            wizard.openAlart();
        } else {
            wizard.closeAlart();
        }
        wizard.setLoadOnce(true);
        wizard.open(fm.getName());
    }

    public void wizardSetout(FormulaWizardUI wizard) {
    }

    public void wizardReturnee(FormulaWizardUI wizard, String formulaLine, boolean isOk) {
        if (!this.isAdvMode) {
            this.formulaLine = formulaLine;
            this.endPicker(isOk);
        } else if (isOk) {
            this.txtExpression.insert(formulaLine, this.txtExpression.getCaretPosition());
            this.formulaLine = this.txtExpression.getText();
        }
    }

    private boolean canInsert(char ch, int insertPos) {
        String line = this.txtExpression.getText();
        char preChar = '\u0000';
        if (line == null || line.length() == 0) {
            insertPos = -1;
        } else if (insertPos > 0) {
            preChar = line.charAt(insertPos - 1);
        }
        boolean res = false;
        switch (ch) {
            case '+': {
                res = true;
                break;
            }
            case '-': {
                res = true;
                break;
            }
            case '*': {
                res = insertPos > 0;
                break;
            }
            case '/': {
                res = insertPos > 0;
                break;
            }
            case '(': {
                res = true;
            }
        }
        return res;
    }

    private void insertOperator(char ch) {
        int pos = this.txtExpression.getCaretPosition();
        if (this.canInsert(ch, pos)) {
            if (ch != '(') {
                this.txtExpression.insert(Character.toString(ch), pos);
            } else {
                this.txtExpression.insert("()", pos);
                this.txtExpression.setCaretPosition(pos + 1);
            }
            this.formulaLine = this.txtExpression.getText();
        }
    }

    @Override
    public void insertOperatorAction_actionPerformed(ActionEvent e) throws Exception {
        super.insertOperatorAction_actionPerformed(e);
        int ch = 0;
        Object src = e.getSource();
        if (src == this.btnPlus) {
            ch = 43;
        } else if (src == this.btnMinus) {
            ch = 45;
        } else if (src == this.btnMultiply) {
            ch = 42;
        } else if (src == this.btnDivision) {
            ch = 47;
        } else if (src == this.btnBracket) {
            ch = 40;
        }
        this.insertOperator((char)ch);
        this.txtExpression.requestFocus();
    }

    public void setRptContext(RptContextManager rptContext) {
        this.context = rptContext;
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        this.txtExpression.setText("");
        this.txtExpression.requestFocus();
    }

    protected JButton getDefaultButton() {
        return this.btnOk;
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.showAdvance) {
            try {
                this.btnAdvance_actionPerformed(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isShowAdvance) {
            this.btnAdvance.setVisible(true);
            this.btnAdvance.setEnabled(true);
        } else {
            this.btnAdvance.setVisible(false);
            this.btnAdvance.setEnabled(false);
        }
        RptHelper.setEscAction((CoreUIObject)this, new Action(){

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void setEnabled(boolean b) {
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public Object getValue(String key) {
                return null;
            }

            @Override
            public void putValue(String key, Object value) {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                FormulaPickerUI.this.endPicker(false);
            }
        });
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
        JButton btn = (JButton)e.getSource();
        try {
            HelpUtils.ActionHelp h = new HelpUtils.ActionHelp("fatempClassCriterion", (Component)btn, "fatempClassCriterion", 30);
            h.actionPerformed(e);
        }
        catch (Exception ex) {
            MsgBox.showError((String)RptUtil.getReportResource("HELP_NOT_EXISTS"));
        }
    }

    public void setAdvMode(boolean isAdvMode) {
        this.isAdvMode = isAdvMode;
    }

    public String getFormulaLine() {
        return this.formulaLine;
    }

    public void setFormulaLine(String formulaLine) {
        this.formulaLine = formulaLine;
    }

    public List<String> getFormulaNames() {
        return this.formulaNames;
    }

    public void setFormulaNames(List<String> formulaNames) {
        this.formulaNames = formulaNames;
    }

    private class SearchAction
    implements ActionListener {
        private SearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormulaPickerUI.this.searchFormula();
        }
    }
}

