/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.SelectNumOrNameEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupNormalProcessUI;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.rpt.VoucherFieldsCollection;
import com.kingdee.eas.fi.rpt.VoucherFieldsFactory;
import com.kingdee.eas.fi.rpt.VoucherFieldsInfo;
import com.kingdee.eas.fi.rpt.client.AbstractGenVoucherInfoMappingUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class GenVoucherInfoMappingUI
extends AbstractGenVoucherInfoMappingUI {
    private static final Logger logger = CoreUIObject.getLogger(GenVoucherInfoMappingUI.class);
    private VoucherFieldsCollection noSelectFields = new VoucherFieldsCollection();
    private Sheet rptSheet = null;
    private static final String TB_ID = "id";
    private static final String TB_KEY = "key";
    private static final String TB_FIELD_NAME = "fieldName";
    private static final String TB_SHOW_NAME = "showName";
    private static final String TB_NAME_OR_NUM = "nameOrNum";
    private static final String TB_IS_DEFAULT = "isDefault";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initParament();
        this.loadFieldsToTable();
    }

    private void initParament() {
        this.rptSheet = (Sheet)this.getUIContext().get("KEY_KDTABLE");
        if (this.rptSheet == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"TableIsNull"));
            SysUtil.abort();
        }
    }

    private CoreBaseCollection getVoucherFields() throws BOSException {
        String oql = "select fieldName, showName, key, defaultSelect, isSelect, nameOrNum, sequence, isAsstAct, id order by Sequence asc";
        return VoucherFieldsFactory.getRemoteInstance().getCollection(oql);
    }

    private VoucherFieldsCollection getselectVoucherFields(CoreBaseCollection voucherFields) {
        VoucherFieldsInfo fieldInfo = null;
        VoucherFieldsCollection selectFields = new VoucherFieldsCollection();
        for (int i = 0; i < voucherFields.size(); ++i) {
            fieldInfo = (VoucherFieldsInfo)voucherFields.get(i);
            if (fieldInfo.isDefaultSelect() || fieldInfo.isIsSelect()) {
                selectFields.add(fieldInfo);
                continue;
            }
            this.noSelectFields.add(fieldInfo);
        }
        return selectFields;
    }

    private void loadFieldsToTable() throws BOSException {
        VoucherFieldsCollection selectFields = this.getselectVoucherFields(this.getVoucherFields());
        this.voucherTable.checkParsed();
        this.voucherTable.getSelectManager().setSelectMode(10);
        this.voucherTable.getColumn(TB_IS_DEFAULT).getStyleAttributes().setLocked(true);
        this.voucherTableAddRow(selectFields);
        VoucherFieldsInfo fieldInfo = null;
        IRow row = null;
        for (int i = 0; i < selectFields.size(); ++i) {
            fieldInfo = selectFields.get(i);
            row = this.voucherTable.getRow(i);
            this.setValueToCell(fieldInfo, row);
        }
    }

    private void setValueToCell(VoucherFieldsInfo fieldInfo, IRow row) {
        if (fieldInfo == null || row == null) {
            return;
        }
        row.getCell(TB_ID).setValue((Object)fieldInfo.getId());
        row.getCell(TB_KEY).setValue((Object)fieldInfo.getKey());
        row.getCell(TB_FIELD_NAME).setValue((Object)fieldInfo);
        if (fieldInfo.isDefaultSelect()) {
            row.getCell(TB_FIELD_NAME).getStyleAttributes().setLocked(true);
        }
        row.getCell(TB_SHOW_NAME).setValue((Object)(fieldInfo.getShowName() != null ? fieldInfo.getShowName() : fieldInfo.getFieldName()));
        row.getCell(TB_NAME_OR_NUM).setValue((Object)fieldInfo.getNameOrNum());
        row.getCell(TB_NAME_OR_NUM).getStyleAttributes().setLocked(!this.nameOrNumCanChange(fieldInfo.getKey()));
        row.getCell(TB_IS_DEFAULT).setValue((Object)fieldInfo.isDefaultSelect());
    }

    private void removeRowEnabled() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.voucherTable);
        for (int i = 0; i < selectRows.length; ++i) {
            Object cellValue = this.voucherTable.getRow(selectRows[i]).getCell(TB_IS_DEFAULT).getValue();
            if (cellValue == null || !((Boolean)cellValue).booleanValue()) continue;
            this.removeRow.setEnabled(false);
            return;
        }
        this.removeRow.setEnabled(true);
    }

    private void voucherTableAddRow(VoucherFieldsCollection selectFields) {
        this.voucherTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                GenVoucherInfoMappingUI.this.removeRowEnabled();
            }
        });
        this.voucherTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == GenVoucherInfoMappingUI.this.voucherTable.getColumnIndex(GenVoucherInfoMappingUI.TB_FIELD_NAME)) {
                    Object newValue = e.getValue();
                    Object oldValue = e.getOldValue();
                    if (newValue != null && !newValue.equals(oldValue)) {
                        IRow row = GenVoucherInfoMappingUI.this.voucherTable.getRow(e.getRowIndex());
                        VoucherFieldsInfo fieldInfo = (VoucherFieldsInfo)newValue;
                        GenVoucherInfoMappingUI.this.setValueToCell(fieldInfo, row);
                        GenVoucherInfoMappingUI.this.noSelectFields.removeObject((IObjectValue)fieldInfo);
                        if (GenVoucherInfoMappingUI.this.noSelectFields.size() == 0) {
                            GenVoucherInfoMappingUI.this.addRow.setEnabled(false);
                        }
                    }
                    KDComboBox cmb = (KDComboBox)GenVoucherInfoMappingUI.this.voucherTable.getColumn(GenVoucherInfoMappingUI.TB_FIELD_NAME).getEditor().getComponent();
                    cmb.removeItem(newValue);
                }
            }

            public void editStarting(KDTEditEvent e) {
                if (e.getColIndex() == GenVoucherInfoMappingUI.this.voucherTable.getColumnIndex(GenVoucherInfoMappingUI.TB_FIELD_NAME)) {
                    KDComboBox cmb = (KDComboBox)GenVoucherInfoMappingUI.this.voucherTable.getColumn(GenVoucherInfoMappingUI.TB_FIELD_NAME).getEditor().getComponent();
                    if (e.getValue() != null) {
                        cmb.addItem((Object)((VoucherFieldsInfo)e.getValue()));
                        cmb.setSelectedIndex(cmb.getItemCount() - 1, false);
                    }
                }
            }
        });
        this.voucherTable.addRows(selectFields.size());
        KDComboBox cmbFieldName = new KDComboBox();
        cmbFieldName.addItems(this.noSelectFields.toArray());
        this.voucherTable.getColumn(TB_FIELD_NAME).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbFieldName));
        KDComboBox cmbNameOrNum = new KDComboBox();
        cmbNameOrNum.addItem((Object)SelectNumOrNameEnum.getEnum((String)"NAME"));
        cmbNameOrNum.addItem((Object)SelectNumOrNameEnum.getEnum((String)"NUMBER"));
        this.voucherTable.getColumn(TB_NAME_OR_NUM).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbNameOrNum));
    }

    @Override
    protected void btnMoveDown_actionPerformed(ActionEvent e) throws Exception {
        if (this.voucherTable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.voucherTable);
        int top = selectRows[0];
        int bottom = selectRows[0];
        if (bottom < this.voucherTable.getRowCount() - 1) {
            this.voucherTable.addRow(top, this.voucherTable.getRow(bottom + 1));
            this.voucherTable.getSelectManager().select(top + 1, 0, bottom + 1, this.voucherTable.getColumnCount() - 1);
            this.voucherTable.removeRow(bottom + 2);
            this.voucherTable.getLayoutManager().scrollRowToShow(top + 1);
        }
    }

    @Override
    protected void btnMoveUp_actionPerformed(ActionEvent e) throws Exception {
        if (this.voucherTable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.voucherTable);
        int top = selectRows[0];
        int bottom = selectRows[0];
        if (top > 0) {
            this.voucherTable.addRow(bottom + 1, this.voucherTable.getRow(top - 1));
            this.voucherTable.removeRow(top - 1);
            this.voucherTable.getSelectManager().select(top - 1, 0, bottom - 1, this.voucherTable.getColumnCount() - 1);
            this.voucherTable.getLayoutManager().scrollRowToShow(top - 1);
        }
    }

    @Override
    protected void btnMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        if (this.voucherTable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.voucherTable);
        int rowIndex = selectRows[0];
        this.voucherTable.addRow(this.voucherTable.getRowCount(), this.voucherTable.getRow(rowIndex));
        this.voucherTable.removeRow(rowIndex);
        int bottomIndex = this.voucherTable.getRowCount() - 1;
        this.voucherTable.getSelectManager().select(bottomIndex, 0, bottomIndex, this.voucherTable.getColumnCount() - 1);
        this.voucherTable.getLayoutManager().scrollRowToShow(bottomIndex);
    }

    @Override
    protected void btnMoveTop_actionPerformed(ActionEvent e) throws Exception {
        if (this.voucherTable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.voucherTable);
        int rowIndex = selectRows[0];
        this.voucherTable.addRow(0, this.voucherTable.getRow(rowIndex));
        this.voucherTable.removeRow(rowIndex + 1);
        this.voucherTable.getSelectManager().select(0, 0, 0, this.voucherTable.getColumnCount() - 1);
        this.voucherTable.getLayoutManager().scrollRowToShow(0);
    }

    @Override
    protected void addRow_actionPerformed(ActionEvent e) throws Exception {
        this.voucherTable.addRow(this.voucherTable.getRowCount());
    }

    @Override
    protected void removeRow_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows;
        if (this.voucherTable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (this.confirmRemove((selectRows = KDTableUtil.getSelectedRows((KDTable)this.voucherTable))[0])) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                VoucherFieldsInfo info;
                IRow row = this.voucherTable.getRow(selectRows[i]);
                Object cellValue = row.getCell(TB_IS_DEFAULT).getValue();
                if (cellValue != null && ((Boolean)cellValue).booleanValue()) continue;
                VoucherFieldsInfo voucherFieldsInfo = info = row.getCell(TB_FIELD_NAME) != null ? (VoucherFieldsInfo)row.getCell(TB_FIELD_NAME).getValue() : null;
                if (info != null) {
                    KDComboBox cmb = (KDComboBox)this.voucherTable.getColumn(TB_FIELD_NAME).getEditor().getComponent();
                    cmb.addItem((Object)info);
                    this.noSelectFields.add(info);
                }
                this.voucherTable.removeRow(selectRows[i]);
            }
            this.removeRowEnabled();
            if (this.noSelectFields.size() > 0) {
                this.addRow.setEnabled(true);
            }
        }
    }

    private boolean hasNumOrSheetName() {
        boolean flag = false;
        for (int i = 0; i < this.voucherTable.getRowCount(); ++i) {
            VoucherFieldsInfo vcInfo;
            Object value = this.voucherTable.getRow(i).getCell(TB_FIELD_NAME).getValue();
            if (value == null || !"sheetName".equals((vcInfo = (VoucherFieldsInfo)value).getKey()) && !"voucherNumber".equals(vcInfo.getKey())) continue;
            flag = true;
        }
        return flag;
    }

    protected boolean confirmRemove(int top) {
        return this.voucherTable.getRow(top).getCell(TB_ID).getValue() == null || MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.hasNumOrSheetName()) {
            if (this.checkAsst()) {
                VoucherFieldsFactory.getRemoteInstance().save(this.storeValue());
                this.fillInfoToSheet();
                this.uiWindow.close();
            }
        } else {
            MsgBox.showConfirm2((String)CslRptUtil.getString((String)"vcNumOrSheetName"));
        }
    }

    public boolean checkAsst() throws Exception {
        CoreBaseCollection selectVoucherData = this.getTableData();
        HashSet<String> selectKey = new HashSet<String>();
        for (int i = 0; i < selectVoucherData.size(); ++i) {
            selectKey.add(((VoucherFieldsInfo)selectVoucherData.get(i)).getKey());
        }
        if (!selectKey.isEmpty()) {
            HashMap<String, String> asstMap = new HashMap<String, String>();
            for (int i = 1; i <= 8; ++i) {
                asstMap.put("asstActType" + i, "asstActNumber" + i);
            }
            StringBuffer errorMsg = new StringBuffer();
            for (String asstActType : asstMap.keySet()) {
                String index;
                String asstActNumber = (String)asstMap.get(asstActType);
                if (selectKey.contains(asstActType)) {
                    if (selectKey.contains(asstActNumber)) continue;
                    index = asstActType.substring(asstActType.length() - 1);
                    errorMsg.append(CslRptUtil.getStringWithFormat((String)"1016lostAsstNumber", (Object[])new Object[]{index, index})).append("\r\n");
                    continue;
                }
                if (!selectKey.contains(asstActNumber)) continue;
                index = asstActType.substring(asstActType.length() - 1);
                errorMsg.append(CslRptUtil.getStringWithFormat((String)"1017lostAsstType", (Object[])new Object[]{index, index})).append("\r\n");
            }
            if (errorMsg.length() > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)CslRptUtil.getString((String)"1015assttypeAcctExist"), (String)errorMsg.toString(), (int)8188);
                return false;
            }
        }
        selectKey.clear();
        return true;
    }

    private void fillInfoToSheet() throws EASBizException, BOSException {
        SpreadManager spreadManager = null;
        if (this.getUIContext().get("Owner") instanceof GroupNormalProcessUI) {
            spreadManager = ((GroupNormalProcessUI)this.getUIContext().get("Owner")).getSpreadManager();
        }
        int top = this.rptSheet.getActiveRow();
        int left = this.rptSheet.getActiveCol();
        CoreBaseCollection selectVoucherData = this.getTableData();
        int size = selectVoucherData.size();
        if (this.getUIContext().get("basePoint") != null) {
            int deleteCount = (Integer)this.getUIContext().get("filedsCount");
            Point basePoint = (Point)this.getUIContext().get("basePoint");
            this.rptSheet.getRange(basePoint.y, basePoint.x, basePoint.y + 1, basePoint.x + deleteCount).clear(true, true, true, true, new String[0]);
        }
        int asstActPointMin = -1;
        int asstActColMax = -1;
        for (int i = 0; i < size; ++i) {
            VoucherFieldsInfo info = (VoucherFieldsInfo)selectVoucherData.get(i);
            int valueRangeTop = top;
            if (info.isIsAsstAct()) {
                this.rptSheet.getRange(top, left + i).setValue(new Variant((Object)CslRptUtil.getString((String)"rptGenVoucherAsstAct")));
                valueRangeTop = top + 1;
                if (asstActPointMin == -1) {
                    asstActPointMin = i;
                }
                asstActColMax = i;
            } else {
                this.setMerge(this.rptSheet, top, left + i, top + 1, left + i);
            }
            this.rptSheet.getRange(valueRangeTop, left + i).setValue(new Variant((Object)info.getShowName()));
            this.rptSheet.getRange(valueRangeTop, left + i).setUserObject("fieldKey", (Object)info.getKey());
            boolean isName = SelectNumOrNameEnum.NAME.equals((Object)info.getNameOrNum());
            if (isName && this.nameOrNumCanChange(info.getKey())) {
                this.rptSheet.getRange(valueRangeTop, left + i).setUserObject("isName", (Object)true);
            }
            this.autoSetColWidth(spreadManager, this.rptSheet, valueRangeTop, left + i);
        }
        this.setMerge(this.rptSheet, top, left + asstActPointMin, top, left + asstActColMax);
        Range range = this.rptSheet.getRange(top, left);
        range.setUserObject("fieldsCount", (Object)size);
    }

    private boolean nameOrNumCanChange(String fieldName) {
        if ("companyNumber".equals(fieldName) || "profitCenterNumber".equals(fieldName)) {
            return true;
        }
        if ("accountNumber".equals(fieldName)) {
            return true;
        }
        if ("currencyNumber".equals(fieldName)) {
            return true;
        }
        if ("asstActNumber".equals(fieldName.substring(0, fieldName.length() - 1))) {
            return true;
        }
        return "measurement".equals(fieldName);
    }

    private void autoSetColWidth(SpreadManager spreadManager, Sheet sheet, int row, int col) {
        int w;
        if (spreadManager == null) {
            return;
        }
        KDSpread spread = spreadManager.getSpreadContainer().getSpread();
        Graphics2D g2d = (Graphics2D)spread.getGraphics();
        Cell cell = sheet.getCell(row, col, false);
        int width = sheet.getColRange(col, col).getColumnWidth();
        FontMetrics fm = g2d.getFontMetrics((Font)cell.getStyle().getKDFont());
        ICellDisplayProvider cvp = spread.getCellDisplayProvider();
        Object value = cvp.getBaseValue(cell, spread.getBook().getActiveSheet().getSheetOption().getCellDisplayMode());
        if (value instanceof String && ((w = fm.stringWidth((String)value)) > width || width - w < 12)) {
            width = w + 12;
        }
        if (width > 0) {
            sheet.getColRange(col, col).setColumnWidth(width + 8);
        }
    }

    private void setMerge(Sheet sheet, int top, int left, int bottom, int right) {
        Range rg = sheet.getRange(top, left, bottom, right);
        Book book = sheet.getBook();
        boolean merged = book.getActiveSheet().isMerged(rg.getBlock(0));
        rg.merge();
        if (!merged) {
            this.setAlignCenter(rg);
        }
    }

    private void setAlignCenter(Range rg) {
        StyleAttributes sa = Styles.getEmptySA();
        sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        rg.setStyle(sa, sa);
    }

    protected CoreBaseCollection storeValue() {
        CoreBaseCollection selectVoucherData = this.getTableData();
        CoreBaseCollection deleteVoucherData = this.getDeletedData();
        selectVoucherData.addCollection(deleteVoucherData);
        return selectVoucherData;
    }

    protected CoreBaseCollection getTableData() {
        CoreBaseCollection voucherCollection = new CoreBaseCollection();
        VoucherFieldsInfo info = null;
        int i = 0;
        int seq = 0;
        while (i < this.voucherTable.getRowCount()) {
            IRow row = this.voucherTable.getRow(i);
            info = (VoucherFieldsInfo)row.getCell(TB_FIELD_NAME).getValue();
            if (info != null) {
                info.setShowName((String)row.getCell(TB_SHOW_NAME).getValue());
                info.setNameOrNum((SelectNumOrNameEnum)row.getCell(TB_NAME_OR_NUM).getValue());
                info.setIsSelect(true);
                info.setSequence(seq);
                voucherCollection.add((CoreBaseInfo)info);
            } else {
                --seq;
            }
            ++i;
            ++seq;
        }
        return voucherCollection;
    }

    protected CoreBaseCollection getDeletedData() {
        CoreBaseCollection voucherCollection = new CoreBaseCollection();
        VoucherFieldsInfo info = null;
        for (int i = 0; i < this.noSelectFields.size(); ++i) {
            info = this.noSelectFields.get(i);
            info.setSequence(-1);
            info.setIsSelect(false);
            info.setNameOrNum(SelectNumOrNameEnum.NAME);
            voucherCollection.add((CoreBaseInfo)info);
        }
        return voucherCollection;
    }

    @Override
    public void actionCanCel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }
}

