/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewProfitCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.AdjustStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataYearInit;
import com.kingdee.eas.fi.gr.cslrpt.IRPTDataService;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.MaintainYearInitDataFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CSLContextHelper;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptListUI;
import com.kingdee.eas.fi.gr.cslrpt.client.ICSLContextUI;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.client.AbstractGenerateNextYearInitUI;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class GenerateNextYearInitUI
extends AbstractGenerateNextYearInitUI
implements ICSLContextUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(GenerateNextYearInitUI.class);
    private static final String COL_SELECTED = "selectedColumn";
    private static final String COL_RPTITEM_NUMBER = "rptItemNumberColumn";
    private static final String COL_RPTITEM_NAME = "rptItemNameColumn";
    private static final String COL_SRCCURRENCY = "srcCurrency";
    private static final String COL_CURRENCY = "currencyColumn";
    private static final String COL_YEAR = "yearColumn";
    private static final String COL_PERIOD = "periodColumn";
    private static final String COL_CREDIT = "creditColumn";
    private static final String COL_DEBIT = "debitColumn";
    private static final String COL_DATA_ELEMENT = "dataElementColumn";
    private static final String COL_VALUE_TYPE = "valueTypeColumn";
    private static final String COL_ORGTREE = "orgTreeColumn";
    private static final String COL_ADJUSTSTATUS = "adjustStatus";
    private boolean is13Period = false;
    private boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod(null);
    private boolean isProfit = false;
    private Object pmptOrgUnitF7Value = null;
    private boolean isGroupRptListUI = false;
    private Map<String, List<OrgTreeInfo>> map;
    private boolean isInitOrgTree = false;
    private boolean isLoaded = false;

    public GenerateNextYearInitUI() throws Exception {
        this.is13Period = CslRptUtil.isSupport13Period(null);
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (!this.isGroupRptListUI) {
            super.handlePermissionForItemAction(action);
        }
    }

    public void onLoad() throws Exception {
        this.isGroupRptListUI = this.getUIContext().get("Owner") instanceof GroupRptListUI;
        super.onLoad();
        this.isProfit = OrgType.ProfitCenter.equals(this.getUIContext().get("orgType"));
        this.isLoaded = false;
        this.init();
        this.isLoaded = true;
        if (this.isGroupRptListUI) {
            CSLContextHelper.registUIObject((ICSLContextUI)this);
            if (this.pmptOrgUnit.getData() == null) {
                return;
            }
        }
        this.refreshTableNew();
        this.setAllRowSelected(true);
        this.initListener();
    }

    public void update(Observable o, Object arg) {
        CSLContextHelper.update((Observable)o, (CoreUI)this);
    }

    public void disposeUIWindow() {
        if (this.isGroupRptListUI) {
            CSLContextHelper.unRegistUIObject((ICSLContextUI)this);
        }
        super.disposeUIWindow();
    }

    private void init() throws EASBizException, BOSException {
        OrgUnitInfo selecedCompany = (OrgUnitInfo)this.getUIContext().get("selectedCompany");
        if (this.isGroupRptListUI) {
            this.pmptOrgUnitF7Value = selecedCompany;
            Set orgUnitSet = (Set)this.getUIContext().get("UnitSet");
            UnionF7Helper.UnionF7 f7 = new UnionF7Helper.UnionF7((IUIObject)this, 3);
            f7.setRootUnitID(CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString());
            f7.setTreeID(CSLContextHelper.getCSLContext().getCurOrgBound().getId().toString());
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            f7.filterUnitSql(UnionF7Helper.getMergeModeOrgUnitIDSql(CSLContextHelper.getCSLContext().getCurOrgBound().getId().toString(), CSLContextHelper.getCSLContext().getCurOrgGroup().getId().toString(), CslRptUtil.getMergeMode((OrgTreeInfo)CSLContextHelper.getCSLContext().getCurOrgBound())));
            if (orgUnitSet != null && orgUnitSet.size() > 0) {
                FilterInfo outerFilterInfo = new FilterInfo();
                outerFilterInfo.getFilterItems().add(new FilterItemInfo("unit.id", (Object)orgUnitSet, CompareType.INCLUDE));
                f7.setOuterFilterInfo(outerFilterInfo);
            }
            this.pmptOrgUnit.setSelector((KDPromptSelector)f7);
        } else {
            NewProfitCenterF7 f7;
            if (this.isProfit) {
                f7 = new NewProfitCenterF7((IUIObject)this);
                f7.setPermissionItem("prof_rpt_view");
            } else {
                f7 = new NewCompanyF7((IUIObject)this);
                f7.setPermissionItem("rpt_report_view");
            }
            f7.setShowAssistantOrg(true);
            f7.setCheckedAssistantOrgChkBox(true);
            this.pmptOrgUnit.setSelector((KDPromptSelector)f7);
        }
        this.pmptOrgUnit.setEditable(false);
        this.pmptOrgUnit.setEnabled(true);
        this.pmptOrgUnit.setValue(this.isGroupRptListUI ? this.pmptOrgUnitF7Value : this.getCompanyOrgUnitInfo());
        String currencyId = "";
        if (this.getUIContext().get("currencyId") != null) {
            currencyId = this.getUIContext().get("currencyId").toString();
        } else if (this.isGroupRptListUI) {
            if (selecedCompany != null && selecedCompany.isIsCompanyOrgUnit() && ((CompanyOrgUnitInfo)selecedCompany).getBaseCurrency() != null) {
                currencyId = ((CompanyOrgUnitInfo)selecedCompany).getBaseCurrency().getId().toString();
            }
        } else {
            CompanyOrgUnitInfo currentFIUnit = RptNewUIUtil.getDelegateCompany((Map)this.getUIContext(), (IUIObject)this);
            if (currentFIUnit != null && currentFIUnit.getBaseCurrency() != null) {
                currencyId = currentFIUnit.getBaseCurrency().getId().toString();
            }
        }
        if (!StringUtils.isEmpty((String)currencyId)) {
            CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            this.pmptCurrency.setValue((Object)currencyInfo);
            this.pmptSourceCurrency.setValue((Object)currencyInfo);
        }
        if (this.getUIContext().get("year") != null) {
            this.spYear.setValue(this.getUIContext().get("year"));
        } else {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(System.currentTimeMillis());
            this.spYear.setValue((Object)c.get(1));
        }
        if (this.getUIContext().get("periodType") != null && this.getUIContext().get("period") != null) {
            if (((RptPeriodTypeEnum)this.getUIContext().get("periodType")).getValue() == 3) {
                this.cmbPeriod.addItem((Object)12);
                if (this.is13Period || this.isMergeByFiscalPeriod) {
                    this.cmbPeriod.addItem((Object)13);
                } else {
                    this.cmbPeriod.setEnabled(false);
                }
            } else {
                this.cmbPeriod.addItem(this.getUIContext().get("period"));
                this.cmbPeriod.setEnabled(false);
            }
            this.cmbPeriod.setSelectedItem(this.getUIContext().get("period"), false);
        } else {
            this.cmbPeriod.addItem((Object)12);
            if (this.is13Period || this.isMergeByFiscalPeriod) {
                this.cmbPeriod.addItem((Object)13);
            } else {
                this.cmbPeriod.setEnabled(false);
            }
        }
        this.rptItemKDTable.checkParsed();
        this.rptItemKDTable.getSelectManager().setSelectMode(2);
        this.rptItemKDTable.getColumn(COL_SELECTED).getStyleAttributes().setLocked(false);
        this.rptItemKDTable.getColumn(COL_RPTITEM_NUMBER).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_RPTITEM_NAME).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_SRCCURRENCY).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_CURRENCY).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_YEAR).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_CREDIT).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_DEBIT).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_DATA_ELEMENT).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_VALUE_TYPE).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_ORGTREE).getStyleAttributes().setLocked(true);
        this.rptItemKDTable.getColumn(COL_ADJUSTSTATUS).getStyleAttributes().setLocked(true);
        this.combAdjustStatus.removeItem((Object)AdjustStatusEnum.CALIADJUSTED);
        this.rptItemKDTable.getColumn(COL_ORGTREE).getStyleAttributes().setHided(false);
        this.initOrgTree();
    }

    private FullOrgUnitInfo getCompanyOrgUnitInfo() {
        return RptNewUIUtil.getRptWktOrgUnitInfo((Map)this.getUIContext(), (IUIObject)this).castToFullOrgUnitInfo();
    }

    protected void initListener() {
        this.rptItemKDTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    GenerateNextYearInitUI.this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    GenerateNextYearInitUI.this.handUIException(exc);
                }
            }
        });
    }

    private void eventChange() throws Exception {
        this.isInitOrgTree = true;
        this.initOrgTree();
        this.isInitOrgTree = false;
        this.btnRefresh_actionPerformed(null);
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.setAllRowSelected(true);
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.setAllRowSelected(false);
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.isGroupRptListUI && this.pmptOrgUnit.getData() == null) {
            this.pmptOrgUnit.setValue(this.pmptOrgUnitF7Value);
            return;
        }
        this.rptItemKDTable.removeRows(false);
        this.refreshTableNew();
        if (this.isGroupRptListUI && this.pmptOrgUnitF7Value == null) {
            this.pmptOrgUnitF7Value = this.pmptOrgUnit.getData();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if ((e.getClickCount() != 2 || e.getType() == 0) && e.getClickCount() == 1 && e.getType() == 1) {
            IRow row = this.rptItemKDTable.getRow(e.getRowIndex());
            Boolean chooseValue = (Boolean)row.getCell(COL_SELECTED).getValue();
            row.getCell(COL_SELECTED).setValue((Object)(chooseValue == false ? 1 : 0));
        }
        if (e.getType() == 0 && e.getColIndex() == 1) {
            return;
        }
        if (e.getColIndex() == -1 || e.getType() == 0) {
            // empty if block
        }
    }

    @Override
    protected void btnGenerate_actionPerformed(ActionEvent e) throws Exception {
        ArrayList selectedItemList = new ArrayList();
        HashMap<String, Object> map = null;
        int rowCount = this.rptItemKDTable.getRowCount();
        IRow row = null;
        Object userObject = null;
        Object valueList = null;
        Object valueMap = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.rptItemKDTable.getRow(i);
            if (!((Boolean)row.getCell(COL_SELECTED).getValue()).booleanValue() || (userObject = row.getCell(COL_RPTITEM_NUMBER).getUserObject()) == null || !(userObject instanceof Object[])) continue;
            Object[] data = (Object[])userObject;
            String orgUnitId = ((OrgUnitInfo)this.pmptOrgUnit.getData()).getId().toString();
            int year = (Integer)this.spYear.getValue() + 1;
            int period = (Integer)this.cmbPeriod.getSelectedItem();
            String srcCurrencyId = ((CurrencyInfo)this.pmptSourceCurrency.getData()).getId().toString();
            String currencyId = ((CurrencyInfo)this.pmptCurrency.getData()).getId().toString();
            map = new HashMap<String, Object>();
            map.put("OrgUnitID", orgUnitId);
            map.put("Year", year);
            map.put("Period", period);
            map.put("RptItemID", data[19]);
            map.put("CurrencyID", currencyId);
            map.put("srcCurrencyId", srcCurrencyId);
            map.put("DataElement", data[21]);
            map.put("ValueType", data[20]);
            map.put("Debit", row.getCell(COL_DEBIT).getValue());
            map.put("Credit", row.getCell(COL_CREDIT).getValue());
            map.put("CurrentUserID", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            map.put("ControlUnitID", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            map.put("MergeType", this.isManageMerge() ? 1 : 0);
            selectedItemList.add(map);
        }
        if (selectedItemList.size() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"GenerateNextYearInitData_Dialog_SelectRptItem"));
            return;
        }
        String res = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"confirmTransfer");
        int confirm2 = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(res, this.cmbPeriod.getSelectedItem()));
        if (confirm2 == 2) {
            return;
        }
        boolean isOk = MaintainYearInitDataFacadeFactory.getRemoteInstance().updateItemDataYearInit(selectedItemList);
        if (isOk) {
            MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"GENERATED_N_ROWSDATA2"), selectedItemList.size()));
        }
    }

    private void setAllRowSelected(boolean selected) {
        int rowCount = this.rptItemKDTable.getRowCount();
        IRow row = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.rptItemKDTable.getRow(i);
            if (row == null) continue;
            row.getCell(COL_SELECTED).setValue((Object)selected);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ItemDataYearInitFactory.getRemoteInstance();
    }

    private Map<String, Object> getParam() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Map uiContext = this.getUIContext();
        param.put("companyId", ((OrgUnitInfo)this.pmptOrgUnit.getData()).getId().toString());
        param.put("year", this.spYear.getValue());
        param.put("currencyId", ((CurrencyInfo)this.pmptCurrency.getData()).getId().toString());
        param.put("sourceCurrencyId", ((CurrencyInfo)this.pmptSourceCurrency.getData()).getId().toString());
        param.put("dataCollectNumber", "ACTUALDATA");
        param.put("dataElement", 4);
        param.put("period", this.cmbPeriod.getSelectedItem());
        param.put("isGroupRptListUI", this.isGroupRptListUI);
        return param;
    }

    private void verify() {
        if (this.pmptOrgUnit.getData() == null) {
            MsgBox.showInfo((String)CslRptUtil.getString((String)"YearInitSelectOrgFirst"));
            this.rptItemKDTable.removeRows(false);
            SysUtil.abort();
        }
        if (this.spYear.getValue() == null || this.spYear.getIntegerVlaue() < 1900) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString((String)"YearInitSelectCorrectYear"));
            this.rptItemKDTable.removeRows(false);
            SysUtil.abort();
        }
        if (this.pmptSourceCurrency.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ConvertRate", (String)"137_Need_Select_Currency"));
            this.rptItemKDTable.removeRows(false);
            SysUtil.abort();
        }
        if (this.pmptCurrency.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ConvertRate", (String)"132_Need_Select_Currency"));
            this.rptItemKDTable.removeRows(false);
            SysUtil.abort();
        }
    }

    private void refreshTableNew() throws Exception {
        this.verify();
        if (this.map == null || this.map != null && this.map.isEmpty()) {
            return;
        }
        IRPTDataService dataService = RPTDataServiceFactory.getRemoteInstance();
        ItemDataCondition condition = new ItemDataCondition();
        HashMap extCondition = new HashMap();
        this.setQueryCondition(condition, extCondition);
        ArrayList result = new ArrayList();
        OrgTreeInfo orgTree = (OrgTreeInfo)this.combOrgTree.getSelectedItem();
        if (orgTree != null && orgTree.getId() != null) {
            String orgTreeId = orgTree.getId().toString();
            condition.setOrgTreeId(orgTreeId);
            result = dataService.getItemData(condition, extCondition);
        }
        if (result != null && !result.isEmpty()) {
            int iSize = result.size();
            boolean isAdjusted = ((AdjustStatusEnum)this.combAdjustStatus.getSelectedItem()).equals((Object)AdjustStatusEnum.ADJUSTED);
            this.rptItemKDTable.setRefresh(false);
            this.rptItemKDTable.removeRows();
            HashMap<String, String> orgTreeMap = new HashMap<String, String>();
            for (int i = 0; i < iSize; ++i) {
                IRow tmpRow = this.rptItemKDTable.addRow();
                Object[] row = (Object[])result.get(i);
                tmpRow.getCell(COL_SELECTED).setValue((Object)Boolean.FALSE);
                tmpRow.getCell(COL_RPTITEM_NUMBER).setValue(row[2]);
                tmpRow.getCell(COL_RPTITEM_NAME).setValue(row[3]);
                tmpRow.getCell(COL_SRCCURRENCY).setValue(row[5]);
                tmpRow.getCell(COL_CURRENCY).setValue(row[7]);
                tmpRow.getCell(COL_YEAR).setValue(row[8]);
                tmpRow.getCell(COL_PERIOD).setValue(row[9]);
                tmpRow.getCell(COL_DEBIT).setValue(row[11]);
                tmpRow.getCell(COL_CREDIT).setValue(row[12]);
                tmpRow.getCell(COL_DATA_ELEMENT).setValue(row[16]);
                tmpRow.getCell(COL_VALUE_TYPE).setValue(row[14]);
                tmpRow.getCell(COL_ADJUSTSTATUS).setValue((Object)(isAdjusted ? AdjustStatusEnum.ADJUSTED : AdjustStatusEnum.BEFOREADJUST));
                String orgTreeId = (String)row[18];
                if (!orgTreeMap.containsKey(orgTreeId)) {
                    OrgTreeInfo tree = OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgTreeId));
                    tmpRow.getCell(COL_ORGTREE).setValue((Object)tree.getName());
                    orgTreeMap.put(orgTreeId, tree.getName());
                } else {
                    tmpRow.getCell(COL_ORGTREE).setValue(orgTreeMap.get(orgTreeId));
                }
                tmpRow.getCell(COL_RPTITEM_NUMBER).setUserObject((Object)row);
            }
            this.rptItemKDTable.setRefresh(true);
            this.rptItemKDTable.reLayoutAndPaint();
            this.rptItemKDTable.repaint();
        }
    }

    private void setQueryCondition(ItemDataCondition condition, HashMap extCondition) throws BOSException {
        ArrayList<String> lstCompany = new ArrayList<String>();
        String companyNumber = ((OrgUnitInfo)this.pmptOrgUnit.getData()).getNumber();
        lstCompany.add(companyNumber);
        condition.setOrgUnitNumber(lstCompany);
        condition.setCommitStatus(3);
        boolean isAdjusted = ((AdjustStatusEnum)this.combAdjustStatus.getSelectedItem()).equals((Object)AdjustStatusEnum.ADJUSTED);
        condition.setIsAdjusted(isAdjusted);
        condition.setRptPeriodType(3);
        int curRptYear = Integer.valueOf(this.spYear.getValue().toString());
        int curRptPeriod = (Integer)this.cmbPeriod.getSelectedItem();
        condition.setRptYearStart(curRptYear);
        condition.setRptPeriodStart(curRptPeriod);
        condition.setRptYearEnd(curRptYear);
        condition.setRptPeriodEnd(curRptPeriod);
        condition.setDataSource(1);
        condition.setDataElement(4);
        condition.setIsAllowAmountZero(true);
        condition.setValueType(-1);
        condition.setDataCollectNumber("ACTUALDATA");
        condition.setIsForCompanyGenNextYearInit(true);
        extCondition.put("isShowSum", false);
        extCondition.put("dataType", new Integer(2));
        extCondition.put("excludeAdjust", Boolean.TRUE);
        extCondition.put("excludeElim", Boolean.TRUE);
        extCondition.put("dataCollectNumber", "ACTUALDATA");
        extCondition.put("KEY_ORGUNIT_INFO", (OrgUnitInfo)this.pmptOrgUnit.getData());
        extCondition.put("isYearInit", false);
    }

    private void getOrgTreeIds(Map<String, OrgTreeInfo> map, List<String> orgTreeIds) {
        for (String reportId : map.keySet()) {
            OrgTreeInfo orgtree = map.get(reportId);
            orgTreeIds.add(orgtree.getId().toString());
        }
    }

    private Map<String, BigDecimal> getReportSetToTable(Book book) {
        HashMap<String, BigDecimal> valueMap = new HashMap<String, BigDecimal>();
        Sheet sheet = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            BookProperties bookProperties;
            ReportVariables reVariables;
            sheet = book.getSheet(s);
            if (sheet == null || (reVariables = (bookProperties = BookProperties.loadFromBook(book)).getVariables()).getIntValue("SheetClass", sheet.getSheetName(), 1) != 1) continue;
            int maxRowIndex = sheet.getMaxRowIndex() + 1;
            int maxColIndex = sheet.getMaxColIndex() + 1;
            Cell cell = null;
            ItemFormula rptF = null;
            Object valueObject = null;
            BigDecimal value = null;
            for (int i = 0; i < maxRowIndex; ++i) {
                for (int j = 0; j < maxColIndex; ++j) {
                    cell = sheet.getCell(i, j, false);
                    if (cell == null || (rptF = (ItemFormula)cell.getUserObjectValue("ITEM")) == null || !"ENDBALANCE".equalsIgnoreCase(rptF.getDataElementNumber()) || cell.getValue() == null) continue;
                    valueObject = cell.getValue().getValue();
                    if (valueObject instanceof BigDecimal) {
                        value = (BigDecimal)valueObject;
                    } else if (valueObject instanceof String) {
                        if (StringUtils.isEmpty((String)((String)valueObject))) {
                            value = null;
                        } else {
                            try {
                                value = new BigDecimal(((String)valueObject).trim());
                            }
                            catch (NumberFormatException e) {
                                value = null;
                            }
                        }
                    } else {
                        value = null;
                    }
                    valueMap.put(rptF.getItemNumber(), value);
                }
            }
        }
        return valueMap;
    }

    private void refreshTable() throws Exception {
        this.verify();
        List valueList = ((IItemDataYearInit)this.getBizInterface()).getItemDataByCompany(this.getParam());
        if (valueList == null) {
            return;
        }
        HashMap<String, Book> kdfMap = new HashMap<String, Book>();
        Object info = null;
        Book kdf = null;
        HashSet<String> reportIdSet = new HashSet<String>();
        for (int i = 0; i < valueList.size(); ++i) {
            reportIdSet.add(((Map)valueList.get(i)).get("ReportID").toString());
        }
        String reportIds = "";
        Iterator it = reportIdSet.iterator();
        while (it.hasNext()) {
            reportIds = reportIds + "'" + it.next() + "',";
        }
        reportIds = reportIds.length() > 0 ? reportIds.substring(0, reportIds.length() - 1) : "";
        HashMap<String, Map<String, BigDecimal>> reportDataMap = new HashMap<String, Map<String, BigDecimal>>();
        CslReportCollection col = CslReportFactory.getRemoteInstance().getCslReportCollection("select id, data where id in (" + reportIds + ")");
        Book book = null;
        for (int i = 0; i < col.size(); ++i) {
            book = col.get(i).getBook();
            kdfMap.put(col.get(i).getId().toString(), book);
            reportDataMap.put(col.get(i).getId().toString(), this.getReportSetToTable(book));
        }
        this.rptItemKDTable.setRefresh(false);
        this.rptItemKDTable.removeRows();
        Iterator it2 = valueList.iterator();
        Map valueMap = null;
        Object parentTableCell = null;
        BigDecimal value = null;
        Map oneReportValue = null;
        while (it2.hasNext()) {
            Sheet sheet;
            value = null;
            valueMap = (Map)it2.next();
            kdf = (Book)kdfMap.get(valueMap.get("ReportID"));
            oneReportValue = (Map)reportDataMap.get(valueMap.get("ReportID"));
            if (oneReportValue == null || oneReportValue.size() == 0 || (sheet = kdf.getSheetByID((String)valueMap.get("RptItemSheetID"))) == null) continue;
            value = (BigDecimal)oneReportValue.get(valueMap.get("RptItemNumber"));
            if ((Integer)valueMap.get("RptItemDC") == 1) {
                this.buildTableRow(valueMap, value, null);
                continue;
            }
            if ((Integer)valueMap.get("RptItemDC") != 0) continue;
            this.buildTableRow(valueMap, null, value);
        }
        this.rptItemKDTable.setRefresh(true);
        this.rptItemKDTable.repaint();
    }

    private void buildTableRow(Map valueMap, BigDecimal debitValue, BigDecimal creditValue) throws Exception {
        String itemNumber = (String)valueMap.get("RptItemNumber");
        if (StringUtils.isEmpty((String)itemNumber)) {
            return;
        }
        int rowCount = this.rptItemKDTable.getRowCount();
        IRow row = null;
        ArrayList<Map> valueList = null;
        int valueType = (Integer)valueMap.get("ValueType");
        for (int i = 0; i < rowCount; ++i) {
            row = this.rptItemKDTable.getRow(i);
            if (!itemNumber.equals(row.getCell(COL_RPTITEM_NUMBER).getValue()) || !ValueTypeEnum.getEnum((int)valueType).getAlias().equals(row.getCell(COL_VALUE_TYPE).getValue())) continue;
            String tempStr = (String)row.getCell(COL_ORGTREE).getValue();
            row.getCell(COL_ORGTREE).setValue((Object)(tempStr + "/" + valueMap.get("OrgTreeName")));
            valueList = (ArrayList<Map>)row.getCell(COL_RPTITEM_NUMBER).getUserObject();
            valueList.add(valueMap);
            return;
        }
        row = this.rptItemKDTable.addRow();
        row.getCell(COL_SELECTED).setValue((Object)new Boolean(false));
        row.getCell(COL_RPTITEM_NUMBER).setValue(valueMap.get("RptItemNumber"));
        row.getCell(COL_RPTITEM_NAME).setValue(valueMap.get("RptItemName"));
        row.getCell(COL_SRCCURRENCY).setValue(valueMap.get("srcCurrencyName"));
        row.getCell(COL_CURRENCY).setValue(valueMap.get("CurrencyName"));
        row.getCell(COL_YEAR).setValue(valueMap.get("Year"));
        row.getCell(COL_PERIOD).setValue(valueMap.get("Period"));
        row.getCell(COL_CREDIT).setValue((Object)creditValue);
        row.getCell(COL_DEBIT).setValue((Object)debitValue);
        row.getCell(COL_DATA_ELEMENT).setValue((Object)DataElementProvider.getDataElementName((int)((Integer)valueMap.get("DataElement"))));
        row.getCell(COL_VALUE_TYPE).setValue((Object)ValueTypeEnum.getEnum((int)((Integer)valueMap.get("ValueType"))).getAlias());
        row.getCell(COL_ORGTREE).setValue(valueMap.get("OrgTreeName"));
        valueList = new ArrayList<Map>();
        valueList.add(valueMap);
        row.getCell(COL_RPTITEM_NUMBER).setUserObject(valueList);
    }

    protected boolean isManageMerge() {
        return false;
    }

    @Override
    protected void combAdjustStatus_actionPerformed(ActionEvent e) throws Exception {
        this.btnRefresh_actionPerformed(null);
    }

    private void initOrgTree() throws EASBizException, BOSException {
        this.combOrgTree.removeAllItems();
        this.map = RPTDataServiceFactory.getRemoteInstance().getRptIdAndOrgTreeInfoByCompany(this.getParam());
        ArrayList<OrgTreeInfo> orgTrees = new ArrayList<OrgTreeInfo>();
        if (this.map != null && !this.map.isEmpty()) {
            for (String reportId : this.map.keySet()) {
                List<OrgTreeInfo> trees = this.map.get(reportId);
                for (OrgTreeInfo orgTree : trees) {
                    if (orgTrees.contains(orgTree)) continue;
                    orgTrees.add(orgTree);
                }
            }
        }
        if (orgTrees.size() > 1) {
            Collections.sort(orgTrees, new Comparator<OrgTreeInfo>(){

                @Override
                public int compare(OrgTreeInfo o1, OrgTreeInfo o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
        }
        if (!orgTrees.isEmpty()) {
            this.combOrgTree.addItems(orgTrees.toArray());
        }
    }

    @Override
    protected void combOrgTree_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isInitOrgTree) {
            this.btnRefresh_actionPerformed(null);
        }
    }

    @Override
    protected void pmptOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isLoaded) {
            this.verify();
            this.eventChange();
        }
    }

    @Override
    protected void pmptCurrency_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isLoaded) {
            this.verify();
            this.eventChange();
        }
    }

    @Override
    protected void pmptSourceCurrency_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isLoaded) {
            this.verify();
            this.eventChange();
        }
    }

    @Override
    protected void spYear_stateChanged(ChangeEvent e) throws Exception {
        if (this.isLoaded) {
            this.verify();
            this.eventChange();
        }
    }

    @Override
    protected void cmbPeriod_actionPerformed(ActionEvent e) throws Exception {
        if (this.isLoaded) {
            this.verify();
            this.eventChange();
        }
    }
}

