/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.OrgUnitConvtHelper;
import com.kingdee.eas.fi.rpt.CashTypeEnum;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.CashFlowFormulaStructure;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;

public class INCashFlowFormulaStructure
extends CashFlowFormulaStructure {
    public INCashFlowFormulaStructure(FormulaHint hint) {
        super(hint);
    }

    @Override
    public void parseAccountItem(String accountAndItem) {
        StringTokenizer accountandItemToken = new StringTokenizer(accountAndItem, "|");
        if (accountandItemToken.hasMoreElements()) {
            this.project = accountandItemToken.nextToken();
        }
        while (accountandItemToken.hasMoreElements()) {
            String temptype = null;
            String temptypeItem = null;
            if (this.items == null) {
                this.items = new HashMap();
            }
            temptype = accountandItemToken.nextToken();
            if (accountandItemToken.hasMoreElements()) {
                temptypeItem = accountandItemToken.nextToken();
            }
            this.items.put(temptype, temptypeItem);
        }
    }

    @Override
    public void structure() throws Exception {
        if (this.parameter == null || this.parameter.isEmpty() || this.parameter.size() != 8) {
            MsgBox.showError((String)RptUtil.getReportResource("RPT_LEDGER_ERROR"));
            SysUtil.abort();
        }
        this.company = (String)this.parameter.get(0);
        if (this.company != null && this.company.trim().length() > 0) {
            this.companyOrg = RptUtilForClient.getCompanyOrgUnitInfoByNumber(this.company);
            if (this.companyOrg == null) {
                if (TableToolkit.isCellRef(this.company)) {
                    MsgBox.showError((String)RptUtil.getReportResource("RPT_NOSUPPORT_LEDGE"));
                } else {
                    MsgBox.showError((String)RptUtil.getResourceSince51("NoExistsCompany"));
                }
                SysUtil.abort();
            }
            this.company = this.companyOrg.getId().toString();
            this.isOnlyUnion = this.companyOrg.isIsOnlyUnion();
        } else {
            this.companyOrg = OrgUnitConvtHelper.convtFullToCompanyNotRemote((FullOrgUnitInfo)this.report.getCompany());
            this.companyOrg = RptUtilForClient.getCompanyOrgUnitInfoByNumber(this.companyOrg.getNumber());
            this.company = this.companyOrg.getId().toString();
            this.isOnlyUnion = this.companyOrg.isIsOnlyUnion();
        }
        this.oppCompany = (String)this.parameter.get(1);
        if (this.oppCompany != null && this.oppCompany.trim().length() > 0) {
            CompanyOrgUnitInfo oppCompanyOrg = RptUtilForClient.getCompanyOrgUnitInfoByNumber(this.oppCompany);
            if (oppCompanyOrg == null) {
                if (TableToolkit.isCellRef(this.oppCompany)) {
                    MsgBox.showError((String)RptUtil.getReportResource("RPT_NOSUPPORT_LEDGE"));
                } else {
                    MsgBox.showError((String)RptUtil.getResourceSince51("NoExistsCompany"));
                }
                SysUtil.abort();
            }
            this.oppCompany = oppCompanyOrg.getId().toString();
        }
        Integer Period_Type = new Integer(this.report.getPeriodType().getValue());
        String temp = (String)this.parameter.get(4);
        try {
            this.startYear = Integer.parseInt(temp);
        }
        catch (Exception e) {
            this.startYear = 0;
        }
        if (this.startYear <= 0) {
            this.startYear = this.rptSheetParam.getStartYear() + this.startYear;
            if (this.startYear <= 0) {
                this.startYear = this.report.getYear() + this.startYear;
            }
        }
        String temp2 = (String)this.parameter.get(5);
        try {
            this.startFiscal = Integer.parseInt(temp2);
        }
        catch (Exception e) {
            this.startFiscal = 0;
        }
        if (this.startFiscal <= 0) {
            this.startFiscal = this.rptSheetParam.getStartPeriod() + this.startFiscal;
            if (this.startFiscal <= 0) {
                this.startFiscal = this.report.getPeriod() + this.startFiscal;
            }
            if (this.startFiscal <= 0) {
                --this.startYear;
                this.startFiscal += PeriodUtils.getMaxPeriodNumber(null, (int)this.startYear, (String)this.companyOrg.getId().toString());
            } else if (Period_Type != null && (Period_Type != 3 || this.startFiscal <= 12)) {
                Date periodLastDate = RPTDateUtil.getPeriodFirstDate((int)this.startYear, (int)this.startFiscal, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)Period_Type));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(periodLastDate);
                this.startYear = calendar.get(1);
                this.startFiscal = calendar.get(2) + 1;
            }
        }
        String temp3 = (String)this.parameter.get(4);
        try {
            this.endYear = Integer.parseInt(temp3);
        }
        catch (Exception e) {
            this.endYear = 0;
        }
        if (this.endYear <= 0) {
            this.endYear = this.rptSheetParam.getEndYear() + this.endYear;
            if (this.endYear <= 0) {
                this.endYear = this.report.getYear() + this.endYear;
            }
        }
        String temp4 = (String)this.parameter.get(6);
        try {
            this.endFiscal = Integer.parseInt(temp4);
        }
        catch (Exception e) {
            this.endFiscal = 0;
        }
        if (this.endFiscal <= 0) {
            this.endFiscal = this.rptSheetParam.getEndPeriod() + this.endFiscal;
            if (this.endFiscal <= 0) {
                this.endFiscal = this.report.getPeriod() + this.endFiscal;
            }
            if (this.endFiscal <= 0) {
                --this.endYear;
                this.endFiscal += PeriodUtils.getMaxPeriodNumber(null, (int)this.startYear, (String)this.companyOrg.getId().toString());
            } else if (Period_Type != null) {
                Calendar calendar = Calendar.getInstance();
                if (Period_Type != 3 || this.endFiscal <= 12) {
                    Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)this.endYear, (int)this.endFiscal, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)Period_Type));
                    calendar.setTime(periodLastDate);
                    this.endYear = calendar.get(1);
                    this.endFiscal = calendar.get(2) + 1;
                }
            }
        }
        if (this.endYear < this.startYear) {
            int t = this.startYear;
            this.startYear = this.endYear;
            this.endYear = t;
        } else if (this.endFiscal < this.startFiscal) {
            int t = this.startFiscal;
            this.startFiscal = this.endFiscal;
            this.endFiscal = t;
        }
        String tempcurrency = (String)this.parameter.get(3);
        this.currencyInfo = tempcurrency == null || tempcurrency.trim().length() == 0 ? (this.rptSheetParam.getCurrency() != null ? this.rptSheetParam.getCurrency() : (this.parameter.get(2).equals(CashTypeEnum.Z.getName()) || this.parameter.get(2).equals(CashTypeEnum.AZ.getName()) ? RptUtilForClient.getCurrency("GLC") : (this.parameter.get(2).equals(CashTypeEnum.S.getName()) || this.parameter.get(2).equals(CashTypeEnum.AS.getName()) ? RptUtilForClient.getCurrency("GRC") : this.report.getCurrency()))) : RptUtilForClient.getCurrency(tempcurrency.toUpperCase());
        if (this.currencyInfo == null) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("CurrencyOutOfPlace"));
            SysUtil.abort();
        }
        this.currencyId = this.currencyInfo.getId().toString();
        this.parseAccountItem((String)this.parameter.get(7));
    }
}

