/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTViewManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.IndexDataFactory;
import com.kingdee.eas.fi.rpt.IndexDataInfo;
import com.kingdee.eas.fi.rpt.IndexItemFactory;
import com.kingdee.eas.fi.rpt.IndexItemInfo;
import com.kingdee.eas.fi.rpt.IndexStateEnum;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.client.AbstractIndexCustomQueryListUI;
import com.kingdee.eas.fi.rpt.client.FindLedger;
import com.kingdee.eas.fi.rpt.client.IndexCustomerQuery;
import com.kingdee.eas.fi.rpt.client.IndexItemEditUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexCustomQueryListUI
extends AbstractIndexCustomQueryListUI {
    private static final long serialVersionUID = -5466525723626871660L;
    private EntityViewInfo mainQuery;
    private MetaDataPK metaDataPK = new MetaDataPK("com.kingdee.eas.fi.rpt.app", "IndexDataQuery");
    private int rownum = 0;
    private boolean isGlobeTotalUp = false;
    private boolean isFirstDefaultQuery = true;
    private InnerIndexDataInfo rowInfo = new InnerIndexDataInfo();
    private final BigDecimal ZERO = new BigDecimal("0");
    private CommonQueryDialog dialog = null;
    private static String menuItemCopy = "menuItemCopy";
    private static String menuItemPaste = "menuItemPaste";

    private String getEditUIName() {
        return IndexItemEditUI.class.getName();
    }

    private ICoreBase getBizInterface() throws Exception {
        return IndexItemFactory.getRemoteInstance();
    }

    private void fillKDTable() throws BOSException, SQLException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.metaDataPK);
        exec.option().isAutoTranslateEnum = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.setObjectView(this.mainQuery);
        IRowSet rowSet = exec.executeQuery();
        while (rowSet.next()) {
            this.constructTable(rowSet);
        }
        this.rowInfo.setLastData(this.rowInfo.getCurrentData());
        if (this.isGlobeTotalUp) {
            this.insertTotalUp(true, true, true, true);
        }
        this.initActionStauts(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTViewManager viewmgr = this.kdtIdxDataRpt.getViewManager();
        if (viewmgr != null && !viewmgr.isFreeze()) {
            viewmgr.setFreezeView(0, 4);
            this.kdtIdxDataRpt.setRefresh(true);
            this.kdtIdxDataRpt.reLayoutAndPaint();
        }
    }

    private CommonQueryDialog initCommonQueryDialog() throws Exception {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            this.dialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.dialog.setEntityViewInfo(new EntityViewInfo());
            this.dialog.setQueryObjectPK((IMetaDataPK)this.metaDataPK);
            this.dialog.setHeight(300);
            this.dialog.setWidth(400);
            IndexCustomerQuery customerQuery = new IndexCustomerQuery();
            this.dialog.addUserPanel((KDPanel)customerQuery);
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(false);
            this.dialog.setShowToolbar(true);
            this.dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_data_custocmQuery_title"));
        }
        return this.dialog;
    }

    public void onLoad() throws Exception {
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.itemFindIndexData.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.kDSeparator5.setVisible(true);
        this.kDSeparator6.setVisible(true);
        this.menuItemEnableIdx.setIcon(this.btnEffective.getIcon());
        super.onLoad();
        this.kdtIdxDataRpt.checkParsed();
        this.kdtIdxDataRpt.getIndexColumn().getStyleAttributes().setHided(true);
        this.kdtIdxDataRpt.getSelectManager().setSelectMode(2);
        this.enableExportExcel(this.kdtIdxDataRpt);
        this.actionFindIndexData.setEnabled(true);
        this.btnEdit.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.findAccount.setVisible(false);
        if (this.initDefaultFilter()) {
            this.actionQuery_actionPerformed(null);
            this.isFirstDefaultQuery = false;
        }
        this.kdtIdxDataRpt.addKDTMouseListener((KDTMouseListener)new SelfItemListener());
        this.checkTableCommonMenu(this.getTableForCommon());
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
    }

    protected KDTable getTableForCommon() {
        return this.kdtIdxDataRpt;
    }

    protected void checkTableCommonMenu(KDTable table) {
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if (menuItemPaste.equalsIgnoreCase(pop.getComponent(i).getName())) {
                pop.getComponent(i).setVisible(false);
            }
            if (!menuItemCopy.equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    private void initActionStauts(boolean isEnable) {
        this.btnEffective.setEnabled(isEnable);
        this.actionEffective.setEnabled(isEnable);
        this.btnRemove.setEnabled(isEnable);
        this.actionRemove.setEnabled(isEnable);
        this.btnView.setEnabled(isEnable);
        this.actionView.setEnabled(isEnable);
    }

    private void setQuerySort() {
        SorterItemCollection sorter = this.mainQuery.getSorter();
        sorter.add(new SorterItemInfo("company.longnumber"));
        sorter.add(new SorterItemInfo("itemType.name"));
        sorter.add(new SorterItemInfo("indexItem.number"));
        sorter.add(new SorterItemInfo("report.year"));
        sorter.add(new SorterItemInfo("report.period"));
        sorter.add(new SorterItemInfo("report.sourceType"));
        SorterItemInfo sortItem = new SorterItemInfo("template.createTime");
        sortItem.setSortType(SortType.DESCEND);
        sorter.add(sortItem);
        sortItem = new SorterItemInfo("lastUpdateTime");
        sortItem.setSortType(SortType.DESCEND);
        sorter.add(sortItem);
    }

    private void refresh(ActionEvent e) throws BOSException, SQLException {
        this.kdtIdxDataRpt.removeRows();
        this.rowInfo.initiate();
        this.rownum = 0;
        this.fillKDTable();
    }

    private String getKeyFieldName() {
        return "indexItem.id";
    }

    private void beforeAction(ActionEvent e) throws EASBizException, BOSException, Exception {
        super.beforeActionPerformed(e);
        KDTSelectBlock selectManager = this.kdtIdxDataRpt.getSelectManager().get();
        Object source = e.getSource();
        if (selectManager == null) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_report_SelectRowFirst"));
            this.showMessage();
            SysUtil.abort();
        }
        if (source == this.btnEdit || source == this.btnRemove || source == this.btnView || source == this.btnEffective) {
            int row = selectManager.getBeginRow();
            String idxItemKey = (String)this.kdtIdxDataRpt.getRow(row).getCell(this.getKeyFieldName()).getValue();
            if (idxItemKey == null) {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_report_SelectRowFirst"));
                this.showMessage();
                SysUtil.abort();
            } else if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(idxItemKey))) {
                this.refresh(e);
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
        }
    }

    private void constructTable(IRowSet rs) throws SQLException {
        boolean isCompanyTotalUp = false;
        boolean isIndexTypeTotalUp = false;
        boolean isIndexItemTotalUp = false;
        boolean isYearTotalUp = false;
        this.rowInfo.fill(rs);
        Map currentMap = this.rowInfo.getCurrentData();
        Map lastMap = this.rowInfo.getLastData();
        String companyId = (String)currentMap.get("COMPANY.ID");
        String companyName = (String)currentMap.get("COMPANY.NAME");
        String itemTypeId = (String)currentMap.get("ITEMTYPE.ID");
        String itemTypeName = (String)currentMap.get("ITEMTYPE.NAME");
        String indexItemNum = (String)currentMap.get("INDEXITEM.NUMBER");
        String year = (String)currentMap.get("REPORT.YEAR");
        String indexValue = (String)currentMap.get("INDEXVALUE");
        String period = (String)currentMap.get("REPORT.PERIOD");
        String rptSrcType = (String)currentMap.get("REPORT.SOURCETYPE");
        if (lastMap.get("COMPANY.ID") != null && companyId.equals(lastMap.get("COMPANY.ID")) && indexItemNum.equals(lastMap.get("INDEXITEM.NUMBER")) && year.equals(lastMap.get("REPORT.YEAR")) && period.equals(lastMap.get("REPORT.PERIOD")) && rptSrcType.equals(lastMap.get("REPORT.SOURCETYPE"))) {
            return;
        }
        if (lastMap.get("COMPANY.ID") != null && !companyId.equals(lastMap.get("COMPANY.ID"))) {
            isCompanyTotalUp = true;
        }
        if (isCompanyTotalUp) {
            isIndexTypeTotalUp = true;
        } else if (!(this.rownum != 0 && itemTypeId.equals(lastMap.get("ITEMTYPE.ID")) || this.rownum == 0)) {
            isIndexTypeTotalUp = true;
        }
        if (isIndexTypeTotalUp) {
            isIndexItemTotalUp = true;
        } else if (!(this.rownum != 0 && indexItemNum.equals(lastMap.get("INDEXITEM.NUMBER")) || this.rownum == 0)) {
            isIndexItemTotalUp = true;
        }
        if (isIndexItemTotalUp) {
            isYearTotalUp = true;
        } else if (this.rownum != 0 && year.equals(lastMap.get("REPORT.YEAR"))) {
            year = "";
        } else if (this.rownum != 0) {
            isYearTotalUp = true;
        }
        this.rowInfo.addAmount();
        if (this.isGlobeTotalUp) {
            this.insertTotalUp(isCompanyTotalUp, isIndexTypeTotalUp, isIndexItemTotalUp, isYearTotalUp);
        }
        this.insertRowDetail(companyName, itemTypeName, year, indexValue, rs);
    }

    private void insertTotalUp(boolean isCompanyTotalUp, boolean isIndexTypeTotalUp, boolean isIndexItemTotalUp, boolean isYearTotalUp) {
        boolean isCompanyAmtValid;
        Map lastData = this.rowInfo.getLastData();
        Map markData = this.rowInfo.getMarkData();
        Map totalData = this.rowInfo.getTotalData();
        if (this.rowInfo.getLastData().get("COMPANY.ID") == null) {
            return;
        }
        String lastYear = (String)lastData.get("REPORT.YEAR");
        String lastIdxItem = (String)lastData.get("INDEXITEM.NUMBER");
        String lastIdxType = (String)lastData.get("ITEMTYPE.ID");
        String companyId = (String)lastData.get("COMPANY.ID");
        boolean isYearAmtValid = markData.get("YEAR" + lastYear + lastIdxItem) == null;
        boolean isIndexAmtValid = markData.get("INDEXITEM" + lastIdxItem) == null;
        boolean isIndexTypeAmtValid = markData.get("INDEXITEMTYPE" + lastIdxType) == null;
        boolean bl = isCompanyAmtValid = markData.get("COMPANY" + companyId) == null;
        if (isYearTotalUp && isYearAmtValid) {
            this.insertYearTotalUp((BigDecimal)totalData.get("YEAR" + lastYear + lastIdxItem));
        }
        if (isIndexItemTotalUp && isIndexAmtValid) {
            BigDecimal itemAmt = (BigDecimal)totalData.get("INDEXITEM" + lastIdxItem);
            this.insertItemTotalUp(itemAmt == null ? this.ZERO : itemAmt);
        }
        if (isIndexTypeTotalUp && isIndexTypeAmtValid) {
            BigDecimal typeAmt = (BigDecimal)totalData.get("INDEXITEMTYPE" + lastIdxType);
            this.insertTypeTotalUp(typeAmt == null ? this.ZERO : typeAmt);
        }
        if (isCompanyTotalUp && isCompanyAmtValid) {
            BigDecimal companyAmt = (BigDecimal)totalData.get("COMPANY" + companyId);
            this.insertCompanyTotalUp(companyAmt == null ? this.ZERO : companyAmt);
        }
    }

    private void insertRowDetail(String companyName, String indexTypeName, String reportYear, String indexValue, IRowSet rs) throws SQLException {
        IRow row = this.kdtIdxDataRpt.addRow();
        row.getStyleAttributes().setLocked(true);
        BizEnumValueInfo enumValueInfo = (BizEnumValueInfo)rs.getObject("indexItem.state");
        if (enumValueInfo.getInt() == 1) {
            row.getCell("indexItem.state").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_btn_enable"));
        } else {
            row.getCell("indexItem.state").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_btn_disabled"));
        }
        row.getCell("indexItem.number").setValue((Object)rs.getString("indexItem.number"));
        row.getCell("indexItem.name").setValue((Object)rs.getString("indexItem.name"));
        row.getCell("indexItem.formula").setValue((Object)rs.getString("indexItem.formula"));
        row.getCell("indexItem.description").setValue((Object)rs.getString("indexItem.description"));
        row.getCell("creator.name").setValue((Object)rs.getString("creator.name"));
        row.getCell("indexItem.createTime").setValue((Object)DateTimeUtils.format((Date)rs.getDate("indexItem.createTime")));
        row.getCell("template.name").setValue((Object)(rs.getString("template.name") + "_v" + rs.getString("template.versionNumber") + "|" + rs.getString("sheetParam.sheetName") + "[" + rs.getString("indexItem.cell") + "]"));
        row.getCell("itemType.name").setValue((Object)indexTypeName);
        row.getCell("company.name").setValue((Object)companyName);
        row.getCell("report.year").setValue((Object)rs.getString("report.year"));
        row.getCell("report.period").setValue((Object)String.valueOf(rs.getInt("report.period")));
        row.getCell("report.startDate").setValue(rs.getObject("report.startDate"));
        row.getCell("report.endDate").setValue(rs.getObject("report.endDate"));
        row.getCell("currency.name").setValue((Object)rs.getString("currency.name"));
        row.getCell("indexValue").setValue((Object)indexValue);
        row.getCell("lastUpdateUser.name").setValue((Object)rs.getString("lastUpdateUser.name"));
        row.getCell("lastUpdateTime").setValue((Object)rs.getDate("lastUpdateTime"));
        row.getCell("report.sourceType").setValue((Object)rs.getString("report.sourceType"));
        row.getCell("indexItem.id").setValue((Object)rs.getString("indexItem.id"));
        row.getCell("indexItem.templateId").setValue((Object)rs.getString("indexItem.templateId"));
        row.getCell("currency.id").setValue((Object)rs.getString("currency.id"));
        row.getCell("company.id").setValue((Object)rs.getString("company.id"));
        row.getCell("id").setValue((Object)rs.getString("id"));
        ++this.rownum;
    }

    private void insertYearTotalUp(BigDecimal yearAmt) {
        IRow row = this.kdtIdxDataRpt.addRow();
        row.getStyleAttributes().setLocked(true);
        row.getCell("currency.name").setValue((Object)RptUtil.getResourceSince51("YearlyCount"));
        row.getCell("indexValue").setValue((Object)yearAmt);
        row.getStyleAttributes().setBackground(new Color(249, 244, 246));
        ++this.rownum;
    }

    private void insertItemTotalUp(BigDecimal indexAmt) {
        IRow row = this.kdtIdxDataRpt.addRow();
        row.getStyleAttributes().setLocked(true);
        row.getCell("currency.name").setValue((Object)RptUtil.getResourceSince51("ItemCount"));
        row.getCell("indexValue").setValue((Object)indexAmt);
        row.getStyleAttributes().setBackground(new Color(252, 252, 242));
        ++this.rownum;
    }

    private void insertTypeTotalUp(BigDecimal indexTypeAmt) {
        IRow row = this.kdtIdxDataRpt.addRow();
        row.getStyleAttributes().setLocked(true);
        row.getCell("currency.name").setValue((Object)RptUtil.getResourceSince51("TypeCount"));
        row.getCell("indexValue").setValue((Object)indexTypeAmt);
        row.getStyleAttributes().setBackground(new Color(236, 241, 255));
        ++this.rownum;
    }

    private void insertCompanyTotalUp(BigDecimal totalAmt) {
        IRow row = this.kdtIdxDataRpt.addRow();
        row.getStyleAttributes().setLocked(true);
        row.getCell("currency.name").setValue((Object)RptUtil.getResourceSince51("CompanyCount"));
        row.getCell("indexValue").setValue((Object)totalAmt);
        row.getStyleAttributes().setBackground(new Color(255, 246, 220));
        ++this.rownum;
        this.rowInfo.setLastData(this.rowInfo.getCurrentData());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnView);
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnView.setEnabled(true);
        this.setButtonDefaultStyl(this.btnQuery);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnQuery.setEnabled(true);
        this.setButtonDefaultStyl(this.btnRemove);
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnRemove.setEnabled(true);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnRefresh.setEnabled(true);
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrint.setEnabled(true);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnPrintPreview.setEnabled(true);
        this.btnEffective.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnEffective.setEnabled(true);
        this.menuItemPrint.setEnabled(true);
        this.menuItemPrintPreview.setEnabled(true);
        this.menuItemQuery.setEnabled(true);
        this.menuItemRefresh.setEnabled(true);
        this.menuItemEnableIdx.setIcon(this.btnEffective.getIcon());
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.beforeAction(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.refresh(e);
    }

    private String getSelectedKeyValue() {
        KDTSelectBlock selectBlock = this.kdtIdxDataRpt.getSelectManager().get();
        int row = selectBlock.getBeginRow();
        return (String)this.kdtIdxDataRpt.getRow(row).getCell(this.getKeyFieldName()).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionEffective_actionPerformed(ActionEvent e) throws Exception {
        this.beforeAction(e);
        RptUtil.reqDataMutex((CoreUI)this, this.getSelectedKeyValue(), OprtState.EDIT);
        try {
            ICoreBase bizInterface = this.getBizInterface();
            ObjectUuidPK objectPK = new ObjectUuidPK(this.getSelectedKeyValue());
            IndexItemInfo indexItemInfo = (IndexItemInfo)bizInterface.getValue((IObjectPK)objectPK);
            if (indexItemInfo.getState() == IndexStateEnum.unEffective) {
                indexItemInfo.setState(IndexStateEnum.effective);
            } else {
                indexItemInfo.setState(IndexStateEnum.unEffective);
            }
            bizInterface.update((IObjectPK)objectPK, (CoreBaseInfo)indexItemInfo);
        }
        finally {
            RptUtil.releaseDataMutex((CoreUI)this, this.getSelectedKeyValue());
            this.refresh(e);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtIdxDataRpt);
        this.kdtIdxDataRpt.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtIdxDataRpt);
        this.kdtIdxDataRpt.getPrintManager().printPreview();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.beforeAction(e);
        int isConfirm = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_DeleteConfirm"));
        if (MsgBox.isYes((int)isConfirm)) {
            RptUtil.reqDataMutex((CoreUI)this, this.getSelectedKeyValue(), "REMOVE");
            try {
                this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
            }
            catch (ObjectNotFoundException onfe) {
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            finally {
                RptUtil.releaseDataMutex((CoreUI)this, this.getSelectedKeyValue());
                this.refresh(e);
            }
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.beforeAction(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.putAll(this.getUIContext());
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String dateTime;
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = "com.kingdee.eas.fi.rpt.app.IndexDataQuery")) {
            CommonQueryDialog dialog = this.initCommonQueryDialog();
            if (dialog.show()) {
                this.mainQuery = dialog.getEntityViewInfoResult();
                this.setQuerySort();
                this.isGlobeTotalUp = ((IndexCustomerQuery)dialog.getUserPanel((String)IndexCustomerQuery.class.getName())).showTotalUp;
                this.fillKDTable();
                this.refresh(null);
            } else {
                SysUtil.abort();
            }
        }
        this.setDataObject((IObjectValue)this.mainQuery);
        String format = CslRptUIUtil.getNationalDateFormatString();
        if (format != null) {
            this.kdtIdxDataRpt.getColumn("lastUpdateTime").getStyleAttributes().setNumberFormat(format);
            this.kdtIdxDataRpt.getColumn("createTime").getStyleAttributes().setNumberFormat("@");
            this.kdtIdxDataRpt.getColumn("report.year").getStyleAttributes().setNumberFormat("@");
        }
        if ((dateTime = CslRptUIUtil.getNationalTimeFormatString()) != null) {
            this.kdtIdxDataRpt.getColumn("indexItem.createTime").getStyleAttributes().setNumberFormat(dateTime);
        }
    }

    private void prepareUIContext(UIContext uiContext, ActionEvent e) {
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals((Object)this.actionEdit) || action.equals((Object)this.actionView)) {
            RealModeIDList idList = new RealModeIDList();
            idList.add(this.getSelectedKeyValue().toString());
            uiContext.put((Object)"IDList", (Object)idList);
        }
        if (action.equals((Object)this.actionEdit)) {
            uiContext.put((Object)"ObjectUpdateLockId", (Object)this.getObjectUpdateLockId());
        }
    }

    private void disableEffectiveIdx() {
        this.btnEffective.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnEffective.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_btn_disabled"));
        this.menuItemEnableIdx.setIcon(this.btnEffective.getIcon());
    }

    private void enableEffectiveIdx() {
        this.btnEffective.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnEffective.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_btn_enable"));
        this.menuItemEnableIdx.setIcon(this.btnEffective.getIcon());
    }

    @Override
    public void actionFindIndexData_actionPerformed(ActionEvent e) throws Exception {
        List expresions;
        IndexItemInfo itemInfo;
        String indexFormula;
        IRow row;
        KDTSelectBlock selectManager = this.kdtIdxDataRpt.getSelectManager().get();
        if (selectManager == null) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_report_SelectRowFirst"));
            this.showMessage();
            SysUtil.abort();
        }
        if ((row = this.kdtIdxDataRpt.getRow(selectManager.getBeginRow())).getCell(this.getKeyFieldName()).getValue() == null) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_report_SelectRowFirst"));
            this.showMessage();
            SysUtil.abort();
        }
        if ((indexFormula = (itemInfo = IndexItemFactory.getRemoteInstance().getIndexItemInfo((IObjectPK)new ObjectUuidPK(row.getCell("indexItem.id").getValue().toString()))).getFormula()) == null || indexFormula.trim().length() == 0) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("CellNotExistsFormula"));
            SysUtil.abort();
        }
        if ((expresions = TableToolkit.parseExcelFormula(indexFormula, true)) == null || expresions.size() == 0) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("PleaseChooseFormula2"));
            SysUtil.abort();
        }
        RptSheetParamInfo rptSheetParamInfo = null;
        ReportInfo reportInfo = null;
        IndexDataInfo indexData = IndexDataFactory.getRemoteInstance().getIndexDataInfo((IObjectPK)new ObjectUuidPK(row.getCell("id").getValue().toString()));
        EntityViewInfo entityViewInfo = null;
        EntityViewInfo indexDataView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filters = filterInfo.getFilterItems();
        filters.add(new FilterItemInfo("sheetID", (Object)itemInfo.getSheetParam().getId().toString()));
        filters.add(new FilterItemInfo("report.id", (Object)indexData.getReportID()));
        indexDataView.setFilter(filterInfo);
        indexDataView.getSelector().add(new SelectorItemInfo("*"));
        indexDataView.getSelector().add(new SelectorItemInfo("currency.*"));
        RptSheetParamCollection sheetParamCollection = RptSheetParamFactory.getRemoteInstance().getRptSheetParamCollection(entityViewInfo);
        if (sheetParamCollection.size() <= 0) {
            return;
        }
        rptSheetParamInfo = sheetParamCollection.get(0);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("year"));
        selector.add(new SelectorItemInfo("period"));
        selector.add(new SelectorItemInfo("company.*"));
        selector.add(new SelectorItemInfo("exchangeRate"));
        selector.add(new SelectorItemInfo("currency.*"));
        selector.add(new SelectorItemInfo("startDate"));
        selector.add(new SelectorItemInfo("endDate"));
        selector.add(new SelectorItemInfo("periodType"));
        reportInfo = ReportFactory.getRemoteInstance().getReportInfo((IObjectPK)new ObjectUuidPK(indexData.getReportID()), selector);
        if (reportInfo == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"expressions", (Object)expresions);
        uiContext.put((Object)"report", (Object)reportInfo);
        uiContext.put((Object)"superParent", this.getUIContext().get("superParent"));
        uiContext.put((Object)"rptSheetParam", (Object)rptSheetParamInfo);
        uiContext.put((Object)"type", (Object)"1");
        uiContext.put((Object)"_IndexItemFireFlag", (Object)"true");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FindLedger.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        if (expresions != null && expresions.size() > 1) {
            uiWindow.show();
        }
    }

    private boolean isPerformDefaultQuery(IQuerySolutionFacade iQuery, String queryName) throws Exception {
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            this.mainQuery = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            if (this.mainQuery == null) {
                return false;
            }
            if (this.mainQuery.getFilter() == null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
                this.mainQuery.setFilter(filter);
            }
            QueryPanelCollection queryPanels = solution.getQueryPanelInfo();
            int size = queryPanels.size();
            for (int i = 0; i < size; ++i) {
                if (queryPanels.get(i).getQueryPanelType() != QueryPanelTypeEnum.CUSTOMER_PANEL) continue;
                QueryPanelInfo queryPanel = queryPanels.get(i);
                Object param = null;
                if (queryPanel.getParam() != null) {
                    param = CommonUtil.getObject((byte[])queryPanel.getParam());
                }
                this.isGlobeTotalUp = param == null ? false : (Boolean)param;
                break;
            }
            this.setQuerySort();
            this.isFirstDefaultQuery = false;
            this.refresh(null);
            return true;
        }
        return false;
    }

    private boolean initDefaultFilter() {
        return true;
    }

    public class InnerIndexDataInfo {
        private Map currentData;
        private Map lastData;
        private Map markData;
        private Map totalData;
        public static final String TYPE_PREFIX = "INDEXITEMTYPE";
        public static final String ITEM_PREFIX = "INDEXITEM";
        public static final String YEAR_PREFIX = "YEAR";
        public static final String COMPANY_PREFIX = "COMPANY";

        public InnerIndexDataInfo() {
            this.initiate();
        }

        public void initiate() {
            this.currentData = new HashMap();
            this.lastData = new HashMap();
            this.markData = new HashMap();
            this.totalData = new HashMap();
        }

        public void fill(IRowSet rs) throws SQLException {
            this.lastData = this.currentData;
            this.currentData = new HashMap();
            this.currentData.put("COMPANY.ID", rs.getString("company.id"));
            this.currentData.put("COMPANY.NAME", rs.getString("company.name") == null ? "" : rs.getString("company.name"));
            this.currentData.put("ITEMTYPE.ID", rs.getString("itemType.id"));
            this.currentData.put("ITEMTYPE.NAME", rs.getString("itemType.name") == null ? "" : rs.getString("itemType.name"));
            this.currentData.put("INDEXITEM.NUMBER", rs.getString("indexItem.number"));
            this.currentData.put("REPORT.YEAR", rs.getString("report.year"));
            this.currentData.put("REPORT.PERIOD", rs.getString("report.period"));
            this.currentData.put("REPORT.SOURCETYPE", rs.getString("report.sourceType"));
            this.currentData.put("INDEXVALUE", rs.getString("indexValue") == null ? "" : rs.getString("indexValue"));
        }

        public void addAmount() throws SQLException {
            String companyId = (String)this.currentData.get("COMPANY.ID");
            String indexItemNum = (String)this.currentData.get("INDEXITEM.NUMBER");
            String indexItemType = (String)this.currentData.get("ITEMTYPE.ID");
            String year = (String)this.currentData.get("REPORT.YEAR");
            String indexValue = (String)this.currentData.get("INDEXVALUE");
            boolean isAmount = true;
            try {
                Double.parseDouble(indexValue);
            }
            catch (NumberFormatException e) {
                isAmount = false;
            }
            BigDecimal amount = isAmount ? new BigDecimal(indexValue) : new BigDecimal("0");
            String yearAmtKey = YEAR_PREFIX + year + indexItemNum;
            String indexAmtKey = ITEM_PREFIX + indexItemNum;
            String indexTypeAmtKey = TYPE_PREFIX + indexItemType;
            String companyKey = COMPANY_PREFIX + companyId;
            if (!isAmount) {
                this.markData.put(indexTypeAmtKey, new Boolean(false));
                this.markData.put(indexAmtKey, new Boolean(false));
                this.markData.put(yearAmtKey, new Boolean(false));
                this.markData.put(companyKey, new Boolean(false));
                return;
            }
            if (this.markData.get(yearAmtKey) == null) {
                if (this.totalData.containsKey(yearAmtKey)) {
                    this.totalData.put(yearAmtKey, ((BigDecimal)this.totalData.get(yearAmtKey)).add(amount));
                } else {
                    this.totalData.put(yearAmtKey, amount);
                }
            }
            if (this.markData.get(indexAmtKey) == null) {
                if (this.totalData.containsKey(indexAmtKey)) {
                    this.totalData.put(indexAmtKey, ((BigDecimal)this.totalData.get(indexAmtKey)).add(amount));
                } else {
                    this.totalData.put(indexAmtKey, amount);
                }
            }
            if (this.markData.get(indexTypeAmtKey) == null) {
                if (this.totalData.containsKey(indexTypeAmtKey)) {
                    this.totalData.put(indexTypeAmtKey, ((BigDecimal)this.totalData.get(indexTypeAmtKey)).add(amount));
                } else {
                    this.totalData.put(indexTypeAmtKey, amount);
                }
            }
            if (this.markData.get(companyKey) == null) {
                if (this.totalData.containsKey(companyKey)) {
                    this.totalData.put(companyKey, ((BigDecimal)this.totalData.get(companyKey)).add(amount));
                } else {
                    this.totalData.put(companyKey, amount);
                }
            }
        }

        public Map getCurrentData() {
            return this.currentData;
        }

        public Map getLastData() {
            return this.lastData;
        }

        public Map getMarkData() {
            return this.markData;
        }

        public Map getTotalData() {
            return this.totalData;
        }

        public void setLastData(Map lastData) {
            this.lastData = lastData;
        }
    }

    private class SelfItemListener
    implements KDTMouseListener {
        private SelfItemListener() {
        }

        public void tableClicked(KDTMouseEvent e) {
            int row = e.getRowIndex();
            if (IndexCustomQueryListUI.this.kdtIdxDataRpt.getRow(row) != null && IndexCustomQueryListUI.this.kdtIdxDataRpt.getRow(row).getCell(IndexCustomQueryListUI.this.getKeyFieldName()).getValue() != null) {
                String indexId = IndexCustomQueryListUI.this.kdtIdxDataRpt.getRow(row).getCell(IndexCustomQueryListUI.this.getKeyFieldName()).getValue().toString();
                IndexItemInfo indexItemInfo = null;
                try {
                    indexItemInfo = IndexItemFactory.getRemoteInstance().getIndexItemInfo((IObjectPK)new ObjectUuidPK(indexId));
                    if (indexItemInfo == null) {
                        IndexCustomQueryListUI.this.refresh(null);
                        throw new EASBizException(EASBizException.CHECKEXIST);
                    }
                    if (!indexItemInfo.getCompany().getId().toString().equals(SysContext.getSysContext().getCurrentFIUnit().getId().toString())) {
                        IndexCustomQueryListUI.this.initActionStauts(false);
                        return;
                    }
                }
                catch (Exception ex) {
                    IndexCustomQueryListUI.this.handleException(ex);
                    SysUtil.abort();
                }
                IndexStateEnum state = indexItemInfo.getState();
                if (0 == state.getValue()) {
                    IndexCustomQueryListUI.this.initActionStauts(true);
                    IndexCustomQueryListUI.this.enableEffectiveIdx();
                } else if (1 == state.getValue()) {
                    IndexCustomQueryListUI.this.initActionStauts(true);
                    IndexCustomQueryListUI.this.disableEffectiveIdx();
                } else {
                    IndexCustomQueryListUI.this.initActionStauts(false);
                }
            } else {
                IndexCustomQueryListUI.this.initActionStauts(true);
                IndexCustomQueryListUI.this.initActionStauts(false);
            }
        }
    }
}

