/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.IIndexItemType;
import com.kingdee.eas.fi.rpt.IndexItemCollection;
import com.kingdee.eas.fi.rpt.IndexItemFactory;
import com.kingdee.eas.fi.rpt.IndexItemInfo;
import com.kingdee.eas.fi.rpt.IndexItemTypeCollection;
import com.kingdee.eas.fi.rpt.IndexItemTypeFactory;
import com.kingdee.eas.fi.rpt.IndexStateEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.AbstractIndexItemEditUI;
import com.kingdee.eas.fi.rpt.client.IndexItemListUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class IndexItemEditUI
extends AbstractIndexItemEditUI {
    private static final long serialVersionUID = -8851764818870039492L;
    private RangeSelector cellSelector = null;
    private Book book = null;
    TemplateInfo tempInfo = null;
    private Sheet sheet;
    private int selectMode;
    private IndexItemTypeCollection collection;
    private boolean hasCodingRule = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtFormula.setVisible(false);
        this.editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        if (this.readNumber(this.editData) != null) {
            this.hasCodingRule = true;
        }
        if (OprtState.ADDNEW.equalsIgnoreCase(this.getOprtState())) {
            this.sheet = (Sheet)this.getUIContext().get("CURRENT_SHEET_TABLE");
            this.cellSelector = (RangeSelector)this.getUIContext().get("SELECT_CONTROL");
            this.book = (Book)this.getUIContext().get("BOOK");
            String selectRange = this.sheet.getSelectionRange().getBounds().toString();
            this.editData.setCell(this.sheet.getSheetName() + "!" + selectRange);
            this.tempInfo = (TemplateInfo)this.getUIContext().get("EDIT_DATA");
        } else if (this.getUIContext().get("Owner") instanceof IndexItemListUI) {
            IndexItemListUI list = (IndexItemListUI)((Object)this.getUIContext().get("Owner"));
            this.sheet = (Sheet)list.getUIContext().get("CURRENT_SHEET_TABLE");
            this.cellSelector = (RangeSelector)list.getUIContext().get("SELECT_CONTROL");
            this.book = (Book)list.getUIContext().get("BOOK");
            this.tempInfo = (TemplateInfo)list.getUIContext().get("EDIT_DATA");
        }
        if (this.cellSelector != null) {
            this.cellSelector.setBounds(142, 76, 150, 19);
            this.cellSelector.setText(this.editData.getCell());
            this.add((Component)this.cellSelector);
            if (this.getOprtState() == OprtState.VIEW || this.getOprtState() == OprtState.EDIT) {
                this.cellSelector.setEnabled(false);
            }
        } else {
            KDTextField kf = new KDTextField();
            kf.setBounds(142, 76, 150, 19);
            kf.setText(this.editData.getCell());
            this.add((Component)kf);
            kf.setEditable(false);
            this.comboItemType.setEnabled(false);
            this.comboItemType.setEditable(false);
        }
        if (this.hasCodingRule) {
            this.txtNumber.setEnabled(false);
        }
        this.toolBar.setVisible(false);
        this.initOldData((IObjectValue)this.editData);
    }

    private IndexItemTypeCollection getItemTypes() throws BOSException {
        IIndexItemType indexItem = IndexItemTypeFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
        viewInfo.setFilter(filterInfo);
        IndexItemTypeCollection collection = indexItem.getIndexItemTypeCollection(viewInfo);
        return collection;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("itemType.name"));
        sic.add(new SelectorItemInfo("templateId"));
        sic.add(new SelectorItemInfo("sheetParam.id"));
        sic.add(new SelectorItemInfo("cell"));
        sic.add(new SelectorItemInfo("company.id"));
        return sic;
    }

    protected IObjectValue createNewData() {
        IndexItemInfo itemInfo = new IndexItemInfo();
        itemInfo.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        itemInfo.setState(IndexStateEnum.effective);
        RptSheetParamInfo sheetParamInfo = (RptSheetParamInfo)this.getUIContext().get("CURRENT_SHEETPARAM_INFO");
        itemInfo.setTemplateId((String)this.getUIContext().get("CURRENT_TEMPLATE_UUID"));
        itemInfo.setSheetParam(sheetParamInfo);
        if (this.hasCodingRule) {
            this.txtNumber.setEnabled(false);
        }
        return itemInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return IndexItemFactory.getRemoteInstance();
    }

    private boolean selfValidation() throws BOSException, EASBizException {
        if (!(this.hasCodingRule || this.editData.getNumber() != null && this.editData.getNumber().trim().length() != 0)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_err_NumberIsEmpty"));
            this.txtNumber.requestFocus();
            return false;
        }
        if (this.editData.getName() == null || this.editData.getName().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_err_NameIsEmpty"));
            this.mltName.requestFocus();
            return false;
        }
        if (this.comboItemType.getSelectedItem() == null || this.comboItemType.getSelectedItem().toString().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_err_ItemTypeIsEmpty"));
            this.comboItemType.requestFocus();
            return false;
        }
        if (!TableToolkit.isCorrectSingleCellSelect(this.cellSelector.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.cellRefError"));
            this.cellSelector.requestFocus();
            return false;
        }
        if (this.cellSelector.getText() == null || this.cellSelector.getText().trim().length() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_err_CellIsEmpty"));
            this.cellSelector.requestFocus();
            return false;
        }
        if (this.book.getActiveCellRange().getFormula() != null && this.book.getActiveCellRange().getFormula().indexOf("RptIndex(") != -1) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51("NoSupportDefineIndexRefAsIndex"));
            this.cellSelector.requestFocus();
            return false;
        }
        this.editData.setCell(this.cellSelector.getText());
        if (this.getOprtState() == OprtState.ADDNEW) {
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filterItemCollection = filterInfo.getFilterItems();
            filterItemCollection.add(new FilterItemInfo("sheetParam", (Object)this.editData.getSheetParam().getId()));
            filterItemCollection.add(new FilterItemInfo("cell", (Object)this.editData.getCell()));
            filterItemCollection.add(new FilterItemInfo("company.id", (Object)SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            IndexItemCollection indexItemInfos = IndexItemFactory.getRemoteInstance().getIndexItemCollection(viewInfo);
            if (indexItemInfos.size() > 0) {
                if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"index_item_err_CellDuplicate")) == 2) {
                    SysUtil.abort();
                }
                this.editData.setId(indexItemInfos.get(0).getId());
                String _number = this.txtNumber.getText();
                if (_number != null && _number.trim().length() > 0) {
                    this.editData.setNumber(_number);
                } else {
                    this.editData.setNumber(indexItemInfos.get(0).getNumber());
                }
            } else {
                this.editData.setId(null);
            }
        }
        String itemTypeName = (String)this.comboItemType.getSelectedItem();
        int size = this.collection.size();
        for (int i = 0; i < size; ++i) {
            if (!this.collection.get(i).getName().equals(itemTypeName)) continue;
            this.editData.setItemType(this.collection.get(i));
            break;
        }
        return true;
    }

    private boolean isSingleCellSelect() {
        String str = this.cellSelector.getText();
        return str == null || str.indexOf(",") <= 0 && str.indexOf(":") <= 0;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        for (int i = 0; i < this.tempInfo.getSheetParam().size(); ++i) {
            if (!this.tempInfo.getSheetParam().get(i).getSheetID().equals(this.book.getActiveSheet().getID())) continue;
            this.editData.setSheetParam(this.tempInfo.getSheetParam().get(i));
            break;
        }
        if (!this.selfValidation()) {
            return;
        }
        this.editData.setTemplateId(this.tempInfo.getId().toString());
        this.editData.setFormula(this.book.getActiveCellRange().getFormula());
        IObjectPK pk = this.getBizInterface().submit((CoreBaseInfo)this.editData);
        this.editData.setId(BOSUuid.read((String)pk.toString()));
        this.showSubmitSuccess();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setDataObject(this.createNewData());
            this.loadFields();
            this.setSave(true);
        } else {
            this.setDataObject(this.getValue(pk));
            this.disposeUIWindow();
        }
    }

    public void disposeUIWindow() {
        super.disposeUIWindow();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.collection = this.getItemTypes();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
            this.collection = new IndexItemTypeCollection();
        }
        Object[] values = new String[this.collection.size() + 1];
        values[0] = "";
        int size = this.collection.size();
        for (int i = 0; i < size; ++i) {
            values[i + 1] = this.collection.get(i).getName();
        }
        this.comboItemType.removeAllItems();
        this.comboItemType.addItems(values);
        if (OprtState.ADDNEW.equalsIgnoreCase(this.getOprtState())) {
            this.comboItemType.setSelectedIndex(0);
        } else {
            this.comboItemType.setSelectedItem((Object)this.editData.getItemType().getName());
        }
    }

    private String readNumber(IndexItemInfo itemInfo) throws EASBizException, BOSException {
        String companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (iCodingRuleManager.getCodingRule((IObjectValue)itemInfo, companyID) != null) {
            return iCodingRuleManager.readNumber((IObjectValue)itemInfo, companyID);
        }
        return null;
    }
}

