/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.RegisterWindowKeyListenerHelper;
import com.kingdee.eas.fi.rpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.AbstractItemDataAddByNormalTemplateUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ItemDataAddByNormalTemplateUI
extends AbstractItemDataAddByNormalTemplateUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ItemDataAddByNormalTemplateUI.class);
    private String orgUnitId = null;
    private boolean isProfit = false;
    public static List<String> tempIdList = null;
    public static Map<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
    private String INPUT_NAME_OR_NUMBER = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.InputNameOrNumber");

    public void onLoad() throws Exception {
        this.orgUnitId = (String)this.getUIContext().get("orgUnitId");
        this.isProfit = (Boolean)this.getUIContext().get("isProfit");
        tempIdList = new ArrayList<String>();
        this.fillData();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.setEditable(false);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.initButton();
        this.initListeners();
    }

    private void fillData() throws Exception {
        this.actionQueryFilter_actionPerformed(null);
    }

    public void initButton() {
        this.kDButtonConfirm.setVisible(true);
        this.kDButtonConfirm.setEnabled(true);
        this.kDButtonCancel.setVisible(true);
        this.kDButtonCancel.setEnabled(true);
        this.kDWorkButton1.setEnabled(true);
        this.btnAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnQueryScheme.setVisible(false);
        this.kdQueryText.setVisible(true);
        this.kdQueryText.setEnabled(true);
        this.kdQueryText.setText(this.INPUT_NAME_OR_NUMBER);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    private void initListeners() {
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ItemDataAddByNormalTemplateUI.this.actionQueryFilter_actionPerformed(e);
                }
                catch (Exception e1) {
                    ItemDataAddByNormalTemplateUI.this.handUIException(e1);
                }
            }
        };
        RegisterWindowKeyListenerHelper.registerWindowListener((CoreUI)this, (KeyStroke)ks, (Object)"queryFilter", (AbstractAction)action);
    }

    private EntityViewInfo getTemplateViewInfo(String orgUnitId) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ArrayList<OrgType> templateType = new ArrayList<OrgType>();
        if (this.isProfit) {
            templateType.add(OrgType.ProfitCenter);
        } else {
            templateType.add(OrgType.Company);
        }
        TemplateCollection col = TemplateFactory.getRemoteInstance().getTreeDispenseData2(orgUnitId, true, true, false, templateType, null);
        HashSet<String> ids = new HashSet<String>();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                ids.add(col.get(i).getId().toString());
            }
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(1);
        set.add(6);
        set.add(2);
        filter.getFilterItems().add(new FilterItemInfo("templateType", set, CompareType.INCLUDE));
        if (ids == null || ids.size() == 0) {
            ids.add("");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        view.setFilter(filter);
        return view;
    }

    private List<String> getTempIdList() {
        int[] selectRows;
        String id = null;
        if (tempIdList != null) {
            tempIdList.clear();
        } else {
            tempIdList = new ArrayList<String>();
        }
        if (tempIdList != null) {
            tempIdList.clear();
        }
        if ((selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain)).length == 0) {
            return null;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            id = this.tblMain.getRow(selectRows[i]).getCell("id").getValue().toString();
            tempIdList.add(id);
        }
        return tempIdList;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo kDBP_TargCurrency = (CurrencyInfo)this.kDBP_TargCurrency.getValue();
        CurrencyInfo kDBP_SourceCurrency = (CurrencyInfo)this.kDBP_SourceCurrency.getValue();
        if (kDBP_TargCurrency == null || kDBP_SourceCurrency == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.864_currencyNotNull"));
            return;
        }
        if (this.tblMain.getRowCount() != 0 && KDTableUtil.getSelectedRows((KDTable)this.tblMain).length == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg.882_selectRow"));
            return;
        }
        tempIdList = this.getTempIdList();
        if (tempIdList != null && tempIdList.size() == 0) {
            return;
        }
        tempIdList = this.getTempIdList();
        currencyMap.put("targCurrency", kDBP_TargCurrency);
        currencyMap.put("sourceCurrency", kDBP_SourceCurrency);
        this.destroyWindow();
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.mainQuery = this.getTemplateViewInfo(this.orgUnitId);
    }

    @Override
    public void actionQueryFilter_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.checkParsed();
        this.refreshList();
        HashMap<String, String> map = new HashMap<String, String>();
        String queryText = this.kdQueryText.getText();
        if (this.INPUT_NAME_OR_NUMBER.equals(this.kdQueryText.getText())) {
            queryText = "";
        }
        map.put("entryViewIds", this.getTemplateViewInfo(this.orgUnitId).toString().split("AND ")[1]);
        map.put("queryText", queryText);
        List result = ItemDataYearInitFactory.getRemoteInstance().getTemplateByQuery(map);
        this.removeRows();
        if (result == null || result.size() == 0) {
            return;
        }
        TemplateInfo tmp = null;
        for (int i = 0; i < result.size(); ++i) {
            this.tblMain.addRow();
            tmp = (TemplateInfo)result.get(i);
            this.tblMain.getRow(i).getCell("id").setValue((Object)tmp.getId());
            this.tblMain.getRow(i).getCell("number").setValue((Object)tmp.getNumber());
            this.tblMain.getRow(i).getCell("name").setValue((Object)tmp.getName());
            this.tblMain.getRow(i).getCell("templateType").setValue((Object)tmp.getTemplateType());
            this.tblMain.getRow(i).getCell("periodType").setValue((Object)tmp.getPeriodType());
            this.tblMain.getRow(i).getCell("versionNumber").setValue((Object)tmp.getVersionNumber());
            this.tblMain.getRow(i).getCell("orgType").setValue((Object)tmp.getOrgType());
        }
    }

    private void removeRows() {
        int rowCount = this.tblMain.getRowCount();
        if (rowCount == 0) {
            return;
        }
        for (int i = rowCount - 1; i >= 0; --i) {
            this.tblMain.removeRow(i);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            this.actionConfirm_actionPerformed(null);
        }
    }

    @Override
    protected void kdText_mouseClicked(MouseEvent e) throws Exception {
        if (this.INPUT_NAME_OR_NUMBER.equals(this.kdQueryText.getText())) {
            this.kdQueryText.setText("");
        }
    }

    @Override
    protected void kdText_focusLost(FocusEvent e) throws Exception {
        if ("".equals(this.kdQueryText.getText())) {
            this.kdQueryText.setText(this.INPUT_NAME_OR_NUMBER);
        }
        this.actionQueryFilter_actionPerformed(null);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.actionQueryFilter_actionPerformed(e);
    }
}

