/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizComboboxModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.SysDataElementEnum;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.rpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.rpt.ItemDataYearInitInfo;
import com.kingdee.eas.fi.rpt.client.AbstractItemDataInitEndCoverUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ItemDataInitEndCoverUI
extends AbstractItemDataInitEndCoverUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemDataInitEndCoverUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.coverNextYear"));
        this.company.setEnabled(false);
        this.year.setEnabled(false);
        this.type.setEnabled(false);
        this.srcCurrency.setEnabled(false);
        this.currency.setEnabled(false);
        this.btnref.setEnabled(true);
        this.btnSA.setEnabled(true);
        this.btnCA.setEnabled(true);
        this.btnCover.setEnabled(true);
        this.kDMenuEdit.setEnabled(true);
        this.kDMenuBiz.setEnabled(true);
        this.kDMenuItemSA.setEnabled(true);
        this.kDMenuItemCA.setEnabled(true);
        this.kDMenuItemCover.setEnabled(true);
        this.kDMenuEdit.setVisible(true);
        this.kDMenuBiz.setVisible(true);
        this.kDMenuItemSA.setVisible(true);
        this.kDMenuItemCA.setVisible(true);
        this.kDMenuItemCover.setVisible(true);
        this.kDMenuItemSA.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.kDMenuItemCA.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSA.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnCA.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.kDMenuItemCover.setIcon(EASResource.getIcon((String)"imgTbtn_deliverto"));
        this.btnCover.setIcon(EASResource.getIcon((String)"imgTbtn_deliverto"));
        this.tbl.checkParsed();
        KDBizComboboxModel md = new KDBizComboboxModel(null);
        md.setNeedReQuery(false);
        md.addElement((Object)SysDataElementEnum.YTBEGIN);
        this.type.setModel((ComboBoxModel)md);
        this.type.setSelectedItem((Object)SysDataElementEnum.YTBEGIN);
        this.company.setText(RptNewUIUtil.getRptWktOrgUnitInfo((Map)this.getUIContext(), (IUIObject)this).getName());
        this.year.setValue(this.getValueMap().get("year"));
        this.currency.setValue(this.getValueMap().get("currency"));
        this.srcCurrency.setValue(this.getValueMap().get("sourceCurrency"));
        this.loadData();
        this.tbl.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                ItemDataYearInitInfo info;
                if (e.getColIndex() == 7 && e.getValue() != null && e.getValue().toString().trim().length() > 0) {
                    info = (ItemDataYearInitInfo)ItemDataInitEndCoverUI.this.tbl.getRow(e.getRowIndex()).getUserObject();
                    info.setDebit(new BigDecimal(e.getValue().toString()));
                    info.setCredit(null);
                    ItemDataInitEndCoverUI.this.tbl.getRow(e.getRowIndex()).getCell(8).setValue(null);
                }
                if (e.getColIndex() == 8 && e.getValue() != null && e.getValue().toString().trim().length() > 0) {
                    info = (ItemDataYearInitInfo)ItemDataInitEndCoverUI.this.tbl.getRow(e.getRowIndex()).getUserObject();
                    info.setDebit(null);
                    info.setCredit(new BigDecimal(e.getValue().toString()));
                    ItemDataInitEndCoverUI.this.tbl.getRow(e.getRowIndex()).getCell(7).setValue(null);
                }
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
    }

    HashMap getValueMap() {
        return (HashMap)this.getUIContext().get("map");
    }

    void loadData() throws BOSException {
        this.tbl.removeRows();
        ArrayList c = this.getAllItemDataYearInitInfos();
        if (c != null && c.size() > 0) {
            for (ItemDataYearInitInfo info : c) {
                this.bindLineData(this.tbl.addRow(), info);
            }
        }
    }

    void bindLineData(IRow row, ItemDataYearInitInfo info) {
        row.setUserObject((Object)info);
        row.getCell(0).setValue((Object)new Boolean(true));
        row.getCell(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        row.getCell(1).setUserObject((Object)info.getItem());
        row.getCell(1).setValue((Object)info.getItem().getNumber());
        row.getCell(1).getStyleAttributes().setLocked(true);
        row.getCell(2).setValue((Object)info.getItem().getName());
        row.getCell(2).getStyleAttributes().setLocked(true);
        row.getCell(3).setValue((Object)info.getCurrency());
        row.getCell(3).getStyleAttributes().setLocked(true);
        row.getCell(4).setValue((Object)info.getSourceCurrency());
        row.getCell(4).getStyleAttributes().setLocked(true);
        row.getCell(5).getStyleAttributes().setLocked(true);
        row.getCell(5).getStyleAttributes().setBackground(new Color(131, 184, 188));
        row.getCell(6).getStyleAttributes().setLocked(true);
        row.getCell(6).getStyleAttributes().setBackground(new Color(131, 184, 188));
        row.getCell(7).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDNumberTextField(6)));
        row.getCell(7).setValue((Object)info.getDebit());
        row.getCell(7).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(7).getStyleAttributes().setNumberFormat("#,###.00");
        row.getCell(8).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDNumberTextField(6)));
        row.getCell(8).setValue((Object)info.getCredit());
        row.getCell(8).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(8).getStyleAttributes().setNumberFormat("#,###.00");
        row.getCell(9).setEditor((ICellEditor)new KDTDefaultCellEditor());
        row.getCell(9).setValue((Object)info.getDataElement());
        row.getCell(9).getStyleAttributes().setLocked(true);
        row.getCell(9).getStyleAttributes().setBackground(new Color(131, 184, 188));
        KDComboBox box = new KDComboBox();
        box.addItem((Object)ConvertStatusEnum.BeforeConvert);
        box.addItem((Object)ConvertStatusEnum.Converted);
        row.getCell(10).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)box));
        row.getCell(10).setValue((Object)info.getConvertStatus());
        row.getCell(10).getStyleAttributes().setLocked(true);
    }

    ArrayList getAllItemDataYearInitInfos() {
        return (ArrayList)this.getValueMap().get("infos");
    }

    @Override
    public void actionRef_actionPerformed(ActionEvent e) throws Exception {
        this.loadData();
    }

    @Override
    public void actionSA_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            this.tbl.getRow(i).getCell(0).setValue((Object)new Boolean(true));
        }
    }

    @Override
    public void actionCA_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            this.tbl.getRow(i).getCell(0).setValue((Object)new Boolean(false));
        }
    }

    ArrayList getSelectInfos() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            boolean selected = (Boolean)row.getCell("select").getValue();
            if (!selected) continue;
            list.add(row.getUserObject());
        }
        return list;
    }

    @Override
    public void actionCover_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list = this.getSelectInfos();
        if (list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.noItem"));
            return;
        }
        Integer period = (Integer)this.getValueMap().get("rptPeriod");
        String res = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"confirmTransfer");
        String msg = MessageFormat.format(res, period);
        int confirm2 = MsgBox.showConfirm2((Component)((Object)this), (String)msg);
        if (confirm2 == 2) {
            return;
        }
        ItemDataYearInitFactory.getRemoteInstance().saveAll(list);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.sc"));
    }
}

