/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTVertical;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewProfitCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.DebitOrCreditEnum;
import com.kingdee.eas.fi.gr.cslrpt.IItemDataYearInit;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataProviderException;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataYearInitInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ReportClassInfo;
import com.kingdee.eas.fi.gr.cslrpt.TablePreferHelperYearInit;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.ItemDataImportWizardUI;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.CslGradeManageUtil;
import com.kingdee.eas.fi.newrpt.PermissionHelper;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.designer.TableSorter;
import com.kingdee.eas.fi.rpt.client.AbstractItemDataYearInitUI;
import com.kingdee.eas.fi.rpt.client.GenerateNextYearInitUI;
import com.kingdee.eas.fi.rpt.client.ItemDataAddByNormalTemplateUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ItemDataYearInitUI
extends AbstractItemDataYearInitUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ItemDataYearInitUI.class);
    protected EntityViewInfo entityViewInfo = new EntityViewInfo();
    protected String COL_ID = "id";
    protected String COL_SELECT = "select";
    protected String COL_ITEM_NUMBER = "number";
    protected String COL_ITEM_NAME = "name";
    protected String COL_CURRENCY_NAME = "currency.name";
    protected String COL_CURRENCY_NUMBER = "currency.number";
    protected String COL_SOURCECURRENCY_NAME = "sourceCurrency.name";
    protected String COL_SOURCECURRENCY_NUMBER = "sourceCurrency.number";
    protected String COL_YEAR = "year";
    protected String COL_PERIOD = "period";
    protected String COL_DEBITFORMULA = "debit";
    protected String COL_CREDITFORMULA = "credit";
    protected String COL_VALUETYPE = "valueType";
    protected String COL_DATAELEMENT = "dataElement";
    protected String COL_CONVERTSTATUS = "convertStatus";
    protected String COL_DATACOLLECT = "dataCollect";
    protected Integer STATUS_ADDNEW = new Integer(1);
    protected Integer STATUS_DELETE = new Integer(2);
    protected Integer STATUS_UPDATE = new Integer(3);
    protected OrgUnitInfo orgUnit = null;
    protected Integer year = null;
    protected CurrencyInfo currency = null;
    protected CurrencyInfo sourceCurrency = null;
    protected ReportClassInfo reportClass = null;
    protected ValueTypeEnum valueType = null;
    protected DataElementInfo dataElement = null;
    protected TableSorter tableSorter = null;
    protected DataCollectInfo dataCollectInfo = null;
    private IObjectCollection cacheDataCollection = null;
    private List deleteIdList = new ArrayList();
    private HashMap changedInfosMap = new HashMap();
    private FullOrgUnitCollection orgList = new FullOrgUnitCollection();
    private static final int PERIOD = 1;
    private Color yellowColor = new Color(0xF6F6BF);
    private Color whiteColor = new Color(0xFFFFFF);
    private KDBizPromptBox bizBoxItem = null;
    private boolean isProfit = false;

    public ItemDataYearInitUI() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        this.year = c.get(1);
        this.valueType = ValueTypeEnum.MONEY;
        this.dataElement = DataElementProvider.getDataElementInfo((String)"YTBEGIN");
        this.dataCollectInfo = DataCollectConstant.getActualDC();
        this.actionGenerate.setEnabled(this.isLastPeriod());
    }

    private ItemDataYearInitInfo createNewInfo() {
        ItemDataYearInitInfo info = new ItemDataYearInitInfo();
        Object data = this.pmptOrgUnit.getData();
        if (data != null && data instanceof OrgUnitInfo) {
            info.setOrgUnit(((OrgUnitInfo)this.pmptOrgUnit.getData()).castToFullOrgUnitInfo());
        } else {
            info.setOrgUnit(this.getCompanyOrgUnitInfo());
        }
        info.setPeriod(1);
        return info;
    }

    private FullOrgUnitInfo getCompanyOrgUnitInfo() {
        return RptNewUIUtil.getRptWktOrgUnitInfo((Map)this.getUIContext(), (IUIObject)this).castToFullOrgUnitInfo();
    }

    protected void initHelper() {
        if (this.tHelper != null) {
            return;
        }
        this.tHelperPrint = this.tHelper = new TablePreferHelperYearInit((CoreUI)this);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.isProfit = OrgType.ProfitCenter.equals(this.getUIContext().get("orgType"));
        this.initHead();
        this.initEntryTable();
        this.storeHeadData();
        this.loadData();
        this.loadFromFields();
        this.tableSorter = new TableSorter(this.kDTMain){

            protected void afterSort() {
                super.afterSort();
                for (int i = 0; i < ItemDataYearInitUI.this.kDTMain.getRowCount(); ++i) {
                    IRow row = ItemDataYearInitUI.this.kDTMain.getRow(i);
                    Object obj = row.getCell(ItemDataYearInitUI.this.COL_ITEM_NUMBER).getValue();
                    if (obj == null || !(obj instanceof RPTItemInfo)) continue;
                    ItemDataYearInitUI.this.setColor(row, ((RPTItemInfo)obj).getDc());
                }
            }
        };
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddBatch.setVisible(false);
        this.menuItemAddBatch.setVisible(false);
        this.menuItemAddLine.setVisible(false);
        this.btnGenerate.setVisible(false);
        this.menuItemGenerate.setVisible(false);
    }

    protected void checkTableParsed() {
        this.kDTMain.checkParsed();
    }

    private boolean isLastPeriod() {
        return true;
    }

    private void loadData() throws Exception {
        this.deleteIdList.clear();
        this.cacheDataCollection = this.getBizInterface().getCollection(this.getEntityViewInfo());
        Iterator it = this.cacheDataCollection.iterator();
        while (it.hasNext()) {
            this.deleteIdList.add(((ItemDataYearInitInfo)it.next()).getId());
        }
    }

    private void saveData() throws Exception {
        ((IItemDataYearInit)this.getBizInterface()).saveData((Map)this.changedInfosMap);
    }

    private void storeHeadData() throws BOSException, EASBizException {
        if (this.pmptOrgUnit.getValue() == null) {
            this.setMessageText(CslRptUtil.getString((String)"YearInitSelectOrgFirst"));
            this.showMessage();
            SysUtil.abort();
        }
        this.orgUnit = (OrgUnitInfo)this.pmptOrgUnit.getValue();
        this.currency = (CurrencyInfo)this.pmptCurrency.getValue();
        this.sourceCurrency = (CurrencyInfo)this.pmptSourceCurrency.getValue();
        this.year = this.spYear.getIntegerVlaue();
    }

    private void initHead() throws Exception, BOSException {
        NewProfitCenterF7 f7;
        if (this.isProfit) {
            f7 = new NewProfitCenterF7((IUIObject)this);
            f7.setPermissionItem("prof_rpt_view");
        } else {
            f7 = new NewCompanyF7((IUIObject)this);
            f7.setPermissionItem("rpt_report_view");
        }
        f7.setShowAssistantOrg(true);
        f7.setCheckedAssistantOrgChkBox(true);
        this.pmptOrgUnit.setSelector((KDPromptSelector)f7);
        this.pmptOrgUnit.setEnabled(true);
        this.pmptOrgUnit.setValue((Object)this.getCompanyOrgUnitInfo());
        this.spYear.setValue((Object)this.year);
        this.spYear.setUserObject((Object)this.year);
    }

    public void initListener() {
        this.kDTMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                ItemDataYearInitUI.this.tableValueChanged(e);
            }
        });
        this.kDTMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int first = e.getFirstRow();
                int count = e.getLastRow() - e.getFirstRow() + 1;
                Object tmp = null;
                for (int i = first; i < first + count; ++i) {
                    IRow row = ItemDataYearInitUI.this.kDTMain.getRow(i);
                    tmp = row.getCell(ItemDataYearInitUI.this.COL_ITEM_NUMBER).getValue();
                    if (tmp == null || !(tmp instanceof RPTItemInfo)) continue;
                    ItemDataYearInitUI.this.setColor(row, ((RPTItemInfo)tmp).getDc());
                }
            }
        });
        this.spYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    ItemDataYearInitUI.this.storeToFields();
                    if (ItemDataYearInitUI.this.changedInfosMap.size() != 0) {
                        int status = MsgBox.showConfirm3((String)(CslRptUtil.getString((String)"YearInitHintBeforeSave") + CslRptUtil.getString((String)"_changeYear")));
                        if (status == 0) {
                            ItemDataYearInitUI.this.actionSave_actionPerformed(null);
                        } else if (status != 1) {
                            ItemDataYearInitUI.this.spYear.setValue(ItemDataYearInitUI.this.spYear.getUserObject(), false);
                            return;
                        }
                    }
                    ItemDataYearInitUI.this.spYear.setUserObject(ItemDataYearInitUI.this.spYear.getValue());
                    ItemDataYearInitUI.this.actionRefresh_actionPerformed(null);
                }
                catch (Exception e1) {
                    if (e1 instanceof AbortException) {
                        ItemDataYearInitUI.this.spYear.setValue(ItemDataYearInitUI.this.spYear.getUserObject(), false);
                    }
                    ItemDataYearInitUI.this.handUIException(e1);
                }
            }
        });
        this.pmptOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                ItemDataYearInitUI.this.preChangeForComp(e, "org");
            }
        });
        this.pmptOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() != e.getOldValue()) {
                    try {
                        ItemDataYearInitUI.this.actionRefresh_actionPerformed(null);
                        if (ItemDataYearInitUI.this.pmptOrgUnit.getData() != null) {
                            CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)ItemDataYearInitUI.this.bizBoxItem, (String)((OrgUnitInfo)ItemDataYearInitUI.this.pmptOrgUnit.getData()).getId().toString());
                            ItemDataYearInitUI.this.menuItemAddByTemp.setEnabled(true);
                            ItemDataYearInitUI.this.btnAddByTemp.setEnabled(true);
                        } else {
                            ItemDataYearInitUI.this.menuItemAddByTemp.setEnabled(false);
                            ItemDataYearInitUI.this.btnAddByTemp.setEnabled(false);
                        }
                    }
                    catch (Exception e1) {
                        ItemDataYearInitUI.this.handUIException(e1);
                    }
                }
            }
        });
        this.pmptCurrency.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                ItemDataYearInitUI.this.preChangeForComp(e, "currency");
            }
        });
        this.pmptCurrency.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() != e.getOldValue()) {
                    try {
                        ItemDataYearInitUI.this.actionRefresh_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        ItemDataYearInitUI.this.handUIException(e1);
                    }
                }
            }
        });
        this.pmptSourceCurrency.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                ItemDataYearInitUI.this.preChangeForComp(e, "srcCurrency");
            }
        });
        this.pmptSourceCurrency.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() != e.getOldValue()) {
                    try {
                        ItemDataYearInitUI.this.actionRefresh_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        ItemDataYearInitUI.this.handUIException(e1);
                    }
                }
            }
        });
    }

    private void preChangeForComp(PreChangeEvent e, String compName) {
        try {
            this.storeToFields();
            if (this.changedInfosMap.size() != 0) {
                String tailInfo = "";
                switch (compName) {
                    case "org": {
                        tailInfo = CslRptUtil.getString((String)"_changeOrg");
                        break;
                    }
                    case "currency": {
                        tailInfo = CslRptUtil.getString((String)"_changeCurrency");
                        break;
                    }
                    case "srcCurrency": {
                        tailInfo = CslRptUtil.getString((String)"_changeSrcCurrency");
                        break;
                    }
                    default: {
                        tailInfo = "";
                    }
                }
                int status = MsgBox.showConfirm3((String)(CslRptUtil.getString((String)"YearInitHintBeforeSave") + tailInfo));
                if (status == 0) {
                    this.actionSave_actionPerformed(null);
                } else if (status != 1) {
                    e.setResult(0);
                }
            }
        }
        catch (Exception e1) {
            if (e1 instanceof AbortException) {
                e.setResult(0);
            }
            this.handUIException(e1);
        }
    }

    public boolean isModify(AbstractObjectValue oldData, AbstractObjectValue editData) {
        return !ObjectValueUtil.objectValueEquals((AbstractObjectValue)oldData, (AbstractObjectValue)editData);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        this.checkSelected();
        StringBuilder saveFailInfoSb = new StringBuilder();
        if (this.kDTMain != null && this.kDTMain.getRowCount() > 0) {
            boolean isRowSaveFail = false;
            int j = this.kDTMain.getRowCount();
            for (int i = 0; i < j; ++i) {
                IRow curRow;
                if (isRowSaveFail) {
                    saveFailInfoSb.append("\n");
                    isRowSaveFail = false;
                }
                if ((curRow = this.kDTMain.getRow(i)).getCell(this.COL_ITEM_NUMBER).getValue() == null) {
                    isRowSaveFail = true;
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"Item_Blank2"));
                }
                if (curRow.getCell(this.COL_CURRENCY_NAME).getValue() == null) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CURRENCY_CANNOT_EMPTY2"));
                }
                if (curRow.getCell(this.COL_SOURCECURRENCY_NAME).getValue() == null) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SOURCECURRENCY_CANNOT_EMPTY2"));
                }
                if (curRow.getCell(this.COL_VALUETYPE).getValue() == null) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"VALUETYPE_CANNOT_EMPTY"));
                }
                if (curRow.getCell(this.COL_DATAELEMENT).getValue() == null) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"DATAELEMENT_CANNOT_EMPTY"));
                }
                if (ConvertStatusEnum.Converted.equals(curRow.getCell(this.COL_CONVERTSTATUS).getValue()) && curRow.getCell(this.COL_CURRENCY_NAME).getValue() != null && curRow.getCell(this.COL_SOURCECURRENCY_NAME).getValue() != null && ((CurrencyInfo)curRow.getCell(this.COL_CURRENCY_NAME).getValue()).getNumber().equals(((CurrencyInfo)curRow.getCell(this.COL_SOURCECURRENCY_NAME).getValue()).getNumber())) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"YearInitSameCurrencyAfterConvert"));
                }
                if (ConvertStatusEnum.BeforeConvert.equals(curRow.getCell(this.COL_CONVERTSTATUS).getValue()) && curRow.getCell(this.COL_CURRENCY_NAME).getValue() != null && curRow.getCell(this.COL_SOURCECURRENCY_NAME).getValue() != null && !((CurrencyInfo)curRow.getCell(this.COL_CURRENCY_NAME).getValue()).getNumber().equals(((CurrencyInfo)curRow.getCell(this.COL_SOURCECURRENCY_NAME).getValue()).getNumber())) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"YearInitDifCurrencyBeforeConvert"));
                }
                Object debitFormula = curRow.getCell(this.COL_DEBITFORMULA).getValue();
                Object creditFormula = curRow.getCell(this.COL_CREDITFORMULA).getValue();
                if (debitFormula != null && creditFormula != null && !StringUtils.isEmpty((String)debitFormula.toString()) && ((BigDecimal)debitFormula).compareTo(new BigDecimal("0")) != 0 && !StringUtils.isEmpty((String)creditFormula.toString()) && ((BigDecimal)creditFormula).compareTo(new BigDecimal("0")) != 0) {
                    if (!isRowSaveFail) {
                        saveFailInfoSb.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"failRow", (Object[])new Object[]{i + 1}));
                        isRowSaveFail = true;
                    } else {
                        saveFailInfoSb.append("\uff0c");
                    }
                    saveFailInfoSb.append(CslRptUtil.getString((String)"YearInitMutexCreditAndDebit"));
                }
                if (!isRowSaveFail || saveFailInfoSb.substring(saveFailInfoSb.length() - 1).toString().equals("\uff01") || saveFailInfoSb.substring(saveFailInfoSb.length() - 1).toString().equals("!")) continue;
                saveFailInfoSb.append("\uff01");
            }
            if (saveFailInfoSb.length() > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"saveFail"), (String)saveFailInfoSb.toString(), (int)2);
                SysUtil.abort();
            }
        }
    }

    public void loadFromFields() throws BOSException {
        super.loadFields();
        if (this.cacheDataCollection != null && this.cacheDataCollection.size() > 0) {
            int j = this.cacheDataCollection.size();
            for (int i = 0; i < j; ++i) {
                ItemDataYearInitInfo dataInfo = (ItemDataYearInitInfo)this.cacheDataCollection.getObject(i);
                IRow curRow = this.kDTMain.addRow();
                this.setPrecision(curRow.getRowIndex(), dataInfo.getCurrency());
                curRow.getCell(this.COL_ID).setValue((Object)dataInfo.getId().toString());
                curRow.getCell(this.COL_ITEM_NUMBER).setValue((Object)dataInfo.getItem());
                curRow.getCell(this.COL_ITEM_NAME).setValue((Object)dataInfo.getItem().getName());
                this.setColor(curRow, dataInfo.getItem().getDc());
                curRow.getCell(this.COL_CURRENCY_NAME).setValue((Object)dataInfo.getCurrency());
                curRow.getCell(this.COL_CURRENCY_NUMBER).setValue((Object)dataInfo.getCurrency().getNumber());
                curRow.getCell(this.COL_SOURCECURRENCY_NAME).setValue((Object)dataInfo.getSourceCurrency());
                curRow.getCell(this.COL_SOURCECURRENCY_NUMBER).setValue((Object)dataInfo.getSourceCurrency().getNumber());
                curRow.getCell(this.COL_YEAR).setValue((Object)new Integer(dataInfo.getYear()));
                curRow.getCell(this.COL_DEBITFORMULA).setValue((Object)dataInfo.getDebit());
                curRow.getCell(this.COL_CREDITFORMULA).setValue((Object)dataInfo.getCredit());
                curRow.getCell(this.COL_VALUETYPE).setValue((Object)dataInfo.getValueType());
                curRow.getCell(this.COL_SELECT).getStyleAttributes().setLocked(4 != dataInfo.getDataElement());
                curRow.getCell(this.COL_DATAELEMENT).setValue((Object)DataElementProvider.getDataElementInfo((int)dataInfo.getDataElement()));
                curRow.getCell(this.COL_CONVERTSTATUS).setValue((Object)dataInfo.getConvertStatus());
                curRow.getCell(this.COL_PERIOD).setValue((Object)new Integer(dataInfo.getPeriod()));
                curRow.getCell(this.COL_DATACOLLECT).setValue((Object)dataInfo.getDataCollect().getName());
            }
        }
    }

    public void storeToFields() {
        this.changedInfosMap.clear();
        if (this.kDTMain != null && this.kDTMain.getRowCount() > 0) {
            ItemDataYearInitInfo dataInfo = null;
            int j = this.kDTMain.getRowCount();
            for (int i = 0; i < j; ++i) {
                IRow curRow = this.kDTMain.getRow(i);
                if (curRow.getCell(this.COL_SELECT).getValue() != null) continue;
                Object obj = curRow.getCell(this.COL_ID).getValue();
                dataInfo = obj != null ? (ItemDataYearInitInfo)((ItemDataYearInitInfo)this.cacheDataCollection.getObject((Object)BOSUuid.read((String)((String)obj)))).clone() : this.createNewInfo();
                dataInfo.setItem((RPTItemInfo)curRow.getCell(this.COL_ITEM_NUMBER).getValue());
                dataInfo.setCurrency((CurrencyInfo)curRow.getCell(this.COL_CURRENCY_NAME).getValue());
                dataInfo.setSourceCurrency((CurrencyInfo)curRow.getCell(this.COL_SOURCECURRENCY_NAME).getValue());
                dataInfo.setYear(((Integer)curRow.getCell(this.COL_YEAR).getValue()).intValue());
                dataInfo.setDebit((BigDecimal)curRow.getCell(this.COL_DEBITFORMULA).getValue());
                dataInfo.setCredit((BigDecimal)curRow.getCell(this.COL_CREDITFORMULA).getValue());
                dataInfo.setValueType((ValueTypeEnum)curRow.getCell(this.COL_VALUETYPE).getValue());
                dataInfo.setDataElement(((DataElementInfo)curRow.getCell(this.COL_DATAELEMENT).getValue()).getInterSeq());
                dataInfo.setConvertStatus((ConvertStatusEnum)curRow.getCell(this.COL_CONVERTSTATUS).getValue());
                dataInfo.setDataCollect(this.dataCollectInfo);
                dataInfo.setDataCollectNumber(this.dataCollectInfo.getNumber());
                if (curRow.getCell(this.COL_PERIOD) != null && curRow.getCell(this.COL_PERIOD).getValue() != null) {
                    dataInfo.setPeriod(((Integer)curRow.getCell(this.COL_PERIOD).getValue()).intValue());
                }
                if (obj == null) {
                    this.changedInfosMap.put(dataInfo, this.STATUS_ADDNEW);
                    continue;
                }
                this.deleteIdList.remove(dataInfo.getId());
                if (!this.isModify((AbstractObjectValue)dataInfo, (AbstractObjectValue)this.cacheDataCollection.getObject((Object)BOSUuid.read((String)((String)obj))))) continue;
                this.changedInfosMap.put(dataInfo, this.STATUS_UPDATE);
            }
        }
        for (BOSUuid element : this.deleteIdList) {
            this.changedInfosMap.put(this.cacheDataCollection.getObject((Object)element), this.STATUS_DELETE);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ItemDataYearInitFactory.getRemoteInstance();
    }

    protected void checkSelected() {
        if (this.pmptOrgUnit.getData() == null) {
            MsgBox.showInfo((String)CslRptUtil.getString((String)"YearInitSelectOrgFirst"));
            SysUtil.abort();
        }
        if (this.spYear.getValue() == null || this.spYear.getIntegerVlaue() < 1900) {
            MsgBox.showWarning((Component)((Object)this), (String)CslRptUtil.getString((String)"YearInitSelectCorrectYear"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAddBatch_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkSelected();
        CurrencyInfo currency = (CurrencyInfo)this.pmptCurrency.getData();
        CurrencyInfo sourceCurrency = (CurrencyInfo)this.pmptSourceCurrency.getData();
        KDBizPromptBox bizBoxItem = new KDBizPromptBox();
        bizBoxItem.setVisible(false);
        bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)bizBoxItem, (String)((OrgUnitInfo)this.pmptOrgUnit.getData()).getId().toString());
        bizBoxItem.setEnabledMultiSelection(true);
        bizBoxItem.setDataBySelector();
        if (bizBoxItem.getData() == null) {
            SysUtil.abort();
        }
        Object[] rptItemArray = (Object[])bizBoxItem.getData();
        ArrayList<Object> l = new ArrayList<Object>(rptItemArray.length);
        for (i = 0; i < rptItemArray.length; ++i) {
            if (rptItemArray[i] == null) {
                SysUtil.abort();
            }
            l.add(rptItemArray[i]);
        }
        Collections.sort(l);
        for (i = 0; i < l.size(); ++i) {
            RPTItemInfo element = (RPTItemInfo)l.get(i);
            IRow iRow = this.kDTMain.addRow();
            iRow.getCell(this.COL_SELECT).getStyleAttributes().setLocked(true);
            iRow.getCell(this.COL_ITEM_NUMBER).setValue((Object)element);
            iRow.getCell(this.COL_ITEM_NAME).setValue((Object)element.getName());
            this.setColor(iRow, element.getDc());
            if (currency != null) {
                iRow.getCell(this.COL_CURRENCY_NAME).setValue((Object)currency);
                iRow.getCell(this.COL_CURRENCY_NUMBER).setValue((Object)currency.getName());
            }
            if (sourceCurrency != null) {
                iRow.getCell(this.COL_SOURCECURRENCY_NAME).setValue((Object)sourceCurrency);
                iRow.getCell(this.COL_SOURCECURRENCY_NUMBER).setValue((Object)sourceCurrency.getName());
            }
            iRow.getCell(this.COL_YEAR).setValue((Object)this.year);
            iRow.getCell(this.COL_VALUETYPE).setValue((Object)this.valueType);
            iRow.getCell(this.COL_DATAELEMENT).setValue((Object)this.dataElement);
            if (currency != null && sourceCurrency != null) {
                if (currency.getNumber().equals(sourceCurrency.getNumber())) {
                    iRow.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
                } else {
                    iRow.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.Converted);
                }
            } else {
                iRow.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
            }
            this.kDTMain.getColumn(this.COL_PERIOD).getStyleAttributes().setHided(true);
            String dataCollect = this.dataCollectInfo.getNumber();
            if (dataCollect.equals("ACTUALDATA")) {
                dataCollect = DataCollectConstant.getActualDC().getName(SysContext.getSysContext().getLocale());
            } else if (dataCollect.equals("BUDGETDATA")) {
                dataCollect = DataCollectConstant.getBudgetDC().getName(SysContext.getSysContext().getLocale());
            }
            iRow.getCell(this.COL_DATACOLLECT).setValue((Object)dataCollect);
        }
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizBoxItem, (String)((OrgUnitInfo)this.pmptOrgUnit.getData()).getId().toString());
        IRow row = this.kDTMain.addRow();
        row.getCell(this.COL_SELECT).getStyleAttributes().setLocked(true);
        row.getCell(this.COL_YEAR).setValue((Object)this.year);
        row.getCell(this.COL_VALUETYPE).setValue((Object)this.valueType);
        row.getCell(this.COL_DATAELEMENT).setValue((Object)this.dataElement);
        String dataCollect = this.dataCollectInfo.getNumber();
        if (dataCollect.equals("ACTUALDATA")) {
            dataCollect = DataCollectConstant.getActualDC().getName(SysContext.getSysContext().getLocale());
        } else if (dataCollect.equals("BUDGETDATA")) {
            dataCollect = DataCollectConstant.getBudgetDC().getName(SysContext.getSysContext().getLocale());
        }
        row.getCell(this.COL_DATACOLLECT).setValue((Object)dataCollect);
        this.kDTMain.getColumn(this.COL_PERIOD).getStyleAttributes().setHided(true);
        CurrencyInfo currency = (CurrencyInfo)this.pmptCurrency.getData();
        CurrencyInfo sourceCurrency = (CurrencyInfo)this.pmptSourceCurrency.getData();
        if (currency != null) {
            row.getCell(this.COL_CURRENCY_NAME).setValue((Object)currency);
            row.getCell(this.COL_CURRENCY_NUMBER).setValue((Object)currency.getName());
        }
        if (sourceCurrency != null) {
            row.getCell(this.COL_SOURCECURRENCY_NAME).setValue((Object)sourceCurrency);
            row.getCell(this.COL_SOURCECURRENCY_NUMBER).setValue((Object)sourceCurrency.getName());
        }
        if (currency != null && sourceCurrency != null && !currency.getName().equals(sourceCurrency.getName())) {
            row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.Converted);
        } else {
            row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
        }
        if (this.kDTMain.getRowCount() > 0) {
            int preTableHeght = (int)this.kDTMain.getBounds().getHeight();
            int rowHight = this.kDTMain.getBody().getRowHeight(0);
            if (this.kDTMain.getRowCount() < preTableHeght / rowHight - 2) {
                KDTVertical vertical = this.kDTMain.getLayoutManager().getVertical(1);
                vertical.repaint();
                vertical.scrollToPosition(0);
                this.kDTMain.getSelectManager().select(this.kDTMain.getRowCount() - 1, 0);
            } else {
                KDTVertical vertical = this.kDTMain.getLayoutManager().getVertical(1);
                vertical.repaint();
                vertical.scrollToPosition(this.kDTMain.getRowCount() - (preTableHeght / rowHight - 2));
                this.kDTMain.getSelectManager().select(this.kDTMain.getRowCount() - 1, 0);
            }
        }
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDTMain.getSelectManager().size() > 0) {
            this.deleteSelectedRows();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        }
    }

    protected void deleteSelectedRows() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        KDTSelectBlock selectBlock = null;
        int size = this.kDTMain.getSelectManager().size();
        if (size == 0 || this.kDTMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            selectBlock = this.kDTMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                Integer tempIndex = new Integer(j);
                if (list.contains(tempIndex)) continue;
                list.add(tempIndex);
            }
        }
        Object[] index = list.toArray();
        Arrays.sort(index);
        IRow row = null;
        Object obj = null;
        for (int i = index.length; i > 0; --i) {
            row = this.kDTMain.getRow(((Integer)index[i - 1]).intValue());
            obj = row.getCell(this.COL_ID).getValue();
            if (obj != null) {
                this.deleteIdList.add(BOSUuid.read((String)((String)obj)));
            }
            this.kDTMain.removeRow(((Integer)index[i - 1]).intValue());
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.kDTMain.removeRows();
        this.storeHeadData();
        this.loadData();
        this.loadFromFields();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.beforeExit(e);
        super.actionExitCurrent_actionPerformed(e);
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            this.beforeExit(null);
        }
        catch (Exception e) {
            if (e instanceof AbortException) {
                return false;
            }
            super.handUIException((Throwable)e);
        }
        return super.checkBeforeWindowClosing();
    }

    private void beforeExit(ActionEvent e) throws Exception {
        this.storeToFields();
        if (this.changedInfosMap.size() != 0) {
            int status = MsgBox.showConfirm3((String)(CslRptUtil.getString((String)"YearInitHintBeforeSave") + CslRptUtil.getString((String)"_exit")));
            if (status == 2) {
                SysUtil.abort();
            } else if (status == 0) {
                this.actionSave_actionPerformed(e);
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        long startTime = System.currentTimeMillis();
        super.actionSave_actionPerformed(e);
        this.beforeStoreFields(e);
        this.storeToFields();
        this.checkDataRepeat();
        this.saveData();
        this.actionRefresh_actionPerformed(e);
        long counter = System.currentTimeMillis() - startTime;
        BigDecimal time = new BigDecimal(String.valueOf((double)counter / 1000.0)).setScale(2, 4);
        Object[] param = new Object[]{time.toString()};
        super.setMessageText(CslRptUtil.getStringWithFormat((String)"YearInitSaveOK", (Object[])param));
        super.showMessage();
    }

    public void checkDataRepeat() throws ItemDataProviderException {
        HashSet<Integer> rowset = new HashSet<Integer>();
        ArrayList repeatList = new ArrayList();
        ArrayList<Integer> repeatItemRow = null;
        for (int i = 0; i < this.kDTMain.getRowCount() - 1; ++i) {
            if (rowset.contains(i)) continue;
            repeatItemRow = new ArrayList<Integer>();
            for (int j = i + 1; j < this.kDTMain.getRowCount(); ++j) {
                String number = this.kDTMain.getRow(i).getCell("number").getValue().toString();
                String currency = this.kDTMain.getRow(i).getCell("currency.name").getValue().toString();
                String sourceCurrency = this.kDTMain.getRow(i).getCell("sourceCurrency.name").getValue().toString();
                String convertStatus = this.kDTMain.getRow(i).getCell("convertStatus").getValue().toString();
                String valueType = this.kDTMain.getRow(i).getCell("valueType").getValue().toString();
                if (!number.equals(this.kDTMain.getRow(j).getCell("number").getValue().toString()) || !currency.equals(this.kDTMain.getRow(j).getCell("currency.name").getValue().toString()) || !sourceCurrency.equals(this.kDTMain.getRow(j).getCell("sourceCurrency.name").getValue().toString()) || !convertStatus.equals(this.kDTMain.getRow(j).getCell("convertStatus").getValue().toString()) || !valueType.equals(this.kDTMain.getRow(j).getCell("valueType").getValue().toString())) continue;
                if (!repeatItemRow.contains(i + 1)) {
                    repeatItemRow.add(i + 1);
                }
                repeatItemRow.add(j + 1);
                rowset.add(j);
            }
            if (repeatItemRow.size() == 0) continue;
            repeatList.add(repeatItemRow);
        }
        StringBuffer repeatException = new StringBuffer("");
        if (repeatList.size() > 0) {
            for (int i = 0; i < repeatList.size(); ++i) {
                repeatException.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"884_dataRepeat", (Object[])new Object[]{repeatList.get(i).toString()}));
                repeatException.append("\n");
            }
            MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"889_doubleData"), (String)repeatException.toString());
            SysUtil.abort();
        }
    }

    @Override
    public void actionAddByTemp_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        this.checkSelected();
        String curOrgUnitId = ((OrgUnitInfo)this.pmptOrgUnit.getData()).getId().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"orgUnitId", (Object)curOrgUnitId);
        uiContext.put((Object)"isProfit", (Object)this.isProfit);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ItemDataAddByNormalTemplateUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        window.show();
        List<String> tempIdList = ItemDataAddByNormalTemplateUI.tempIdList;
        Map<String, CurrencyInfo> currencyMap = ItemDataAddByNormalTemplateUI.currencyMap;
        if (tempIdList == null || tempIdList.size() == 0) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("templateIds", tempIdList);
        param.put("dataElement", this.dataElement.getInterSeq());
        List result = ((IItemDataYearInit)this.getBizInterface()).getYearInitItemByTemplates(param);
        if (result == null) {
            return;
        }
        int rowCount = this.kDTMain.getRowCount();
        ArrayList<String> itemNumbers = new ArrayList<String>();
        RPTItemInfo rptItem = null;
        CurrencyInfo sourceCurrency = null;
        CurrencyInfo currency = null;
        String key = null;
        Object obj = null;
        ValueTypeEnum valueTypeEnum = null;
        for (int i = rowCount - 1; i >= 0; --i) {
            row = this.kDTMain.getRow(i);
            obj = row.getCell(this.COL_ITEM_NUMBER).getValue();
            if (obj == null || !(obj instanceof RPTItemInfo)) continue;
            rptItem = (RPTItemInfo)obj;
            currency = (CurrencyInfo)row.getCell(this.COL_CURRENCY_NAME).getValue();
            sourceCurrency = (CurrencyInfo)row.getCell(this.COL_SOURCECURRENCY_NAME).getValue();
            valueTypeEnum = (ValueTypeEnum)row.getCell(this.COL_VALUETYPE).getValue();
            key = rptItem.getNumber() + (currency == null ? "" : currency.getNumber() + (sourceCurrency == null ? "" : sourceCurrency.getNumber())) + valueTypeEnum.getValue();
            itemNumbers.add(key);
        }
        sourceCurrency = currencyMap.get("sourceCurrency");
        currency = currencyMap.get("targCurrency");
        RPTItemInfo itemInfo = null;
        for (int i = 0; i < result.size(); ++i) {
            itemInfo = (RPTItemInfo)result.get(i);
            if (itemInfo == null) continue;
            valueTypeEnum = (ValueTypeEnum)itemInfo.get("ValueType");
            key = itemInfo.getNumber() + (currency == null ? "" : currency.getNumber() + (sourceCurrency == null ? "" : sourceCurrency.getNumber())) + valueTypeEnum.getValue();
            if (itemNumbers.contains(key)) continue;
            row = this.kDTMain.addRow();
            row.getCell(this.COL_SELECT).getStyleAttributes().setLocked(true);
            row.getCell(this.COL_ITEM_NUMBER).setValue((Object)itemInfo);
            row.getCell(this.COL_ITEM_NAME).setValue((Object)itemInfo.getName());
            this.setColor(row, itemInfo.getDc());
            if (currency != null) {
                row.getCell(this.COL_CURRENCY_NAME).setValue((Object)currency);
                row.getCell(this.COL_CURRENCY_NUMBER).setValue((Object)currency.getName());
            }
            if (sourceCurrency != null) {
                row.getCell(this.COL_SOURCECURRENCY_NAME).setValue((Object)sourceCurrency);
                row.getCell(this.COL_SOURCECURRENCY_NUMBER).setValue((Object)sourceCurrency.getName());
            }
            row.getCell(this.COL_YEAR).setValue((Object)this.spYear.getIntegerVlaue());
            row.getCell(this.COL_VALUETYPE).setValue((Object)valueTypeEnum);
            row.getCell(this.COL_DATAELEMENT).setValue((Object)this.dataElement);
            if (currency != null && sourceCurrency != null) {
                if (currency.getNumber().equals(sourceCurrency.getNumber())) {
                    row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
                } else {
                    row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.Converted);
                }
            } else {
                row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
            }
            row.getCell("dataCollect").setValue((Object)this.dataCollectInfo.getNumber());
            this.kDTMain.getColumn(this.COL_PERIOD).getStyleAttributes().setHided(true);
        }
        this.tableSorter.setOrder(0);
        this.tableSorter.sort("number");
    }

    @Override
    public void actionGenerate_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isLastPeriod()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CslRptUITitleRes", (String)"GroupRptList_Dialog_NotLastPeriodRpt"));
            return;
        }
        if (this.pmptCurrency.getValue() == null || this.pmptSourceCurrency.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.ConvertRate", (String)"137_Need_Select_Currency"));
            return;
        }
        this.storeHeadData();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"companyName", (Object)this.orgUnit.getName());
        uiContext.put((Object)"companyId", (Object)this.orgUnit.getId().toString());
        uiContext.put((Object)"year", (Object)this.year);
        if (this.currency != null) {
            uiContext.put((Object)"currencyId", (Object)this.currency.getId().toString());
        }
        if (this.sourceCurrency != null) {
            uiContext.put((Object)"sourceCurrencyId", (Object)this.sourceCurrency.getId().toString());
        }
        uiContext.put((Object)"dataCollectNumber", (Object)this.dataCollectInfo.getNumber());
        uiContext.put((Object)"dataElement", (Object)4);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(GenerateNextYearInitUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        window.show();
    }

    protected EntityViewInfo getEntityViewInfo() throws Exception {
        if (this.pmptOrgUnit.getValue() == null) {
            this.setMessageText(CslRptUtil.getString((String)"YearInitSelectOrgFirst"));
            this.showMessage();
            SysUtil.abort();
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)((OrgUnitInfo)this.pmptOrgUnit.getValue()).getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("year", (Object)this.spYear.getIntegerVlaue()));
        filterInfo.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)this.dataCollectInfo.getNumber()));
        if (this.pmptCurrency.getData() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)((CurrencyInfo)this.pmptCurrency.getData()).getId().toString()));
        }
        if (this.pmptSourceCurrency.getData() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceCurrency.id", (Object)((CurrencyInfo)this.pmptSourceCurrency.getData()).getId().toString()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("dataElement", (Object)new Integer(this.dataElement.getInterSeq())));
        this.entityViewInfo.setFilter(filterInfo);
        this.entityViewInfo.getSelector().clear();
        this.entityViewInfo.put("selector", (Object)this.getSelectorItemCollection());
        this.entityViewInfo.getSorter().clear();
        this.entityViewInfo.getSorter().add(new SorterItemInfo("item.number"));
        return this.entityViewInfo;
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("item.id"));
        sic.add(new SelectorItemInfo("item.number"));
        sic.add(new SelectorItemInfo("item.name"));
        sic.add(new SelectorItemInfo("item.dc"));
        sic.add(new SelectorItemInfo("item.reportClass.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("sourceCurrency.id"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.precision"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("debit"));
        sic.add(new SelectorItemInfo("credit"));
        sic.add(new SelectorItemInfo("valueType"));
        sic.add(new SelectorItemInfo("convertStatus"));
        sic.add(new SelectorItemInfo("dataElement"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("dataCollect.*"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        return sic;
    }

    private void initEntryTable() throws Exception {
        KDCheckBox chkSelect = new KDCheckBox();
        chkSelect.setSelected(false);
        KDTDefaultCellEditor selectEditor = new KDTDefaultCellEditor((JCheckBox)chkSelect);
        this.kDTMain.getColumn(this.COL_SELECT).setEditor((ICellEditor)selectEditor);
        KDFormattedTextField formatField = new KDFormattedTextField();
        formatField.setDataType(1);
        formatField.setSupportedEmpty(true);
        formatField.setPrecision(5);
        KDTDefaultCellEditor dcEditor = new KDTDefaultCellEditor((JTextField)formatField);
        this.kDTMain.getColumn(this.COL_DEBITFORMULA).setEditor((ICellEditor)dcEditor);
        this.kDTMain.getColumn(this.COL_CREDITFORMULA).setEditor((ICellEditor)dcEditor);
        KDTDefaultCellEditor currencyEditor = new KDTDefaultCellEditor((IKDEditor)CslRptUIUtil.getCurrencyF7());
        this.kDTMain.getColumn(this.COL_CURRENCY_NAME).setEditor((ICellEditor)currencyEditor);
        this.kDTMain.getColumn(this.COL_CURRENCY_NAME).getStyleAttributes().setLocked(false);
        this.kDTMain.getColumn(this.COL_CURRENCY_NUMBER).getStyleAttributes().setHided(true);
        KDTDefaultCellEditor sourceCurrencyEditor = new KDTDefaultCellEditor((IKDEditor)CslRptUIUtil.getCurrencyF7());
        this.kDTMain.getColumn(this.COL_SOURCECURRENCY_NAME).setEditor((ICellEditor)sourceCurrencyEditor);
        this.kDTMain.getColumn(this.COL_SOURCECURRENCY_NAME).getStyleAttributes().setLocked(false);
        this.kDTMain.getColumn(this.COL_SOURCECURRENCY_NUMBER).getStyleAttributes().setHided(true);
        this.bizBoxItem = new KDBizPromptBox();
        this.bizBoxItem.setQueryInfo("com.kingdee.eas.fi.gr.cslrpt.RPTItemQuery");
        this.bizBoxItem.setEditFormat("$number$");
        this.bizBoxItem.setDisplayFormat("$number$");
        this.bizBoxItem.setEditable(true);
        this.bizBoxItem.setCommitFormat("$number$");
        CslGradeManageUtil.setRptItemF7GMFilter((KDBizPromptBox)this.bizBoxItem, null);
        KDTDefaultCellEditor itemEditor = new KDTDefaultCellEditor((IKDEditor)this.bizBoxItem);
        this.kDTMain.getColumn(this.COL_ITEM_NUMBER).setEditor((ICellEditor)itemEditor);
        KDComboBox cmbDataElement = new KDComboBox();
        cmbDataElement.addItem((Object)DataElementProvider.getDataElementInfo((int)3));
        cmbDataElement.addItem((Object)DataElementProvider.getDataElementInfo((int)5));
        this.kDTMain.getColumn(this.COL_DATAELEMENT).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbDataElement));
        KDComboBox cmbValueType = new KDComboBox();
        cmbValueType.addItem((Object)ValueTypeEnum.MONEY);
        cmbValueType.addItem((Object)ValueTypeEnum.QUANTITY);
        this.kDTMain.getColumn(this.COL_VALUETYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbValueType));
        KDComboBox cmbConvertStatus = new KDComboBox();
        cmbConvertStatus.addItem((Object)ConvertStatusEnum.BeforeConvert);
        cmbConvertStatus.addItem((Object)ConvertStatusEnum.Converted);
        this.kDTMain.getColumn(this.COL_CONVERTSTATUS).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbConvertStatus));
        this.kDTMain.getColumn(this.COL_PERIOD).getStyleAttributes().setLocked(true);
        this.kDTMain.getColumn(this.COL_DATAELEMENT).getStyleAttributes().setLocked(true);
        this.kDTMain.getColumn(this.COL_DATACOLLECT).getStyleAttributes().setLocked(true);
        if ("true".equals(CslRptUtil.getParamValue(null, null, (String)"GR_CSL_SupportOtherDS"))) {
            this.kDTMain.getColumn(this.COL_DATACOLLECT).getStyleAttributes().setHided(false);
        } else {
            this.kDTMain.getColumn(this.COL_DATACOLLECT).getStyleAttributes().setHided(true);
        }
        String numberFmt = FMClientHelper.getNumberFtm((int)2);
        if (this.kDTMain.getColumn(this.COL_DEBITFORMULA) != null) {
            this.kDTMain.getColumn(this.COL_DEBITFORMULA).getStyleAttributes().setNumberFormat(numberFmt);
        }
        if (this.kDTMain.getColumn(this.COL_CREDITFORMULA) != null) {
            this.kDTMain.getColumn(this.COL_CREDITFORMULA).getStyleAttributes().setNumberFormat(numberFmt);
        }
    }

    private void setColor(IRow row, DebitOrCreditEnum dc) {
        if (DebitOrCreditEnum.CREDIT.equals((Object)dc)) {
            row.getCell(this.COL_CREDITFORMULA).getStyleAttributes().setBackground(this.yellowColor);
            row.getCell(this.COL_DEBITFORMULA).getStyleAttributes().setBackground(this.whiteColor);
        } else if (DebitOrCreditEnum.DEBIT.equals((Object)dc)) {
            row.getCell(this.COL_CREDITFORMULA).getStyleAttributes().setBackground(this.whiteColor);
            row.getCell(this.COL_DEBITFORMULA).getStyleAttributes().setBackground(this.yellowColor);
        } else {
            row.getCell(this.COL_CREDITFORMULA).getStyleAttributes().setBackground(this.whiteColor);
            row.getCell(this.COL_DEBITFORMULA).getStyleAttributes().setBackground(this.whiteColor);
        }
    }

    private void tableValueChanged(KDTEditEvent e) {
        Object obj;
        CurrencyInfo currency;
        int selectRow = e.getRowIndex();
        KDTable kdtEntry = (KDTable)e.getSource();
        IRow row = kdtEntry.getRow(selectRow);
        if (e.getColIndex() == kdtEntry.getColumnIndex(this.COL_ITEM_NUMBER) && e.getValue() != null && e.getOldValue() != e.getValue()) {
            row.getCell(this.COL_CREDITFORMULA).setValue(null);
            row.getCell(this.COL_DEBITFORMULA).setValue(null);
            RPTItemInfo rptItem = (RPTItemInfo)e.getValue();
            row.getCell(this.COL_ITEM_NAME).setValue((Object)rptItem.getName(this.getCurrentLocale()));
            this.setColor(row, rptItem.getDc());
        }
        if (e.getColIndex() == kdtEntry.getColumnIndex(this.COL_CURRENCY_NAME) && e.getValue() != null && e.getOldValue() != e.getValue()) {
            row.getCell(this.COL_CREDITFORMULA).setValue(null);
            row.getCell(this.COL_DEBITFORMULA).setValue(null);
            currency = (CurrencyInfo)e.getValue();
            this.setPrecision(e.getRowIndex(), currency);
            row.getCell(this.COL_CURRENCY_NUMBER).setValue((Object)currency.getName(this.getCurrentLocale()));
            obj = row.getCell(this.COL_SOURCECURRENCY_NAME).getValue();
            if (obj != null) {
                if (currency.getNumber().equals(((CurrencyInfo)obj).getNumber())) {
                    row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
                } else {
                    row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.Converted);
                }
            }
        }
        if (e.getColIndex() == kdtEntry.getColumnIndex(this.COL_SOURCECURRENCY_NAME) && e.getValue() != null && e.getOldValue() != e.getValue()) {
            row.getCell(this.COL_CREDITFORMULA).setValue(null);
            row.getCell(this.COL_DEBITFORMULA).setValue(null);
            currency = (CurrencyInfo)e.getValue();
            this.setPrecision(e.getRowIndex(), currency);
            row.getCell(this.COL_SOURCECURRENCY_NUMBER).setValue((Object)currency.getName(this.getCurrentLocale()));
            obj = row.getCell(this.COL_CURRENCY_NAME).getValue();
            if (obj != null) {
                if (currency.getNumber().equals(((CurrencyInfo)obj).getNumber())) {
                    row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.BeforeConvert);
                } else {
                    row.getCell(this.COL_CONVERTSTATUS).setValue((Object)ConvertStatusEnum.Converted);
                }
            }
        }
        if (e.getColIndex() == kdtEntry.getColumnIndex(this.COL_DEBITFORMULA) || e.getColIndex() == kdtEntry.getColumnIndex(this.COL_CREDITFORMULA)) {
            Object debitFormula = row.getCell(this.COL_DEBITFORMULA).getValue();
            Object creditFormula = row.getCell(this.COL_CREDITFORMULA).getValue();
            if (debitFormula != null && creditFormula != null && !StringUtils.isEmpty((String)debitFormula.toString()) && ((BigDecimal)debitFormula).compareTo(new BigDecimal("0")) != 0 && !StringUtils.isEmpty((String)creditFormula.toString()) && ((BigDecimal)creditFormula).compareTo(new BigDecimal("0")) != 0) {
                MsgBox.showInfo((Component)((Object)this), (String)CslRptUtil.getString((String)"YearInitMutexCreditAndDebit"));
                row.getCell(e.getColIndex()).setValue(null);
            }
        }
    }

    private void setPrecision(int rowIndex, CurrencyInfo currency) {
        StyleAttributes attrDebit = this.kDTMain.getRow(rowIndex).getCell(this.COL_DEBITFORMULA).getStyleAttributes();
        attrDebit.setNumberFormat(CslRptUIUtil.getFmtStr((CurrencyInfo)currency));
        attrDebit.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        StyleAttributes attrCredit = this.kDTMain.getRow(rowIndex).getCell(this.COL_CREDITFORMULA).getStyleAttributes();
        attrCredit.setNumberFormat(CslRptUIUtil.getFmtStr((CurrencyInfo)currency));
        attrCredit.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    public void actionImportExcelData_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        HashMap<String, FullOrgUnitCollection> params = new HashMap<String, FullOrgUnitCollection>();
        if (this.orgList == null || this.orgList.size() == 0) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            String[] permItems = PermissionHelper.getRptBasePermArrByOrgType((OrgType)OrgType.Company);
            this.orgList = (FullOrgUnitCollection)ItemDataYearInitFactory.getRemoteInstance().getAuthorizedOrg(userId, permItems, OrgType.Company);
        }
        params.put("orgIds", this.orgList);
        uiContext.put((Object)"parentUI", (Object)this);
        uiContext.put((Object)"UIParams", params);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ItemDataImportWizardUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
        this.actionRefresh_actionPerformed(e);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId());
    }
}

