/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.client.ICellTextFormator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class KDTableUtil {
    private static final Logger log = Logger.getLogger(KDTableUtil.class);

    public static <T> void fillData(List<T> rows, KDTable tblMain, boolean clearPreviousRow, Map<String, ICellTextFormator> cellTextFormators) {
        if (clearPreviousRow) {
            tblMain.removeRows();
        }
        KDTColumns columns = tblMain.getColumns();
        String fieldName = null;
        Object fieldValue = null;
        String cellValue = null;
        for (T rowData : rows) {
            IRow row = tblMain.addRow();
            row.setUserObject(rowData);
            for (int i = 0; i < columns.size(); ++i) {
                fieldName = columns.getColumnKey(i);
                fieldValue = KDTableUtil.getFieldValue(rowData, fieldName);
                if (fieldValue == null) continue;
                row.getCell(i).setUserObject(fieldValue);
                cellValue = cellTextFormators.containsKey(fieldName) ? cellTextFormators.get(fieldName).convert(fieldValue) : fieldValue.toString();
                row.getCell(i).setValue((Object)cellValue);
            }
        }
    }

    private static Object getFieldValue(Object bean, String fieldName) {
        try {
            int pointPos = fieldName.indexOf(".");
            if (pointPos != -1) {
                bean = KDTableUtil.getFieldValue(bean, fieldName.substring(0, pointPos));
                return KDTableUtil.getFieldValue(bean, fieldName.substring(pointPos + 1));
            }
            Method getMethod = null;
            String methodName = "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
            try {
                getMethod = bean.getClass().getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                getMethod = bean.getClass().getMethod(methodName, new Class[0]);
            }
            NewRptUtil.makeAccessible((Method)getMethod);
            return getMethod.invoke(bean, new Object[0]);
        }
        catch (SecurityException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"", (Throwable)e);
        }
        return null;
    }
}

