/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.PublicTemplateException;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.ISpecialTemplateManager;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.util.List;
import java.util.Map;

public class PublicTemplateManager
implements ISpecialTemplateManager {
    private ListUI ui;

    public PublicTemplateManager(ListUI ui) {
        this.ui = ui;
    }

    @Override
    public IRowSet getTemplateDataRowSet(String currenctCompanyid, List versionTypeList, boolean isShowUnpblish, boolean isShowUnaudit, SorterItemCollection sorter) throws EASBizException, BOSException {
        return this.getBizInterface().getRowSetForPublicTemplate(currenctCompanyid, versionTypeList, isShowUnpblish, isShowUnaudit, sorter);
    }

    @Override
    public void prepareForEdit(UIContext uiContext, String templateid, String currenctCompanyID) throws EASBizException, BOSException {
        try {
            boolean isNeedVersioning = this.getBizInterface().isPublicTemplateNeedVersioning(templateid, currenctCompanyID);
            uiContext.put((Object)"PublilcTemlateNeedVersioning", (Object)isNeedVersioning);
        }
        catch (PublicTemplateException e) {
            if (PublicTemplateException.TEMPLATE_QUOTED.getCode().equals(e.getSubCode())) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"146_PublicTemplateManager");
                int isOK = MsgBox.showConfirm3a((Component)this.ui, (String)msg, (String)((Exception)e.getCause()).getLocalizedMessage());
                if (isOK == 1 || isOK == 2) {
                    SysUtil.abort();
                } else {
                    uiContext.put((Object)"PublilcTemlateNeedVersioning", (Object)Boolean.TRUE);
                    uiContext.put((Object)"isNewVersion", (Object)Boolean.TRUE);
                }
            }
            if (PublicTemplateException.NEEDUN_AUDIT_FIRST.getCode().equals(e.getSubCode())) {
                this.showErrorMsg(e.getMessage());
                SysUtil.abort();
            }
            if (PublicTemplateException.TEMPLATE_AUDITED.getCode().equals(e.getSubCode())) {
                if (!Boolean.TRUE.equals(uiContext.get((Object)"onlyAudited"))) {
                    int isOK = MsgBox.showConfirm2((Component)this.ui, (String)e.getMessage());
                    if (isOK == 1 || isOK == 2) {
                        SysUtil.abort();
                    } else {
                        uiContext.put((Object)"PublilcTemlateNeedVersioning", (Object)Boolean.TRUE);
                    }
                }
            }
            this.showErrorMsg(e.getMessage());
            SysUtil.abort();
        }
    }

    @Override
    public void prepareForDelete(TemplateInfo info) throws EASBizException, BOSException {
        List templateQuotedList = this.getBizInterface().checkPublicTemplateQuoted(info.getId().toString());
        if (templateQuotedList != null && templateQuotedList.size() > 0) {
            String msg = this.buildQuetedPublicTemplateMsg(info, templateQuotedList);
            MsgBox.showError((Component)this.ui, (String)new PublicTemplateException(PublicTemplateException.TEMPLATE_QUOTED).getMessage(), (String)msg);
            SysUtil.abort();
        }
    }

    private ITemplate getBizInterface() throws BOSException {
        return TemplateFactory.getRemoteInstance();
    }

    private String buildQuetedPublicTemplateMsg(TemplateInfo info, List quoteResultList) {
        StringBuffer detail = new StringBuffer();
        detail.append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"5_ReportControllerBean")).append(info.getNumber()).append(" ").append(info.getName()).append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"20_TemplateControllerBean"));
        for (Map entry : quoteResultList) {
            detail.append(entry.get("CompanyName")).append("\uff0c");
            ReportTypeEnum type = (ReportTypeEnum)((Object)entry.get("SourceType"));
            if (ReportTypeEnum.REPORT.equals((Object)type)) {
                detail.append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"21_TemplateControllerBean")).append(entry.get("Source")).append("\n");
                continue;
            }
            detail.append(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"22_TemplateControllerBean")).append(entry.get("Source")).append("\n");
        }
        detail.append("\n");
        return detail.toString();
    }

    private void showErrorMsg(String msg) {
        this.ui.setMessageText(msg);
        this.ui.setMessageIcon(ListUI.SHOW_MESSAGE_ICON_ERROR);
        this.ui.setMessageBgcolor(ListUI.SHOW_MESSAGE_BG_ERROR);
        this.ui.showMessage();
    }

    @Override
    public void updateUIStateAfterDataRequest(ListUI ui) {
        IColumn column = ui.getMainTable().getColumn("isAllowChange");
        if (column != null) {
            column.getStyleAttributes().setHided(false);
        }
        if ((column = ui.getMainTable().getColumn("groupCompany")) != null) {
            column.getStyleAttributes().setHided(false);
        }
        if ((column = ui.getMainTable().getColumn("company")) != null) {
            column.getStyleAttributes().setHided(false);
        }
    }
}

