/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.fi.rpt.client.AbstractQuickSelectorUI;
import com.kingdee.eas.fi.rpt.client.QuickSelectorObject;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class QuickSelectorUI
extends AbstractQuickSelectorUI
implements IUIObject {
    private static final long serialVersionUID = 7805983967469407338L;
    private static final Logger logger = CoreUIObject.getLogger(QuickSelectorUI.class);
    private List dataList;
    private List currentDisplayList;
    private boolean isCancel;
    private Object selectedObject;

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.beforeDispose(true);
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        this.okAction();
    }

    private void okAction() {
        int index = this.kdTable.getSelectManager().getActiveRowIndex();
        Object o = null;
        if (index >= 0) {
            o = this.currentDisplayList.get(index);
        }
        if (this.currentDisplayList != null && o != null && this.currentDisplayList.size() > 0 && o instanceof QuickSelectorObject) {
            QuickSelectorObject qso = o;
            this.selectedObject = qso.getObject();
        } else {
            this.selectedObject = null;
        }
        this.beforeDispose(false);
        this.disposeUIWindow();
    }

    private void beforeDispose(boolean isCancel) {
        this.currentDisplayList.clear();
        this.currentDisplayList.addAll(this.dataList);
        this.refresh();
        this.queryText.setText(null);
        this.isCancel = isCancel;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentDisplayList == null) {
            this.currentDisplayList = new ArrayList();
        } else {
            this.currentDisplayList.clear();
        }
        String queryString = this.queryText.getText();
        if (queryString != null && queryString.length() > 0) {
            Iterator iterator = this.dataList.iterator();
            boolean isFool = this.chkFool.isSelected();
            while (iterator.hasNext()) {
                QuickSelectorObject qo = (QuickSelectorObject)iterator.next();
                if (!this.isStringMatch(queryString, qo.getDisplayString(), isFool)) continue;
                this.currentDisplayList.add(qo);
            }
        } else if (this.chkFool.isSelected()) {
            this.currentDisplayList.addAll(this.dataList);
        }
        this.refreshTable(this.currentDisplayList);
        if (this.currentDisplayList.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.Target_Not_Found"));
            this.queryText.requestFocus();
        }
        this.kdTable.getSelectManager().removeAll();
    }

    private boolean isStringMatch(String source, String target, boolean isIllegibility) {
        if (!isIllegibility) {
            if (source == null && target == null) {
                return true;
            }
            if (source == null || target == null) {
                return false;
            }
            return source.equals(target);
        }
        int targetLength = target.length();
        int sourceLength = source.length();
        int sourceIndex = 0;
        if (targetLength == 0 && sourceLength == 0) {
            return true;
        }
        if (targetLength < sourceLength) {
            return false;
        }
        for (int targetIndex = 0; targetIndex < targetLength; ++targetIndex) {
            while (sourceIndex < sourceLength && targetIndex < targetLength && target.charAt(targetIndex) == source.charAt(sourceIndex)) {
                ++targetIndex;
                ++sourceIndex;
            }
            if (sourceIndex == sourceLength) {
                return true;
            }
            sourceIndex = 0;
        }
        return false;
    }

    public boolean isCanceled() {
        return this.isCancel;
    }

    public Object getData() {
        return this.selectedObject;
    }

    public void setData(Object o) {
        this.selectedObject = o;
    }

    public void setDisplayQueryString(String queryString) {
        this.queryLable.setText(queryString);
    }

    public void setDataCollection(Collection col) {
        this.dataList = new ArrayList(col);
        if (this.dataList != null && this.dataList.size() > 0) {
            this.currentDisplayList = new ArrayList(this.dataList);
            this.refreshTable(this.currentDisplayList);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        IColumn dataColumn = this.kdTable.addColumn();
        dataColumn.setWidth(300);
        this.kdTable.getSelectManager().setSelectMode(2);
        this.kdTable.setEditable(false);
        this.btnQeury.setEnabled(true);
        this.btnOK.setEnabled(true);
        this.btnCancle.setEnabled(true);
        KDTMenuManager popup = new KDTMenuManager(this.kdTable);
        KDTMenuManager mm = this.getMenuManager(this.kdTable);
        mm = popup;
        mm.getMenu().setEnabled(false);
    }

    private void refreshTable(List list) {
        this.kdTable.removeRows();
        if (list == null || list.size() == 0) {
            return;
        }
        Iterator iterator = list.iterator();
        int i = 0;
        boolean isSelected = false;
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof QuickSelectorObject)) continue;
            QuickSelectorObject so = (QuickSelectorObject)o;
            IRow row = this.kdTable.addRow();
            ICell cell = row.getCell(0);
            cell.setValue((Object)so.getDisplayString());
            if (this.selectedObject != null && this.selectedObject.equals(so.getObject())) {
                this.kdTable.getSelectManager().setActiveRowIndex(i);
                this.kdTable.getSelectManager().select(i, 0);
                this.kdTable.scrollToVisible(i, 0);
                isSelected = true;
            }
            ++i;
        }
        if (!isSelected) {
            this.kdTable.getSelectManager().removeAll();
        }
    }

    public void refresh() {
        this.refreshTable(this.currentDisplayList);
    }

    public void selectNull() {
        this.kdTable.getSelectManager().removeAll();
    }

    public void selectFirstData() {
        if (this.dataList != null && this.dataList.size() > 0) {
            this.selectedObject = ((QuickSelectorObject)this.dataList.get(0)).getObject();
            this.refreshTable(this.dataList);
            this.selectedObject = null;
        }
    }

    public void setHeader(String header) {
        this.kdTable.addHeadRow().getCell(0).setValue((Object)header);
    }

    public void onShow() throws Exception {
        super.onShow();
        QuickSelectorUI ui = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int index = QuickSelectorUI.this.kdTable.getSelectManager().getActiveRowIndex();
                QuickSelectorUI.this.kdTable.scrollToVisible(index, 0);
            }
        });
    }
}

