/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.rpt.AbstractReportDateMapingInfo;
import com.kingdee.eas.fi.rpt.CompanyMapingDataCollection;
import com.kingdee.eas.fi.rpt.CompanyMapingDataFactory;
import com.kingdee.eas.fi.rpt.CompanyMapingDataInfo;
import com.kingdee.eas.fi.rpt.JiuQiReportTypeEnum;
import com.kingdee.eas.fi.rpt.ReportDateMapingCollection;
import com.kingdee.eas.fi.rpt.ReportDateMapingFactory;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.ReportMapingData;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportExporter {
    private static Logger logger = Logger.getLogger(ReportExporter.class);
    private StringBuffer buf = null;
    private StringBuffer errorBuf = null;
    private Component parentWindow = null;
    private boolean isWithYear;
    private boolean isWithPeriod;
    private boolean isWithJiuQiReportType;

    public void exceportForRPA(String reportId, String patch, String reportName) throws Exception {
        this.errorBuf = new StringBuffer();
        File exportDir = new File(patch);
        if (!exportDir.exists()) {
            exportDir.mkdirs();
        }
        ICslReport rpt = CslReportFactory.getRemoteInstance();
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)reportId));
        ev.getSelector().add(new SelectorItemInfo("*"));
        ev.getSelector().add(new SelectorItemInfo("orgUnit.*"));
        ev.getSelector().add(new SelectorItemInfo("currency.*"));
        CslReportCollection cslc = rpt.getCslReportCollection(ev);
        CslReportInfo cslrptinfo = null;
        if (cslc != null && cslc.size() > 0) {
            cslrptinfo = cslc.get(0);
        } else {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"134_ReportExporter");
            this.logError(MessageFormat.format(msg, reportId));
        }
        if (cslrptinfo == null || cslrptinfo.getId() == null) {
            return;
        }
        String fileName = patch + "\\" + cslrptinfo.getName();
        this.exportExcel(cslrptinfo, fileName + ".xls");
        this.writeIniHeadInBuf(cslrptinfo, fileName + ".xls");
        this.exportINIFile(exportDir, cslrptinfo.getId().toString(), -1, fileName + ".ini");
    }

    public void exceport(Component parentWindow, String[] reportIds) throws BOSException, IOException, ClassNotFoundException, EASBizException, KDFException {
        this.parentWindow = parentWindow;
        if (reportIds != null && reportIds.length > 0) {
            File exportDir;
            File dir = this.getDirPath();
            if (dir == null) {
                return;
            }
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if ((exportDir = new File(dir.getPath() + File.separator + EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"147_ReportExporter"))).exists()) {
                if (2 == MsgBox.showConfirm2((Component)parentWindow, (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"148_ReportExporter"))) {
                    return;
                }
                exportDir.delete();
            }
            exportDir.mkdir();
            File excelFileDir = new File(exportDir.getPath() + File.separator + "EXCEL FILES");
            excelFileDir.mkdir();
            this.buf = new StringBuffer();
            this.errorBuf = new StringBuffer();
            this.exportExcelFiles(excelFileDir, reportIds);
            this.showExportInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportINIFile(File exportDir, String reportId, int index, String fileName) throws BOSException, IOException, ClassNotFoundException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)reportId));
        ev.getSelector().add(new SelectorItemInfo("*"));
        ev.getSelector().add(new SelectorItemInfo("template.*"));
        ICslReport rpt = CslReportFactory.getRemoteInstance();
        CslReportCollection cslc = rpt.getCslReportCollection(ev);
        TemplateInfo template = null;
        if (cslc == null || cslc.size() == 0) {
            return;
        }
        template = cslc.get(0).getTemplate();
        AbstractReportDateMapingInfo info = null;
        try {
            EntityViewInfo mappingQuery = new EntityViewInfo();
            FilterInfo mappingFilter = new FilterInfo();
            mappingQuery.setFilter(mappingFilter);
            mappingFilter.getFilterItems().add(new FilterItemInfo("templet.id", (Object)template.getId().toString()));
            mappingFilter.getFilterItems().add(new FilterItemInfo("templet.group", (Object)template.getGroup()));
            mappingFilter.setMaskString("#0 OR #1");
            SorterItemInfo versionSortItem = new SorterItemInfo("templet.versionNumber");
            versionSortItem.setSortType(SortType.DESCEND);
            mappingQuery.getSorter().add(versionSortItem);
            SelectorItemCollection mappingSelector = new SelectorItemCollection();
            mappingQuery.setSelector(mappingSelector);
            mappingSelector.add(new SelectorItemInfo("mapingData"));
            mappingSelector.add(new SelectorItemInfo("templet.versionNumber"));
            ReportDateMapingCollection mappings = ReportDateMapingFactory.getRemoteInstance().getReportDateMapingCollection(mappingQuery);
            int currTempletVersionNumber = Integer.parseInt(template.getVersionNumber().split("\\.")[0]);
            for (int i = 0; i < mappings.size(); ++i) {
                if (mappings.get(i).getTemplet() == null || Integer.parseInt(mappings.get(i).getTemplet().getVersionNumber().split("\\.")[0]) > currTempletVersionNumber) continue;
                info = mappings.get(i);
                break;
            }
        }
        catch (BOSException e) {
            logger.debug((Object)e.getMessage());
            logger.error((Object)e);
        }
        if (info == null) {
            this.logError(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"149_ReportExporter"));
            return;
        }
        if (StringUtil.isEmptyString((String)fileName)) {
            fileName = exportDir.getPath() + "\\Maping" + index + ".ini";
        }
        FileOutputStream out = null;
        OutputStreamWriter writer = null;
        ObjectInputStream in = null;
        ByteArrayInputStream bin = null;
        try {
            out = new FileOutputStream(fileName);
            writer = new OutputStreamWriter(out);
            writer.write("[File]\r\n");
            writer.write(this.buf.toString());
            byte[] data = info.getMapingData();
            if (data != null) {
                bin = new ByteArrayInputStream(data);
                in = new ObjectInputStream(bin);
                ReportMapingData rdata = (ReportMapingData)in.readObject();
                rdata.writeReportMapingData(writer);
            }
        }
        finally {
            CslRptUtil.closeInputStream(bin);
            CslRptUtil.closeInputStream(in);
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"writer.close() error.", (Throwable)ex);
            }
            CslRptUtil.closeOutputStream((OutputStream)out);
        }
    }

    private void exportExcelFiles(File exportDir, String[] reportIds) throws BOSException, EASBizException, IOException, KDFException, ClassNotFoundException {
        ICslReport rpt = CslReportFactory.getRemoteInstance();
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        for (int i = 0; i < reportIds.length; ++i) {
            if (reportIds[i] == null || reportIds[i].trim().length() <= 0) continue;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            ev.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)reportIds[i]));
            ev.getSelector().add(new SelectorItemInfo("*"));
            ev.getSelector().add(new SelectorItemInfo("orgUnit.*"));
            ev.getSelector().add(new SelectorItemInfo("currency.*"));
            CslReportCollection cslc = rpt.getCslReportCollection(ev);
            CslReportInfo cslrptinfo = null;
            if (cslc == null || cslc.size() <= 0) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"134_ReportExporter");
                this.logError(MessageFormat.format(msg, reportIds[i]));
                continue;
            }
            cslrptinfo = cslc.get(0);
            String fileName = exportDir.getPath() + "\\" + cslrptinfo.getOrgUnit().getName() + "-" + cslrptinfo.getNumber() + "-" + cslrptinfo.getName() + "-" + calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + "-" + cslrptinfo.getCurrency().getName() + ".XLS";
            try {
                Book book = cslrptinfo.getBook();
                this.setBookProtect(book);
                KDSBook kdsbook = BookToKDSBook.traslate((Book)book);
                kdsbook.getBookStyleAttributes().setLocked(true);
                kdsbook.getSheets().getSheet((Object)new Integer(0)).getSheetStyleAttributes().setLocked(true);
                ExportManager em = new ExportManager();
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
                em.setExporterParmeter(ExporterParameter.BOOK_LOCKED, (Object)Boolean.TRUE);
                em.exportToExcel(kdsbook, fileName);
            }
            catch (Exception e) {
                logger.debug((Object)e.getStackTrace(), (Throwable)e);
                File file = new File(fileName);
                file.delete();
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"135_ReportExporter");
                this.logError(MessageFormat.format(msg, reportIds[i]));
            }
            this.writeIniHeadInBuf(cslrptinfo, fileName);
            this.exportINIFile(exportDir, reportIds[i], i, "");
        }
    }

    private void exportExcel(CslReportInfo cslrptinfo, String fileName) {
        try {
            Book book = cslrptinfo.getBook();
            this.setBookProtect(book);
            KDSBook kdsbook = BookToKDSBook.traslate((Book)book);
            kdsbook.getBookStyleAttributes().setLocked(true);
            kdsbook.getSheets().getSheet((Object)new Integer(0)).getSheetStyleAttributes().setLocked(true);
            ExportManager em = new ExportManager();
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.BOOK_LOCKED, (Object)Boolean.TRUE);
            em.exportToExcel(kdsbook, fileName);
        }
        catch (Exception e) {
            logger.debug((Object)e.getStackTrace(), (Throwable)e);
            File file = new File(fileName);
            file.delete();
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"135_ReportExporter");
            this.logError(MessageFormat.format(msg, cslrptinfo.getId()));
        }
    }

    private void setBookProtect(Book book) {
        BookProtection bp = book.getProtection();
        bp.appendOperation(2);
        bp.appendOperation(1);
        Protection pro = null;
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet sheet = book.getSheet(i);
            StyleAttributes sa = Styles.getEmptySA();
            sa.setLocked(true);
            sheet.getRowRange(0, sheet.getRows().getMaxIntMark()).setStyle(sa, Styles.getEmptySA());
            pro = sheet.getSheetOption().getProtection(true);
            pro.start("1234");
        }
    }

    private void writeIniHeadInBuf(CslReportInfo cslrptinfo, String fileName) throws BOSException {
        EntityViewInfo ev1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        ev1.setFilter(filter1);
        ev1.getSelector().add(new SelectorItemInfo("*"));
        filter1.getFilterItems().add(new FilterItemInfo("fullOrgUnit", (Object)cslrptinfo.getOrgUnit().getId().toString()));
        HashSet<Integer> reporttype = new HashSet<Integer>();
        if (cslrptinfo.getSourceType().equals((Object)RptSrcTypeEnum.COMMITREPORT) || cslrptinfo.getSourceType().equals((Object)RptSrcTypeEnum.NORMAL)) {
            reporttype.add(new Integer(7));
            reporttype.add(new Integer(1));
            filter1.getFilterItems().add(new FilterItemInfo("easReportType", reporttype, CompareType.INCLUDE));
        } else {
            filter1.getFilterItems().add(new FilterItemInfo("easReportType", (Object)new Integer(cslrptinfo.getSourceType().getValue())));
        }
        CompanyMapingDataCollection c = CompanyMapingDataFactory.getRemoteInstance().getCompanyMapingDataCollection(ev1);
        if (c == null || c.size() == 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"136_ReportExporter");
            this.logError(MessageFormat.format(msg, cslrptinfo.getOrgUnit().getName()));
            return;
        }
        CompanyMapingDataInfo info = c.get(0);
        String numberCode = this.createNumberCode(info, cslrptinfo);
        String bufLine = numberCode + "=" + info.getCompanyName() + "&" + fileName + "\r\n";
        this.buf = new StringBuffer();
        this.buf.append(bufLine);
    }

    private String createNumberCode(CompanyMapingDataInfo companyInfo, CslReportInfo cslrptinfo) {
        String companyCode = companyInfo.getCompanyCode();
        if (companyCode == null || "".equals(companyCode.trim())) {
            return this.createYearPeriodTypeString(companyInfo, cslrptinfo);
        }
        StringBuffer result = new StringBuffer();
        companyCode = companyCode.trim();
        int length = companyCode.length();
        result.append(companyCode);
        result.append(this.createYearPeriodTypeString(companyInfo, cslrptinfo));
        return result.toString();
    }

    private String createYearPeriodTypeString(CompanyMapingDataInfo companyInfo, CslReportInfo cslrptinfo) {
        JiuQiReportTypeEnum jiuQiReportType;
        StringBuffer result = new StringBuffer();
        if (this.isWithYear) {
            result.append(cslrptinfo.getYear());
        }
        if (this.isWithPeriod) {
            short period = cslrptinfo.getPeriod();
            if (period < 10) {
                result.append("0");
            }
            result.append(period);
        }
        if (this.isWithJiuQiReportType && (jiuQiReportType = companyInfo.getJiuQiReportType()) != null) {
            result.append(jiuQiReportType.getValue());
        }
        return result.toString();
    }

    private File getDirPath() throws UIException {
        String sUIName = "com.kingdee.eas.fi.rpt.client.ExportPathChooserUI";
        UIContext uiContext = new UIContext((Object)this.parentWindow);
        Hashtable ht = new Hashtable();
        uiContext.put((Object)"config", ht);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(sUIName, (Map)uiContext);
        uiWindow.show();
        if (ht.get("action") != null && ht.get("action").toString().equals("cancel")) {
            return null;
        }
        String filePathName = (String)ht.get("path");
        if (filePathName == null || filePathName.trim().length() == 0) {
            return null;
        }
        return new File(filePathName);
    }

    private void logError(String msg) {
        this.errorBuf.append("ERROR : " + msg + "\r\n");
    }

    private void showExportInfo() {
        if (this.errorBuf.length() == 0) {
            MsgBox.showInfo((Component)this.parentWindow, (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"154_ReportExporter"));
        } else {
            MsgBox.showInfo((Component)this.parentWindow, (String)(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"155_ReportExporter") + "\r\n" + this.errorBuf.toString()));
        }
    }

    public void setParentWindow(Component parentWindow) {
        this.parentWindow = parentWindow;
    }

    public void setWithYear(boolean isWithYear) {
        this.isWithYear = isWithYear;
    }

    public void setWithPeriod(boolean isWithPeriod) {
        this.isWithPeriod = isWithPeriod;
    }

    public void setWithJiuQiReportType(boolean isWithJiuQiReportType) {
        this.isWithJiuQiReportType = isWithJiuQiReportType;
    }
}

