/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialog;
import com.kingdee.eas.fi.rpt.IInitDataFacada;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ITemplate;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.client.AbstractReportUpgradeUI;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ReportUpgradeUI
extends AbstractReportUpgradeUI {
    private static final String UPGRADE = "UPGRADE";
    private static final String RECOVER = "RECOVER";
    private static final String BROWSE = "BROWSE";
    private static final String BACKUP = "BACKUP";
    private static final String CHECK_ALL = "CHECK_ALL";
    private static final String CLEAR_ALL = "CLEAR_ALL";
    private static final Logger logger = CoreUIObject.getLogger(ReportUpgradeUI.class);
    private List idlist;
    private ICoreBase bizInterface;
    private static String kdf_magic = "###PACKER4.0.1###";
    private static String kds_magic = "###KDSpread1.0###";

    public static void registerBackDoorAction(KDPanel panel, Action action) {
        KeyStroke ks = KeyStroke.getKeyStroke("alt shift F1");
        String strKey = "ALT_SHIFT_F1";
        panel.getActionMap().put(strKey, action);
        panel.getInputMap(2).put(ks, strKey);
    }

    public static void upgrade(List ids, ICoreBase ibiz, Object parent) {
        try {
            IUIWindow w = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ReportUpgradeUI.class.getName(), (Map)new UIContext(parent));
            ReportUpgradeUI ui = (ReportUpgradeUI)w.getUIObject();
            ui.idlist = ids;
            ui.bizInterface = ibiz;
            ui.loadReports();
            w.show();
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
            logger.debug((Object)e.getMessage());
        }
    }

    private void initActions() {
        MyAction myAction = new MyAction();
        String text = this.btnBackUp.getText();
        this.btnBackUp.setAction((Action)myAction);
        this.btnBackUp.setText(text);
        text = this.btnBrowse.getText();
        this.btnBrowse.setAction((Action)myAction);
        this.btnBrowse.setText(text);
        text = this.btnRecover.getText();
        this.btnRecover.setAction((Action)myAction);
        this.btnRecover.setText(text);
        this.btnRecover.setVisible(false);
        text = this.btnUpgrade.getText();
        this.btnUpgrade.setAction((Action)myAction);
        this.btnUpgrade.setText(text);
        text = this.btnCheckAll.getText();
        this.btnCheckAll.setAction((Action)myAction);
        this.btnCheckAll.setText(text);
        text = this.btnClearAll.getText();
        this.btnClearAll.setAction((Action)myAction);
        this.btnClearAll.setText(text);
        this.btnBackUp.setActionCommand(BACKUP);
        this.btnBrowse.setActionCommand(BROWSE);
        this.btnRecover.setActionCommand(RECOVER);
        this.btnUpgrade.setActionCommand(UPGRADE);
        this.btnCheckAll.setActionCommand(CHECK_ALL);
        this.btnClearAll.setActionCommand(CLEAR_ALL);
    }

    private void checkAll(boolean b) {
        int rowCount = this.tblReport.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblReport.getRow(i);
            ICell cell = row.getCell("check");
            if (cell.getStyleAttributes().isLocked() || RptUtil.isTrue(cell.getValue()) == b) continue;
            cell.setValue((Object)b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionUpgrade() throws BOSException, EASBizException {
        int rowCount = this.tblReport.getRowCount();
        ArrayList<String> todo = new ArrayList<String>();
        boolean needBackup = this.btnBackUp.isSelected();
        String folder = this.txtFolder.getText();
        if (needBackup && StringUtils.isEmpty((String)folder)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"186_ReportUpgradeUI"));
            return;
        }
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblReport.getRow(i);
            ICell cell = row.getCell("check");
            if (!RptUtil.isTrue(cell.getValue())) continue;
            IObjectValue vo = (IObjectValue)row.getUserObject();
            BOSUuid uuid = vo.getBOSUuid("id");
            String id = uuid.toString();
            todo.add(id);
            if (needBackup) {
                File f = new File(folder + File.separator + this.formatUuid(id) + ".bin");
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(f, false);
                    out.write(vo.getBytes("data"));
                }
                catch (Exception exception) {
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            cell.setValue((Object)Boolean.FALSE);
            cell.getStyleAttributes().setLocked(true);
            row.getStyleAttributes().setBackground(Color.lightGray);
        }
        IInitDataFacada idf = InitDataFacadaFactory.getRemoteInstance();
        idf.kdf2kdsUpgrade(todo);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"187_ReportUpgradeUI"));
    }

    private void actionRecover() {
    }

    private String formatUuid(String id) {
        if (id == null || id.length() == 0) {
            return id;
        }
        if (id.length() == 44 || id.length() == 40) {
            Uuid uuid = Uuid.read((String)id.substring(0, 36));
            String type = id.substring(36).intern();
            return uuid.toString() + type;
        }
        if (id.length() == 28) {
            byte[] array = Base64Encoder.base64ToByteArray((String)id);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(array));
            try {
                Uuid uuid = Uuid.read((DataInput)in);
                BOSObjectType type = BOSObjectType.read((DataInput)in);
                return uuid.toString() + type;
            }
            catch (IOException ioe) {
                throw new UuidException((Throwable)ioe);
            }
        }
        throw new IllegalArgumentException("the arguemtn 'id' is invalid. '" + id + "'");
    }

    private void actionBrowse() {
        KDFileChooser parseDir = new KDFileChooser();
        parseDir.setFileSelectionMode(1);
        if (0 == parseDir.showOpenDialog((Component)((Object)this))) {
            File file = parseDir.getSelectedFile();
            this.txtFolder.setText(file.getAbsolutePath());
        }
    }

    private void actionBackup() {
    }

    public void onLoad() throws Exception {
        this.initActions();
        this.txtFolder.setEditable(false);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String table = "";
                    if (ReportUpgradeUI.this.bizInterface instanceof IReport) {
                        table = EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"188_ReportUpgradeUI");
                    } else if (ReportUpgradeUI.this.bizInterface instanceof ITemplate) {
                        table = EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"189_ReportUpgradeUI");
                    } else if (ReportUpgradeUI.this.bizInterface instanceof ICslReport) {
                        table = EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"190_ReportUpgradeUI");
                    }
                    IObjectPK[] list = ReportUpgradeUI.this.bizInterface.getPKList();
                    final List<IObjectPK> todo = Arrays.asList(list);
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"83_ReportUpgradeUI");
                    int i = MsgBox.showConfirm2((String)(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"191_ReportUpgradeUI") + "\n" + MessageFormat.format(msg, table, todo.size()) + "\n"));
                    if (i == 0) {
                        final IInitDataFacada idf = InitDataFacadaFactory.getRemoteInstance();
                        ProgressDialog dialog = ProgressDialog.createProgressDialog((Component)((Object)ReportUpgradeUI.this), (boolean)true);
                        dialog.setIcon(EASResource.getIcon((String)"imgTbtn_upgrade"));
                        dialog.run(true, true, new IRunnableWithProgress(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run(IProgressMonitor monitor) {
                                monitor.beginTask(EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"194_ReportUpgradeUI"), todo.size());
                                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"84_ReportUpgradeUI");
                                monitor.setTaskName(MessageFormat.format(msg, todo.size()));
                                try {
                                    for (int i = 0; i < todo.size(); ++i) {
                                        if (monitor.isCanceled()) {
                                            break;
                                        }
                                        String msg2 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"85_ReportUpgradeUI");
                                        monitor.subTaskBegin(MessageFormat.format(msg2, i + 1, todo.get(i)));
                                        ArrayList m = new ArrayList(1);
                                        m.add(todo.get(i));
                                        try {
                                            idf.kdf2kdsUpgrade(m);
                                            monitor.worked(1);
                                            continue;
                                        }
                                        catch (Exception ie) {
                                            String msg3 = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"86_ReportUpgradeUI");
                                            monitor.setTaskName(MessageFormat.format(msg, todo.get(i)));
                                        }
                                    }
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        });
                        MsgBox.showInfo((Component)((Object)ReportUpgradeUI.this), (String)EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"200_ReportUpgradeUI"));
                    }
                }
                catch (Exception ex) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"87_ReportUpgradeUI");
                    MsgBox.showInfo((Component)((Object)ReportUpgradeUI.this), (String)MessageFormat.format(msg, ex.getMessage()));
                    logger.debug((Object)ex.getMessage());
                }
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke("alt shift 0");
        String strKey = "ALT_SHIFT_0";
        this.getActionMap().put(strKey, action);
        this.getInputMap(2).put(ks, strKey);
    }

    private void loadReports() throws BOSException, Exception {
        this.tblReport.checkParsed();
        this.tblReport.getSelectManager().setSelectMode(2);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(this.idlist), CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("data"));
        CoreBaseCollection rpts = this.bizInterface.getCollection(view);
        for (int i = 0; i < rpts.size(); ++i) {
            CoreBaseInfo vo = rpts.get(i);
            String id = vo.get("id").toString();
            String name = vo.get("name").toString();
            String number = vo.get("number").toString();
            byte[] data = (byte[])vo.get("data");
            String format = this.getFormat(data);
            IRow row = null;
            row = format.equalsIgnoreCase("KDF") ? this.tblReport.addRow(0) : this.tblReport.addRow();
            row.setUserObject((Object)vo);
            row.getCell("id", true).setValue((Object)id);
            row.getCell("number", true).setValue((Object)number);
            row.getCell("name", true).setValue((Object)name);
            row.getCell("format", true).setValue((Object)format);
            row.getCell("size", true).setValue((Object)new Integer((data == null ? 0 : data.length) / 1024));
            ICell checkCell = row.getCell("check", true);
            checkCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
            if (format.equalsIgnoreCase("KDF")) {
                checkCell.setValue((Object)Boolean.TRUE);
                row.getStyleAttributes().setBackground(Color.yellow);
            } else {
                checkCell.setValue((Object)Boolean.FALSE);
                checkCell.getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(Color.lightGray);
            }
            row.getCell("oldid", true).setValue((Object)this.formatUuid(id));
        }
        super.onLoad();
    }

    public String getFormat(byte[] bin) {
        if (bin == null || bin.length < 17) {
            return "Unknow";
        }
        String magic_str = new String(bin, 0, 17);
        if (magic_str.equalsIgnoreCase(kdf_magic)) {
            return "KDF";
        }
        if (magic_str.equalsIgnoreCase(kds_magic)) {
            return "KDS";
        }
        return "Unknow";
    }

    private class MyAction
    extends AbstractAction {
        private MyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getActionCommand() == ReportUpgradeUI.BACKUP) {
                    ReportUpgradeUI.this.actionBackup();
                } else if (e.getActionCommand() == ReportUpgradeUI.BROWSE) {
                    ReportUpgradeUI.this.actionBrowse();
                } else if (e.getActionCommand() == ReportUpgradeUI.RECOVER) {
                    ReportUpgradeUI.this.actionRecover();
                } else if (e.getActionCommand() == ReportUpgradeUI.UPGRADE) {
                    ReportUpgradeUI.this.actionUpgrade();
                } else if (e.getActionCommand() == ReportUpgradeUI.CHECK_ALL) {
                    ReportUpgradeUI.this.checkAll(true);
                } else if (e.getActionCommand() == ReportUpgradeUI.CLEAR_ALL) {
                    ReportUpgradeUI.this.checkAll(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

