/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.RptCellComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.fi.rpt.client.IControlledDialogListener;
import com.kingdee.eas.fi.rpt.client.ISimpleDialog;
import com.kingdee.eas.fi.rpt.client.RptCellCmtEditUI;
import com.kingdee.eas.fi.rpt.client.RptCellTextRender;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class RptCell
implements Serializable {
    private static final long serialVersionUID = 20040415140217L;
    private transient Object cell;
    private transient Object sheet;
    private transient Object comment;
    private transient Object cellRander;
    private ItemFormula itemFormula;
    private EditorListener edListener = null;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.itemFormula);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object o = in.readObject();
        if (o == null) {
            this.itemFormula = null;
        } else if (o instanceof ItemFormula) {
            this.itemFormula = (ItemFormula)o;
            this.itemFormula.setCell(null);
        } else {
            throw new ClassNotFoundException();
        }
    }

    public RptCell(ICell cl) {
        this.cell = cl;
        this.sheet = null;
        this.comment = null;
        this.cellRander = null;
    }

    public Object getValue() {
        return this.cell == null ? null : ((ICell)this.cell).getValue();
    }

    public Object setValue(Object val) {
        if (this.cell != null) {
            ((ICell)this.cell).setValue(val);
        }
        return val;
    }

    public void addComment(RptCellComment cmt) {
        if (this.comment == null) {
            this.comment = new RptCommentTank();
        }
        ((RptCommentTank)this.comment).addInitEntry(cmt);
        this.triggerCmtRander();
    }

    public void removeComments() {
        this.comment = null;
        this.triggerCmtRander();
    }

    public boolean hasComment() {
        return this.comment != null && ((RptCommentTank)this.comment).isValid();
    }

    private void triggerCmtRander() {
        RptCellTextRender cr = (RptCellTextRender)this.cellRander;
        if (cr == null) {
            ICell ic = (ICell)this.cell;
            cr = new RptCellTextRender();
            this.cellRander = cr;
            ic.setRenderer((IBasicRender)cr);
            if (ic.getValue() == null && ic.getExpressions() == null) {
                ic.setValue((Object)"");
            }
        }
        if (this.comment != null && ((RptCommentTank)this.comment).isValid()) {
            if (!cr.hasCmtRander) {
                cr.hasCmtRander = true;
            }
        } else if (cr.hasCmtRander) {
            cr.hasCmtRander = false;
        }
    }

    private void triggerItemRander() {
        RptCellTextRender cr = (RptCellTextRender)this.cellRander;
        if (cr == null) {
            cr = new RptCellTextRender();
            this.cellRander = cr;
            ((ICell)this.cell).setRenderer((IBasicRender)cr);
        }
        if (this.itemFormula != null && this.itemFormula.getFormula() != null) {
            if (!cr.hasItemRander) {
                cr.hasItemRander = true;
            }
            if (this.itemFormula.getExt("20") != null) {
                if (this.itemFormula.getExt("20").equals("23")) {
                    cr.isItemNotExists = true;
                } else if (this.itemFormula.getExt("20").equals("24")) {
                    cr.isFormulaDuplicate = true;
                } else {
                    cr.isFormulaInvalid = true;
                }
            } else {
                cr.isItemNotExists = false;
                cr.isFormulaInvalid = false;
                cr.isFormulaDuplicate = false;
            }
        } else if (cr.hasItemRander) {
            cr.hasItemRander = false;
        }
        if (this.itemFormula != null) {
            cr.isBasePoint = this.itemFormula.isBasePoint();
        }
    }

    public void getComments(PostilCollection comments) {
        if (this.comment == null) {
            return;
        }
        ((RptCommentTank)this.comment).dump(comments, this.itemFormula != null ? this.itemFormula.getItemNumber() : null);
    }

    public String getCommentString() {
        if (this.comment == null || !((RptCommentTank)this.comment).isValid()) {
            return null;
        }
        return this.comment.toString();
    }

    public void editComment(boolean isEditable) {
        if (this.comment == null) {
            this.comment = new RptCommentTank();
        }
        if (this.edListener == null) {
            this.edListener = new EditorListener();
        }
        try {
            String title = RptResourceHelper.getString("cellcmt") + RptResourceHelper.getString(isEditable ? "edit" : "view");
            RptCellCmtEditUI ed = RptCellCmtEditUI.getInstance(((RptSheet)this.sheet).getParentUI());
            ed.addSimpleDialogListener(this.edListener);
            ed.open(this.comment, title, isEditable);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void setSheet(RptSheet sht) {
        this.sheet = sht;
    }

    public RptSheet getSheet() {
        return (RptSheet)this.sheet;
    }

    public ItemFormula setItemFormula(String line) {
        if (line == null || line.length() < 1) {
            this.itemFormula = null;
        } else {
            if (this.itemFormula == null) {
                this.itemFormula = new ItemFormula();
                this.itemFormula.setCell(null);
            }
            this.itemFormula.FormulaToObject(line.trim());
        }
        this.triggerItemRander();
        return this.itemFormula;
    }

    public String getItemFormulaLine() {
        return this.itemFormula == null ? null : this.itemFormula.getFormula();
    }

    public ICell getCell() {
        return (ICell)this.cell;
    }

    public void setCell(ICell cell) {
        this.cell = cell;
    }

    public RptCommentTank getComment() {
        return (RptCommentTank)this.comment;
    }

    public void setComment(RptCommentTank comment) {
        this.comment = comment;
    }

    public ItemFormula getItemFormula() {
        return this.itemFormula;
    }

    public void setItemFormula(ItemFormula itemFormula) {
        this.itemFormula = itemFormula;
    }

    public void setFormula(String expr) {
        ((ICell)this.cell).setExpressions(expr);
    }

    private final class EditorListener
    implements IControlledDialogListener {
        private EditorListener() {
        }

        @Override
        public Object getTrueController() {
            return new RptCellComment(((ICell)RptCell.this.cell).getColumnIndex(), ((ICell)RptCell.this.cell).getRowIndex());
        }

        @Override
        public void pilotSetout(ISimpleDialog source) {
        }

        @Override
        public void pilotReturnee(ISimpleDialog source, Object result, boolean isOk) {
            if (isOk) {
                ((RptCommentTank)RptCell.this.comment).updateFrom((RptCommentTank)result);
            }
            RptCell.this.triggerCmtRander();
        }
    }
}

